/* ProgramFolder.cmd
 *
 * move program object into the Program Folder
 * arg is the program object
 * 
 * if arg is NULL, create the Program Folder used by Suntan Special
 *
 * Copyright (C) 2013 Blonde Guy
 * All Rights Reserved
 */

parse arg programObject
programFolderID = cdglobal('programFolderID')
programFolderName = cdglobal('programFolderName')

if programObject \= '' then do
   rc = SysMoveObject(programObject, programFolderID)
   if rc = 0 then do
      call CreateProgramFolder
      rc = SysMoveObject(programObject, programFolderID)
      if rc = 0 then do
         call LogCdi "could not move" programObject "to" programFolderName
      end
      /* close folder when done */
      call SysSleep 2
      address cmd '@sendmsg "' || programFolderName || '" WM_CLOSE'
   end
  return programFolderID
end

createProgramFolder:

programFolderParent = cdglobal('programFolderParent')

rc = SysCreateObject('WPFolder', programFolderName, programFolderParent,,
                     'OBJECTID=' || programFolderID || ';OPEN=ICON',,
                     'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create" programFolderName "Folder with" programFolderID
end

return programFolderID
