/* recursive make directory
 *
 * Note: the full directory path must be specified
 *
 * Copyright (C) 2006 Blonde Guy
 * All Rights Reserved
 */

parse arg newDir

if length(newDir) = 2 & right(newDir, 1) = ':' then do
   return 0
end

parse arg newDrive ':\' newPath

if newDrive = '' then do
   call LogCdi "SuntanMkDir(" || newDir || ") failed because no drive letter specified"
   return 2
end

if newPath = '' then do
   call LogCdi "SuntanMkDir(" || newDir || ") failed because no path specified"
   return 3
end

rc = SysMkDir(newDir)
if rc = 0 | rc = 5 then do
   return rc
end

curPath = ''
do while newPath <> ''
   parse var newPath subDir '\' newPath
   curPath = curPath || '\' || subDir
   rc = SysMkDir(newDrive || ':' || curPath)
   if rc <> 0 & rc <> 5 then do
      call LogCdi "SuntanMkDir(" || newDir || ") encountered error" rc "creating" curPath
      return rc
   end
end

return 0

