/* Chooser 4
 *
 * Install program for Suntan Special
 *
 * Copyright (C) 2019 Blonde Guy
 * All Rights Reserved
 */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

tempDir = value('TEMP',,'OS2ENVIRONMENT')
if tempDir = '' then do
   say 'Suntan Special requires a TEMP environment variable, but none was found.'
   pull foo
   return
end

originalDir = Directory()
if Directory(tempDir) = '' then do
   say 'Suntan Special requires a TEMP directory.' tempDir 'does not exist.'
   pull foo
   return
end
call Directory originalDir

testDir = tempDir || '\suntanxxx'
rc = sysmkdir(testDir)
if rc <> 0 then do
   say 'Suntan Special encountered error' rc 'while using' tempDir
   pull foo
   return
end
call sysrmdir testDir

/* prepare environment for running Suntan Special from distribution */
/* is this an upgrade; does suntanDir exist? */
fNewInstall = 1
suntanDir = strip(sysini("User", 'Suntan Special', 'Settings'), 'T', d2c(0))
if suntanDir <> 'ERROR:' then do
   if stream(suntanDir || '\settings.txt', 'c', 'query exists') <> '' then do
      fNewInstall = 0
   end
end

if fNewInstall then do
   /* if not, set up suntan writable files in tempDir */
   rc = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   rc = SysIni('User', 'Suntan Special', 'Settings', tempDir || d2c(0))
   address cmd '@copy settings.txt' tempDir '> nul'
   if rc <> 0 then do
      call LogCdi "Error" rc "copying settings.txt from" Directory()
   end
end
else do
   originalDir = directory()
   setupDir = cdglobal('setupDir')
   sourceDir = cdglobal('sourceDir')
   mediaDir = directory('..\setup')
   call directory originalDir

   found = 0
   newSourceDir = ''
   do while sourceDir <> ''
      parse var sourceDir myDir ';' sourceDir
      if translate(myDir) = translate(mediaDir) then do
         found = 1
      end
      else do
         newSourceDir = newSourceDir || ';' || myDir
      end
   end
   sourceDir = mediaDir || ';' || strip(newSourceDir, 'Both', ';')
   call SetSetting 'sourceDir', sourceDir

   if found = 0 then do
      call LogCdi "Added media directory to source dir:" mediaDir
      call LogCdi "Source Dir:" sourceDir
   end
end

AppendMediaPath = value('AppendMediaPath',,'OS2ENVIRONMENT')
if AppendMediaPath <> '' then do
   sourceDir = cdglobal('sourceDir')
   sourceDir = sourceDir || ';' || AppendMediaPath
   call SetSetting 'sourceDir', sourceDir
   call LogCdi "Added addditional media directory to source dir:" AppendMediaPath
end

/* launch display monitor to install Suntan Special */
call startGui 'suntan', fNewInstall

/* clean up settings */
if fNewInstall then do
   address cmd '@del' tempDir || '\settings.txt > nul'
   address cmd '@del' tempDir || '\cd-log.txt > nul'
end
return

wtf:

dialogText = "Suntan Special version" sunver || "." || cr || cr ||,
             "Current Directory" Directory() || cr ||,
             "Original Directory" originalDir || cr ||,
             "newSourceDir" newSourceDir || cr ||,
             "setupDir" cdglobal('setupDir') || cr ||,
             "sourceDir" cdglobal('sourceDir') || cr || cr ||,
             "Press OK to continue."
rc = messageDialog("Debugging Screen", 1, dialogText)

return
