/* Example of the REXX interface to a Group Folder                    */
/*                                                                    */
/* Those setting up many Group Folder uses (e.g., a LAN               */
/* administrator) may want to use REXX to create a Group Folder with  */
/* their own standard groups and objects.  This REXX command file     */
/* creates the same objects as would choosing the "Create standard    */
/* groups" choice from the Group Folder menu.                         */
/*                                                                    */
/* Note: The SysSetObjectData only accepts object IDs for folder      */
/*       objects; paths are not accepted.  As a result, the           */
/*       Group Folder must be created with an object ID.  I believe   */
/*       this is a REXX bug, since WinSetObjectData/WinQueryObject    */
/*       together work with either folder or data file objects.       */

signal on novalue

call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
call RxFuncAdd 'SysSetObjectData', 'RexxUtil', 'SysSetObjectData'
call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

rc = SysCreateObject("ExGroupFolder", "My Group Folder", ,
    "<WP_DESKTOP>", "OBJECTID=<MY_GROUPFOLDER>", "Update");

rc = SysSetObjectData("<MY_GROUPFOLDER>", "NEWGROUP=Development");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "NEWGROUP=Games");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "NEWGROUP=System");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "NEWGROUP=Palettes");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "NEWGROUP=Misc");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "NEWGROUP=Help");

/* Development */
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Development;" || ,
     "CREATEOBJECT=Enhanced Editor;CLASS=WPProgram;" || ,
     "EXENAME=?:\OS2\APPS\EPM.EXE;PROGTYPE=PM;HELPPANEL=20278");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Development;" || ,
     "CREATEOBJECT=Seek and Scan Files;CLASS=WPProgram;" || ,
     "EXENAME=?:\OS2\APPS\PMSEEK.EXE;PROGTYPE=PM;HELPPANEL=20285");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Development;" || ,
     "CREATEOBJECT=OS/2 Window;CLASS=WPProgram;" || ,
     "EXENAME=*;PROGTYPE=WINDOWABLEVIO;HELPPANEL=8010");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Development;" || ,
     "CREATEOBJECT=OS/2 Full Screen;CLASS=WPProgram;" || ,
     "EXENAME=*;PROGTYPE=FULLSCREEN;HELPPANEL=8009");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Development;" || ,
     "CREATEOBJECT=Command Reference;CLASS=WPProgram;" || ,
     "EXENAME=?:\OS2\VIEW.EXE;PARAMETERS=CMDREF.INF;HELPPANEL=9301");

/* Below is an example of how OBJECTID can be used to later refer */
/* to an object created in a GFolder. */

rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Development;" || ,
     "CREATEOBJECT=Icon Editor;CLASS=WPProgram;OBJECTID=<MY_GROUPFOLDERICONEDIT>")
rc = SysSetObjectData("<MY_GROUPFOLDERICONEDIT>", ,
     "EXENAME=?:\OS2\ICONEDIT.EXE;PROGTYPE=PM;" || ,
     "ASSOCFILTER=*.BMP,*.PTR,*.ICO;HELPPANEL=20279");

/* Games */
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Games;" || ,
     "CREATEOBJECT=Solitaire - Klondike;CLASS=WPProgram;" || ,
     "EXENAME=?:\OS2\APPS\KLONDIKE.EXE;PROGTYPE=PM;HELPPANEL=20295");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Games;" || ,
     "CREATEOBJECT=Reversi;CLASS=WPProgram;" || ,
     "EXENAME=?:\OS2\APPS\REVERSI.EXE;PROGTYPE=PM;HELPPANEL=20297");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Games;" || ,
     "CREATEOBJECT=OS/2 Chess;CLASS=WPProgram;" || ,
     "EXENAME=?:\OS2\APPS\OS2CHESS.EXE;PROGTYPE=PM;" || ,
     "STARTUPDIR=\OS2\APPS;HELPPANEL=20296");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Games;" || ,
     "CREATEOBJECT=Games;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_GAMES>;");

/* System */
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=System;" || ,
     "CREATEOBJECT=OS/2 System;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_OS2SYS>;");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=System;" || ,
     "CREATEOBJECT=Startup;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_START>;");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=System;" || ,
     "CREATEOBJECT=System;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_SYSTEM>;");

/* Palettes */
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Palettes;" || ,
     "CREATEOBJECT=Font Palette;CLASS=WPFontPalette");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Palettes;" || ,
     "CREATEOBJECT=Color Palette;CLASS=WPColorPalette");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Palettes;" || ,
     "CREATEOBJECT=Scheme Palette;CLASS=WPSchemePalette;AUTOSETUP=YES");

/* Misc */
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Misc;" || ,
     "CREATEOBJECT=Templates;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_TEMPS>;");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Misc;" || ,
     "CREATEOBJECT=Minimized"||D2C(10)||"Window Viewer;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_VIEWER>;");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Misc;" || ,
     "CREATEOBJECT=Shredder;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_SHRED>;");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Misc;" || ,
     "CREATEOBJECT=Drives;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_DRIVES>;");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Misc;" || ,
     "CREATEOBJECT=Desktop;CLASS=WPShadow;" || ,
     "SHADOWID=<WP_DESKTOP>;");

/* Help */
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Help;" || ,
     "CREATEOBJECT=Master Help Index;CLASS=Mindex;INDEX=HELP");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Help;" || ,
     "CREATEOBJECT=Information;CLASS=WPShadow;SHADOWID=<WP_INFO>");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Help;" || ,
     "CREATEOBJECT=Start Here;CLASS=WPProgram;" || ,
     "EXENAME=STHR.EXE;PROGTYPE=PM;STARTUPDIR=\OS2\HELP;HELPPANEL=9278");
rc = SysSetObjectData("<MY_GROUPFOLDER>", "INGROUP=Help;" || ,
     "CREATEOBJECT=Glossary;CLASS=Mindex;INDEX=GLOSSARY");

rc = SysSetObjectData("<MY_GROUPFOLDER>", "OPEN=DEFAULT");
