/*
  some parts are base on
  
  ------------------------------
  
	mini Weather
	Code & Images: Arlo Rose
 
	This Widget grabs the latest current weather data from weather.com and builds
	it into a nice little iconic representation.
	
	For more information about the services weather.com offers, visit their
	website at: <http://www.weather.com>
 
	
	(c) 2003 - 2004 Pixoria
*/

var userLocationId = "94583"; // san ramon
var userLocation = "San Ramon, CA";
var userUnit = "s"; // standard
var splash = 0;//1000 * 5; // 5 seconds;
var checkInterval = 1000 * 60 * 10; // 10 minutes
var updateInterval = 1000 * 60 * 60 * 4; // 4 hours
  
var WeatherData = {
  update: 0,
  city: 0,
  temp: 0,
  icon: null,
  userLocationId: null,
  userLocation: null,
  userUnit: null
}

function init()
{
  //onFetchFailure(); return;
  
  loadSettings();
  setTimeout("updateWeather()", splash);
  setInterval("updateWeather()", checkInterval);
}

function timeStamp()
{
  return new Date() - Date.parse('January 1, 1970');
}

function saveCache()
{
  try {
    widget.setPreferenceForKey(WeatherData, 'kludget/weather/cache');
  } catch(e) {
    alert(e);
  }
}

function loadCache()
{
  try {
    var obj = widget.preferenceForKey('kludget/weather/cache');
    if (obj.update && obj.city && obj.temp && obj.icon) {
      WeatherData = obj;
      return true;
    }
  } catch(e) {
  }
  return false;
}

function loadSettings()
{
  try {
    userLocation = Kludget.Settings.read('kludget/weather/location', userLocation);
    userLocationId = Kludget.Settings.read('kludget/weather/locationId', userLocationId);
    userUnit = Kludget.Settings.read('kludget/weather/useMetric', 0) ? 'm' : 's';
  } catch(e) {
    // alert(e);
  }
}


function updateWeather()
{  
  // check cache
  if (WeatherData.update == 0)
  {
    loadCache();
  }
  
  if (WeatherData.userLocation != userLocation) {
    // do a search
    WeatherData.userLocation = userLocation;
    searchLocation();
    return;
  }
  
  if (WeatherData.update > 0 && WeatherData.userLocationId == userLocationId && WeatherData.userUnit == userUnit) {
    var d = timeStamp() - WeatherData.update;
    if (d < updateInterval)
    {
      alert('using cached data');
      updateDisplay();
      return;
    }
  }
 
  var url = "http://xoap.weather.com/weather/local/" + userLocationId + "?cc=*&link=xoap&unit=" + userUnit;
  // url += "&par=" + partnerID + "&key=" + licenseID;
  // url = "sample.xml";

  alert('fetch ' + url);
  
  // fetch
  new Ajax.Request(url,
  {
    method:'get',
    onSuccess: function(transport) { if (!onWeatherData(transport)) onFetchFailure(); },
    onFailure: function() { onFetchFailure(); }
  });

}

function searchLocation()
{
    var url = "http://xoap.weather.com/search/search?where=" + userLocation;
    
    // fetch
    new Ajax.Request(url,
    {
      method:'get',
      onSuccess: function(transport) { if (!onLocationData(transport)) onFetchFailure(); },
      onFailure: function() { onFetchFailure(); }
    });
}

function onFetchFailure()
{
  WeatherData.icon = "-";
  WeatherData.city = "Weather.com";
  WeatherData.temp = "";
  updateDisplay();

  alert('unable to download data from weather.com');
  setTimeout("updateWeather()", 1000 * 60 * 5);
}

function onWeatherData(req)
{  
  alert('weather data received');
  var xmlobject = (new DOMParser()).parseFromString(req.responseText, "text/xml");
  var tmp = xmlobject.getElementsByTagName('tmp').item(0);
  if (!tmp)
    return;

  var dnam = xmlobject.getElementsByTagName('dnam').item(0);
  if (!dnam)
    return;

  var fullCity = dnam.firstChild.nodeValue;  
  var icon = xmlobject.getElementsByTagName('icon').item(0);
  if (!icon)
    return;
    
  WeatherData.update = timeStamp();
  WeatherData.city = fullCity.split(',')[0];
  WeatherData.temp = tmp.firstChild.nodeValue + "&deg;";
  WeatherData.icon = icon.firstChild.nodeValue;
  WeatherData.userLocationId = userLocationId;
  WeatherData.userUnit = userUnit;
  
  saveCache();
  
  updateDisplay();
  
  return true;
}

function onLocationData(req)
{
  var xmlobject = (new DOMParser()).parseFromString(req.responseText, "text/xml");
  var tmp = xmlobject.getElementsByTagName('loc').item(0);
  if (!tmp)
    return;
    
  var locId = tmp.getAttribute("id");
  if (locId)
  {
    Kludget.Settings.write('kludget/weather/locationId', locId);
    userLocationId = locId;
    updateWeather();
  }
  
  //alert(locId);
  
  return true;
}

function updateDisplay()
{
  document.getElementById('temp').innerHTML = WeatherData.temp;
  document.getElementById('city').innerHTML = WeatherData.city;
  
  var Sun = new Object;
  var Cloud = new Object;
  var Water = new Object;
  
  var sunIcon = document.getElementById('sun');
  var cloudIcon = document.getElementById('cloud');
  var waterIcon = document.getElementById('water');
  
  sunIcon.src = '';
  cloudIcon.src = '';
  waterIcon.src = '';
  
	// Get everyone back to normal
	Sun.src = "resources/Sun.png";
	Sun.opacity = 255;
	Sun.hOffset = 0;
	Sun.vOffset = 0;
	Cloud.opacity = 255;
	Cloud.src = "resources/Smaller Clouds.png";
	Cloud.hOffset = 13;
	Cloud.vOffset = 17;
  Water.src = "";
	Water.opacity = 0;
	Water.hOffset = 8;
	Water.vOffset = 23;
  
  switch (WeatherData.icon)
  {

  case "-":  // Unknown Weather
    Sun.src = "resources/Unknown.png";
    Cloud.opacity = 0;
    break;

  case "0":
  case "3":
  case "4":
  case "17":
  case "35": // Thunder Storms
    Sun.opacity = 0;
    Cloud.src = "resources/Rain Cloud.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Thunder.png";
    Water.opacity = 255;
    Water.hOffset = 6;
    Water.vOffset = 25;
    break;

  case "1":
  case "2":  // Windy Showers
    Sun.src = "resources/Windy Rain.png";
    Cloud.opacity = 0;
    break;

  case "5":
  case "7":  // Icy Snowy Rain
    Sun.opacity = 0;
    Cloud.src = "resources/Clouds.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Icy Frozen Snow.png";
    Water.opacity = 255;
    Water.hOffset = 1;
    Water.vOffset = 27;
    break;

  case "6":
  case "18": // Sleet
    Sun.opacity = 0;
    Cloud.src = "resources/Clouds.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Sleet.png";
    Water.opacity = 255;
    Water.hOffset = 8;
    Water.vOffset = 28;
    break;
  case "8":  // Icy Drizzle
    Sun.opacity = 0;
    Cloud.src = "resources/Rain Cloud.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Icy Drizzle.png";
    Water.opacity = 255;
    Water.hOffset = 10;
    Water.vOffset = 28;
    break;

  case "9":  // Drizzle
    Sun.opacity = 0;
    Cloud.src = "resources/Rain Cloud.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Drizzle.png";
    Water.opacity = 255;
    Water.hOffset = 10;
    Water.vOffset = 28;
    break;
  case "10": // Icy Rain
    Sun.opacity = 0;
    Cloud.src = "resources/Rain Cloud.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Icy Rain.png";
    Water.opacity = 255;
    Water.hOffset = 6;
    Water.vOffset = 26;
    break;

  case "11":
  case "40": // Showers
    Sun.opacity = 0;
    Cloud.src = "resources/Rain Cloud.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Light Rain.png";
    Water.opacity = 255;
    Water.hOffset = 10;
    Water.vOffset = 28;
    break;
  case "12": // Rain
    Sun.opacity = 0;
    Cloud.src = "resources/Rain Cloud.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Rain.png";
    Water.opacity = 255;
    Water.hOffset = 6;
    Water.vOffset = 26;
    break;

  case "13": // Light Snow Flurries
    Sun.opacity = 0;
    Cloud.src = "resources/Clouds.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Light Snow.png";
    Water.opacity = 255;
    Water.hOffset = 3;
    Water.vOffset = 28;
    break;

  case "14": // Med Snow
    Sun.opacity = 0;
    Cloud.src = "resources/Clouds.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Med Snow.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 28;
    break;

  case "15":
  case "25": // Friged (Very Cold) (change?)
  case "43": // Blowing/Windy Snow
    Sun.src = "resources/Windy Snow.png";
    Cloud.opacity = 0;
    break;

  case "16":
  case "41":
  case "42": // Normal Snow
    Sun.opacity = 0;
    Cloud.src = "resources/Clouds.png";
    Cloud.hOffset = 3;
    Cloud.vOffset = 6;
    Water.src = "resources/Snow.png";
    Water.opacity = 255;
    Water.hOffset = 2;
    Water.vOffset = 26;
    break;

  case "19": // Dust
    Water.src = "resources/Dust.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 10;
    Sun.opacity = 0;
    Cloud.opacity = 0;
    break;

  case "20": // Fog
    Water.src = "resources/Fog.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 10;
    Sun.opacity = 0;
    Cloud.opacity = 0;
    break;

  case "21": // Hazy
    Water.src = "resources/Haze.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 10;
    Sun.opacity = 0;
    Cloud.opacity = 0;
    break;
  case "22": // Smoke
    Water.src = "resources/Smoke.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 10;
    Sun.opacity = 0;
    Cloud.opacity = 0;
    break;

  case "23":
  case "24": // Windy
    Sun.src = "resources/Wind.png";
    Cloud.opacity = 0;
    break;

  case "26": // Cloudy (no sun/moon)
    Sun.opacity = 0;
    Cloud.opacity = 255;
    Cloud.hOffset = 21;
    Cloud.vOffset = 11;
    Water.src = "resources/Clouds.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 12;
    break;

  case "27": // Mostly Cloudy Night
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    Cloud.opacity = 255;
    Cloud.hOffset = 21;
    Cloud.vOffset = 11;
    Water.src = "resources/Clouds.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 12;
    break;

  case "28": // Mostly Cloudy Day
    Cloud.opacity = 255;
    Cloud.hOffset = 21;
    Cloud.vOffset = 11;
    Water.src = "resources/Clouds.png";
    Water.opacity = 255;
    Water.hOffset = 0;
    Water.vOffset = 12;
    break;

  case "29": // Partially Cloudy Night
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    break;

  case "30": // Partially Cloudy Day
    // Looks like the default Widget state, no change.
    break;

  case "31": // Clear Night
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    Cloud.opacity = 0;
    break;

  case "32": // Clear Day
    Sun.src = "resources/Sun.png";
    Cloud.opacity = 0;
    break;

  case "33": // Tiny bit of clouds at night
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    Cloud.opacity = 100;
    break;

  case "34": // Tiny bit of clouds during the day
    Sun.src = "resources/Sun.png";
    Cloud.opacity = 100;
    Cloud.hOffset = 13;
    Cloud.vOffset = 17;
    break;

  case "36": // Hot
    Sun.src = "resources/Sun.png";
    Cloud.opacity = 0;
    break;

  case "37":
  case "38": // Sunny Thunder Storm
    Cloud.src = "resources/Smaller Rain Cloud.png";
    Cloud.hOffset = 9;
    Cloud.vOffset = 13;
    Water.src = "resources/Thunder.png";
    Water.opacity = 255;
    Water.hOffset = 9;
    Water.vOffset = 25;
    break;

  case "39": // Sunny Showers
    Cloud.src = "resources/Smaller Rain Cloud.png";
    Cloud.hOffset = 10;
    Cloud.vOffset = 14;
    Water.src = "resources/Light Rain.png";
    Water.opacity = 255;
    Water.hOffset = 10;
    Water.vOffset = 28;
    break;

  case "44": // Partially Cloudy Day
    // Looks like the default Widget state, no change.
    break;

  case "45": // Night Rain
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    Cloud.src = "resources/Smaller Rain Cloud.png";
    Cloud.hOffset = 10;
    Cloud.vOffset = 14;
    Water.src = "resources/Light Rain.png";
    Water.opacity = 255;
    Water.hOffset = 10;
    Water.vOffset = 28;
    break;

  case "46": // Night Snow
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    Cloud.src = "resources/Smaller Clouds.png";
    Cloud.hOffset = 10;
    Cloud.vOffset = 14;
    Water.src = "resources/Light Snow.png";
    Water.opacity = 255;
    Water.hOffset = 10;
    Water.vOffset = 28;
    break;

  case "47": // Night Thunder Storm
    Sun.src = "resources/Moon.png";
    Sun.hOffset = 1;
    Sun.vOffset = 1;
    Cloud.src = "resources/Smaller Rain Cloud.png";
    Cloud.hOffset = 9;
    Cloud.vOffset = 13;
    Water.src = "resources/Thunder.png";
    Water.opacity = 255;
    Water.hOffset = 9;
    Water.vOffset = 25;
    break;

  default:
    Sun.src = "resources/Unknown.png";
    Cloud.opacity = 0;
    break;
  }
  
  var offsetScale = 1.2;
  sunIcon.src = Sun.src;
  sunIcon.style.opacity = (Sun.opacity / 255);
  sunIcon.style.left = Sun.hOffset * offsetScale;
  sunIcon.style.top = Sun.vOffset * offsetScale;
  
  cloudIcon.src = Cloud.src;
  cloudIcon.style.opacity = (Cloud.opacity / 255);
  cloudIcon.style.left = Cloud.hOffset * offsetScale;
  cloudIcon.style.top = Cloud.vOffset * offsetScale;

  waterIcon.src = Water.src;
  waterIcon.style.opacity = (Water.opacity / 255);
  waterIcon.style.left = Water.hOffset * offsetScale;
  waterIcon.style.top = Water.vOffset * offsetScale;
  
  //Effect.Appear('sun');
  //Effect.Appear('cloud');
  //Effect.Appear('water');
  
  document.title = "Weather - " + userLocation;
}

try {
  Kludget.onSettingsChanged = function() {
    loadSettings();
    updateWeather()
  };
} catch(e) {
}

