function getMonthName(m)
{
  var months =
    new Array(
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December'
    );

  return months[m];
}

function getDayName(d)
{
  var days =
    new Array(
      'Su',
      'Mo',
      'Tu',
      'We',
      'Th',
      'Fr',
      'Sat'
    );

  return days[d];
}

function generate(calendarDate)
{
  var toDay = 0;
  var thisMonth = new Date();
  if (calendarDate.getMonth() == thisMonth.getMonth() &&
      calendarDate.getFullYear() == thisMonth.getFullYear() &&
      calendarDate.getDate() == thisMonth.getDate())
  {
    toDay = thisMonth.getDate();
  }

  var tmp = new Date();
  tmp.setMonth(calendarDate.getMonth());
  tmp.setYear(calendarDate.getFullYear());
  tmp.setDate(1);

  var start = tmp.getDay();
  tmp.setMonth(tmp.getMonth()+1);
  tmp.setDate(tmp.getDate()-1);
  var end = tmp.getDate();

  var calendar = document.getElementById('calendar');
  var calTable = document.getElementById('cal');

  var ths = calTable.getElementsByTagName("th");
  var i = 1; // skip month name
  while (i < ths.length)
  {
    var th = ths.item(i);
    th.innerHTML = getDayName(i-1);
    i++;
  }

  var prevRow = null;
  var tds = calTable.getElementsByTagName("td");
  var day = 1;
  var i = 0;
  while (i < 42 && i < tds.length)
  {
    var td = tds.item(i);
    var tr = td.parentNode;

    if (tr != prevRow)
      tr.style.display = 'none';

    prevRow = tr;

    if (start < 1 && day <= end)
    {
      tr.style.display = '';
      if (day == toDay)
      {
        td.innerHTML = '<div class="today">' + day + '</span>';
      }
      else
      {
        td.innerHTML = '<div>' + day + '</span>';
      }
      day++;
    }
    else
    {
      td.innerHTML = '';
    }

    i++;
    start--;
  }

  var monthName = document.getElementById("monthName");
  if (monthName)
  {
    monthName.innerHTML = getMonthName(calendarDate.getMonth()) + ' ' + calendarDate.getFullYear();
  }
}

function previousMonth()
{
  viewDate.setMonth(viewDate.getMonth()-1);
  generate(viewDate);
  
  alert('previous month');
}

function nextMonth()
{
  viewDate.setMonth(viewDate.getMonth()+1);
  generate(viewDate);
  
  alert('next month');
}

function thisMonth()
{
  viewDate = new Date();
  generate(viewDate);
}

function init()
{
  thisMonth();

  // update every ten minutes
  setInterval("refresh()", 1000 * 60 * 10);

}

function refresh()
{
  generate(viewDate);
}

function showControl()
{
  var ctrl = document.getElementById('control');
  ctrl.style.display = 'block';
}

function hideControl()
{
  var ctrl = document.getElementById('control');
  ctrl.style.display = 'none';
}

var viewDate;
