/***************************************************************************/
/* ODFIX.CMD - Copyright 2004  R.L. Walsh                                  */
/*                                                                         */
/* Fixes compatibility problems with Object Desktop components:            */
/*   Zip Folders - supports v1.52 and 2.01 or later                        */
/*   Control Center - should work with all versions                        */
/*                                                                         */
/***************************************************************************/

version.0 = 3
version.1 = 'v2.0 - Fixkit 1 or later applied'
version.2 = 'v2.0 - Fixkit 2 with revised icons'
version.3 = 'v1.5 - Fixkit 2 applied'

offset.0 = 3
offset.1 = '154AE'
offset.2 = '1550E'
offset.3 = '1E3CE'

skip2 = '83C702'
skip3 = '83C703'

/***************************************************************************/

'@ECHO OFF'
'CLS'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say ''
say 'ODFix corrects problems with two Object Desktop components.'
say 'It must be run from the directory containing O.D.''s dlls.'
say ''
say '  Zip Folders - enables these to be used with recent versions'
say '                of Infozip''s Unzip (>v5.32).  It will change'
say '                one byte in objdoarc.dll after making a backup.'
say '                This fix works with v1.52 and v2.01 or later.'
say ''
say '  Control Center - turns on the CPU meter and prevents Desktop'
say '                lockups when dragging over Control Center.  It'
say '                will register a WPS class and put a file named'
say '                odccfix.rwy in CC.  To hide this object, go to'
say '                the Sections tab of CC''s properties notebook.'
say ''
say '  Options        Install fixes             Uninstall fixes'
say '                ------------------        ------------------'
say '                 1. Both                   6. Both'
say '                 2. Control Center         7. Control Center'
say '                 3. Zip Folders            8. Zip Folders'
say ''
say '                         0. Quit with no changes'
say ''
say 'To select an option, enter its number:'

do forever
  answer = SysGetKey('noecho')
  select
    when answer = 1 then
      do
      call FixZip
      call FixCC
      leave
      end
    when answer = 2 then
      do
      call FixCC
      leave
      end
    when answer = 3 then
      do
      call FixZip
      leave
      end
    when answer = 6 then
      do
      call UnfixZip
      call UnfixCC
      leave
      end
    when answer = 7 then
      do
      call UnfixCC
      leave
      end
    when answer = 8 then
      do
      call UnfixZip
      leave
      end
    when answer = 0 then
      leave
    otherwise
      iterate
  end
end

say ''
say '== exiting odfix.cmd =='
'PAUSE'
exit

/***************************************************************************/

FixCC:

say ''
say '== installing Control Center fix =='
say ''

rc = SysDeregisterObjectClass('ODCCFix')

if stream('ODCCFIX.DLL','c','query exists') = ''
  then do
    say 'Error:  unable to locate ODCCFIX.DLL in the current directory.'
    return
  end

rc = SysRegisterObjectClass('ODCCFix', directory()||'\ODCCFIX.DLL')
if rc = 0
  then do
    say 'Error:  failed to register ODCCFix class using '||directory()||'\ODCCFIX.DLL'
    return
  end

do 1

  if SysCreateObject('ODCCFix','ODCCFIX.RWY','<OBJD_CONTROLCENTER>','OBJECTID=<ODCCFix_File>','R')
    then do
      if SysCreateObject('ODCCFix','ODCCFIX.RWY','<OBJD_NETSCAN>','OBJECTID=<ODCCFix_File2>','R')
        then
          say 'Success:  ODCCFix was installed in Control Panel & Object Netscan.'
      else
          say 'Success:  ODCCFix was installed in your Control Panel.'
      leave
    end

  if SysCreateObject('ODCCFix','ODCCFIX.RWY','<WP_DESKTOP>','OBJECTID=<ODCCFix_File>','R')
    then do
      say 'Error:  unable to locate your Control Center object(s).'
      say 'A file named ODCCFIX.RWY has been created on your Desktop.'
      say 'Drag it to your Control Center to complete the installation.'
      leave
    end

  say 'Error:  registered the ODCCFix class but failed to create a file'
  say 'named ODCCFIX.RWY.  Use your text editor''s Save As dialog to create'
  say 'a file with this name in your desktop''s Control Center directory.'

end /* do 1 */

say ''
say '- To hide ODCCFIX.RWY, open the Control Center''s notebook'
say '  to the Sections tab, then remove it from the Visible list.'
say ''
say '- If you have more than one Control Center object, drag a copy of'
say '  ODCCFIX.RWY to each one to protect it from lockups during d&d.'

return

/***************************************************************************/

UnfixCC:

say ''
say '== uninstalling Control Center fix =='
say ''

if SysDestroyObject('<ODCCFix_File>')
  then do
    if SysDestroyObject('<ODCCFix_File2>') then
      say 'Success:  file ODCCFIX.RWY was deleted from Control Center & Object Netscan.'
    else
      say 'Success:  file ODCCFIX.RWY was deleted from your Control Center.'
  end
else
  say 'Error:  unable to delete file ODCCFIX.RWY from your Control Center.'

say ''
if SysDeregisterObjectClass('ODCCFix') then
  say 'Success:  class ODCCFix has been deregistered.'
else
  say 'Error:  unable to deregister class ODCCFix.'

return

/***************************************************************************/

FixZip:

say ''
say '== installing Zip Folder fix =='
say ''

if stream('OBJDOARC.DLL','c','query exists') = ''
  then do
    say 'Error:  unable to locate OBJDOARC.DLL in the current directory.'
    return
  end

rc = Patch(skip3,skip2)
if rc \= 1
  then do
    if rc = -1 then
      say 'Error:  your copy of OBJDOARC.DLL has already been patched.'
    else
      say 'Error:  unable to patch OBJDOARC.DLL - your version may not be supported.'
    return
  end

answer = 'Y'
if stream('OBJDOARC.BAK','c','query exists') \= ''
  then do
    say 'Backup file OBJDOARC.BAK already exists.  Replace it? [y/N]'
    answer = SysGetKey('noecho')
    if answer = 'y' then
      answer = 'Y'
    say ''
  end

if answer = 'Y' then
  'OLDNEWBK OBJDOARC.DLL OBJDOARC.PAT OBJDOARC.BAK > NUL'
else
  'OLDNEWBK OBJDOARC.DLL OBJDOARC.PAT > NUL'

if rc \= 0
  then do
    if answer = 'Y' then
      'COPY OBJDOARC.DLL OBJDOARC.BAK > NUL'
    'COPY OBJDOARC.PAT OBJDOARC.DLL > NUL'
    if rc
      then do
        call SysPutEA 'OBJDOARC.PAT', '.LONGNAME', ''
        if answer = 'Y' then
          call SysPutEA 'OBJDOARC.BAK', '.LONGNAME', ''
        say 'Error:  Unable to replace OBJDOARC.DLL.  The patched'
        say '        file (OBJDOARC.PAT) is in the current directory.'
        return
      end
  end

'DEL OBJDOARC.PAT > NUL'

call SysPutEA 'OBJDOARC.DLL', '.LONGNAME', ''
if answer = 'Y' then
  call SysPutEA 'OBJDOARC.BAK', '.LONGNAME', ''

say 'Success:  patched OBJDOARC.DLL ('|| version.i ||')'
say ''
say '- Reboot or restart the WPS to put the change into effect.'

return

/***************************************************************************/

UnfixZip:

say ''
say '== uninstalling Zip Folder fix =='
say ''

if stream('OBJDOARC.DLL','c','query exists') = ''
  then do
    say 'Error:  unable to locate OBJDOARC.DLL in the current directory.'
    return
  end

if stream('OBJDOARC.BAK','c','query exists') \= ''
  then do
    'OLDNEWBK OBJDOARC.DLL OBJDOARC.BAK > NUL'
    if rc = 0
      then do
        call SysPutEA 'OBJDOARC.DLL', '.LONGNAME', ''
        say 'Success:  restored OBJDOARC.DLL from the backup file.'
        say ''
        say '- Reboot or restart the WPS to put the changes into effect.'
        return
      end
  end

say 'Error:  unable to restore OBJDOARC.DLL from the backup file.'
say ''
say 'Do you want to restore it by patching the file? [y/N]'

answer = SysGetKey('noecho')
say ''
if answer \= 'Y' & answer \= 'y'
  then do
    say 'Error:  the original version of OBJDOARC.DLL was not restored.'
    return
  end

rc = Patch(skip2,skip3)
if rc \= 1
  then do
    if rc = -1 then
      say 'Error:  your copy of OBJDOARC.DLL is already in its original state.'
    else
      say 'Error:  unable to restore OBJDOARC.DLL - your version may not be supported.'
    return
  end

'OLDNEWBK OBJDOARC.DLL OBJDOARC.PAT > NUL'

if rc \= 0
  then do
    'COPY OBJDOARC.PAT OBJDOARC.DLL > NUL'
    if rc
      then do
        call SysPutEA 'OBJDOARC.PAT', '.LONGNAME', ''
        say 'Error:  unable to restore OBJDOARC.DLL.  The patched'
        say '        file (OBJDOARC.PAT) is in the current directory.'
        return
      end
  end

'DEL OBJDOARC.PAT > NUL'

call SysPutEA 'OBJDOARC.DLL', '.LONGNAME', ''

say 'Success:  restored OBJDOARC.DLL to its original state.'
say ''
say '- Reboot or restart the WPS to put the change into effect.'

return

/***************************************************************************/

Patch:  arg frombytes, tobytes

rtn = 0

do 1

  'COPY OBJDOARC.DLL OBJDOARC.PAT > NUL'
  if rc then
    leave

  rc = stream('OBJDOARC.PAT','c','open')
  if rc \= 'READY:' then
    leave

  do i=1 to version.0

    rc = stream('OBJDOARC.PAT','c','seek ='x2d(offset.i)+1)
    if rc \= x2d(offset.i)+1 then
      iterate

    rc = charin('OBJDOARC.PAT',,3)
    if rc \= x2c(frombytes)
      then do
        if rc \= x2c(tobytes) then
          iterate
        else do
          rtn = -1
          leave
        end
      end

    rc = stream('OBJDOARC.PAT','c','seek -3')
    if rc = x2d(offset.i)+1
      then do
        rc = charout('OBJDOARC.PAT',x2c(tobytes))
        if rc = 0 then
          rtn = 1
      end
    leave

  end /* i=1 to version.0 */

  rc = stream('OBJDOARC.PAT','c','close')

end /* do 1 */

if rtn \= 1 then
  'DEL OBJDOARC.PAT > NUL'

return rtn

/***************************************************************************/

