/* WPS 2 PDE: Converts WPS program objects in PDE program shortcuts */
/* Requires: WPTools by Henk Kelder, REXXUTIL and WPS running       */
/* Author: Salvador Parra Camacho (x3265340@fedro.ugr.es)           */

say 'WPS 2 PDE: Converts WPS program objects in PDE program shortcuts.'
say '(c)2003, Salvador Parra Camacho (x3265340@fedro.ugr.es)'
say ''

signal on halt name halted

signal on syntax name norexxutil

/* Load REXXUTIL functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

signal on syntax name nowptools

/* Load WPTOOLS functions */
call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
call WPToolsLoadFuncs

signal off syntax

/* WPS running? */

if SysQueryClassList(stem.) = 0 then
	do
	say 'WPS not running!'
	say '(Required by WPS to PDE.)'
	exit
	end

say 'Use:'
say ' WPS 2 PDE generates a directory tree in the current directory'
say ' which contents the created program shortcuts.'
say ' This is potencially VERY DANGEROUS!'
say 'Current limitations:'
say ' Does not overwrite existing program shortcuts.'
say ' Does not parse the special WPS parameters such as %* or [].'
say ' Does not check the posible conflicts between directories created'
say ' and program shortcuts.'
say ' Limited error handling.'
say 'Disclaimer:'
say ' YOU ARE USING THIS PROGRAM AT YOUR OWN RISK!'
say ''

rec = WPToolsQueryObject('<WP_DESKTOP>', ., 'desktop_title', ., 'desktop_location') 
if rec = 1 then
	/* desktop_dir = desktop_location||'\'||desktop_title */ /* it's result c:\\Desktop (stVova)*/
	desktop_dir = desktop_location||desktop_title
else
	do
	say 'WPS desktop not found!'
	exit
	end

current_dir = directory()

if translate(current_dir) = translate(desktop_dir) then
	do
	say "DON'T EXECUTE THE PROGRAM FROM THE WPS DESKTOP DIRECTORY!"
	exit
	end

say 'Current directory: '||current_dir
say 'Desktop directory: '||desktop_dir
say 'Do you want continue? (Y/N)'
key = translate(SysGetKey('NOECHO'))
if key <> 'Y' then
	exit

say 'Searching subdirectories...'

call SysFileTree desktop_dir||'\*', dirs, 'DOS'

say 'Search ended.'
say 'Creating program shortcuts...'

bar.0 = 3
bar.1 = '/'
bar.2 = '-'
bar.3 = '\'

parse value SysCurPos() with rows cols
call SysCurState 'OFF'

do i = 1 to dirs.0
	m = (i//3) + 1
	call SysCurPos rows, cols
	call charout ,bar.m
	rec = WPToolsFolderContent(dirs.i, 'contents.')
	destination_dir = current_dir'\'||substr(dirs.i, length(desktop_dir) + 1)
	call SysMkDir destination_dir
	do j = 1 to contents.0
		rec = WPToolsQueryObject(contents.j, 'class', 'title', 'setupstring', .)
		if class = 'WPProgram' then
			call write_program
	end
end

call SysCurState 'ON'

say 'Program ended.'

exit

write_program:

call directory destination_dir
call split_setupstring
call title2name
call lineout name, '[SHORTCUT]'
call lineout name, '//link: type, object-name, path, parameters'
call lineout name, 'APP'
call lineout name, exe
call lineout name, dir
call lineout name, parameters
call lineout name

return

title2name:

name = translate(title, '         ', '\/:*?"<>|')

return

split_setupstring:

if pos('EXENAME=', setupstring) <> '0' then
	do
	exe = substr(setupstring, pos('EXENAME=', setupstring) + 8)
	if delstr(exe, pos(';', exe)) <> '0' then
		exe = delstr(exe, pos(';', exe))
	end
else
	exe = ''

if pos('STARTUPDIR=', setupstring) <> '0' then
	do
	dir = substr(setupstring, pos('STARTUPDIR=', setupstring) + 11)
	if delstr(dir, pos(';', dir)) <> '0' then
		dir = delstr(dir, pos(';', dir))
	end
else
	dir = ''

if pos('PARAMETERS=', setupstring) <> '0' then
	do
	parameters = substr(setupstring, pos('PARAMETERS=', setupstring) + 11)
	if delstr(parameters, pos(';', parameters)) <> '0' then
		parameters = delstr(parameters, pos(';', parameters))
	end
else
	parameters = ''

return

norexxutil:
say 'REXXUTIL not found!'
say '(Required by WPS to PDE.)'
exit

nowptools:
say 'WPTools by Henk Kelder not found!'
say '(Required by WPS to PDE.)'
exit

halted:
say ''
call SysCurState 'ON'
say 'Process stopped by the user!'
exit