//------------------------------------------
//  PDE, 2003-2004
//  changed XPLORBTN.PAS from Sybil
//  use now hIcon from WinExtractFileIcon()
//  21.03.2004, stVova
//  -don't draw text, you need manually
//   free hIcon before calling "Free"
//
//------------------------------------------

Unit XplorBtn2I;

Interface

Uses
  Classes, Forms, Buttons, Graphics, os2def, PMWIN;

{Declare new class}
Type
  TExplorerButton2I=Class(TSpeedButton)
  Private
    FMouseInside:Boolean;
    FMouseTimer:TTimer;
    FCapture:Boolean;
    FFlat:Boolean;
    FIcon: hPointer;
    Procedure EvFMouseTimer(Sender:TObject);
    Procedure SetFIcon(NewIcon: hPointer);
    Procedure SetFlat(Value:Boolean);
  Protected
    Procedure SetupComponent; Override;
    Procedure MouseDown(Button:TMouseBUtton;ShiftState:TShiftState;X,Y:LongInt); Override;
    Procedure MouseMove(ShiftState:TShiftState;X,Y:LongInt); Override;
    Procedure MouseUp(Button:TMouseBUtton;ShiftState:TShiftState;X,Y:LongInt); Override;
    Procedure DrawFrame(Down:Boolean); Override;
    Procedure DrawBitmap(Bitmap:TBitmap;Down:Boolean); Override;
    Property Cancel;
    Property Default;
    Property Kind;
    Property TabOrder;
    Property TabStop;
    Property ZOrder;
    Property OnKeyPress;
    Property OnScan;
  Public
    Property Flat:Boolean read FFlat write SetFlat;
  Published
    Mini: Boolean; {draw mini icon or normal}
    SysIconSize: Integer; {icons size for button}
    Property Icon: hPointer read FIcon write SetFIcon;
  End;


{Define components to export}
{You may define a navigator page and a component bitmap file}
Exports
  TExplorerButton2I,'User','';


Implementation


Procedure TExplorerButton2I.SetupComponent;
Begin
  Inherited SetupComponent;

  Name := 'ExplorerButton2I';
  Caption := '';
  Width := 40;
  Height := 40;
  FFlat := True;
  FMouseTimer.Create(Self);
  Include(FMouseTimer.ComponentState, csDetail);
  FMouseTimer.Interval := 50;
  FMouseTimer.OnTimer := EvFMouseTimer;
  SysIconSize := 32;

End;

Procedure TExplorerButton2I.MouseDown(Button:TMouseBUtton;ShiftState:TShiftState;X,Y:LongInt);
Begin
  Inherited MouseDown(Button,ShiftState,X,Y);

  If Button = mbLeft Then FCapture := True;
End;

Procedure TExplorerButton2I.MouseMove(ShiftState:TShiftState;X,Y:LongInt);
Begin
  FMouseTimer.Stop;

  Inherited MouseMove(ShiftState,X,Y);
  If Application <> Nil Then
    If Not Application.HasFocus Then exit;

  If (not FMouseInside) And (not FCapture) Then
  Begin
    FMouseInside := True;
    Redraw(ClientRect);
  End;

  {Start Timer}
  If FFlat Then FMouseTimer.Start;
End;

Procedure TExplorerButton2I.MouseUp(Button:TMouseBUtton;ShiftState:TShiftState;X,Y:LongInt);
Begin
  Inherited MouseUp(Button,ShiftState,X,Y);

  If Button = mbLeft Then FCapture := False;
End;

Procedure TExplorerButton2I.EvFMouseTimer(Sender:TObject);
Var
  AControl:TControl;
Begin
  FMouseTimer.Stop;

  If FCapture Then AControl := Self
  Else AControl := Screen.GetControlFromPoint(Screen.MousePos);

  If AControl <> Self Then
  Begin
    FMouseInside := False;
    Redraw(ClientRect);
  End
  Else FMouseTimer.Start;
End;

Procedure TExplorerButton2I.SetFIcon(NewIcon: hPointer);
Begin

     FIcon := NewIcon;

     Invalidate;
end;

Procedure TExplorerButton2I.SetFlat(Value:Boolean);
Begin
     FFlat := Value;
     FMouseInside := False;
End;

Procedure TExplorerButton2I.DrawFrame(Down:Boolean);
Var
  rec:TRect;
  FrameColor:TColor;
Begin
  If ((not Down) And (FFlat) And
      (((not FMouseInside) And (not FCapture)) Or (not Enabled))) Then
  Begin
    // dont draw the Frame
    rec := ClientRect;
    If Parent <> Nil Then FrameColor := Parent.Color
    Else FrameColor := clBackGround;

    If Designed Then
    Begin
      Canvas.Brush.Color := FrameColor;
      Canvas.Pen.Color := clBlack;
      Canvas.Pen.Style := psDash;
      Canvas.Brush.Style := bsClear;
      Canvas.Rectangle(rec);
    End
    Else Canvas.ShadowedBorder(rec,FrameColor,FrameColor);

    InflateRect(rec,-1,-1);
    Canvas.ShadowedBorder(rec,FrameColor,FrameColor);

    Canvas.ClipRect := IntersectRect(Canvas.ClipRect,rec);
  End
  Else //Inherited DrawFrame(Down);
    Begin
    rec := ClientRect;
    //InflateRect(rec,-1,-1);
    If Down
      Then Canvas.ShadowedBorder(rec,clBtnShadow,clBtnHighlight)
      Else Canvas.ShadowedBorder(rec,clBtnHighlight,clBtnShadow);
    InflateRect(rec,-1,-1);
    Canvas.ClipRect := IntersectRect(Canvas.ClipRect,rec);
    End;
End;

Procedure TExplorerButton2I.DrawBitmap(Bitmap:TBitmap;Down:Boolean);
Var
  ps: hPS;
  rc1:TRect;
  d, dm, dMini: Integer;
Begin

  dMini := 0;
  d := (Height - SysIconSize) div 2 - 1;
  if Mini then
     begin
     dMini := 4;
  //   d := (Height - SysIconSize div 2) div 2 - 1;
     end;
  dm := 0;
  if Down then dm := 1;
  ps := WinGetPS(Handle);
  rc1 := Canvas.ClipRect;
  canvas.fillrect(rc1, color);
  Canvas.ExcludeClipRect(rc1);

  WinDrawPointer( ps, d+dm, d+dm, FIcon, dMini);
  WinReleasePS(ps);

End;

Initialization
  {Register classes}
  RegisterClasses([TExplorerButton2I]);
End.

