
{ͻ
                                                                           
      Sibyl Portable Component Classes                                     
                                                                           
      Copyright (C) 1995,97 SpeedSoft Germany,   All rights reserved.      
                                                                           
 ͼ}

//this is modified ListView2.pas to use in PDE file open/save dialog
//7.03.04 stVova

Unit pdeFileBox;

Interface

Uses Os2Def,PmWin,PmStdDlg;

Uses Messages,SysUtils,Classes,Forms,Graphics,OutLine,
     StdCtrls;

Type
    EListViewError=Class(Exception);

Type
    TPDEListBoxNode=Class;
    TPDEListBox=Class;

    PListViewRecord=^TPDEListBoxRecord;
    TPDEListBoxRecord=Record
         RecordCore:RecordCore;
         Node:TPDEListBoxNode;  {Extra Data}
    End;

    TPDEListBoxNode=Class
      Private
         FTreeRec:PListViewRecord;
         FCaption:PChar;
         FData:Pointer;
         FIndex:LongInt;
         FListView:TPDEListBox;
         FBitmap:TBitmap;
      Private
         Function GetCaption:String;
         Procedure SetCaption(NewCaption:String);
         Function GetBitmap:TBitmap;
         Procedure SetBitmap(NewBitmap:TBitmap);
         Function GetItemRect:TRect;
      Public
         RealFileName: String;
         InCase: Boolean;
         IsDirectory: Boolean;
         Constructor Create(Owner:TPDEListBox);
         Destructor Destroy;Override;
      Public
         Property Data:Pointer Read FData Write FData;
         Property Text:String Read GetCaption Write SetCaption;
         Property Bitmap:TBitmap Read GetBitmap Write SetBitmap;
         Property Index:LongInt Read FIndex;
         Property ItemRect:TRect read GetItemRect;
    End;
    TPDEListBoxNodeClass=Class Of TPDEListBoxNode;

    {$M+}
    TPDEListBoxItemSelectEvent=Procedure(Sender:TObject;Index:LongInt) Of Object;
    {$M-}

    TPDEListBox=Class(TControl)
      Private
         FBitmapSize:TSize;
         FShowDragRects:Boolean;
         FDragRectValid:Boolean;
         FDragRect:TRect;
         FDragSelected:TPDEListBoxNode;
         FInitNodes:TList;
         FNodes:TList;
         FNodeClass:TPDEListBoxNodeClass;
         FPictureList:TBitmapList;
         FMultipleSel:Boolean;
         FBorderStyle:TBorderStyle;
         FPopupPos:TPoint;
         FOnItemSelect:TPDEListBoxItemSelectEvent;
         FUpdateCount:LongInt;
         FSorted:Boolean;

         FDirBitmap: TBitmap;
         FFileBitmap: TBitmap;
         FSelectedLabel: TLabel;
         FSelectedName: TEdit;
         FSelectedPath: TEdit;
         FPath: String;
         FMask: String;
      Private
         Procedure SetDirBitmap(Value: TBitmap);
         Procedure SetFileBitmap(Value: TBitmap);
         Procedure SetSelectedLabel(Value: TLabel);
         Procedure SetSelectedName(Value: TEdit);
         Procedure SetSelectedPath(Value: TEdit);

         Procedure WMPaint(Var Msg:TMessage);Message WM_PAINT;
         Procedure SetCnrInfo;
         Procedure SetupImageList;
         Procedure SetupList;
         Function AddPicture(NewBitmap:TBitmap):TBitmap;
         Function Get(Index:LongInt):TPDEListBoxNode;
         Function GetItemCount:LongInt;
         Procedure UpdateNode(Node:TPDEListBoxNode);
         Procedure SetBorderStyle(NewBorder:TBorderStyle);
         Function GetItemIndex:LongInt;
         Procedure SetItemIndex(NewValue:LongInt);
         Function GetSelect(Index:LongInt):Boolean;
         Procedure SetSelect(Index:LongInt;NewValue:Boolean);
         Procedure SetSorted(NewValue:Boolean);
         Procedure DrawDragRect;
      Protected
         Procedure SetupComponent;Override;
         Procedure SetupShow;Override;
         Procedure GetClassData(Var ClassData:TClassData);Override;
         Procedure CreateParams(Var Params:TCreateParams);Override;
         Procedure CreateWnd;Override;
         Procedure DestroyWnd;Override;
         Procedure ParentNotification(Var Msg:TMessage);Override;
         Procedure ScanEvent(Var KeyCode:TKeyCode;RepeatCount:Byte);Override;
         Procedure MouseClick(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);Override;
         Procedure DragOver(Source:TObject;X,Y:LongInt;State:TDragState;Var Accept:Boolean);Override;
         Procedure DragDrop(Source:TObject;X,Y:LongInt);Override;
      Public
         Destructor Destroy;Override;
         Function Add(Const Text:String;Data:Pointer;Bitmap:TBitmap):TPDEListBoxNode;
         Procedure ItemSelect(Index: LongInt);
         Function AddFN(Const Text, RealName:String;Data:Pointer;Bitmap:TBitmap):TPDEListBoxNode;
         Function AddIS(Const Text:String;Data:Pointer;Bitmap:TBitmap;IsDir:Boolean):TPDEListBoxNode;
         Function NodeFromPoint(pt:TPoint):TPDEListBoxNode;
         Procedure Clear;
         Procedure BeginUpdate;
         Procedure EndUpdate;
      Public
         FileAttributes: Integer;
         Procedure vFilesOnMouseDown (Sender: TObject; Button: TMouseButton; Shift: TShiftState; X: LongInt; Y: LongInt);
         Procedure LoadFromPath;
         Procedure SetPath(Value: String);
         Procedure SetMask(Value: String);

         Property NodeClass:TPDEListBoxNodeClass Read FNodeClass Write FNodeClass;
         Property Nodes:TList Read FNodes;
         Property Items[Index:LongInt]:TPDEListBoxNode Read Get;Default;
         Property ItemCount:LongInt Read GetItemCount;
         Property ItemIndex:LongInt Read GetItemIndex Write SetItemIndex;
         Property Selected[Index:LongInt]:Boolean Read GetSelect Write SetSelect;
         Property XAlign;
         Property XStretch;
         Property YAlign;
         Property YStretch;
      Published
         Property Mask: String read FMask write SetMask;
         Property DirBitmap: TBitmap read FDirBitmap write SetDirBitmap;
         Property FileBitmap: TBitmap read FFileBitmap write SetFileBitmap;
         Property SelectedLabel: TLabel read FSelectedLabel write SetSelectedLabel;
         Property SelectedName: TEdit read FSelectedName write SetSelectedName;
         Property SelectedPath: TEdit read FSelectedPath write SetSelectedPath;
         Property Path: String read FPath write SetPath;

         Property Align;
         Property Color;
         Property BitmapSize:TSize Read FBitmapSize Write FBitmapSize;
         Property BorderStyle:TBorderStyle Read FBorderStyle Write SetBorderStyle;
         Property PenColor;
         Property DragCursor;
         Property DragMode;
         Property Enabled;
         Property Font;
         Property MultipleSel:Boolean Read FMultipleSel Write FMultipleSel;
         Property ParentColor;
         Property ParentPenColor;
         Property ParentFont;
         Property ParentShowHint;
         Property PopupMenu;
         Property ShowDragRects:Boolean Read FShowDragRects Write FShowDragRects;
         Property ShowHint;
         Property Sorted:Boolean read FSorted write SetSorted;
         Property TabOrder;
         Property TabStop;
         Property Visible;
         Property ZOrder;

         Property OnCanDrag;
         Property OnDblClick;
         Property OnDragDrop;
         Property OnDragOver;
         Property OnEndDrag;
         Property OnEnter;
         Property OnExit;
         Property OnFontChange;
         Property OnItemSelect:TPDEListBoxItemSelectEvent Read FOnItemSelect Write FOnItemSelect;
         Property OnMouseClick;
         Property OnMouseDblClick;
         Property OnMouseDown;
         Property OnMouseMove;
         Property OnMouseUp;
         Property OnSetupShow;
         Property OnStartDrag;
    End;


Function InserTPDEListBox(parent:TControl;Left,Bottom,Width,Height:LongInt;Hint:String):TPDEListBox;


Implementation


Function InserTPDEListBox(parent:TControl;Left,Bottom,Width,Height:LongInt;Hint:String):TPDEListBox;
Begin
     Result.Create(parent);
     Result.SetWindowPos(Left,Bottom,Width,Height);
     Result.TabStop := True;
     Result.Hint := Hint;
     Result.parent := parent;
End;


Procedure RemoveRecord(Node:TPDEListBoxNode; Update:Boolean);
Var  Flags:LongWord;
     ListHandle:LongWord;
Begin
     If Node = Nil Then Exit;
     If Node.FTreeRec = Nil Then Exit;

     ListHandle := Node.FListView.Handle;
     If ListHandle <> 0 Then
     Begin
          {$IFDEF OS2}
          Flags := CMA_FREE;
          If Update Then Flags := Flags Or CMA_INVALIDATE;
          WinSendMsg(ListHandle,CM_REMOVERECORD,LongWord(@Node.FTreeRec),
                     MPFROM2SHORT(1,Flags));
          {$ENDIF}
          {$IFDEF Win95}
          SendMessage(ListHandle,LVM_DELETEITEM,
                      LongWord(Node.FTreeRec^.RecordCore.iItem),0);
          {$ENDIF}
     End;

     {$IFDEF Win95}
     Dispose(Node.FTreeRec);
     {$ENDIF}
     Node.FTreeRec := Nil;
End;


Procedure InsertRecord(NewNode:TPDEListBoxNode; AParentRecord:PListViewRecord;
                       RecordOrder:Pointer);
Var  ListHandle:LongWord;
     List:TPDEListBox;
     {$IFDEF OS2}
     aRecordInsert:RECORDINSERT;
     {$ENDIF}
Begin
     NewNode.FTreeRec^.Node := NewNode;
     {specify where To Insert}
     List := NewNode.FListView;
     ListHandle := List.Handle;

     {$IFDEF OS2}
     aRecordInsert.cb := SizeOf(RECORDINSERT);
     aRecordInsert.pRecordOrder := RecordOrder;
     aRecordInsert.ZOrder := CMA_TOP;
     aRecordInsert.cRecordsInsert := 1;     //Number Of records
     aRecordInsert.fInvalidateRecord := 1;  //Invalidate records
     aRecordInsert.pRecordParent := Pointer(AParentRecord);

     {Insert Record}
     WinSendMsg(ListHandle,CM_INSERTRECORD,
                LongWord(NewNode.FTreeRec),LongWord(@aRecordInsert));
     {$ENDIF}

     {$IFDEF Win95}
     SendMessage(ListHandle,LVM_INSERTITEM,0,LongWord(@NewNode.FTreeRec^.RecordCore));
     {$ENDIF}
End;


Procedure AllocateRecord(Handle:LongWord;Var porec:PListViewRecord);
Begin
     //allocate Memory
     {$IFDEF OS2}
     porec:=Pointer(WinSendMsg(Handle,
                               CM_ALLOCRECORD,
                               {additional Info For ListViewRecord}
                               SizeOf(TPDEListBoxRecord)-SizeOf(RecordCore),
                               1));          {allocate one Record}
     {$ENDIF}
End;

//------------------------------------------
//--TPDEListBox class implementation--------
//------------------------------------------

Type
    TPDEListBoxBitmap=Class(TBitmap)
    End;




Function TPDEListBoxNode.GetCaption:String;
Begin
     If FCaption=Nil Then Result:=''
     Else Result:=FCaption^;
End;


Procedure TPDEListBoxNode.SetCaption(NewCaption:String);
Begin
     If NewCaption = Text Then Exit;

     If FCaption<>Nil Then FreeMem(FCaption,Length(FCaption^)+1);
     FCaption:=Nil;
     If NewCaption<>'' Then
     Begin
          GetMem(FCaption,Length(NewCaption)+1);
          FCaption^:=NewCaption;
     End;

     {$IFDEF OS2}
     //If FTreeRec<>Nil Then FTreeRec^.RecordCore.pszIcon:=FCaption;

     //stVova
     If FTreeRec<>Nil Then
       begin
       FTreeRec^.RecordCore.pszIcon:=FCaption;
       FTreeRec^.RecordCore.pszName:=FCaption;
       FTreeRec^.RecordCore.pszText:=FCaption;
       end;
     //-----

     {$ENDIF}
     {$IFDEF Win95}
     If FTreeRec<>Nil Then
     Begin
          FTreeRec^.RecordCore.pszText:=FCaption;
          If FCaption<>Nil Then
             FTreeRec^.RecordCore.cchTextMax:=Length(FCaption^)+1
          Else FTreeRec^.RecordCore.cchTextMax:=0;
     End;
     {$ENDIF}

     FListView.UpdateNode(Self);
End;


Procedure TPDEListBoxNode.SetBitmap(NewBitmap:TBitmap);
Begin
     FBitmap:=FListView.AddPicture(NewBitmap);

     {$IFDEF OS2}
     If FTreeRec<>Nil Then
     Begin
        If FBitmap<>Nil Then
           FTreeRec^.RecordCore.hbmBitmap:=FBitmap.Handle
        Else
           FTreeRec^.RecordCore.hbmBitmap:=0;
     End;
     {$ENDIF}
     {$IFDEF Win95}
     If FTreeRec<>Nil Then
     Begin
        If FBitmap<>Nil Then
           FTreeRec^.RecordCore.iImage := TPDEListBoxBitmap(FBitmap).FHimlIndex
        Else
           FTreeRec^.RecordCore.iImage:=0;
     End;
     {$ENDIF}

     FListView.UpdateNode(Self);
End;


Function TPDEListBoxNode.GetBitmap:TBitmap;
Begin
     If FBitmap = Nil Then
     Begin
          FBitmap.Create;
          Include(FBitmap.ComponentState, csDetail);
     End;
     Result := FBitmap;
End;


Constructor TPDEListBoxNode.Create(Owner:TPDEListBox);
Begin
     Inherited Create;

     If Owner Is TPDEListBox Then
     Begin
          FListView := TPDEListBox(Owner)
     End
     Else Raise EListViewError.Create('Invalid listview item owner');
End;

Destructor TPDEListBoxNode.Destroy;
Begin
     RemoveRecord(Self,True);

     If FCaption <> Nil Then
     Begin
          FreeMem(FCaption,Length(FCaption^)+1);
          FCaption := Nil;
     End;

     Inherited Destroy;
End;

Function TPDEListBoxNode.GetItemRect:TRect;
{$IFDEF OS2}
Var RecRect:QUERYRECORDRECT;
{$ENDIF}
Begin
     FillChar(result,sizeof(TRect),0);
     {$IFDEF OS2}
     RecRect.cb:=sizeof(QUERYRECORDRECT);
     RecRect.pRecord:=@FTreeRec^.RecordCore;
     RecRect.fRightSplitWindow:=0;
     RecRect.fsExtent:=CMA_ICON OR CMA_TEXT;
     WinSendMsg(FListView.Handle,CM_QUERYRECORDRECT,LongWord(@Result),LongWord(@RecRect));
     {$ENDIF}
End;

{
ͻ
                                                                           
 Speed-Pascal/2 Version 2.0                                                
                                                                           
 Speed-Pascal Component Classes (SPCC)                                     
                                                                           
 This section: TPDEListBox Class Implementation                              
                                                                           
 (C) 1995,97 SpeedSoft. All rights reserved. Disclosure probibited !       
                                                                           
ͼ
}


Procedure TPDEListBox.UpdateNode(Node:TPDEListBoxNode);
Begin
     If Handle=0 Then Exit;
     {$IFDEF OS2}
     WinSendMsg(Handle,CM_INVALIDATERECORD,LongWord(@Node.FTreeRec),
                MPFROM2SHORT(1,0));
     {$ENDIF}
     {$IFDEF Win95}
     SendMessage(Handle,LVM_SETITEM,0,LongWord(@Node.FTreeRec^.RecordCore));
     {$ENDIF}
End;

Procedure TPDEListBox.SetCnrInfo;
Var acnrInfo:CNRINFO;
    Flags:LongWord;
Begin
     If Handle=0 Then Exit;

     FillChar(acnrInfo,SizeOf(CNRINFO),0);
     Flags:=CMA_FLWINDOWATTR;

     With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);
          flWindowAttr:=CV_NAME or CV_FLOW;//}CV_ICON;
          slBitmapOrIcon.CX:=FBitmapSize.CX;
          slBitmapOrIcon.CY:=FBitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWBITMAP;// or CA_CONTAINERTITLE;
     End;
     WinSendMsg(Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

End;


Procedure TPDEListBox.GetClassData(Var ClassData:TClassData);
Begin
     Inherited GetClassData(ClassData);

     {$IFDEF OS2}
     ClassData.ClassULong := WC_CONTAINER;
     {$ENDIF}
     {$IFDEF Win95}
     CreateSubClass(ClassData,WC_LISTVIEW);
     {$ENDIF}
End;

Procedure TPDEListBox.CreateParams(Var Params:TCreateParams);
Begin
     Inherited CreateParams(Params);

     {$IFDEF OS2}
     Params.Style := Params.Style Or CCS_AUTOPOSITION;
     If FMultipleSel Then Params.Style := Params.Style Or CCS_MULTIPLESEL
     Else Params.Style := Params.Style Or CCS_SINGLESEL;
     {$ENDIF}
     {$IFDEF Win95}
     Params.Style := Params.Style Or LVS_AUTOARRANGE;
     Params.Style := Params.Style Or WS_CHILD Or LVS_ICON;
     If Not FMultipleSel Then Params.Style:=Params.Style Or LVS_SINGLESEL;

     If FBorderStyle = bsSingle Then
     Begin
          Params.Style := Params.Style Or WS_BORDER;             {Single}
          Params.ExStyle := Params.ExStyle Or WS_EX_CLIENTEDGE;  {Double}
     End;
     {$ENDIF}
End;

Procedure TPDEListBox.SetupImageList;
{$IFDEF Win95}
Var  Count:LongInt;
     T:LongInt;
     Bitmap:TPDEListBoxBitmap;
     BitHandle:LongWord;
{$ENDIF}
Begin
     {$IFDEF Win95}
     If Handle=0 Then Exit;
     If FPictureList=Nil Then Exit;

     Count:=FPictureList.Count;

     If Count=0 Then Exit;

     If FHim<>Nil Then ImageList_Destroy(FHim);

     FHim:=ImageList_Create(FBitmapSize.CX,
                            FBitmapSize.CY,
                            ILC_COLOR4,Count,0);

     For T:=0 To FPictureList.Count-1 Do
     Begin
          Bitmap:=TPDEListBoxBitmap(FPictureList.Bitmaps[T]);
          BitHandle:=Bitmap.CreateBitmapFromClass(FBitmapSize.CX,FBitmapSize.CY);
          Bitmap.FHimlIndex:=ImageList_AddIcon(FHim,BitHandle);
          DeleteObject(BitHandle);
     End;

     SendMessage(Handle,LVM_SETIMAGELIST,LVSIL_NORMAL,LongWord(FHim));
     {$ENDIF}
End;

Procedure SetupNode(Node:TPDEListBoxNode);
Begin
     {$IFDEF OS2}
     //Node.FTreeRec^.RecordCore.pszIcon := Node.FCaption;

     //stVova
       Node.FTreeRec^.RecordCore.pszIcon:=Node.FCaption;
       Node.FTreeRec^.RecordCore.pszName:=Node.FCaption;
       Node.FTreeRec^.RecordCore.pszText:=Node.FCaption;
     //-----

     If Node.FBitmap<>Nil Then
       Node.FTreeRec^.RecordCore.hbmBitmap:=Node.FBitmap.Handle
     Else
       Node.FTreeRec^.RecordCore.hbmBitmap:=0;
     //Node.FTreeRec^.RecordCore.ptlIcon.X:=20;
     //Node.FTreeRec^.RecordCore.ptlIcon.Y:=20;
     {$ENDIF}
     {$IFDEF Win95}
     Node.FTreeRec^.RecordCore.Mask:=LVIF_TEXT Or LVIF_IMAGE Or LVIF_PARAM;
     Node.FTreeRec^.RecordCore.iItem:=Node.Index;
     Node.FTreeRec^.RecordCore.iSubItem:=0;
     Node.FTreeRec^.RecordCore.State:=0;
     Node.FTreeRec^.RecordCore.StateMask:=0;
     Node.FTreeRec^.RecordCore.pszText:=Node.FCaption;
     Node.FTreeRec^.RecordCore.cchTextMax:=Length(Node.FCaption^)+1;
     If Node.FBitmap<>Nil Then
       Node.FTreeRec^.RecordCore.iImage:=TPDEListBoxBitmap(Node.FBitmap).FHimlIndex
     Else
       Node.FTreeRec^.RecordCore.iImage:=0;
     Node.FTreeRec^.RecordCore.LParam:=LongWord(Node);
     {$ENDIF}
End;



Procedure TPDEListBox.SetupList;
Var T:LongInt;
    Node,PrevNode:TPDEListBoxNode;
    P:Pointer;
Begin
     If Handle=0 Then Exit;
     If FInitNodes=Nil Then Exit;
     {Create All main Nodes}
     PrevNode:=Nil;
     For T:=0 To FNodes.Count-1 Do
     Begin
          Node:=FNodes.Items[T];
          If Node.FTreeRec=Nil Then
          Begin
               AllocateRecord(Handle,Node.FTreeRec);
               SetupNode(Node);
          End;

          If PrevNode=Nil
          Then
          Begin
              LongWord(P):=CMA_FIRST;
              InsertRecord(Node,Nil,P);
          End
          Else InsertRecord(Node,Nil,Pointer(PrevNode.FTreeRec));
          PrevNode:=Node;
     End;
     FInitNodes:=Nil;
End;


Procedure TPDEListBox.CreateWnd;
Begin
     Inherited CreateWnd;

     If Handle=0 Then Exit;
     {Set Options}
     SetCnrInfo;
     SetupImageList;
     SetupList;
End;

Procedure TPDEListBox.SetupComponent;
Begin
     Inherited SetupComponent;

     FBitmapSize.CX:=16;
     FBitmapSize.CY:=18;

     FNodeClass := TPDEListBoxNode;
     Ownerdraw := False;
     Name:='ListView';
     Height:=150;
     Width:=150;
     color:=clWindow;
     ParentPenColor:=False;
     ParentColor:=False;
     FBorderStyle:=bsSingle;

     FileAttributes := faAnyFile; //faDirectory
     FMask := '*.*';
     FSelectedLabel:=nil;
     FSelectedName:=nil;
     FSelectedPath:=nil;

     OnMouseDown := vFilesOnMouseDown;

End;

{$IFDEF OS2}
Procedure TPDEListBox.SetupShow;
Begin
     Inherited SetupShow;
     CreateCanvas;
End;


Procedure TPDEListBox.WMPaint(Var Msg:TMessage);
Var
  rc1,rcupdate:TRect;
  ii, bms: LongInt;
Begin
     If FBorderStyle = bsSingle Then
     Begin {Exclude border from Redraw area}
          rc1 := ClientRect;
          {????????+-1}
          Inc(rc1.Right);
          Inc(rc1.Top);
          InflateRect(rc1,-2,-2);

          WinQueryUpdateRect(Handle,RECTL(rcupdate));
          WinValidateRect(Handle,RECTL(rcupdate),False);
          rcupdate := IntersectRect(rcupdate,rc1);
          WinInvalidateRect(Handle,RECTL(rcupdate),False);
     End;

     DefaultHandler(Msg);       {Do Default Action}

     If FBorderStyle = bsSingle Then
     Begin
          rc1 := ClientRect;
          DrawSystemBorder(Self,rc1,FBorderStyle); {overpaint Text ON the border}
     End;

     if ItemCount > 0 then
     for ii:=ItemCount - 1 downto 0 do
     if Items[ii].InCase then
       begin
       rc1 := Items[ii].ItemRect;
       bms := BitmapSize.CX;
       if bms = 0 then bms := 16;
       bms := bms div 4;
       Canvas.Pen.Mode := pmNot;
       Canvas.Pen.Width := 2;
       Canvas.MoveTo(rc1.Left, rc1.Bottom + bms div 2);
       Canvas.LineTo(rc1.Left + bms, rc1.Bottom + bms div 2);
       Canvas.MoveTo(rc1.Left + bms div 2, rc1.Bottom + bms);
       Canvas.LineTo(rc1.Left + bms div 2, rc1.Bottom);
       end;


End;
{$ENDIF}


Procedure TPDEListBox.SetBorderStyle(NewBorder:TBorderStyle);
Begin
     FBorderStyle := NewBorder;
     {$IFDEF OS2}
     Invalidate;
     {$ENDIF}
     {$IFDEF Win95}
     RecreateWnd;
     {$ENDIF}
End;

Procedure TPDEListBox.Clear;
Var  T:LongInt;
     Node:TPDEListBoxNode;
Begin
    {Store Tree Items -> Linear List}
    If FNodes<>Nil Then
    Begin
         For t:=FNodes.Count-1 Downto 0 Do
         Begin
             Node:=FNodes[t];
             Node.Destroy;
         End;
         FNodes.Destroy;
         FNodes:=Nil;
    End;

End;

Procedure TPDEListBox.BeginUpdate;
Begin
     If FUpdateCount = 0 Then
     Begin
          If Handle <> 0 Then
          {$IFDEF OS2}
          WinEnableWindowUpdate(Handle,False);
          {$ENDIF}
          {$IFDEF Win95}
          SendMessage(Handle,WM_SETREDRAW, 0, 0);
          {$ENDIF}
     End;
     Inc(FUpdateCount);
End;


Procedure TPDEListBox.EndUpdate;
Begin
     Dec(FUpdateCount);
     If FUpdateCount = 0 Then
     Begin
          If Handle <> 0 Then
          {$IFDEF OS2}
          WinEnableWindowUpdate(Handle,True);
          {$ENDIF}
          {$IFDEF Win95}
          SendMessage(Handle,WM_SETREDRAW, 1, 0);
          {$ENDIF}
          Invalidate;
     End;
End;

Procedure TPDEListBox.DestroyWnd;
Begin
     Clear;

     Inherited DestroyWnd;
End;


Destructor TPDEListBox.Destroy;
Begin
     If FPictureList <> Nil Then
     Begin
          FPictureList.Destroy;  {Destroy local Bitmaps}
          FPictureList := Nil;
     End;

     {$IFDEF Win95}
     If FHim <> Nil Then ImageList_Destroy(FHim);
     FHim := Nil;
     {$ENDIF}

     Inherited Destroy;
End;

Function TPDEListBox.AddPicture(NewBitmap:TBitmap):TBitmap;
Var  idx:LongInt;
Begin
     If NewBitmap = Nil Then
     Begin
          Result := Nil;
          Exit;
     End;

     If FPictureList = Nil Then
     Begin
          FPictureList.Create;
          FPictureList.BitmapClass := TPDEListBoxBitmap;
          FPictureList.Duplicates := False;
     End;

     idx := FPictureList.IndexOfOrigin(NewBitmap);

     If idx < 0 Then                                     {Not found}
     Begin
          idx := FPictureList.Add(NewBitmap);  {Create local Bitmap}
          SetupImageList;
     End;
     Result := FPictureList.Bitmaps[idx];
End;

Procedure TPDEListBox.SetSorted(NewValue:Boolean);
Var Nodes:TList;
    t:Longint;
    Node:TPDEListBoxNode;
Begin
    If NewValue=FSorted Then exit;

    FSorted:=NewValue;

    If Sorted Then //resort
      If FNodes<>Nil Then
    Begin
       BeginUpdate;

       Nodes:=FNodes;

       FNodes:=Nil;
       For t:=Nodes.Count-1 Downto 0 Do
       Begin
           Node:=Nodes[t];
           Add(Node.Text,Node.Data,Node.FBitmap);
           Node.Destroy;
       End;
       Nodes.Destroy;

       EndUpdate;
    End;
End;

Function TPDEListBox.Add(Const Text:String;Data:Pointer;Bitmap:TBitmap):TPDEListBoxNode;
Var  NewNode,PrevNode,Node:TPDEListBoxNode;
     P:Pointer;
     t,t1:LongInt;
Begin
     NewNode := FNodeClass.Create(Self);
     NewNode.Data := Data;
     NewNode.Text := Text;
     NewNode.FBitmap:=AddPicture(Bitmap);
     If Bitmap<>Nil Then
     Begin
        If FBitmapSize.CX=0 Then FBitmapSize.CX:=Bitmap.Width;
        If FBitmapSize.CY=0 Then FBitmapSize.CY:=Bitmap.Width;
     End;

     If FNodes=Nil Then FNodes.Create;
     If Sorted Then
     Begin
        NewNode.FIndex:=FNodes.Count;
        For t:=0 To FNodes.Count-1 Do
        Begin
            Node:=FNodes[t];
            If Node.Text>Text Then
            Begin
                NewNode.FIndex:=Node.FIndex;
                For t1:=t To FNodes.Count-1 Do
                Begin
                    Node:=TPDEListBoxNode(FNodes[t1]);
                    inc(Node.FIndex);
                End;
                break;
            End;
        End;

        FNodes.Insert(NewNode.FIndex,NewNode);
     End
     Else
     Begin
        NewNode.FIndex:=FNodes.Count;
        FNodes.Add(NewNode);
     End;

     If Handle=0 Then FInitNodes:=FNodes
     Else
     Begin
          If FNodes.Count=1 Then PrevNode:=Nil
          Else PrevNode:=FNodes.Items[NewNode.FIndex-1];

          If NewNode.FTreeRec=Nil Then
          Begin
               AllocateRecord(Handle,NewNode.FTreeRec);
               SetupNode(NewNode);
          End;

          If PrevNode=Nil
          Then
          Begin
              LongWord(P):=CMA_FIRST;
              InsertRecord(NewNode,Nil,P);
          End
          Else InsertRecord(NewNode,Nil,Pointer(PrevNode.FTreeRec));
     End;
     Result := NewNode;
End;

Function TPDEListBox.AddFN(Const Text, RealName:String;Data:Pointer;Bitmap:TBitmap):TPDEListBoxNode;
Begin
  Result := Add(Text, Data, Bitmap);
  Result.RealFileName := RealName;
End;

Function TPDEListBox.Get(Index:LongInt):TPDEListBoxNode;
Begin
     Result:=FNodes.Items[Index];
End;

Function TPDEListBox.GetItemCount:LongInt;
Begin
     If FNodes=Nil Then Result:=0
     Else Result:=FNodes.Count;
End;

Procedure TPDEListBox.ScanEvent(Var KeyCode:TKeyCode;RepeatCount:Byte);
Begin
     Case KeyCode Of
       kbCUp,kbCDown,kbCLeft,kbCRight: begin end{!}
       Else Inherited ScanEvent(KeyCode,RepeatCount);
     End;
End;

Procedure TPDEListBox.ParentNotification(Var Msg:TMessage);
{$IFDEF OS2}
Var  Node:TPDEListBoxNode;
     RecordCore:PListViewRecord;
     RecEnter:PNOTIFYRECORDENTER;
{$ENDIF}
Begin
     {$IFDEF OS2}
     Case Msg.Param1Hi Of
       CN_SCROLL:
       Begin
            Inherited ParentNotification(Msg);

            {!! Update BitBlt area Of the Ownerdraw Frame}
            If FBorderStyle = bsSingle Then Invalidate;
       End;
       CN_ENTER:      {Enter & DoubleClick}
       Begin
            If Designed Then Exit;
            Inherited ParentNotification(Msg);

            RecEnter := Pointer(Msg.Param2);
            If RecEnter = Nil Then Exit;
            RecordCore := Pointer(RecEnter^.pRecord);
            If RecordCore = Nil Then Exit;
            Node := RecordCore^.Node;

            If Node Is TPDEListBoxNode Then
            Begin
                 ItemSelect(Node.Index);
                 If OnItemSelect <> Nil Then OnItemSelect(Self,Node.Index);
            End;
       End;
       CN_CONTEXTMENU:
       Begin
            If Designed Then Exit;
            CheckMenuPopup(FPopupPos);
       End;
       Else Inherited ParentNotification(Msg);
     End;
     {$ENDIF}

     {$IFDEF Win95}
     Inherited ParentNotification(Msg);
     {$ENDIF}
End;

Function TPDEListBox.GetItemIndex:LongInt;
Var RecordCore:PListViewRecord;
    rc1: TRect;
    bms: Integer;
Begin
     Result:=-1;
     If Handle=0 Then Exit;

     RecordCore:=Pointer(WinSendMsg(Handle,CM_QUERYRECORDEMPHASIS,
                         CMA_FIRST,CRA_SELECTED));
     If RecordCore<>Nil Then
     begin
     Result:=RecordCore^.Node.Index;

     if Items[Result].InCase then
       begin
       rc1 := Items[Result].ItemRect;
       bms := BitmapSize.CX;
       if bms = 0 then bms := 16;
       bms := bms div 4;
       Canvas.Pen.Mode := pmNot;
       Canvas.Pen.Width := 2;
       Canvas.MoveTo(rc1.Left, rc1.Bottom + bms div 2);
       Canvas.LineTo(rc1.Left + bms, rc1.Bottom + bms div 2);
       Canvas.MoveTo(rc1.Left + bms div 2, rc1.Bottom + bms);
       Canvas.LineTo(rc1.Left + bms div 2, rc1.Bottom);
       end;
     end;

End;

Procedure TPDEListBox.SetItemIndex(NewValue:LongInt);
Begin
     If Handle=0 Then Exit;
     If ((NewValue<0)Or(NewValue>FNodes.Count-1)) Then Exit;

     WinSendMsg(Handle,CM_SETRECORDEMPHASIS,LongWord(Items[NewValue].FTreeRec),
                MPFROM2SHORT(1,CRA_SELECTED));
End;

Function TPDEListBox.NodeFromPoint(pt:TPoint):TPDEListBoxNode;
Var t:LongInt;
    rec:TRect;
Begin
    For t:=0 To ItemCount-1 Do
    Begin
        result:=Items[t];
        rec:=result.ItemRect;
        If ((pt.X>=rec.Left)And(pt.X<=rec.Right)) Then
          If ((pt.Y>=rec.Bottom)And(pt.Y<=rec.Top)) Then
            begin
              exit;
            end;
    End;
    result:=Nil;
End;

Procedure TPDEListBox.DrawDragRect;
Begin
     If Canvas = Nil Then Exit;
     Canvas.Pen.Mode:=pmNot;
     Canvas.Pen.color:=clBlack;
     Canvas.Pen.Style:=psDot;
     Canvas.Rectangle(FDragRect);
     Canvas.Pen.Mode:=pmCopy;
End;

Procedure TPDEListBox.DragOver(Source:TObject;X,Y:LongInt;State:TDragState;Var Accept:Boolean);
Var Node:TPDEListBoxNode;
Label invalid;
Begin
     Node:=Nil;
     Inherited DragOver(Source,X,Y,State,Accept);
     If FShowDragRects Then
     Begin
          If Accept Then
          Begin
               Node:=NodeFromPoint(Point(X,Y));
               If Node<>Nil Then
               Begin
                    Case State Of
                       dsDragEnter:
                       Begin
                            CreateDragCanvas;
                            If FDragRectValid Then DrawDragRect; //Delete old
                            FDragRect := Node.ItemRect;
                            FDragRectValid:=True;
                            DrawDragRect;  //Draw New
                            DeleteDragCanvas;
                       End;
                       dsDragMove:
                       If Node<>FDragSelected Then
                       Begin
                            CreateDragCanvas;
                            If FDragRectValid Then DrawDragRect; //Delete old
                            FDragRect := Node.ItemRect;
                            FDragRectValid:=True;
                            DrawDragRect; //Draw New
                            DeleteDragCanvas;
                       End;
                       dsDragLeave:
                       Begin
                            If FDragRectValid Then
                            Begin
                                 FDragRectValid:=False;
                                 CreateDragCanvas;
                                 DrawDragRect; //Delete old
                                 DeleteDragCanvas;
                            End;
                       End;
                    End; //Case
               End
               Else Goto invalid;
          End
          Else
          Begin
invalid:
               If FDragRectValid Then
               Begin
                    FDragRectValid:=False;
                    CreateDragCanvas;
                    DrawDragRect; //Delete old
                    DeleteDragCanvas;
               End;
          End;
          FDragSelected:=Node;
     End;
End;

Procedure TPDEListBox.DragDrop(Source:TObject;X,Y:LongInt);
Begin
     If FDragRectValid Then
     Begin
          CreateDragCanvas;
          DrawDragRect; //Delete old
          DeleteDragCanvas;
          FDragRectValid:=False;
     End;
     Inherited DragDrop(Source,X,Y);
End;

Function TPDEListBox.GetSelect(Index:LongInt):Boolean;
Var RecordCore:PListViewRecord;
    Start:LongWord;
Begin
     Result:=False;
     If Handle=0 Then Exit;
     If ((Index<0)Or(Index>FNodes.Count-1)) Then Exit;

     If Index=0 Then Start:=CMA_FIRST
     Else Start:=LongWord(Items[Index-1].FTreeRec);

     RecordCore:=Pointer(WinSendMsg(Handle,CM_QUERYRECORDEMPHASIS,
                         Start,CRA_SELECTED));
     If RecordCore<>Nil Then
     Begin
         If Start=CMA_FIRST Then
         Begin
              If RecordCore^.Node=Items[0].FTreeRec^.Node Then Result:=True;
         End
         Else
         Begin
              If RecordCore^.Node=Items[Index].FTreeRec^.Node Then Result:=True;
         End;
     End;

End;

Procedure TPDEListBox.SetSelect(Index:LongInt;NewValue:Boolean);
Var Value:LongInt;
Begin
     If Handle=0 Then Exit;
     If ((Index<0)Or(Index>FNodes.Count-1)) Then Exit;

     If NewValue Then Value:=1
     Else Value:=0;

     WinSendMsg(Handle,CM_SETRECORDEMPHASIS,LongWord(Items[Index].FTreeRec),
                MPFROM2SHORT(Value,CRA_SELECTED));

End;


Procedure TPDEListBox.MouseClick(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);
Begin
     If OnMouseClick <> Nil Then OnMouseClick(Self,Button,ShiftState,X,Y);
     {no Inherited because Of CN_CONTEXTMENU, but Store the mouse Pos}
     FPopupPos := Point(X,Y);
End;

{$IFDEF WIN32}
Procedure TPDEListBox.MouseDblClick(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);
Var Index:LongInt;
    HitTest:LV_HITTESTINFO;
    pt:TPoint;
Begin
     Inherited MouseDblClick(Button,ShiftState,X,Y);
     LastMsg.CallDefaultHandler;
     If Button=mbLeft Then
     Begin
          pt:=Point(X,Y);
          TransformClientPoint(pt,Self,Nil);
          HitTest.pt:=pt;
          HitTest.Flags:=LVHT_ONITEMICON;
          Index:=SendMessage(Handle,LVM_HITTEST,0,LongWord(@HitTest));
          If Index<>-1 Then
          Begin
               ItemSelect(Index);
               If OnItemSelect <> Nil Then OnItemSelect(Self,Index);
          End;
     End;
End;
{$ENDIF}

Procedure TPDEListBox.LoadFromPath;
var
  maskedpath: String;
  sr: TSearchRec;
  rez: integer;
Begin

Cursor := crHourGlass;
BeginUpdate;

  if path[length(path)] = '\' then
    maskedpath := path+'*.*'
    else
    maskedpath := path+'\*.*';

rez:=FindFirst(maskedpath , FileAttributes, sr);
while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)<>0 then
      if sr.name<>'..' then
        AddIS(sr.name, nil, DirBitmap, True);
    end;
FindClose(sr);

rez:=FindFirst(maskedpath , FileAttributes, sr);
if sr.name<>'.' then
    begin
    if (sr.attr and faDirectory)<>0 then
      AddIS(sr.name, nil, DirBitmap, True)
      else
        begin
        if (Mask = '*.*') then
          AddIS(sr.name, nil, FileBitmap, False)
          //'*.txt;*.htm'
          else if (pos(lowercase(extractfileext(sr.name)), Mask) <> 0) then
          AddIS(sr.name, nil, FileBitmap, False);
        end;
    end;
while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then
      if sr.name<>'..' then
        begin
        //check if file in Mask (ie 'file.txt' = '*.txt')
        if (Mask = '*.*') then
          AddIS(sr.name, nil, FileBitmap, False)
          //'*.txt;*.htm'
          else if (pos(lowercase(extractfileext(sr.name)), Mask) <> 0) then
          AddIS(sr.name, nil, FileBitmap, False);
        end;
    end;
FindClose(sr);

EndUpdate;
Cursor := crDefault;

End;

Procedure TPDEListBox.SetPath(Value: String);
var
  sr: TsearchRec;
  temp: String;
Begin

temp:=value;
if temp[length(temp)]='\' then
  temp:=temp+'*.*'
  else
  temp:=temp+'\*.*';

if FindFirst(temp , faAnyFile, sr)<>0 then
  begin
  FindClose(sr);
  exit;
  end;

if Value <> FPath then
  Begin
  FPath := Value;
  if FSelectedPath <> nil then FSelectedPath.Text := fpath;
  Clear;
  LoadFromPath;
  End;

End;


Procedure TPDEListBox.ItemSelect(Index: LongInt);
var
  temp: String;
Begin

  if Items[Index].IsDirectory then
    begin
    if (FPath[length(FPath)] = '\') then
      FPath:=FPath+Items[ItemIndex].Text+'\'
      else
      FPath:=FPath+'\'+Items[ItemIndex].Text+'\';
    if FSelectedPath <> nil then FSelectedPath.Text := fpath;
    Clear;
    LoadFromPath;
    End;

End;

Procedure TPDEListBox.SetDirBitmap(Value: TBitmap);
Begin
if Value <> nil then
  FDirBitmap := Value;
End;

Procedure TPDEListBox.SetFileBitmap(Value: TBitmap);
Begin
if Value <> nil then
  FFileBitmap := Value;
End;

Procedure TPDEListBox.SetSelectedLabel(Value: TLabel);
Begin
if Value <> nil then
  FSelectedlabel := Value;
End;

Procedure TPDEListbox.SetSelectedName(Value: TEdit);
Begin
if Value <> nil then
  FSelectedName := Value;
End;

Procedure TPDEListbox.SetSelectedPath(Value: TEdit);
Begin
if Value <> nil then
  FSelectedPath := Value;
End;

Procedure TPDEListbox.SetMask(Value: String);
Begin
if FMask <> Value then
  begin
  FMask := Value;
  Clear;
  LoadFromPath;
  //LoadFromPath;
  //Invalidate;
  end;
End;

Function TPDEListBox.AddIS(Const Text:String;Data:Pointer;Bitmap:TBitmap;IsDir:Boolean):TPDEListBoxNode;
Begin
  Result := Add(Text, Data, Bitmap);
  Result.IsDirectory := IsDir;
  //Result.OnClick := ItemClick;
End;

Procedure TPDEListbox.vFilesOnMouseDown (Sender: TObject; Button: TMouseButton; Shift: TShiftState; X: LongInt; Y: LongInt);
Begin

if NodeFromPoint(Point(x, y))<>nil then
  begin
  ItemIndex:=TPDEListBoxNode(NodeFromPoint(Point(x, y))).Index;

  if FSelectedName <> nil then
    FSelectedName.Text := Items[ItemIndex].Text;
  end;

End;

Begin
End.


