(*////////////////////////////////////////////////////
//    PDE -  graphical user shell for OS/2 Warp
//    Copyleft stVova, [PDE-Team], 2003 - 2004
//    http://os2progg.by.ru/pde
//    NLS (multi language support) for PDE
//    and PDE *.CFG files routines.
/////////////////////////////////////////////////////*)

unit pdeNLS;

interface

Uses
  Classes, Forms, SysUtils, Dos, SysUtils, Dialogs;

//--load key values from Theme.cfg (located at [PDE_HOME]\Bitmaps\[theme_name])
function pdeLoadThemeStr(theme, key: String): String;
function pdeLoadThemeInt(theme, key: String): Integer;
function pdeLoadThemeColor(theme, key: String): TColor;
//same, but with default values
function pdeLoadThemeStrD(theme, key: String; defvalue: String): String;
function pdeLoadThemeIntD(theme, key: String; defvalue: LongInt): Integer;

//--load key values from .cfg files of PDE
function pdeLoadCfgStr(cfgfile, key: String): String;
function pdeLoadCfgInt(cfgfile, key: String): Integer;
function pdeLoadCfgColor(cfgfile, key: String): TColor;
//same, but with default values
function pdeLoadCfgStrD(cfgfile, key: String; defvalue: String): String;
function pdeLoadCfgIntD(cfgfile, key: String; defvalue: LongInt): Integer;

//--load NLS string from PDE .nls files
function pdeLoadNLS(keystr, defaultValue: String): String;

//--rewrite hole .cfg with new data from StringList
function pdeSaveCfgFile(cfgfile: String; cfgdata: TStringList): Integer;

implementation

//-----------------------------------------

function pdeLoadThemeStrD(theme, key: String; defvalue: String): String;
Begin
  Result := pdeLoadThemeStr(theme, key);
  if Result = '' then
    Result := defvalue;
End;

function pdeLoadThemeIntD(theme, key: String; defvalue: LongInt): Integer;
Begin
  Result := pdeLoadThemeInt(theme, key);
  if Result = 0 then
    Result := defvalue;
End;

function pdeLoadThemeStr(theme, key: String): String;
var
  homepath: String;
  afile: TextFile;
  tmpkey, tmpstr: String;
  fname: String;
begin
  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  Result := '';

  if FileExists(homepath + '\Bitmaps\' + theme+'\Theme.cfg') then
    fname := homepath + '\Bitmaps\' + theme+'\Theme.cfg'
  else if FileExists('Theme.cfg') then
    fname := 'Theme.cfg'
  else fname := '';

  if fname <> '' then
  try
  AssignFile(afile, fname);
  Reset(afile);
  While not(eof(afile)) do
    begin
    //load config string
    Readln(afile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(key) then
      begin
      Result := tmpstr;
      CloseFile(afile);
      exit;
      end;
    end;

  except
    CloseFile(afile);
  end;
  CloseFile(afile);

end; {pdeLoadThemeStr}

function pdeLoadThemeInt(theme, key: String): Integer;
var
  homepath: String;
  afile: TextFile;
  tmpkey, tmpstr: String;
begin
  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  Result := 0;

  if FileExists(homepath + '\Bitmaps\' + theme+'\Theme.cfg') then
  try
  AssignFile(afile, homepath + '\Bitmaps\' + theme+'\Theme.cfg');
  Reset(afile);
  While not(eof(afile)) do
    begin
    //load config Integer value
    Readln(afile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(key) then
      begin
      try
        Result := StrToInt(tmpstr);
        except
        Result := 0;
        end;
      CloseFile(afile);
      exit;
      end;
    end;

  except
    CloseFile(afile);
  end;
  CloseFile(afile);

end; {pdeLoadThemeInt}

function pdeLoadThemeColor(theme, key: String): TColor;
var
  homepath: String;
  afile: TextFile;
  tmpkey, tmpstr: String;
begin
  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  Result := $000000;

  if FileExists(homepath + '\Bitmaps\' + theme+'\Theme.cfg') then
  try
  AssignFile(afile, homepath + '\Bitmaps\' + theme+'\Theme.cfg');
  Reset(afile);
  While not(eof(afile)) do
    begin
    Readln(afile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(key) then
      begin
      try
        Result := TColor(StrToInt(tmpstr));
        except
        Result := $000000;
        end;
      CloseFile(afile);
      exit;
      end;
    end;

  except
    CloseFile(afile);
  end;
  CloseFile(afile);

end; {pdeLoadThemeColor}

//-----------------------------------------

function pdeLoadCfgStrD(cfgfile, key: String; defvalue: String): String;
Begin
  Result := pdeLoadCfgStr(cfgfile, key);
  if Result = '' then
    Result := defvalue;
End;

function pdeLoadCfgIntD(cfgfile, key: String; defvalue: LongInt): Integer;
Begin
  Result := pdeLoadCfgInt(cfgfile, key);
  if Result = 0 then
    Result := defvalue;
End;

//-----------------------------------------

function pdeLoadCfgStr(cfgfile, key: String): String;
var
  homepath: String;
  afile: TextFile;
  tmpkey, tmpstr: String;
  fname: String;
begin
  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  Result := '';

  if FileExists(homepath + '\PDEConf\' + cfgfile) then
    fname := homepath + '\PDEConf\' + cfgfile
  else if FileExists(cfgfile) then
    fname := cfgfile
  else fname := '';

  if fname <> '' then
  try
  AssignFile(afile, fname);
  Reset(afile);
  While not(eof(afile)) do
    begin
    //load config string
    Readln(afile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(key) then
      begin
      Result := tmpstr;
      CloseFile(afile);
      exit;
      end;
    end;

  except
    CloseFile(afile);
  end;
  CloseFile(afile);

end; {pdeLoadCfgStr}

//-----------------------------------------

function pdeLoadCfgInt(cfgfile, key: String): Integer;
var
  homepath: String;
  afile: TextFile;
  tmpkey, tmpstr: String;
begin
  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  Result := 0;

  if FileExists(homepath + '\PDEConf\' + cfgfile) then
  try
  AssignFile(afile, homepath + '\PDEConf\' + cfgfile);
  Reset(afile);
  While not(eof(afile)) do
    begin
    //load config Integer value
    Readln(afile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(key) then
      begin
      try
        Result := StrToInt(tmpstr);
        except
        Result := 0;
        end;
      CloseFile(afile);
      exit;
      end;
    end;

  except
    CloseFile(afile);
  end;
  CloseFile(afile);

end; {pdeLoadCfgInt}

//-----------------------------------------

function pdeLoadCfgColor(cfgfile, key: String): TColor;
var
  homepath: String;
  afile: TextFile;
  tmpkey, tmpstr: String;
begin
  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  Result := $000000;

  if FileExists(homepath + '\PDEConf\' + cfgfile) then
  try
  AssignFile(afile, homepath + '\PDEConf\' + cfgfile);
  Reset(afile);
  While not(eof(afile)) do
    begin
    Readln(afile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(key) then
      begin
      try
        Result := TColor(StrToInt(tmpstr));
        except
        Result := $000000;
        end;
      CloseFile(afile);
      exit;
      end;
    end;

  except
    CloseFile(afile);
  end;
  CloseFile(afile);

end; {pdeLoadCfgColor}

//-----------------------------------------

function pdeLoadNLS(keystr, defaultValue: String): String;
var
  homepath: String;
  nlsfile: TextFile;
  lang: String;
  tmpkey, tmpstr: String;
begin

  //PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

  //current PDE language from general.cfg
  lang := pdeLoadCfgStrD('general.cfg', 'language', 'en_en');

  Result := defaultValue;

  if not FileExists(homepath + '\Languages\'+lang + '.nls') then
    exit;

  try
  AssignFile(nlsfile, homepath + '\Languages\'+lang + '.nls');
  Reset(nlsfile);
  While not(eof(nlsfile)) {and (filepos(nlsfile)<=filesize(nlsfile))} do
    begin
    Readln(nlsfile, tmpstr);
    if tmpstr[1] = '/' then continue;
    tmpkey := copy (tmpstr, 1, pos('=', tmpstr)-1);
    delete(tmpstr, 1, pos('=', tmpstr));
    if lowercase(tmpkey) = lowercase(keystr) then
      begin
      Result := tmpstr;
      CloseFile(nlsfile);
      exit;
      end;
    end;
  except
    //close language file
    CloseFile(nlsfile);
    ShowMessage('PDE "Languages" folder not found!');
  end;
  CloseFile(nlsfile);

end; {pdeLoadNLS}

//-----------------------------------------

function pdeSaveCfgFile(cfgfile: String; cfgdata: TStringList): Integer;
var
  homepath: String;
  afile: TextFile;
  //tmpstr: String;
  counter: Integer;
begin

  if (cfgData <> nil) then
    begin
    //PDE home directory from config.sys
    homepath := getenv('PDE_HOME');
    if homepath = '' then
      homepath := 'c:\pde';

    Result := 0;
    counter := 0;

    try
    AssignFile(afile, homepath + '\PDEConf\' + cfgfile);
    Rewrite(afile);
    while counter < cfgData.Count do
      begin
      Writeln(afile, cfgData.Strings[counter]);
      inc(counter);
      end;
    except
      CloseFile(afile);
      exit;
      end;
    CloseFile(afile);
    end;

end; {pdeSaveCfgFile}

//-----------------------------------------

end.