(*////////////////////////////////////////////////////
//    PDE -  graphical user shell for OS/2 Warp
//    Copyleft stVova, [PDE-Team], 2003
//    http://os2progg.by.ru/pde
//    FileHalf - "Drive Properties" dialog
/////////////////////////////////////////////////////*)

Unit PropUnit2;

Interface

Uses
  Classes, Forms, Graphics, SysUtils, PDENLS, Buttons, PMWin
  , ExtCtrls, StdCtrls, Spin, ComCtrls, os2def;

Type
  TPropForm2 = Class (TForm)
    btnCancel: TButton;
    Shape1: TShape;
    LName: TLabel;
    Bevel1: TBevel;
    pBox: TPaintBox;
    LSize: TLabel;
    LFree: TLabel;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    LUsed: TLabel;
    LSize1: TLabel;
    LUsed1: TLabel;
    LFree1: TLabel;
    Shape5: TShape;
    pBox2: TPaintBox;
    Procedure pBox2OnPaint (Sender: TObject; Const rec: TRect);
    Procedure PropForm2OnShow (Sender: TObject);
    Procedure pBoxOnPaint (Sender: TObject; Const rec: TRect);
    Procedure PropForm2OnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode;
      Var ReceiveR: TForm);
    Procedure btnOKOnClick (Sender: TObject);
    Procedure btnCancelOnClick (Sender: TObject);
    Procedure PropForm2OnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  PropForm2: TPropForm2;
  drSize, drFree: Long;
  bmp: LongWord;

Implementation

Uses Unit1;

Procedure TPropForm2.pBox2OnPaint (Sender: TObject; Const rec: TRect);
var
  ps: hPS;
Begin
  {render image in "bmp" pointer}
  pBox2.canvas.fillrect(pBox2.Canvas.ClipRect, PropForm2.Color);
  ps := WinGetPS(pBox2.Handle);
  WinDrawPointer( ps, 0, 0, bmp, 0);
  WinReleasePS(ps);
End;

Procedure TPropForm2.PropForm2OnShow (Sender: TObject);
Begin
  Shape1.Brush.Color := MainForm.Color;
  LName.Color := MainForm.Color;
  LSize.Color := MainForm.Color;
  LUsed.Color := MainForm.Color;
  LFree.Color := MainForm.Color;
  LSize1.Color := MainForm.Color;
  LUsed1.Color := MainForm.Color;
  LFree1.Color := MainForm.Color;
  btnCancel.Color := MainForm.Color;
  pBox.Color := MainForm.Color;
  bmp := MainForm.vFiles.Items[MainForm.vFiles.ItemIndex].Icon;
End;

Procedure TPropForm2.pBoxOnPaint (Sender: TObject; Const rec: TRect);
Begin

  {paint drive info on pBox canvas}
  pBox.Canvas.FillRect(pBox.ClientRect, Shape1.Brush.Color);

  pBox.Canvas.Pen.Color := clBlack;
  pBox.Canvas.FilledEllipse(110, 70, 110, 70);
  pBox.Canvas.Pen.Color := clBlue;
  pBox.Canvas.FilledEllipse(110, 75, 110, 70);

  pBox.Canvas.Pen.Color := clBlack;
  pBox.Canvas.Brush.Color := clYellow;
  pBox.Canvas.Pie(110, 75, 110, 70, 0, 360*(drFree/drSize));

  pBox.Canvas.Ellipse(110, 75, 110, 70);

End;

Procedure TPropForm2.PropForm2OnTranslateShortCut (Sender: TObject;
  KeyCode: TKeyCode; Var ReceiveR: TForm);
Begin
  if KeyCode=kbEsc then
    btnCancelOnClick (Sender);
End;

Procedure TPropForm2.btnOKOnClick (Sender: TObject);
Begin
  PropForm2.Close;
  WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
End;

Procedure TPropForm2.btnCancelOnClick (Sender: TObject);
Begin
  PropForm2.Close;
  WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
End;

Procedure TPropForm2.PropForm2OnCreate (Sender: TObject);
Begin
  BorderStyle:=bsStealthDlg;
  caption := pdeLoadNLS('popupmenuProperies', '⢠');
  btnCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
End;

Initialization
  RegisterClasses ([TPropForm2, TButton, TShape, TLabel, TBevel
   , TPaintBox]);
End.
