//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  "P-Panel" (DeskHalf.exe). Main module //
//  Copyleft [PDE Team] 2003-2004         //
//  Programmed by: stVova                 //
//----------------------------------------//

Unit Unit2;

Interface

Uses
  Classes, Forms, Graphics, Buttons, PMWin, XplorBtn, ExtCtrls,
  StdCtrls, SysUtils, DeskUni2, PMWP, BSEDos, os2def, strings,
  Dialogs, ComCtrls, RunUnit, pdeNLS, {pdedlgs,} XplorBtn2I
  , pdedlgsDLL;

//Name of the shared memory object
Const
    SharedMemName='DragDrop_ItemsInfo';

//Drag source identification
Const
    DragSourceId='File or Folder to Copy';

Type
  TMainForm = Class (TForm)
    bRoll: TExplorerButton;
    bCalc: TExplorerButton;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    mSetWidth2: TMenuItem;
    MenuItem5: TMenuItem;
    mSetHeight2: TMenuItem;
    MenuItem8: TMenuItem;
    mSetOnTop1: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem12: TMenuItem;
    mSetWidth1: TMenuItem;
    mSetHeight1: TMenuItem;
    mSetDrawers1: TMenuItem;
    mSetOnTop2: TMenuItem;
    mSetColor: TMenuItem;
    mSetDrawers2: TMenuItem;
    pmApps: TPopupMenu;
    mMoveLeft: TMenuItem;
    mMoveRight: TMenuItem;
    MenuItem6: TMenuItem;
    mDelete: TMenuItem;
    bLeft: TExplorerButton;
    bRight: TExplorerButton;
    Bevel1: TBevel;
    mAbout: TMenuItem;
    MenuItem3: TMenuItem;
    imgNone: TImage;
    mReload: TMenuItem;
    MenuItem1: TMenuItem;
    cpuProgress: TLabel;
    secProgress: TProgressBar;
    lDate: TLabel;
    Clock: TLabel;
    indPanel2: TPanel;
    pmGo: TPopupMenu;
    mSettings: TMenuItem;
    MenuItem2: TMenuItem;
    mClose: TMenuItem;
    Timer1: TTimer;
    Procedure MainFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure mSetOnTop1OnClick (Sender: TObject);
    Procedure mSetOnTop2OnClick (Sender: TObject);
    Procedure mSetWidth1OnClick (Sender: TObject);
    Procedure mSetWidth2OnClick (Sender: TObject);
    Procedure mSetHeight1OnClick (Sender: TObject);
    Procedure mSetHeight2OnClick (Sender: TObject);
    Procedure mSetDrawers1OnClick (Sender: TObject);
    Procedure mSetDrawers2OnClick (Sender: TObject);
    Procedure mSetColorOnClick (Sender: TObject);
    Procedure bPiOnMouseUp (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure pmAppsOnPopup (Sender: TObject);
    Procedure bRollOnClick (Sender: TObject);
    Procedure mMoveLeftOnClick (Sender: TObject);
    Procedure mMoveRightOnClick (Sender: TObject);
    Procedure mDeleteOnClick (Sender: TObject);
    Procedure mAboutOnClick (Sender: TObject);
    Procedure mReloadOnClick (Sender: TObject);
    Procedure MainFormOnDragDrop (Sender: TObject; Source: TObject; X: LongInt;
      Y: LongInt);
    Procedure MainFormOnDragOver (Sender: TObject; Source: TObject; X: LongInt;
      Y: LongInt; State: TDragState; Var Accept: Boolean);
    Procedure mSettingsOnClick (Sender: TObject);
    Procedure MainFormOnDestroy (Sender: TObject);
    Procedure MainFormOnResize (Sender: TObject);
    Procedure Timer1OnTimer (Sender: TObject);
    Procedure mCloseOnClick (Sender: TObject);
    Procedure MainFormOnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode;
      Var ReceiveR: TForm);
    Procedure MainFormOnShow (Sender: TObject);
    Procedure bRightOnClick (Sender: TObject);
    Procedure bLeftOnClick (Sender: TObject);
    Procedure bPiOnClick (Sender: TObject);
    Procedure Form1OnCreate (Sender: TObject);

    Procedure allProgspBtnClick(Sender: TObject);
    Procedure pAppsMouseUp (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure xbOnPaint (Sender: TObject; Const rec: TRect);
    Procedure xbOnMouseMove (Sender: TObject; Shift: TShiftState; X: LongInt;
      Y: LongInt);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    function OS2Exec(fname, fdir, fparam: string): Boolean;
    function LoadSettings: Integer;
    function SaveSettings: Integer;
    function SwapLeft: Integer;
    function SwapRight: Integer;
    function SaveProgs: Integer;
    procedure MakeStayOnTop;
    procedure MakeNotStayOnTop;
    procedure CalcPanelWidth;
  End;

  TPrRec = record
    ptag: Integer;
    ptype: string;
    pbmp: string;
    pname: string;
    ppath: string;
    pparam: string;
    pBtn: TExplorerButton2I;
  end;

  TDragDropItem=Record
                        Len:Byte;         //length of string
                        Data:Array[0..0] Of Char;
                  End;

    PDragDropInfo=^TDragDropInfo;
    TDragDropInfo=Record
                        Count:LongWord;   //Count of elements
                        Items:Array[0..0] Of TDragDropItem;
                  End;

  TMyShape = class(TShape)
    public
      property Canvas;
  End;

Var
  MainForm: TMainForm;
  pdebase: string; {get as ExtractFilePath('deskhalf.exe') (C:\PDE\ for example) }
  bPi: TExplorerButton2I;
  findUtil: String;
  allprogs: array[1..200] of TPrRec;
  allprogsCount, i2: LongInt;
  sr: TSearchRec;
  Days: array[1..7] of String; // = ('.', '.', '.', '.', '.', '.', '.');

  popI2: Integer;
  sys_ico_size: ULong;

  Small_Ico          : Boolean; //indicates size of P-Panel: normal/small.
  DynamicSize, OnTop : Boolean; // -//-     width, be on top or not.
  Show_Switches      : Boolean; // -//-     showing of [<] and [>] buttons.

function SysDirSetCurrent(Path: String): Longint;

Implementation

//-----------------------------------------

//--set current directory--
function SysDirSetCurrent(Path: String): Longint;
begin

  Result := DosSetDefaultDisk(ord(LowerCase(Path)[1])-96);
  Result := DosSetCurrentDir(Path);

end; {SysDirSetCurrent}

//-- ணࠬ--
function TMainForm.OS2Exec(fname, fdir, fparam: string): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2: pchar;
  rc, rc2: APIRET;
begin

if fparam <> '' then fparam := '"'+fparam+'"'; //<-  ஡    䠩

new(fname2);
new(fparam2);
fname2 := StrPCopy(fname2, fname);
fparam2 := StrPCopy(fparam2, fparam);

with sd do
  begin
      Length   := sizeof(StartData);
      Related  := ssf_Related_Independent; // start an independent session
      FgBg     := ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := ssf_InhertOpt_Parent;
      SessionType := ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"

SysDirSetCurrent(fdir);

rc2:=DosStartSession(sd, idSession, apid);
if (rc2 = 2) then
  //--30.05.04 stVova--
  // ⮫  ﬨ,     ⢥ ⥪饩 ४ਨ
  //⮩,  ன 室 FileHalf,  ணࠬ (... ᪠  吝 ᫮...)
  // 室 ᢮  (Qu/2, SysInfo, VP/2, ...) (,  ࠧ 㤭 㧭 ,   EXE ,  ???)
  // ᮮ Error 2 = FILE_NOT_FOUND.
  // ,   ⠭   
  begin
  fdir := ExtractFilePath(fname);
  Delete(fdir, length(fdir), 1);
  SysDirSetCurrent(fdir);
  rc2:=DosStartSession(sd, idSession, apid);
  end;
  //-------------------------------

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));

{if rc2 <> 0 then //ERROR!!!
  if ExtractFileName(fname) <> 'comodo.exe' then
  if pdeloadcfgint('general.cfg', 'execerrors') = 1 then
  pdeMessageBox(pdeLoadNLS('dlgRunErrorProgram', 'ணࠬ:')+' _'+StrPas(fname2)+'_'+chr(13)+
    chr(10)+pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc2)
  , pdeLoadNLS('dlgRunErrorCaption', '訡 ᪠'), 0);
}
  Result := True;

end;
//------------------

//---------"LoadSettings"-------------------
function TMainForm.LoadSettings: integer;
var
  afile: TextFile;
  tbmp: TPicture;
  fbase, fbmp, fstr: String;
  fcolor: longint;
  cpath: cstring;
Begin

caption := pdeLoadNLS('ppCaption', '-');
Days[1] := pdeLoadNLS('daySundayShort', '.');
Days[2] := pdeLoadNLS('dayMondayShort', '.');
Days[3] := pdeLoadNLS('dayTuesdayShort', '.');
Days[4] := pdeLoadNLS('dayWednesdayShort', '.');
Days[5] := pdeLoadNLS('dayThursdayShort', '.');
Days[6] := pdeLoadNLS('dayFridayShort', '.');
Days[7] := pdeLoadNLS('daySaturdayShort', '.');
mSettings.caption := pdeLoadNLS('ppmSettings', 'ன');
  mSetOnTop1.caption := pdeLoadNLS('ppmSettings1', 'Float on top');
  mSetOnTop2.caption := pdeLoadNLS('ppmSettings2', 'Normal window');
  mSetWidth1.caption := pdeLoadNLS('ppmSettings3', 'Width as screen');
  mSetWidth2.caption := pdeLoadNLS('ppmSettings4', 'Dynamic width');
  mSetHeight1.caption := pdeLoadNLS('ppmSettings5', 'Normal height');
  mSetHeight2.caption := pdeLoadNLS('ppmSettings6', '1/2 height');
  mSetDrawers1.caption := pdeLoadNLS('ppmSettings7', 'Show drawers');
  mSetDrawers2.caption := pdeLoadNLS('ppmSettings8', 'Hide drawers');
  mSetColor.caption := pdeLoadNLS('ppmSettings9', 'Panel color...');
mReload.caption := pdeLoadNLS('ppmReload', '');
mClose.caption := pdeLoadNLS('ppmClose', '\tAlt+F4');
mAbout.caption := pdeLoadNLS('menuAbout', 'ଠ  த');
mMoveLeft.caption := pdeLoadNLS('ppmMoveLeft', '(<-)  ६');
mMoveRight.caption := pdeLoadNLS('ppmMoveRight', '(->)  ६');
mDelete.caption := pdeLoadNLS('ppmDelete', '(><)  ');

fbase := pdebase+'Bitmaps\Deskhalf\';
tbmp:=TPicture.Create(self);
allprogsCount := 0;
//color of pi-panel
Color:=pdeLoadCfgColor('deskhalf.cfg', 'color1');
//color of p-menu
MMenu.Color:=pdeLoadCfgColor('deskhalf.cfg', 'color2');
//color of clock
Clock.Color:=pdeLoadCfgColor('deskhalf.cfg', 'color3');
//
Top:=Screen.Height-Height-pdeLoadCfgInt('deskhalf.cfg', 'bottom');
//DynamicSize
DynamicSize := (pdeLoadCfgStr('deskhalf.cfg', 'DynamicSize') = 'yes' );
OnTop := (pdeLoadCfgStr('deskhalf.cfg', 'OnTop') = 'yes' ); //be OnTop
If OnTop then
  MakeStayOnTop;

if small_ico then
  clock.height := sys_ico_size+3;
//IndicatorPanel1
//if (pdeLoadCfgStr('deskhalf.cfg', 'IndPanel1')='no') then indPanel1.Width:=0;
//IndicatorPanel2
if (pdeLoadCfgStr('deskhalf.cfg', 'IndPanel2')='no') then indPanel2.Width:=0;
//pi-button
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'pButton1');
bPi.Icon := WinLoadFileIcon(fbase+fbmp, False);
bPi.Hint := pdeLoadNLS('ppHint1', '   㯠  ');
//drives
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bDrives');
tbmp.loadfromfile(fbase+fbmp); MMenu.bDisks.Glyph:=tbmp.Bitmap;
MMenu.bDisks.Caption:=pdeLoadNLS('ppDrives', '᪨');
//programs
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bProgs');
tbmp.loadfromfile(fbase+fbmp); MMenu.bProgs.Glyph:=tbmp.Bitmap;
MMenu.bProgs.Caption:=pdeLoadNLS('ppProgs', 'ணࠬ >');
//favorites
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bFavor');
tbmp.loadfromfile(fbase+fbmp); MMenu.bFavor.Glyph:=tbmp.Bitmap;
MMenu.bFavor.Caption:=pdeLoadNLS('ppBookmarks', '    >');
//documents
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bDocs');
tbmp.loadfromfile(fbase+fbmp); MMenu.bDocs.Glyph:=tbmp.Bitmap;
MMenu.bDocs.Caption:=pdeLoadNLS('ppDocs', '㬥  >');
//find
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bSearch');
findUtil := pdeLoadCfgStr('deskhalf.cfg', 'Finder');
tbmp.loadfromfile(fbase+fbmp); MMenu.bFind.Glyph:=tbmp.Bitmap;
MMenu.bFind.Caption:=pdeLoadNLS('ppFind', '');
//help
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bHelp');
tbmp.loadfromfile(fbase+fbmp); MMenu.bHelp.Glyph:=tbmp.Bitmap;
MMenu.bHelp.Caption:=pdeLoadNLS('ppHelp', 'ࠢ');
//run
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bRun');
tbmp.loadfromfile(fbase+fbmp);
MMenu.bRun.Glyph:=tbmp.Bitmap;
MMenu.bRun.Hint := pdeLoadNLS('ppHint2', ' ணࠬ');
//reboot
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bReset');
tbmp.loadfromfile(fbase+fbmp);
MMenu.bReboot.Glyph:=tbmp.Bitmap;
MMenu.bReboot.Hint := pdeLoadNLS('ppHint3', '१㧪');
//shutdown
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bShutdown');
tbmp.loadfromfile(fbase+fbmp);
MMenu.bShutDown.Glyph:=tbmp.Bitmap;
MMenu.bShutDown.Hint := pdeLoadNLS('ppHint4', '몫 ');
//refresh :-)
fbmp := pdeLoadCfgStr('deskhalf.cfg', 'bSmile');
tbmp.loadfromfile(fbase+fbmp);
MMenu.bRefresh.Picture.LoadFromFile(fbase+fbmp);

{loading quick-buttons}
if FileExists(pdebase+'PDEConf\ppanel.progs') then
begin
  Assignfile(afile, pdebase+'PDEConf\ppanel.progs');
  Reset(afile);
  Readln(afile);
  i2:=0;
  While not(eof(afile)) do
    begin
    inc(i2);
    readln(afile, allprogs[i2].ptype);
    readln(afile, allprogs[i2].pbmp);

    allprogs[i2].ptag := i2;
    readln(afile, allprogs[i2].pname);
    readln(afile, allprogs[i2].ppath);
    readln(afile, allprogs[i2].pparam);
    inc(allprogsCount);
    allprogs[i2].pBtn:=TExplorerButton2I.Create(self);
    allprogs[i2].pBtn.Parent:=self;
    allprogs[i2].pBtn.OnClick:=allProgspBtnClick;
    allprogs[i2].pBtn.OnMouseUp := pAppsMouseUp;

    allprogs[i2].pBtn.ParentColor := True;
    allprogs[i2].pBtn.Glyph := imgNone.Bitmap;
    allprogs[i2].pBtn.Mini := small_ico;
    allprogs[i2].pBtn.SysIconSize := sys_ico_size;
    allprogs[i2].pBtn.Width := sys_ico_size+4;//pdeLoadCfgIntD('deskhalf.cfg', 'size', 38);
    allprogs[i2].pBtn.Height := allprogs[i2].pBtn.Width;

    if allprogs[i2].pbmp <> '' then //icon specified in cfg
      allprogs[i2].pbtn.Icon := WinLoadFileIcon(fbase+allprogs[i2].pbmp, False)
    else
      begin
      if allprogs[i2].pname[2] = ':' then
        allprogs[i2].pbtn.Icon := WinLoadFileIcon(allprogs[i2].pname, False)
      else
        allprogs[i2].pbtn.Icon := WinLoadFileIcon(pdebase+allprogs[i2].pname, False);
      end;

    allprogs[i2].pBtn.Hint:=allprogs[i2].pname;
    allprogs[i2].pBtn.Left:=18+i2*(2 + allprogs[i2].pBtn.Width);
    allprogs[i2].pBtn.Top:=2;
    end;

  closefile(afile);
  end;
  tbmp.free;
End;
//--END of "LoadSettings"-------------------

Procedure TMainForm.MainFormOnCloseQuery (Sender: TObject;
  Var CanClose: Boolean);
Begin

  {save settings on exit}
  SaveSettings;

  CanClose := True;

End;

procedure TMainForm.CalcPanelWidth;
begin

  {set P-Panel width according to settings}
  if DynamicSize then
    begin
    MainForm.Width := indPanel2.Width+(allprogsCount+1)*(2+bPi.Width)+40;
    MainForm.Left:=(Screen.Width-MainForm.Width) div 2;
    end
  else
    begin
    MainForm.Width := screen.width;
    MainForm.Left := 0;
    end;

end;

//---------"SaveSettings"-------------------
function TMainForm.SaveSettings: Integer;
var
  st: TStringList;
  t: String;
begin

  {Save settings to the "deskhalf.cfg"}
  st := TStringList.Create;
  st.Add('//Polumuh Desktop Environment');
  st.Add('//P-Panel settings file');
  st.Add('//color1 - color of P-Panel');
  st.Add('color1='+IntToStr(Color));
  st.Add('//color2 - color of P-button menu');
  st.Add('color2='+IntToStr(MMenu.Color));
  st.Add('//color3 - clock color (by default=clYellow, and with days (clBlue) = Ukrainian flag ;-)');
  st.Add('color3='+IntToStr(Clock.Color));
  st.Add('//panel size: normal = system_ico_size; small=1/2 -//-');
  t := 'normal';
  if small_ico then t := 'small';
  st.Add('size='+t);
  st.Add('//position from bottom of the screen');
  st.Add('bottom='+IntToStr(Bottom));
  st.Add('//DynamicSize yes/no');
  t := 'no';
  if DynamicSize then t := 'yes';
  st.Add('DynamicSize='+t);
  st.Add('//OnTop yes/no');
  t := 'no';
  if OnTop then t := 'yes';
  st.Add('OnTop='+t);
  st.Add('//IndPanel1 yes/no');
  st.Add('IndPanel1=no');
  st.Add('//IndPanel2 yes/no');
  st.Add('IndPanel2='+pdeLoadCfgStrD('deskhalf.cfg', 'IndPanel2', 'yes'));
  st.Add('//show [<] [>] buttons yes/no');
  t := 'no';
  if Show_Switches then t := 'yes';
  st.Add('Switches='+t);
  st.Add('//pi-button: normal, down, up');
  st.Add('pButton1=go.ico');
  st.Add('//drives-button');
  st.Add('bDrives=_drives.bmp');
  st.Add('//programs-button');
  st.Add('bProgs=_progs.bmp');
  st.Add('//favorites-button');
  st.Add('bFavor=_favor.bmp');
  st.Add('//docs-button');
  st.Add('bDocs=_docs.bmp');
  st.Add('//find-button');
  st.Add('bSearch=_search.bmp');
  st.Add('Finder='+findUtil);
  st.Add('//help-button');
  st.Add('bHelp=_help.bmp');
  st.Add('//run-button');
  st.Add('bRun=_run.bmp');
  st.Add('//reboot-button');
  st.Add('bReset=_reset.bmp');
  st.Add('//shut-button');
  st.Add('bShutdown=_shutdown.bmp');
  st.Add('//:-) button <- reload configuration');
  st.Add('bSmile=_smile.bmp');

  pdeSaveCfgFile('deskhalf.cfg', st);
  st.Free;

end;
//--END of "SaveSettings"-------------------

//------------------------------------------
Procedure TMainForm.mSetOnTop1OnClick (Sender: TObject);
Begin

  { + float on top}
  OnTop := True;
  MakeStayOnTop;
  SaveSettings;

End;

Procedure TMainForm.mSetOnTop2OnClick (Sender: TObject);
Begin

  { - float on top}
  OnTop := False;
  MakeNotStayOnTop;
  SaveSettings;

End;

Procedure TMainForm.mSetWidth1OnClick (Sender: TObject);
Begin

  {set panel width as screen width}
  DynamicSize := False;
  CalcPanelWidth;
  SaveSettings;

End;

Procedure TMainForm.mSetWidth2OnClick (Sender: TObject);
Begin

  {dynamic size on}
  DynamicSize := True;
  CalcPanelWidth;
  SaveSettings;

End;

Procedure TMainForm.mSetHeight1OnClick (Sender: TObject);
Begin

  {set normal height of panel}
  Small_Ico := False;
  SaveSettings;
  mReloadOnClick (Sender);

End;

Procedure TMainForm.mSetHeight2OnClick (Sender: TObject);
Begin

  {set panel height as 1/2 of normal height}
  Small_Ico := True;
  SaveSettings;
  mReloadOnClick (Sender);

End;

Procedure TMainForm.mSetDrawers1OnClick (Sender: TObject);
Begin

  {show drawers ('<' and '>' buttons) }
  Show_Switches := True;
  bLeft.Visible := True;
  bRight.Visible := True;
  SaveSettings;

End;

Procedure TMainForm.mSetDrawers2OnClick (Sender: TObject);
Begin

  {hide drawers ('<' and '>' buttons) }
  Show_Switches := False;
  bLeft.Visible := False;
  bRight.Visible := False;
  SaveSettings;

End;

Procedure TMainForm.mSetColorOnClick (Sender: TObject);
var
  clr: TColor;
Begin

  {choose panel's color}
  if pdeColorDialog(clr) then
    begin
    MainForm.Color := clr;
    end;
  SaveSettings;

End;
//--panel's settings submenu----------------

Procedure TMainForm.pmAppsOnPopup (Sender: TObject);
Begin
//  pmApps.Top := pmApps.Top - 40;
End;

procedure TMainForm.MakeNotStayOnTop;
Begin

{change window style to not WS_TOPMOST}
WinSetWindowULong(Frame.Handle, QWL_STYLE
  , WinQueryWindowULong(Frame.Handle, QWL_STYLE) - $200000);

End;

procedure TMainForm.MakeStayOnTop;
Begin

{change window style to WS_TOPMOST}
WinSetWindowULong(MainForm.Frame.Handle, QWL_STYLE
  , WinQueryWindowULong(MainForm.Frame.Handle, QWL_STYLE) or WS_TOPMOST);

End;

Procedure TMainForm.bRollOnClick (Sender: TObject);
var
  hwndtop: hwnd;
  enum: henum;
  swp1: SWP;
Begin

  {minimize all windows on Desktop}
enum:=WinBeginEnumWindows(HWND_DESKTOP);
hwndTop:=WinGetNextWindow(enum);
while (hwndTop<>0) do
  begin
  WinQueryWindowPos(hwndTop, swp1);
  if (swp1.Fl and SWP_MINIMIZE)<>0 then
    WinShowWindow(hwndTop, false);
  hwndTop:=WinGetNextWindow(enum);
  end;
WinEndEnumWindows(enum);

End;

function TMainForm.SaveProgs: Integer;
var
  cfgdata: TStringList;
begin
  cfgdata := TStringList.Create;
  cfgdata.Add('//Programs on Panel (near the P-button): [type, name, path, parameters]');
  if (allprogscount > 0) then
    for i2 := 1  to allprogscount do
      begin
      cfgdata.Add(allprogs[i2].ptype);
      cfgdata.Add(allprogs[i2].pbmp);
      cfgdata.Add(allprogs[i2].pname);
      cfgdata.Add(allprogs[i2].ppath);
      cfgdata.Add(allprogs[i2].pparam);
      end;
  pdeSaveCfgFile('ppanel.progs', cfgdata);
End;

//--applications buttons menu routines------
function TMainForm.SwapLeft: Integer;
var
  ptag: Integer;
  ptype: string;
  pbmp: string;
  pname: string;
  ppath: string;
  pparam: string;
  ti: HPointer;
begin

  if (i2 > 1) then
  begin
  ptag :=   allprogs[i2-1].ptag;
  ptype :=  allprogs[i2-1].ptype;
  pbmp :=   allprogs[i2-1].pbmp;
  pname :=  allprogs[i2-1].pname;
  ppath :=  allprogs[i2-1].ppath;
  pparam := allprogs[i2-1].pparam;

  allprogs[i2-1].ptag   := allprogs[i2].ptag;
  allprogs[i2-1].ptype  := allprogs[i2].ptype;
  allprogs[i2-1].pbmp   := allprogs[i2].pbmp;
  allprogs[i2-1].pname  := allprogs[i2].pname;
  allprogs[i2-1].ppath  := allprogs[i2].ppath;
  allprogs[i2-1].pparam := allprogs[i2].pparam;
  allprogs[i2-1].pbtn.Hint := allprogs[i2].pbtn.Hint;
  //allprogs[i2-1].pbtn.Glyph := allprogs[i2].pbtn.Glyph;
  ti := allprogs[i2-1].pbtn.icon;
  allprogs[i2-1].pbtn.icon := allprogs[i2].pbtn.icon;
  allprogs[i2].pbtn.icon := ti;

  allprogs[i2].ptag   := ptag;
  allprogs[i2].ptype  := ptype;
  allprogs[i2].pbmp   := pbmp;
  allprogs[i2].pname  := pname;
  allprogs[i2].ppath  := ppath;
  allprogs[i2].pparam := pparam;
  allprogs[i2].pbtn.Hint := allprogs[i2].pname;
  //try
  //  allprogs[i2].pbtn.Glyph.LoadFromFile(extractfilepath(application.exename)
  //    +'Bitmaps\Deskhalf\'+allprogs[i2].pbmp);
  //  except
  //  allprogs[i2].pbtn.Glyph := imgNone.Picture.bitmap;
  //  end;
  allprogs[i2-1].pbtn.Invalidate;
  allprogs[i2].pbtn.Invalidate;
  end;
{SwapLeft}
end;

function TMainForm.SwapRight: Integer;
var
  ptag: Integer;
  ptype: string;
  pbmp: string;
  pname: string;
  ppath: string;
  pparam: string;
  ti: HPointer;
begin

  if (i2 < allprogscount) then
  begin

  ptag :=   allprogs[i2+1].ptag;
  ptype :=  allprogs[i2+1].ptype;
  pbmp :=   allprogs[i2+1].pbmp;
  pname :=  allprogs[i2+1].pname;
  ppath :=  allprogs[i2+1].ppath;
  pparam := allprogs[i2+1].pparam;

  allprogs[i2+1].ptag   := allprogs[i2].ptag;
  allprogs[i2+1].ptype  := allprogs[i2].ptype;
  allprogs[i2+1].pbmp   := allprogs[i2].pbmp;
  allprogs[i2+1].pname  := allprogs[i2].pname;
  allprogs[i2+1].ppath  := allprogs[i2].ppath;
  allprogs[i2+1].pparam := allprogs[i2].pparam;
  allprogs[i2+1].pbtn.Hint := allprogs[i2].pbtn.Hint;
  //allprogs[i2+1].pbtn.Glyph := allprogs[i2].pbtn.Glyph;
  ti := allprogs[i2+1].pbtn.icon;
  allprogs[i2+1].pbtn.icon := allprogs[i2].pbtn.icon;
  allprogs[i2].pbtn.icon := ti;

  allprogs[i2].ptag   := ptag;
  allprogs[i2].ptype  := ptype;
  allprogs[i2].pbmp   := pbmp;
  allprogs[i2].pname  := pname;
  allprogs[i2].ppath  := ppath;
  allprogs[i2].pparam := pparam;
  allprogs[i2].pbtn.Hint := allprogs[i2].pname;
  //try
  //  allprogs[i2].pbtn.Glyph.LoadFromFile(extractfilepath(application.exename)
  //    +'Bitmaps\Deskhalf\'+allprogs[i2].pbmp);
  //  except
  //  allprogs[i2].pbtn.Glyph := imgNone.Picture.bitmap;
  //  end;
  allprogs[i2+1].pbtn.Invalidate;
  allprogs[i2].pbtn.Invalidate;
  end;

{SwapRight}
end;

Procedure TMainForm.pAppsMouseUp (Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X: LongInt; Y: LongInt);
var p: TPoint;
Begin
if Button = mbRight then
  begin
    for PopI2 := 1 to allprogsCount do
      if (allprogs[PopI2].pbtn.Hint=TExplorerButton(Sender).Hint) then  //諠 ᥭ
        break;
    //p := TExplorerButton(Sender).ClientToScreen(Point(X, Y));
    p := TExplorerButton(Sender).ClientToScreen(Point(0, 0));
    if (p.Y < Screen.Height div 2) then
      pmApps.Popup(p.X, p.Y + sys_ico_size+4)
    else
      pmApps.Popup(p.X, p.Y - 2*sys_ico_size-4);
  end;
End;

Procedure TMainForm.bPiOnMouseUp (Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X: LongInt; Y: LongInt);
var p: TPoint;
Begin
if Button = mbRight then
  begin
    p := TExplorerButton2I(Sender).ClientToScreen(Point(0, 0));
    if (p.Y < Screen.Height div 2) then
      pmGo.Popup(p.X, p.Y + sys_ico_size+4)
      else
      pmGo.Popup(p.X, p.Y - 2*sys_ico_size-4);
  end;
End;

//--applications buttons popupmenu----------
Procedure TMainForm.mMoveLeftOnClick (Sender: TObject);
Begin
i2 := PopI2;
SwapLeft;
SaveProgs;
End;

Procedure TMainForm.mMoveRightOnClick (Sender: TObject);
Begin

i2 := PopI2;
SwapRight;
SaveProgs;

End;

Procedure TMainForm.mDeleteOnClick (Sender: TObject);
Begin

{delete quick-button from Panel}
i2 := PopI2;
  while i2 < allprogsCount do
    begin
    SwapRight;
    inc(i2);
    end;
WinFreeFileIcon(allprogs[i2].pbtn.icon);
allprogs[i2].pbtn.Free;
dec(allprogsCount);
SaveProgs;
CalcPanelWidth;

End;
//-----------------------------------------

Procedure TMainForm.xbOnMouseMove (Sender: TObject; Shift: TShiftState;
  X: LongInt; Y: LongInt);
Begin
{  xbOnPaint(Sender, clientrect);
  if TExplorerButton(Sender).Down then //down
    Canvas.ShadowedBorder(TExplorerButton(Sender).ClientRect,cl3DDkShadow,clBtnHighlight)
    else
    Canvas.ShadowedBorder(TExplorerButton(Sender).ClientRect,clBtnHighlight,cl3DDkShadow);
}
End;

Procedure TMainForm.xbOnPaint (Sender: TObject; Const rec: TRect);
{var
  i2: Integer;
  fname: String;
  hico: HPointer;
  ps: HPS;}
Begin
//ᮢ ணࠬ 

{if allprogsCount>0 then
  for i2:=1 to allprogsCount do
    if (allprogs[i2].pbtn.Hint=TExplorerButton(Sender).Hint) then  //諠 ᥭ
      break;

if (allprogs[i2].pname[2] = ':') then //full path
  fname := allprogs[i2].pname
  else //path from \..\pde\
  fname := extractfilepath(application.exename)+allprogs[i2].pname;

hico := WinLoadFileIcon(fname, False);
ps := WinGetPS(allprogs[i2].pbtn.handle);
allprogs[i2].pbtn.canvas.fillrect(allprogs[i2].pbtn.clientrect, bPi.Color);
WinDrawPointer( ps, 2, 2, hico, 0);
WinReleasePS(ps);
WinFreeFileIcon(hico);
}
End;

Procedure TMainForm.mAboutOnClick (Sender: TObject);
{var
  about, authors, thanks: TStringList;
  cptn, text, licensefile: String;
  logo: Pointer;
}
var
  about, authors, thanks: String;
  afile: TextFile;
  cptn, text, licensefile: String;
  logo: LongInt;
Begin
//ଠ  த
  {about := TStringList.Create;
  about.Add(pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.1');
  about.Add('');
  about.Add(pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  about.Add(pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  about.Add('');
  about.Add(pdeLoadNLS('pdeDescription6', '-. ন   '));
  about.Add(pdeLoadNLS('pdeDescription7', ' 㯠  ਫ  .'));
//pdeLoadNLS('', '')
  authors := TStringList.Create;
  authors.Add('Vladymyr Sergeyev, stVova');
  authors.Add('Sergey Sergeyev, SERG');
  authors.Add('e-mail: stVova@ukrpost.com.ua or stVova@ukr.net');
  authors.Add('web: http://os2progg.by.ru');
  {authors.Add(pdeLoadNLS('pdeAuthors1.1', 'ࣥ , stVova'));
  authors.Add('');
  authors.Add(pdeLoadNLS('pdeAuthors1.2', 'ࠧࠡ稪'));
  authors.Add(pdeLoadNLS('pdeAuthors1.3', 'ணࠬ஢, '));
  authors.Add(pdeLoadNLS('pdeAuthors1.4', 'stVova@ukrpost.com.ua'));}
  {thanks := TStringList.Create;
  thanks.Add('Our mother Ludmyla Sergeyeva');
  thanks.Add('');
  thanks.Add('Sergey Posokhov');
  thanks.Add('Andy Key (Generalized Bitmap Module)');
  thanks.Add('Independent JPEG group (JPEG support)');
  thanks.Add('Salvador Parra Camacho');
  //thanks.Add('');
  thanks.Add('KDE Team for graphics and icons (www.kde.org)');
  thanks.Add('GNOME Team for graphics and icons (www.gnome.org)');
  thanks.Add('Aaron Lawrence (ACL Library)');
  thanks.Add('');
  thanks.Add('And all friends from native sity Lutsk (Ukraine, Volyn Region)');

  cptn := pdeLoadNLS('dlgAboutProgram', 'ଠ  த');
  text := pdeLoadNLS('pdeDeskHalf', '-');
  licensefile := ExtractFilePath(Application.ExeName)+'copying';
  logo := MainForm.Icon;
  pdeAboutDialog(about, authors, thanks, cptn, text, licensefile, logo);
  }
  //ଠ  த
  about := pdebase+'~ABOUT';
  AssignFile(afile, about);
  Rewrite(afile);
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.2');
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  Writeln(afile, pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeDescription6', '-. ন   '));
  Writeln(afile, pdeLoadNLS('pdeDescription7', ' 㯠  ਫ  .'));
  CloseFile(afile);

  authors := pdebase+'AUTHORS';
  thanks := pdebase+'THANKS';
  cptn := pdeLoadNLS('dlgAboutProgram', 'ଠ  த');
  text := pdeLoadNLS('pdeDeskHalf', '-');
  licensefile := pdebase+'COPYING';
  logo := MainForm.Icon.Handle;
  pdeAboutDialogS(about, authors, thanks, cptn, text, licensefile, logo);

End;

Procedure TMainForm.mReloadOnClick (Sender: TObject);
Begin
//  DeskUni2.MMenu.bRefreshOnDblClick(Sender);
  if allprogsCount>0 then
  for _i:=1 to allprogsCount do
    begin
    WinFreeFileIcon(allprogs[_i].pbtn.icon);
    allprogs[_i].pBtn.Free;
    end;

small_ico := False;
sys_ico_size := WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
if (pdeLoadCfgStrD('deskhalf.cfg', 'size', 'normal')='small') then
  begin
  sys_ico_size := sys_ico_size div 2;
  small_ico := True;
  end;

  MainForm.Height:=8 + sys_ico_size;

bPi.Width := 4 + sys_ico_size;
bPi.Height := bPi.Width;
bPi.Align := alFixedLeftTop;
bPi.Mini :=small_ico;
bPi.SysIconSize := sys_ico_size;

MainForm.Top := Screen.Height-MainForm.Height-pdeLoadCfgInt('deskhalf.cfg', 'bottom');

indPanel2.Height := bPi.Width;

MainForm.LoadSettings;

{set width for P-Panel}
CalcPanelWidth;

bLeft.Left := 2;
bLeft.Height := Height - 4;
bLeft.Bottom := 2;

bRight.Right := 2;
bRight.Height := Height - 4;
bRight.Bottom := 2;

bLeft.Visible := True;
bRight.Visible := True;
show_switches := True;

if pdeLoadCfgStrD('deskhalf.cfg', 'Switches', 'yes') = 'no' then
  begin
  bLeft.Visible := False;
  bRight.Visible := False;
  show_switches := False;
  end;

End;

// ணࠬ    drag'n'drop
Procedure TMainForm.MainFormOnDragDrop (Sender: TObject; Source: TObject;
  X: LongInt; Y: LongInt);
Var SharedMem:PDragDropInfo;
    sh:Longint;
    Temp:^String;
    fsrc: cstring;
    src, tmpstr: string;
    rc: apiret;
    tbmp: TBitmap;
    sr2: TSearchRec;
    afile: TextFile;
    basepath: String;

    ps: HPS;
    hico : HPointer;
    //tmpshape: TMyShape;
    __i, __j: Integer;
    cx_icon, cy_icon: Byte;
    bmpfile: TextFile;
    r, g, b: Byte;
    rgb: TColor;
    bmpsavepath, bmpname: String;

Begin
rc:=0;
//Look if the target is valid for us...
    If ((Source Is TExternalDragDropObject)And
        (TExternalDragDropObject(Source).SourceType=drtString)And
        (TExternalDragDropObject(Source).SourceString=DragSourceId)) Then
    Begin  //accepted
      If not AccessNamedSharedMem(TExternalDragDropObject(Source).SourceFileName,
                                   SharedMem) Then exit;  //some error
      Temp:=@SharedMem^.Items;
            fsrc:=Temp^;
      src:=fsrc;  // 䠩  
      if (FindFirst(src+'\*.*', faAnyFile, sr2)=0) then
        begin  //directory
        FindClose(sr2);
        basepath := pdebase + '\PDEConf\';

        AssignFile(afile, basepath + 'ppanel.progs');
        Reset(afile);
        Seek(afile, filesize(afile));
        //Writeln(afile);
        Writeln(afile, 'FOLDER');
        Writeln(afile, 'Folder.ico');
        if src[length(src)]<>'\' then
          src := src + '\';
        Writeln(afile, src);
        Writeln(afile, src);
        Writeln(afile);

        CloseFile(afile);
        end
      else
        begin  //application
        FindClose(sr2);
        //bmpSavePath := extractfilepath(application.exename)+'\Bitmaps\DeskHalf\defProgs\';
        //bmpName := ChangeFileExt(extractfilename(src), '.bmp');
        //while fileexists(bmpSavePath+bmpName) do
        //  bmpName := 'b'+bmpName;
  //      bmpName := '';

        {tmpShape := TMyShape.Create(Self);
        tmpShape.Parent := Self;
        tmpShape.Height := 32;
        tmpShape.Width := 32;
        tmpShape.Left := 0;
        tmpShape.Top := 0;
        //tmpShape.Pen.Style := psClear;
        //tmpShape.Brush.Color := MainForm.Color;
        tmpShape.ZOrder := zoTop;
        tmpShape.Visible := True;
        //tmpShape.Refresh;}

        //hico := WinLoadFileIcon(src, False);
        //ps := WinGetPS(bPi{tmpShape}.Handle);
        //bPi.canvas.fillrect(bPi.clientrect, bPi.color);
        //WinDrawPointer( ps, 0, 0, hico, 0);

  //cx_icon := WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
  //cy_icon := WinQuerySysValue(HWND_DESKTOP, SV_CYICON);
  //AssignFile(bmpfile, bmpsavepath + bmpname);
  //Rewrite(bmpfile);
  //Write(bmpfile, chr($42), chr($4D), chr($1A), chr($00), chr($00), chr($00), chr($10), chr($00), chr($10), chr($00), chr($1A));
  //Write(bmpfile, chr($00), chr($00), chr($00), chr($0C), chr($00), chr($00), chr($00), chr(cx_icon), chr($00), chr(cy_icon), chr($00));
  //Write(bmpfile, chr($01), chr($00), chr($18), chr($00));
  //for __i := 0 to (cy_icon-1){31} do
  //  for __j := 0 to (cx_icon-1){31} do
  //    begin
      //rgb := tmpShape.canvas.pixels[ __j, __i ];
  //    rgb := bPi.canvas.pixels[ __j, __i ];
  //    RGBToValues(rgb, R, G, B);
  //    Write(bmpfile, chr(b), chr(g), chr(r));
      //Write(bmpfile, rgb);
  //    end;
  //CloseFile(bmpfile);

  //      WinReleasePS(ps);
  //      WinFreeFileIcon(hico);
        //tmpShape.Free;

        basepath := pdebase + '\PDEConf\';

        AssignFile(afile, basepath + 'ppanel.progs');
        Reset(afile);
        Seek(afile, filesize(afile));
        //Writeln(afile);
        Writeln(afile, 'APP');
        Writeln(afile, '');
        Writeln(afile, src);
        Writeln(afile, extractfilepath(src));
        Writeln(afile);

        CloseFile(afile);

        end;

      //each process must free the shared memory !!
      FreeNamedSharedMem(TExternalDragDropObject(Source).SourceFileName);

      //update P-panel
      mReloadOnClick(Sender);
    End;
End;

Procedure TMainForm.MainFormOnDragOver (Sender: TObject; Source: TObject;
  X: LongInt; Y: LongInt; State: TDragState; Var Accept: Boolean);
Begin
Accept:=((Source Is TExternalDragDropObject)And
             (TExternalDragDropObject(Source).SourceType=drtString)And
             (TExternalDragDropObject(Source).SourceString=DragSourceId));

End;
// ''ய :-)

Procedure TMainForm.mSettingsOnClick (Sender: TObject);
Begin
  //ShellExecuteS(pdebase+'PDEConf.exe', '', '');
End;

Procedure TMainForm.MainFormOnDestroy (Sender: TObject);
Begin

End;

Procedure TMainForm.MainFormOnResize (Sender: TObject);
Begin
//Clock.Right:=16;
//Clock.Bottom:=1;
End;

Procedure TMainForm.Timer1OnTimer (Sender: TObject);
var
  Year, Month, Day: Word;
  h, m, s, ms: Word;
  sh, sm: string;
  memload: Word;
  totmem, freemem, swapdrive: ULong;
Begin
DecodeTime(Time, h, m, s, ms);
sh:=IntToStr(h);
if h<10 then sh:='0'+sh;
sm:=IntToStr(m);
if m<10 then sm:='0'+sm;
Clock.Caption:=sh+' : '+sm;
DecodeDate(Date, Year, Month, Day);
if Day < 10 then
  lDate.Caption:=Days[DayOfWeek(Date)]+'  '+IntToStr(Day)
else
  lDate.Caption:=Days[DayOfWeek(Date)]+' '+IntToStr(Day);
lDate.Hint:=DateToStr(Date);

secProgress.Position:=s;
//DosQuerySySInfo(QSV_TOTPHYSMEM, QSV_TOTPHYSMEM, totmem, SizeOf(totmem));
//DosQuerySySInfo(QSV_TOTAVAILMEM, QSV_TOTAVAILMEM, freemem, SizeOf(freemem));
//MainForm.Caption:=IntToStr(freemem)+' '+IntToStr(totmem);
//memload:=100-(100*freemem div totmem);

//DosQuerySySInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, swapdrive, SizeOf(swapdrive));
//ramProgress.Caption := IntToStr((freemem - DiskFree(swapdrive)) div 1024)+'Kb';

//ramProgress.Position:=memload;

//if MainForm.zOrder<>zoTop then
//  MainForm.BringToFront;
{if OnTop then
  if not(WinIsWindowVisible(pmApps.Handle) or WinIsWindowVisible(pmGo.Handle)) then
  WinSetWindowPos(MainForm.Frame.Handle, HWND_TOP, 0, 0, 0, 0
    , SWP_SHOW Or SWP_ZORDER);
}
End;

Procedure TMainForm.mCloseOnClick (Sender: TObject);
Begin
application.terminate;
End;

Procedure TMainForm.MainFormOnTranslateShortCut (Sender: TObject;
  KeyCode: TKeyCode; Var ReceiveR: TForm);
begin
if keycode=kbesc then
  MMenu.Hide;

End;

Procedure TMainForm.MainFormOnShow (Sender: TObject);
var
  afile: TextFile;
  ftype, fname, fpath, fparams: String;
Begin
//BorderStyle:=bsStealth;
RunUnit.RunForm.BorderStyle:=bsStealthDlg;
DeskUni2.MMenu.BorderStyle:=bsStealth;

LoadSettings;

CalcPanelWidth;

Timer1.Start;

End;

Procedure TMainForm.bRightOnClick (Sender: TObject);
Begin
if MainForm.Left<0 then
  MainForm.Left:=(Screen.Width-MainForm.Width) div 2
else
  MainForm.Left:=Screen.Width-16;
End;

Procedure TMainForm.bLeftOnClick (Sender: TObject);
Begin
if MainForm.Left<(Screen.Width div 2) then
  MainForm.Left:=-MainForm.Width+16
else
  MainForm.Left:=(Screen.Width-MainForm.Width) div 2;
End;

Procedure TMainForm.bPiOnClick (Sender: TObject);
Begin
if MMenu.Visible then
  MMenu.Hide
  else
  MMenu.Show;
End;

Procedure TMainForm.Form1OnCreate (Sender: TObject);
var
 tbmp: TPicture;
Begin
BorderStyle:=bsStealth;

pdebase := ExtractFilePath(Application.ExeName);

sys_ico_size := WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
if (pdeLoadCfgStrD('deskhalf.cfg', 'size', 'normal')='small') then
  begin
  sys_ico_size := sys_ico_size div 2;
  small_ico := True;
  end;

  MainForm.Height:=8 + sys_ico_size;
//MainForm.Height:=4 + pdeLoadCfgIntD('deskhalf.cfg', 'size', 38);

MainForm.Width:=Screen.Width;
MainForm.Left:=0;
MainForm.Top:=Screen.Height-MainForm.Height;
//bPi.Width := MainForm.Height - 4;
bPi := TExplorerButton2I.Create(Self);
bPi.Parent := self;
bPi.Width := 4 + sys_ico_size;
bPi.Height := bPi.Width;
bPi.Left := 16;
bPi.Top := 2;
bPi.Align := alFixedLeftTop;
bPi.ParentColor := True;
bPi.Onclick := bpionclick;
bPi.Onmouseup := bPionmouseup;
bPi.Mini :=small_ico;
bPi.SysIconSize := sys_ico_size;
bPi.Glyph := imgNone.Bitmap;

bLeft.Left := 2;
bLeft.Height := Height - 4;
bLeft.Bottom := 2;
bLeft.Align := alFixedLeftBottom;

bRight.Right := 2;
bRight.Height := Height - 4;
bRight.Bottom := 2;
bRight.Align := alFixedRightBottom;

show_switches := True;

if pdeLoadCfgStrD('deskhalf.cfg', 'Switches', 'yes') = 'no' then
  begin
  bLeft.Visible := False;
  bRight.Visible := False;
  show_switches := False;
  end;

//indPanel1.Height := bPi.Width;
indPanel2.Height := bPi.Width;

End;

Procedure TMainForm.allProgspBtnClick(Sender: TObject);
Begin

//--clicking on one of the "quick run buttons"--
if allprogsCount>0 then
  for i2:=1 to allprogsCount do
    if (allprogs[i2].pbtn.Hint=TExplorerButton(Sender).Hint) then  // we find sender
      break;

if allprogs[i2].ptype='APP' then
    Begin
    //ShowMessage('_'+allprogs[i2].pname+'_'+#13+#10+'_'+allprogs[i2].ppath+'_');
    if (allprogs[i2].pname[2] = ':') then //full path
      OS2Exec(allprogs[i2].pname, allprogs[i2].ppath, allprogs[i2].pparam)
      //ShellExecuteS(allprogs[i2].pname, allprogs[i2].ppath, allprogs[i2].pparam)
      //ShellExecute('cmd.exe', allprogs[i2].ppath, '/c "'+pde_base_path+'starter.cmd "'+allprogs[i2].pname+'""', true)
      else //path from \..\pde\
      //ShellExecute('cmd.exe', pde_base_path+allprogs[i2].ppath
      //  , '/c "'+pde_base_path+'starter.cmd "'+pde_base_path+allprogs[i2].pname+'""', true);
      OS2Exec(pdebase+allprogs[i2].pname, pdebase+allprogs[i2].ppath, allprogs[i2].pparam);
      //ShellExecuteS(pde_base_path+allprogs[i2].pname, pde_base_path+allprogs[i2].ppath, allprogs[i2].pparam);

    End
  else if allprogs[i2].ptype='FOLDER' then
    Begin

    if (allprogs[i2].pname[2] = ':') then //full path
      ShellExecuteS(pdebase+'FileHalf.exe', pdebase, allprogs[i2].ppath)
      else
      ShellExecuteS(pdebase+'FileHalf.exe', pdebase, pdebase+allprogs[i2].ppath);

    End
  else ;

End;

Initialization
  RegisterClasses ([TMainForm, TExplorerButton, TLabel, TPopupMenu, TMenuItem
   , TTimer, TPanel, TProgressBar, TImage, TShape, TBevel]);
End.
