  program pdelogo;

  {&PMTYPE PM}
  {&Use32+}
  {&Open32-}

  uses
    os2def, os2base, os2pmapi, pmobj, vputils, sysutils;

  const
    Flags = fcf_tasklist+fcf_nobytealign ;
    WS_TOPMOST = $200000;

  type
    PWnd = ^TWnd;
    TWnd = object(PMWindow)
      PS: hPS;
      ThreadId: LongInt;
      hbm: HBitmap;
      textStr: PChar;
      function HandleMessage(Window: HWnd; Msg: ULong; Mp1,Mp2 : MParam): MResult; virtual;
      procedure StartupAction; virtual;
    end;

    App = object(PMApplication)
      MainWindow: PWnd;
      constructor Init;
      destructor Done; virtual;
    end;

{$R c:\xata\pdelogo\pdelogo.res}

function MyThread( P: Pointer ): Longint;
begin
//  dossleep(100);
//  TextStr := 'Loading Desktop';
end;

constructor App.Init;
begin
  inherited Init;
  MainWindow:=New(PWnd, Init('PDE logo', 'Window', Flags));

end;

destructor App.Done;
begin
  Dispose(MainWindow, Done);
  inherited Done;
end;

procedure TWnd.StartupAction;
var
  cx, cy: Long;
begin

  if DesktopSize.X > 800 then
    begin
    cx := 500;
    cy := 350;
    end
    else
    begin
    cx := 400;
    cy := 280;
    end;

  WinSetWindowPos(FrameWindow, 0, (DesktopSize.X - cx) div 2
    , (DeskTopSize.Y - cy) div 2, cx, cy
    , swp_move+swp_size+swp_activate+swp_show);

  WinSetWindowULong(FrameWindow, QWL_STYLE
  , WinQueryWindowULong(FrameWindow, QWL_STYLE) or WS_TOPMOST);

end;

function TWnd.HandleMessage(Window: HWnd; Msg: ULong; Mp1,Mp2 : MParam): MResult;
var
  DC: hDC;
  Rect: RectL;
  srcR: RectL;
  ab: hab;
  cx, cy: Long;
begin

  HandleMessage:=0;

  if DesktopSize.X > 800 then
    begin
    cx := 500;
    cy := 350;
    end
    else
    begin
    cx := 400;
    cy := 280;
    end;

  case Msg of
    wm_create:
      begin
      DC:=WinOpenWindowDC(Window);
      if ParamStr(1) <> '' then
        TextStr := StrPNew(ParamStr(1))
        else
        TextStr := 'Hallo';
      //WinStartTimer(ab, 0, 0, 1000);
      //threadId := VPBeginThread( MyThread, 16384, @Window);
      end;
    wm_size:
      begin

      end;
    wm_timer:
      begin
      TextStr := StrCat('.', TextStr);
      HandleMessage := WinDefWindowProc(Window, wm_paint, Mp1, Mp2);
      end;
    wm_paint:
      begin
      PS:=WinBeginPaint(Window, 0, @Rect);

      Rect.xLeft := 0;
      Rect.xRight := cx;//400;
      Rect.yBottom := 0;
      Rect.yTop := cy + 20;//300;
      //WinFillRect(ps, Rect, CLR_BLUE);
      hbm := GpiLoadBitmap(ps, 0, 100, cx, cy + 20);//400, 300);
      srcR.xLeft := 1;
      srcR.xRight := cx;//400;
      srcR.yBottom := 20;
      srcR.yTop := cy + 20;//300;
      WinDrawBitmap(ps, hbm, @srcR, @Rect, 0, 0, {DBM_STRETCH);//}DBM_NORMAL);
      GpiDeleteBitmap(hbm);
      //WinDrawBorder(ps, Rect, 3, 3, 0, 0, DB_AREAATTRS);
      Rect.yTop := cy;//280;
      WinDrawBorder(ps, Rect, 1, 1, CLR_WHITE, CLR_WHITE, 0);
      Rect.yBottom := 5;
      WinDrawText(ps, strlen(TextStr), TextStr, Rect, CLR_BLUE, CLR_BLACK, DT_CENTER+DT_Bottom);

      WinEndPaint(PS);
      end;
    wm_button1up:
      begin
      HandleMessage := WinDefWindowProc(Window, wm_close, Mp1, Mp2);
      end;

    else HandleMessage:=WinDefWindowProc(Window, Msg, Mp1, Mp2);

  end;

end;

var
  MyApp: App;

Begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
End.
