//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit16;

Interface

Uses
  Classes, Forms, Graphics, Buttons, ExtCtrls, FileCtrl
  , BseDos, BseErr, SysUtils, pdeNLS;

Type
  TDiskFreeForm = Class (TForm)
    bOK: TButton;
    pBox: TPaintBox;
    Bevel1: TBevel;
    bRefresh: TButton;
    Drives: TDriveComboBox;
    Procedure bOKOnClick (Sender: TObject);
    Procedure DiskFreeFormOnShow (Sender: TObject);
    Procedure bRefreshOnClick (Sender: TObject);
    Procedure pBoxOnPaint (Sender: TObject; Const rec: TRect);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

  TDrivesInfo = record
    ch   : String;
    total: LongInt;
    free : LongInt;
  End;

Var
  DiskFreeForm: TDiskFreeForm;
  i, c, w, pw: Integer;
  s: String;
  a: array[1..26] of TDrivesInfo;
  str_Drive, str_Capacity, str_Used, str_Free, str_Kb: String;

procedure pdeDiskFree;

Function DiskFreeKb(Drive: Byte): LongInt;
Function DiskSizeKb(Drive: Byte): LongInt;
function Rectangle(left, bottom, right, top: Integer): TRect;

Implementation

procedure pdeDiskFree;
begin

  { show disks usage }
  //Application.Create;
  DiskFreeForm := TDiskFreeForm.Create(nil);

  DiskFreeForm.ShowModal;

  DiskFreeForm.Free;
  //Application.Destroy;

end;


Function DiskFreeKb(Drive: Byte): LongInt;
Var
  Buffer: FSALLOCATE;
Begin

  If DosQueryFSInfo(Drive, FSIL_ALLOC, Buffer, SizeOf(Buffer)) = NO_ERROR Then
    With Buffer Do Result := Round((cUnitAvail / 1024) * cSectorUnit * cbSector)
  Else Result := -1;

End;

Function DiskSizeKb(Drive: Byte): LongInt;
Var
  Buffer: FSALLOCATE;
Begin
  If DosQueryFSInfo(Drive, FSIL_ALLOC, Buffer, SizeOf(Buffer)) = NO_ERROR Then
    With Buffer Do Result := Round((cUnit / 1024) * cSectorUnit * cbSector)
  Else Result := -1;
End;

function Rectangle(left, bottom, right, top: Integer): TRect;
begin
  Result.left := left;
  Result.bottom := bottom;
  Result.right := right;
  Result.top := top;
end;

Procedure TDiskFreeForm.bOKOnClick (Sender: TObject);
Begin
  Close;
End;

Procedure TDiskFreeForm.DiskFreeFormOnShow (Sender: TObject);
Begin

  Caption := pdeLoadNLS('DisksFree1', 'Drives space usage');
  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bRefresh.Caption := pdeLoadNLS('RefreshButton', 'Refresh');
  str_Drive := pdeLoadNLS('dlgPropertiesDrive', 'Drive');
  str_Capacity := pdeLoadNLS('dlgPropertiesSize', 'Capacity:');
  str_Used := pdeLoadNLS('dlgPropertiesUsed', 'Used:');
  str_Free := pdeLoadNLS('dlgPropertiesFree', 'Free:');
  str_Kb := pdeLoadNLS('statusKBytes', 'Kb');
  bRefreshOnClick( Sender );

End;

Procedure TDiskFreeForm.bRefreshOnClick (Sender: TObject);
Begin

  { show current disks usage/free }
  c := Drives.Items.Count;
  for i := 0 to Drives.Items.Count - 1 do
    begin
    s := Drives.Items[i];
    a[i+1].ch    := UpperCase(s)[1];
    a[i+1].total := DiskSizeKb(ord(LowerCase(s)[1])-96);
    a[i+1].free  := DiskFreeKb(ord(LowerCase(s)[1])-96);
    end;

  pBox.Refresh;

End;

Procedure TDiskFreeForm.pBoxOnPaint (Sender: TObject; Const rec: TRect);
Begin

  { show disks state }
  if c = 0 then
    begin
    pBox.Canvas.FillRect(pBox.ClientRect, clDlgWindow);
    exit;
    end;

  w := pBox.Height div (c+1);
  if w < 40 then w := 40;
  pw := pBox.Width;
  pBox.Canvas.FillRect(pBox.ClientRect, clDlgWindow);
  for i := 1 to c do
    begin
    pBox.Canvas.FillRect(Rectangle(0, (c-i+1)*w + 5 - w div 2
      , Round(((a[i].total-a[i].free)/a[i].total)*(pw-10)), (c-i+1)*w), clTeal);
    pBox.Canvas.Rectangle(Rectangle(0, (c-i+1)*w + 5 - w div 2, (pw-10), (c-i+1)*w));
    pBox.Canvas.ShadowedBorder(Rectangle(0, (c-i+1)*w + 5 - w div 2
      , Round(((a[i].total-a[i].free)/a[i].total)*(pw-10)), (c-i+1)*w)
      , clWhite, clBlack);

    pBox.Canvas.Brush.Color := clDlgWindow;
    pBox.Canvas.TextOut(12, (c-i+1)*w+2, str_Drive+' '+a[i].ch+':');
    pBox.Canvas.TextOut(80, (c-i+1)*w+2, str_Capacity+' '+IntToStr(a[i].total)+' '+str_Kb);
    pBox.Canvas.TextOut(220, (c-i+1)*w+2, str_Used+' '+IntToStr(a[i].total-a[i].free)+' '+str_Kb);
    pBox.Canvas.TextOut(380, (c-i+1)*w+2, str_Free+' '+IntToStr(a[i].free)+' '+str_Kb);

    end;

End;

Initialization
  RegisterClasses ([TDiskFreeForm, TButton, TPaintBox, TBevel, TDriveComboBox]);
End.
