Unit Unit4;

Interface

Uses
  Classes, Forms, Graphics, pdeNLS, SysUtils, Buttons, StdCtrls
  , TabCtrls, CustomFileControls, DOS, ExtCtrls;

Type
  TCopyDlg = Class (TForm)
    Label1: TLabel;
    DirLab: TLabel;
    SrcName: TEdit;
    DestName: TEdit;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Drive: TCustomDriveComboBox;
    Dir: TCustomDirectoryListBox;
    bCopy: TButton;
    bCancel: TButton;

    Tabs: TTabSet;
    GroupBox2: TGroupBox;
    DirLab2: TLabel;
    ListBox1: TListBox;
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    Constructor Create(AOwner:TComponent); Override;
    Procedure TabChange (Sender: TObject; NewTab: LongInt;
      Var AllowChange: Boolean);
    Procedure ListBoxOnItemSelect (Sender: TObject; Index: LongInt);
  End;

Var
  CopyDlg: TCopyDlg;

//function pdeCopyDialog(src, text: String): String;
//function LoadBookmarks(Box: TListBox): Integer;

Implementation

function pdeCopyDialog(src, text: String): String;
Begin

  {Copy/Move destination choose dialog}
  copyDlg := TCopyDlg.Create(nil);
  copyDlg.Caption := text;//'஢';
  copyDlg.SrcName.Text := src;
  copyDlg.DestName.Text := src;
  copyDlg.bCopy.Caption := text;

  Result := '';

  if copyDlg.ShowModal = cmOK then
  begin
  if copyDlg.Tabs.TabIndex = 0 then
    Result := copyDlg.DirLab.Caption+'\'+copyDlg.DestName.Text
    else
    Result := copyDlg.DirLab2.Caption+copyDlg.DestName.Text;
  end;

  copyDlg.Free;

End;

//------------------------------------------

function LoadBookmarks(Box: TListBox): Integer;
var
  basepath: String;
  pclr: TColor;
  afile: TextFile;
  tsr: TSearchRec;
  itext: String;
  rez: Integer;
begin
//-----㧪 -------------------
basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

rez:=FindFirst(basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+'\*.*',
  faAnyFile, tsr);
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      assignfile(afile, basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+
        '\'+tsr.name);
      reset(afile);
      readln(afile); readln(afile); readln(afile);
      readln(afile, itext);
      Box.Items.Add(itext);
      closefile(afile);
      end;
    end;
FindClose(tsr);

end;

//-----------------------------------------

Constructor TCopyDlg.Create(AOwner:TComponent);
Begin
Inherited Create(AOwner);
BorderStyle := bsDialog;
ClientWidth := 290; ClientHeight := 405;
Position := poScreenCenter; BorderIcons :=[];
Font.Name := 'WarpSans:9';

Label1 := TLabel.Create(Self);
Label1.Parent := Self;
Label1.Caption := pdeLoadNLS('dlgSourceName', '室 :');
Label1.AutoSize := True;
Label1.Left := 10; Label1.Top := 3;
Label1.Align := alFixedLeftTop;

Label2 := TLabel.Create(Self);
Label2.Parent := Self;
Label2.Caption := pdeLoadNLS('dlgDestName', ' :');
Label2.AutoSize := True;
Label2.Left := 10; Label2.Top := 43;
Label2.Align := alFixedLeftTop;

SrcName := TEdit.Create(Self);
SrcName.Parent := Self;
SrcName.Width := 270;
SrcName.Text := '';
SrcName.Left := 10; SrcName.Top := 19;
SrcName.Align := alFixedLeftTop;
SrcName.readOnly := True;

DestName := TEdit.Create(Self);
DestName.Parent := Self;
DestName.Width := 270;
DestName.Left := 10; DestName.Top := 59;
DestName.Text := '';
DestName.Align := alFixedLeftTop;

GroupBox1 := TGroupBox.Create(Self);
GroupBox1.Parent := Self;
GroupBox1.Caption := pdeLoadNLS('dlgChooseDest', '롥  祭');
GroupBox1.Width := 270;
GroupBox1.Height := 262;
GroupBox1.Left := 10;
GroupBox1.top := 79;
GroupBox1.Align := alFixedLeftTop;
GroupBox1.ZOrder := zoBottom;

Drive := TCustomDriveComboBox.Create(Self);
Drive.Parent := GroupBox1;
Drive.Width := 262;
Drive.Left := 4;
Drive.Top := 18;
Drive.Align := alFixedLeftTop;

Dir := TCustomDirectoryListBox.Create(Self);
Dir.Parent := GroupBox1;
Drive.DirList := Dir;
Dir.Width := 262;
Dir.Height := 195;
Dir.Left := 4;
Dir.Top := 42;
Dir.Align := alFixedLeftTop;

DirLab := TLabel.Create(Self);
DirLab.Parent := Self;
DirLab.Caption := '';
DirLab.AutoSize := True;
DirLab.Left := 14;
DirLab.Top := 320;
DirLab.Align := alFixedLeftTop;
Dir.DirLabel := DirLab;

bCopy := TButton.Create(Self);
bCopy.Parent := Self;
bCopy.Width := 100;
bCopy.Height := 26;
bCopy.Left := 95;
bCopy.Top := 364;
bCopy.Caption := pdeLoadNLS('dlgCopyButton', '஢');
bCopy.Command := cmOK;
bCopy.ModalResult := cmOK;
bCopy.Default := True;
bCopy.Align := alFixedLeftTop;
//Copy.OnClick := CopyBtnClick;

bCancel := TButton.Create(Self);
bCancel.Parent := Self;
bCancel.Height := 26;
bCancel.Left := 200;
bCancel.Top := 364;
bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
bCancel.Command := cmCancel;
bCancel.ModalResult := cmCancel;
bCancel.Align := alFixedLeftTop;
bCancel.Cancel := True;
//Cancel.OnClick := CancelBtnClick;

Tabs := TTabSet.Create(Self);
Tabs.Parent := Self;
Tabs.DitherBackground := False;
Tabs.Height := 20;
Tabs.Width := 266;
Tabs.Left := 10;
Tabs.Top := 341;
Tabs.Align := alFixedLeftTop;
Tabs.Tabs.Add(pdeLoadNLS('menuGotoDrives', '᪨'));
Tabs.Tabs.Add(pdeLoadNLS('menuBookmarks', ''));
Tabs.TabIndex := 0;
Tabs.OnChange := TabChange;

GroupBox2 := TGroupBox.Create(Self);
GroupBox2.Parent := Self;
GroupBox2.Caption := pdeLoadNLS('dlgChooseDest', '롥  祭');
GroupBox2.Width := 270;
GroupBox2.Height := 262;
GroupBox2.Left := 10;
GroupBox2.Top := 79;
GroupBox2.Align := alFixedLeftTop;
GroupBox2.ZOrder := zoTop;
GroupBox2.Visible := False;

DirLab2 := TLabel.Create(Self);
DirLab2.Parent := GroupBox2;
DirLab2.Caption := '';
DirLab2.AutoSize := True;
DirLab2.Left := 4;
DirLab2.Top := 241;
DirLab2.Align := alFixedLeftTop;

ListBox1 := TListBox.Create(Self);
ListBox1.Parent := GroupBox2;
ListBox1.Width := 262;
ListBox1.Height := 219;
ListBox1.Left := 4;
ListBox1.Top := 18;
ListBox1.Align := alFixedLeftTop;
ListBox1.OnItemSelect := ListBoxOnItemSelect;

LoadBookmarks(ListBox1);

End;

//-----------------------------------------

Procedure TCopyDlg.ListBoxOnItemSelect (Sender: TObject; Index: LongInt);
Begin
  DirLab2.Caption := ListBox1.Items[Index];
End;

//-----------------------------------------

Procedure TCopyDlg.TabChange (Sender: TObject; NewTab: LongInt;
  Var AllowChange: Boolean);
Begin
  if NewTab = 0 then
    begin
    GroupBox2.Visible := False;
    end
  else
    begin
    GroupBox2.Visible := True;
    end;
  AllowChange := True;
End;

//-----------------------------------------

Initialization
  RegisterClasses ([TCopyDlg, TButton, TEdit, TLabel, TTabSet,
    TCustomDriveComboBox, TCustomDirectoryListBox, TGroupBox, TListBox]);
End.
