//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE English to Russian dictionary     //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit1;

Interface

Uses
  Classes, Forms, Graphics, SysUtils, Buttons, StdCtrls, PMWin
  , Unit2, Unit3, Unit4, XplorBtn, ExtCtrls, BmpList, EditList
  , CustomListBox, Unit5;

Type
  TFullForm = Class (TForm)
    pMenu1: TPopupMenu;
    mAutoSearch1: TMenuItem;
    MenuItem2: TMenuItem;
    mAddWord1: TMenuItem;
    MenuItem4: TMenuItem;
    mShortMode: TMenuItem;
    MenuItem6: TMenuItem;
    mAbout1: TMenuItem;
    MenuItem8: TMenuItem;
    mExit1: TMenuItem;
    LabEng1: TLabel;
    LabRu1: TLabel;
    cbEng: TComboBox;
    mRu: TMemo;
    bGo1: TButton;
    Timer1: TTimer;
    xbExit: TExplorerButton;
    xbMenu: TExplorerButton;
    xbShortMode: TExplorerButton;
    xbView: TExplorerButton;
    xbTranslate: TExplorerButton;
    Bevel1: TBevel;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Shape6: TShape;
    PopupMenu1: TPopupMenu;
    mCopy2: TMenuItem;
    MenuItem5: TMenuItem;
    mViewIt2: TMenuItem;
    MenuItem1: TMenuItem;
    mOnTop1: TMenuItem;
    Procedure mCopy2OnClick (Sender: TObject);
    Procedure FullFormOnShow (Sender: TObject);
    Procedure xbViewOnClick (Sender: TObject);
    Procedure mOnTop2OnClick (Sender: TObject);
    Procedure Label1OnClick (Sender: TObject);
    Procedure Timer1OnTimer (Sender: TObject);
    Procedure FullFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure cbEngOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure cbEngOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure bGo1OnClick (Sender: TObject);
    Procedure cbEngOnEnter (Sender: TObject);
    Procedure cbEngOnChange (Sender: TObject);
    Procedure bMenu1OnClick (Sender: TObject);
    Procedure mExit1OnClick (Sender: TObject);
    Procedure mAbout1OnClick (Sender: TObject);
    Procedure mShortModeOnClick (Sender: TObject);
    Procedure mAddWord1OnClick (Sender: TObject);
    Procedure mAutoSearch1OnClick (Sender: TObject);
    Procedure FullFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  FullForm: TFullForm;
  progPath: String;  //path to program's exe-file
  dict_main: TMemoryStream;  //memory to hold main dictionary
  dict_user: TMemoryStream;  //memory to hold user's dictionary
  FullModeOn: Boolean;
  WordFromComboList: Boolean;

procedure LoadSettings;  //load values from "slovo.cfg"
procedure LoadDictionaries;  //load dictionariees to memory
procedure SaveSettings;  //save program's settings to "slovo.cfg"
procedure FreeResources;  //free memories used by dictionaries
procedure AddNewWord(Eng, Ru: String);  //adds new word/translation to
                                        //user's dictionary

function FindTranslation(s: String): String;  //used in "short mode"
function FindTranslation2(s: String): String;  //used in "full mode"

Implementation

function FindTranslation2(s: String): String;
var
  t, t2: String;
begin

  { return the translation, if it not exists - return '' }
  Result := '';

  if dict_user <> nil then
    begin
    dict_user.seek(0, 0);
    while not dict_user.EndOfData do  //(dict_main.position < dict_main.size) do
      begin
      t := dict_user.readln;
      t2 := dict_user.readln;
      if pos(LowerCase(s), LowerCase(t)) = 1 then
        begin
        Result := t2;
        FullForm.cbEng.Items.Add(t);

        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_user.EndOfData then exit;
        t := dict_user.readln;
        dict_user.readln;
        FullForm.cbEng.Items.Add(t);

        exit;
        end;
      end;
    end;

  if dict_main <> nil then
    begin
    dict_main.seek(0, 0);
    while not dict_main.EndOfData do  //(dict_main.position < dict_main.size) do
      begin
      t := dict_main.readln;
      t2 := dict_main.readln;
      if pos(LowerCase(s), LowerCase(t)) = 1 then
        begin
        Result := t2;
        FullForm.cbEng.Items.Add(t);

        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);
        if dict_main.EndOfData then exit;
        t := dict_main.readln;
        dict_main.readln;
        FullForm.cbEng.Items.Add(t);

        exit;
        end;
      end;
    end;

end;

function FindTranslation(s: String): String;
var
  t, t2: String;
begin

  { return the translation, if it not exists - return '' }
  Result := '';

  if dict_user <> nil then
    begin
    dict_user.seek(0, 0);
    while not dict_user.EndOfData do  //(dict_main.position < dict_main.size) do
      begin
      t := dict_user.readln;
      t2 := dict_user.readln;
      if pos(LowerCase(s), LowerCase(t)) = 1 then
        begin
        ShortForm.LabHint.Caption := t;
        Result := t2;
        exit;
        end;
      end;
    end;

  if dict_main <> nil then
    begin
    dict_main.seek(0, 0);
    while not dict_main.EndOfData do  //(dict_main.position < dict_main.size) do
      begin
      t := dict_main.readln;
      t2 := dict_main.readln;
      if pos(LowerCase(s), LowerCase(t)) = 1 then
        begin
        ShortForm.LabHint.Caption := t;
        Result := t2;
        exit;
        end;
      end;
    end;

end;

procedure FreeResources;
begin

  {free memory used for dirctionaries}
  if dict_main <> nil then
    dict_main.free;

  if dict_user <> nil then
    dict_user.free;

end;

procedure LoadDictionaries;
begin

  {load main and user's dictionaries into memory}
  if FileExists(progpath + 'en2rus.txt') then
    begin
    dict_main := TMemoryStream.Create;
    dict_main.LoadFromFile(progpath + 'en2rus.txt');
    end;


  if FileExists(progpath + 'en2rus_user.txt') then
    begin
    dict_user := TMemoryStream.Create;
    dict_user.LoadFromFile(progpath + 'en2rus_user.txt');
    end;

end;

procedure LoadSettings;
var
  afile: TextFile;
  r, b, a, m: Integer;
begin

  {load program's settings}
  r := 0;
  b := 0;
  a := 0;
  m := 0;

  if FileExists(progpath+'slovo.cfg') then
  begin
  AssignFile(afile, progpath + 'slovo.cfg');
  Reset(afile);

  Readln(afile, r);
  Readln(afile, b);
  Readln(afile, a);
  Readln(afile, m);

  CloseFile(afile);
  end;

  //FullForm.ClientHeight := 225;
  //FullForm.ClientWidth := 370;
  FullForm.Right := r;
  FullForm.Bottom := b;
  FullForm.mAutoSearch1.Checked := (a = 1);
  FullModeOn := (m = 0);

end;

procedure SaveSettings;
var
  afile: TextFile;
  r, b, a, m: Integer;
begin

  // save program setting into config-file
  r := FullForm.Right;
  b := FullForm.Bottom;
  if ShortForm.Visible then
    begin
    r := ShortForm.Right;
    b := ShortForm.Bottom;
    end;

  a := 0;  //auto search = 1
  if FullForm.mAutoSearch1.Checked then
    a := 1;
  m := 0;  //short mode = 1
  if ShortForm.Visible then
    m := 1;

  try
  AssignFile(afile, progpath + 'slovo.cfg');
  Rewrite(afile);

  Writeln(afile, r);
  Writeln(afile, b);
  Writeln(afile, a);
  Writeln(afile, m);

  CloseFile(afile);
  except
  CloseFile(afile);
  end;


end;

procedure AddNewWord(Eng, Ru: String);
var
  afile: TextFile;
begin

{add new word to user's dictionary}
try
  AssignFile(afile, progpath+'en2rus_user.txt');

  if FileExists(progpath+'en2rus_user.txt') then
    Append(afile)
  else  //create new useer's dictionary
    Rewrite(afile);

  Writeln(afile, Eng);
  Writeln(afile, Ru);
  CloseFile(afile);

  if dict_user <> nil then
    dict_user.Free;
  dict_user := TMemoryStream.Create;
  dict_user.LoadFromFile(progpath + 'en2rus_user.txt');
except
  CloseFile(afile);
  dict_user.Free;
  dict_user := nil;
  end;

end;

Procedure TFullForm.mCopy2OnClick (Sender: TObject);
Begin
  mRu.CopyToClipboard;
End;

Procedure TFullForm.FullFormOnShow (Sender: TObject);
Begin

  if ShortForm.Visible then ShortForm.Hide;

End;

Procedure TFullForm.xbViewOnClick (Sender: TObject);
var
  t: String;
Begin

  {open new window with translation}
  if cbEng.Items.Count = 0 then exit;

  Application.CreateForm (TViewForm, ViewForm);
  ViewForm.Caption := 'ᬮ: '+cbEng.Items[0];
  ViewForm.LabWord.Caption := cbEng.Items[0];
  ViewForm.mWord.Clear;
  ViewForm.mWord.Lines.Assign(mRu.Lines);
  {t := mRu.Text;
  while pos('  ', t) <> 0 do
    begin
    ViewForm.mWord.Lines.Add(copy(t, 1, pos('  ', t)));
    delete(t, 1, pos('  ', t)+1);
    end;
  ViewForm.mWord.Lines.Add(t);}
  ViewForm.Show;

End;

Procedure TFullForm.mOnTop2OnClick (Sender: TObject);
Begin

  mOnTop1.Checked := not(mOnTop1.Checked);
  ShortForm.mOnTop.Checked := mOnTop1.Checked;

  if mOnTop1.Checked then
    begin
    WinSetWindowULong(Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(Frame.Handle, QWL_STYLE) or $200000);
    WinSetWindowULong(FullForm.Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(FullForm.Frame.Handle, QWL_STYLE) or $200000);
    end
  else
    begin
    WinSetWindowULong(Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(Frame.Handle, QWL_STYLE) - $200000);
    WinSetWindowULong(FullForm.Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(FullForm.Frame.Handle, QWL_STYLE) - $200000);
    end;

End;

Procedure TFullForm.Label1OnClick (Sender: TObject);
var
  t: string;
Begin

  cbEng.Items.Clear;
  //mRu.Text := FindTranslation2(cbEng.Text);
  mRu.Clear;
  t := FindTranslation2(cbEng.Text);
  while pos('  ', t) <> 0 do
    begin
    mRu.Lines.Add(copy(t, 1, pos('  ', t)));
    delete(t, 1, pos('  ', t)+1);
    end;
  mRu.Lines.Add(t);

End;

Procedure TFullForm.Timer1OnTimer (Sender: TObject);
Begin

  if not FullModeOn then
    mShortModeOnClick(Sender);

  Timer1.Stop;

End;

Procedure TFullForm.FullFormOnCloseQuery (Sender: TObject;
  Var CanClose: Boolean);
Begin

  //save settings and exit
  if not Visible then exit;

  SaveSettings;
  FreeResources;
  Application.Terminate;
  CanClose := True;

End;

Procedure TFullForm.cbEngOnItemSelect (Sender: TObject; Index: LongInt);
Begin

  //cbEng.Items.Clear;
  //mRu.Text := FindTranslation2(cbEng.Text);
  WordFromComboList := True;

End;

Procedure TFullForm.cbEngOnItemFocus (Sender: TObject; Index: LongInt);
Begin

  //mRu.Text := FindTranslation2(cbEng.Items[Index]);
  WordFromComboList := True;

End;

Procedure TFullForm.bGo1OnClick (Sender: TObject);
var
  t: string;
Begin

  if cbEng.Text <> '' then
    begin

    cbEng.Items.Clear;
    //mRu.Text := FindTranslation2(cbEng.Text);
    mRu.Clear;
    t := FindTranslation2(cbEng.Text);
    while pos('  ', t) <> 0 do
    begin
      mRu.Lines.Add(copy(t, 1, pos('  ', t)));
      delete(t, 1, pos('  ', t)+1);
    end;
    mRu.Lines.Add(t);

    end;

End;

Procedure TFullForm.cbEngOnEnter (Sender: TObject);
Begin

  bGo1.Default := True;

End;

Procedure TFullForm.cbEngOnChange (Sender: TObject);
var
  t: string;
Begin

  if WordFromComboList then
    begin
    WordFromComboList := False;
    exit;
    end;

  if cbEng.Text <> '' then
  if mAutoSearch1.Checked then
    begin
    cbEng.Items.Clear;
    //mRu.Text := FindTranslation2(cbEng.Text);
    mRu.Clear;
    t := FindTranslation2(cbEng.Text);
    while pos('  ', t) <> 0 do
      begin
      mRu.Lines.Add(copy(t, 1, pos('  ', t)));
      delete(t, 1, pos('  ', t)+1);
      end;
    mRu.Lines.Add(t);
    end;


End;

Procedure TFullForm.bMenu1OnClick (Sender: TObject);
Begin

  { show menu}
  pMenu1.Popup(Screen.MousePos.X, Screen.MousePos.Y);

End;

Procedure TFullForm.mExit1OnClick (Sender: TObject);
Begin

  //save settings and exit
  SaveSettings;
  FreeResources;
  Application.Terminate;

End;

Procedure TFullForm.mAbout1OnClick (Sender: TObject);
Begin

  {about ...}
  AboutForm.ShowModal;

End;

Procedure TFullForm.mShortModeOnClick (Sender: TObject);
Begin

  //goto to short mode (ShortForm)
  Hide;
  ShortForm.Right := Right;
  ShortForm.Bottom := Bottom;
  ShortForm.Show;

End;

Procedure TFullForm.mAddWord1OnClick (Sender: TObject);
Begin

  //show "add word dialog"
  AddWordForm.edEng1.Text := '';
  AddWordForm.edRu1.Text := '';

  if AddWordForm.ShowModal = cmOk then
    begin //add word to user's dictionary
    AddNewWord(AddWordForm.edEng1.Text, AddWordForm.edRu1.Text);
    end;

End;

Procedure TFullForm.mAutoSearch1OnClick (Sender: TObject);
Begin

  {"auto search"}
  ShortForm.mAutoSearch.Checked := not(ShortForm.mAutoSearch.Checked);
  FullForm.mAutoSearch1.Checked := ShortForm.mAutoSearch.Checked;

End;

Procedure TFullForm.FullFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;
  progpath := ExtractFilePath(Application.ExeName);
  LoadSettings;
  LoadDictionaries;
  Timer1.Start;

End;

Initialization
  RegisterClasses ([TFullForm, TButton, TPopupMenu, TMenuItem, TLabel,
    TComboBox, TMemo, TTimer, TExplorerButton, TBevel, TShape]);
End.
