{==========================================}
{  Find utility for PDE Desktop OS/2       }
{  Copyleft stVova, 2003                   }
{  mailto://stVova@ukrpost.com.ua          }
{  http://os2progg.by.ru/pde               }
{  This is free OS/2 software :-)          }
{  10.10.2003 - 16.10.2003                 }
{  28.10.2003 -  2.11.2003                 }
{  22.11.2003 - 22.11.2003                 }
{   6.12.2003                              }
{   5.03.2004 -  7.03.2004                 }
{  17.04.2004 - 30.05.2004                 }
{==========================================}

Unit Unit1;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, ComCtrls
  , StdCtrls, MultiColumnListBox2, Buttons, CheckLB, FileCtrl
  , SysUtils, Dos, pdeNLS, os2def, bsedos, OutLine
  , PMWin, PmStdDlg, XplorBtn
  , pdedlgsDLL;

Type
  TFinderForm = Class (TForm)
    Procedure lbDrivesOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure btnLocateOnClick (Sender: TObject);
    Procedure mIFindOriginalOnClick (Sender: TObject);
    Procedure mIOpenOnClick (Sender: TObject);
    Procedure xbAddFilterOnClick (Sender: TObject);
    Procedure mIS48OnClick (Sender: TObject);
    Procedure mIS40OnClick (Sender: TObject);
    Procedure mIS32OnClick (Sender: TObject);
    Procedure mIS20OnClick (Sender: TObject);
    Procedure mIS16OnClick (Sender: TObject);
    Procedure mISAutoOnClick (Sender: TObject);
    Procedure mDirExportOnClick (Sender: TObject);
    Procedure FinderFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure mDirSaveNowOnClick (Sender: TObject);
    Procedure xbPropertiesOnClick (Sender: TObject);
    Procedure mDirLoadOnStartOnClick (Sender: TObject);
    Procedure oDirListOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure oDirListOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure xbRenameOnClick (Sender: TObject);
    Procedure xbAddSubSectionOnClick (Sender: TObject);
    Procedure xbAddAllOnClick (Sender: TObject);
    Procedure xbAddOnClick (Sender: TObject);
    Procedure xbDelSectionOnClick (Sender: TObject);
    Procedure xbAddSectionOnClick (Sender: TObject);
    Procedure tbDirectoryOnResize (Sender: TObject);
    Procedure mDirPanelOnClick (Sender: TObject);
    Procedure mShowHelpOnClick (Sender: TObject);
    Procedure lFullOnDblClick (Sender: TObject);
    Procedure bRenameOnClick (Sender: TObject);
    Procedure bDeleteOnClick (Sender: TObject);
    Procedure bMoveOnClick (Sender: TObject);
    Procedure bCopyOnClick (Sender: TObject);
    Procedure mExitOnClick (Sender: TObject);
    Procedure ResultsBoxOnDblClick (Sender: TObject);
    Procedure bOpenOnClick (Sender: TObject);
    Procedure mAboutOnClick (Sender: TObject);
    Procedure mSaveOnClick (Sender: TObject);
    Procedure bRefreshOnClick (Sender: TObject);
    Procedure bNewFindOnClick (Sender: TObject);
    Procedure mShowFoldersOnClick (Sender: TObject);
    Procedure mShowHiddenOnClick (Sender: TObject);
    Procedure FinderFormOnCreate (Sender: TObject);
    MainMenu: TMainMenu;
    mFile: TMenuItem;
    mResults: TMenuItem;
    mSettings: TMenuItem;
    mHelp: TMenuItem;
    mShowHelp: TMenuItem;
    MenuItem1: TMenuItem;
    mAbout: TMenuItem;
    sbStatus: TStatusBar;
    ResultsBox: TMultiColumnListBox;
    Find: TButton;
    BtnPanel2: TToolbar;
    lFull: TLabel;
    Bevel1: TBevel;
    bRename: TExplorerButton;
    bDelete: TExplorerButton;
    bMove: TExplorerButton;
    bCopy: TExplorerButton;
    bOpen: TExplorerButton;
    bRefresh: TExplorerButton;
    bNewFind: TExplorerButton;
    Bevel2: TBevel;
    bSave: TExplorerButton;
    bPrint: TExplorerButton;
    cbDrives: TDriveComboBox;
    imgFile: TImage;
    btnLocate: TButton;
    mIProperties: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem8: TMenuItem;
    mIS16: TMenuItem;
    mIS20: TMenuItem;
    mIS32: TMenuItem;
    mIS40: TMenuItem;
    mIS48: TMenuItem;
    oPopup: TPopupMenu;
    mIOpen: TMenuItem;
    MenuItem13: TMenuItem;
    mIAddSection: TMenuItem;
    mIAddSubSection: TMenuItem;
    mIDelete: TMenuItem;
    MenuItem17: TMenuItem;
    mIFindOriginal: TMenuItem;
    mISAuto: TMenuItem;
    mItemSize: TMenuItem;
    sbDStatus: TStatusBar;
    MenuItem2: TMenuItem;
    mDirAddSection: TMenuItem;
    mDirAddSubSection: TMenuItem;
    mDirDelSection: TMenuItem;
    MenuItem9: TMenuItem;
    mDirAdd: TMenuItem;
    mDirAddAll: TMenuItem;
    MenuItem12: TMenuItem;
    mDirRename: TMenuItem;
    mDirProperties: TMenuItem;
    mDirLoadOnStart: TMenuItem;
    mDirSaveNow: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem7: TMenuItem;
    mDirExport: TMenuItem;
    tbDirectory: TToolbar;
    Bevel3: TBevel;
    lDirCaption: TLabel;
    oDirList: TOutline;
    xbAddSection: TExplorerButton;
    xbDelSection: TExplorerButton;
    xbRename: TExplorerButton;
    xbAddSubSection: TExplorerButton;
    xbAddAll: TExplorerButton;
    xbProperties: TExplorerButton;
    xbAdd: TExplorerButton;
    mDirPanel: TMenuItem;
    mCatalog: TMenuItem;
    ImageList: TImageList;
    MenuItem3: TMenuItem;
    mCopy: TMenuItem;
    mMove: TMenuItem;
    mDelete: TMenuItem;
    mRename: TMenuItem;
    MenuItem4: TMenuItem;
    mExit: TMenuItem;
    mNewFind: TMenuItem;
    MenuItem6: TMenuItem;
    mSave: TMenuItem;
    mShowHidden: TMenuItem;
    mShowFolders: TMenuItem;
    mOpenWith: TMenuItem;
    gbOptions: TGroupBox;
    lName: TLabel;
    edFilename: TEdit;
    Stop: TButton;
    imgLogo: TImage;
    rbPath: TRadioButton;
    rbDrives: TRadioButton;
    lbDrives: TCheckListBox;
    edPath: TEdit;
    chSubDirs: TCheckBox;
    mRefresh: TMenuItem;
    mOpen: TMenuItem;
    Procedure StopOnClick (Sender: TObject);
    Procedure bFindOnClick (Sender: TObject);
    Procedure rbPathOnClick (Sender: TObject);
    Procedure rbDrivesOnClick (Sender: TObject);
    Procedure FinderFormOnShow (Sender: TObject);
    Procedure FinderFormOnResize (Sender: TObject);
    Procedure bPrintOnClick (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    function AnyDriveSelect: Boolean;
    function DoSearch: Integer;
    Procedure OpenWithMenuClick (Sender: TObject);
    //function ShellExecute(fname, fdir, fparam: string; shortcut: Boolean): Boolean;
    function ObjMove(source, dest: cstring): integer;
    function ObjDel(source: string): integer;
    function ResolveAssociation(fname: string): integer;
    function ResolveBmpIndex(fname: string): Integer;
    Procedure LoadDirNow;
    Procedure oDirItemSize(new: Integer);
    Procedure SetButtonsTextNPos(col: Integer;);
  End;

  TSThread = class(TThread)
    NeedTerminate: Boolean;
  Protected
    Procedure Execute; Virtual;
  End;

  TAssociations=record
    flt: string;
    pgm: string;
    bmp: string;
  End;

Var
  FinderForm: TFinderForm;
  assoc: array[1..100] of TAssociations;
  assocCount: Integer;
  fnd: TSThread;
  pdebase: String;
  NeedStop: Boolean;

  DirLoaded, DirChanged: Boolean;
  tbSize: Integer;
  oItemSize: Integer;

  l_case, l_case2: TStringList;
  l_case_dest: String;

  Theme: String = 'Default_theme'; //theme and icons-theme
  ITheme: String = 'Default_theme';


function ListDirectory(path: String): Integer;
function GetAssocNumber(ext: String): String; // '_001' for example
Procedure OpComodo(op, op_text: String);
function ListOpDirectory(base, path: String): Integer;

Implementation

Uses Unit2;

//------------------------------------------

procedure TFinderForm.SetButtonsTextNPos(col: Integer;);
var
  t, k: Integer;
Begin

//set toolbar's buttons position
{
bOpen.Align := alNone;
bCopy.Align := alNone;
bMove.Align := alNone;
bDelete.Align := alNone;
bRename.Align := alNone;
bRefresh.Align := alNone;
bNewFind.Align := alNone;
bSave.Align := alNone;
bPrint.Align := alNone;
Bevel1.Align := alNone;
Bevel2.Align := alNone;
}
//if pdeLoadThemeIntD(Theme, 'ShowButtonsText' , 0) = 0 then
//begin
bOpen.SetWindowPos(2, 2, col, col);
bCopy.SetWindowPos(col+4, 2, col, col);
bMove.SetWindowPos(2*col+6, 2, col, col);
bDelete.SetWindowPos(3*col+8, 2, col, col);
bRename.SetWindowPos(4*col+10, 2, col, col);

bRefresh.SetWindowPos(5*col+18, 2, col, col);
bNewFind.SetWindowPos(6*col+20, 2, col, col);
bSave.SetWindowPos(7*col+22, 2, col, col);
bPrint.SetWindowPos(8*col+30, 2, col, col);

Bevel1.Left := 5*col+12;
Bevel2.Left := 7*col+14;
{end
else  //--show buttons' captions
begin
k := 7;
bBack.Caption := pdeLoadNLS('BackwardButton', '');
t := Length(bBack.Caption)*k;
bBack.SetWindowPos(2, 2, col+t, col);
bForward.Caption := pdeLoadNLS('ForwardButton', '।');
t := Length(bForward.Caption)*k;
bForward.SetWindowPos(bBack.Width+4, 2, col+t, col);
bUp.Caption := pdeLoadNLS('UpDirButton', ' ஢ ');
t := Length(bUp.Caption)*k;
bUp.SetWindowPos(bForward.Left+bForward.Width+2, 2, col+t, col);
bRefresh.Caption := pdeLoadNLS('RefreshButton', '');
t := Length(bRefresh.Caption)*k;
bRefresh.SetWindowPos(bUp.Left+bUp.Width+2, 2, col+t, col);
bCopy.Caption := pdeLoadNLS('CopyButton', '஢');
t := Length(bCopy.Caption)*k;
bCopy.SetWindowPos(bRefresh.Left+bRefresh.Width+8, 2, col+t, col);
bMove.Caption := pdeLoadNLS('MoveButton', '६');
t := Length(bMove.Caption)*k;
bMove.SetWindowPos(bCopy.Left+bCopy.Width+2, 2, col+t, col);
bDelete.Caption := pdeLoadNLS('DeleteButton', '');
t := Length(bDelete.Caption)*k;
bDelete.SetWindowPos(bMove.Left+bMove.Width+2, 2, col+t, col);
bRename.Caption := pdeLoadNLS('RenameButton', '२');
t := Length(bRename.Caption)*k;
bRename.SetWindowPos(bDelete.Left+bDelete.Width+2, 2, col+t, col);
bFind.Caption := pdeLoadNLS('FindButton', '');
t := Length(bFind.Caption)*k;
bFind.SetWindowPos(bRename.Left+bRename.Width+8, 2, col+t, col);
bNew.Caption :=  pdeLoadNLS('NewFolderButton', ' ');
t := Length(bNew.Caption)*k;
bNew.SetWindowPos(bFind.Left+bFind.Width+2, 2, col+t, col);
bProperties.Caption := pdeLoadNLS('PropertiesButton', '⢠');
t := Length(bProperties.Caption)*k;
bProperties.SetWindowPos(bNew.Left+bNew.Width+2, 2, col+t, col);
bNewWindow.Caption := pdeLoadNLS('NewWindowButton', ' ');
t := Length(bNewWindow.Caption)*k;
bNewWindow.SetWindowPos(bProperties.Left+bProperties.Width+2, 2, col+t, col);

Bevel1.Left := bRefresh.Left+bRefresh.Width+2;
Bevel2.Left := bRename.Left+bRename.Width+2;
end;}

Bevel1.Height := col;
Bevel1.Bottom := 2;
Bevel2.Height := col;
Bevel2.Bottom := 2;
{
bBack.Align := alFixedLeftBottom;
bForward.Align := alFixedLeftBottom;
bUp.Align := alFixedLeftBottom;
bRefresh.Align := alFixedLeftBottom;
bCopy.Align := alFixedLeftBottom;
bMove.Align := alFixedLeftBottom;
bDelete.Align := alFixedLeftBottom;
bRename.Align := alFixedLeftBottom;
bFind.Align := alFixedLeftBottom;
bNew.Align := alFixedLeftBottom;
bProperties.Align := alFixedLeftBottom;
bNewWindow.Align := alFixedLeftBottom;
Bevel1.Align := alFixedLeftBottom;
Bevel2.Align := alFixedLeftBottom;
}
End;

//------------------------------------------

function ListOpDirectory(base, path: String): Integer; // [base], [path]\
var
  sr: TSearchRec;
  attr, rez: Integer;
Begin

Application.ProcessMessages;

attr := faReadOnly Or faSysFile Or faArchive or faDirectory or faHidden;

  rez := FindFirst(base + '\' + path+'*', attr, sr);
  if rez = 0 then
  if (sr.attr and faDirectory)=0 then //file
      begin
      l_case2.Add('f ' + path + sr.name);
      end;

  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then //file
      begin
      l_case2.Add('f ' + path + sr.name);
      end;

    end;

FindClose(sr);

//------//

attr := faReadOnly Or faSysFile Or faArchive or faDirectory or faHidden;

  rez := FindFirst(base +'\' + path+'*', attr, sr);
  if rez = 0 then
  if (sr.attr and faDirectory)=0 then //file
      begin
      ;
      end
      else
      begin
      if (sr.name <> '..') and (sr.name <> '.') then
        begin
          l_case2.Add('d ' + path + sr.name);

          ListOpDirectory(base, path + sr.name + '\');
        end;
      end;

  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then //file
      begin
      ;
      end
      else
      begin
      if (sr.name <> '..') and (sr.name <> '.') then
        begin
        l_case2.Add('d ' + path + sr.name);

        ListOpDirectory(base, path + sr.name + '\');
        end;
      end;

    end;

FindClose(sr);

Result := 0;

End;

{==========================================}

Procedure OpComodo(op, op_text: String);
var
  li: LongInt;
  base, ltmp: String;
  afile: TextFile;
  sr: TSearchRec;
  rez: Integer;
Begin

  {file operations using "comodo.exe"}
  if l_case.Count = 0 then exit;

  l_case2.Clear;

  for li := 0 to l_case.Count - 1 do
    begin
    ltmp := l_case.Strings[li];

    if FindFirst(ltmp+'\*.*', faAnyFile, sr) <> 0 then //file
      begin
      l_case2.Add('f ' + ltmp);
      FindClose(sr);
      end
      else
      begin
      FindClose(sr);
      base := ltmp;
      l_case2.Add('b ' + base);
      ListOpDirectory(base, '');
      end;

    end;

  l_case.Clear;

  AssignFile(afile, GetEnv('TEMP')+'\~fhcomodo.txt');
  Rewrite(afile);

  Writeln(afile, IntToStr(l_case2.count));
  Writeln(afile, l_case_dest);
  for li := 0 to l_case2.count - 1 do
    Writeln(afile, l_case2.strings[li]);

  CloseFile(afile);

  ShellExecute(pdebase+'\Utils\comodo.exe'
    , '', op+' '+pdeLoadCfgStrD('general.cfg', 'overwritefiles', '0')+' '+op_text, true);

End;

//------------------------------------------

Procedure TFinderForm.lbDrivesOnItemFocus (Sender: TObject; Index: LongInt);
Begin

  {check drive when you just focus (one click) on it}
  if lbDrives.State[Index] <> clsChecked then
    lbDrives.State[Index] := clsChecked
    else
    lbDrives.State[Index] := clsUnchecked;

End;

Procedure TFinderForm.btnLocateOnClick (Sender: TObject);
var
  openname: String;
  ttt: String;
Begin

  ttt := edPath.Text;
  if (length(ttt) > 3) and (ttt[length(ttt)] = '\') then
  Delete(ttt, length(ttt), 1);

  if ttt <> '' then
  openname := pdeOpenFileDialog(pdeLoadNLS('pFinder29', '롮 ')
    , ttt, pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|')
  else
  openname := pdeOpenFileDialog(pdeLoadNLS('pFinder29', '롮 ')
    , pdebase+pdeLoadCfgStr('general.cfg', 'userhome')+'\'
    , pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|');

  if openname <> '' then
    edPath.Text := openname;

End;

//------------------------------------------

Procedure TFinderForm.mIFindOriginalOnClick (Sender: TObject);
Begin

  {open folder with original}
  if oDirList.SelectedItem = -1 then exit;
  ShellExecute(pdebase+'\FileHalf.exe', pdebase+'\'
    , ExtractFilePath(oDirList.SelectedNode.PathName), false);

End;

Procedure TFinderForm.mIOpenOnClick (Sender: TObject);
Begin

  {open item from e-Directory}
  if oDirList.SelectedItem = -1 then exit;
  oDirListOnItemSelect (Sender, oDirList.SelectedItem);

End;

//--Pictoghrams size settings---------------
Procedure TFinderForm.mIS48OnClick (Sender: TObject);
Begin
  oItemSize := 48;
  ResultsBox.ItemHeight := oItemSize;
  oDirItemSize(oItemSize);
End;

Procedure TFinderForm.mIS40OnClick (Sender: TObject);
Begin
  oItemSize := 40;
  ResultsBox.ItemHeight := oItemSize;
  oDirItemSize(oItemSize);
End;

Procedure TFinderForm.mIS32OnClick (Sender: TObject);
Begin
  oItemSize := 32;
  ResultsBox.ItemHeight := oItemSize;
  oDirItemSize(oItemSize);
End;

Procedure TFinderForm.mIS20OnClick (Sender: TObject);
Begin
  oItemSize := 20;
  ResultsBox.ItemHeight := oItemSize;
  oDirItemSize(oItemSize);
End;

Procedure TFinderForm.mIS16OnClick (Sender: TObject);
Begin
  oItemSize := 16;
  ResultsBox.ItemHeight := oItemSize;
  oDirItemSize(oItemSize);
End;

Procedure TFinderForm.mISAutoOnClick (Sender: TObject);
var
  i: Integer;
Begin

  oItemSize := 0;
  i := pdeLoadThemeIntD(Theme, 'FilelistIconSize', 32);
  if i <> 0 then
    begin
    ResultsBox.ItemHeight := i div 2;
    oDirItemSize(i div 2);
    end
  else
    begin
    ResultsBox.ItemHeight := 18;
    oDirItemSize(18);
    end;

End;

//------------------------------------------

Procedure TFinderForm.FinderFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
var
  cfgfile: TextFile;
Begin

//  CanClose := True;  //debug
//  exit;

  {save changes, then close}
  if DirChanged then
    mDirSaveNowOnClick (Sender );

  try
  AssignFile(cfgfile, extractfilepath(application.exename)+'pFinder.cfg');
  Rewrite(cfgfile);

  Writeln(cfgfile, '//Configuration of pFinder.exe');
  Writeln(cfgfile, FinderForm.Top);
  Writeln(cfgfile, FinderForm.Left);
  Writeln(cfgfile, FinderForm.Width);
  Writeln(cfgfile, FinderForm.Height);
  Writeln(cfgfile, mShowHidden.Checked);
  Writeln(cfgfile, mShowFolders.Checked);
  Writeln(cfgfile, mDirLoadOnStart.Checked);
  Writeln(cfgfile, tbDirectory.Size);
  Writeln(cfgfile, IntToStr(ResultsBox.Color));
  Writeln(cfgfile, IntToStr(oDirList.Color));
  Writeln(cfgfile, IntToStr(oItemSize));
  //Writeln(cfgfile, );

  except
    pdeMessageBoxOK(pdeLoadNLS('eD2Str37', 'Cann''t save settings.')
      , pdeLoadNLS('dlgError','訡'), FinderForm.Icon.Handle);
  end;
  CloseFile(cfgfile);

  CanClose := True;

End;

function TFinderForm.ResolveBmpIndex(fname: string): Integer;
var
  sr: TSearchRec;
  i: Integer;
Begin

  {know index in Associations}
  Result := 4;
  if (FindFirst(fname+'\*.*', faAnyFile, sr)=0) then
    begin
    //directory
    FindClose(sr);
    Result := 0;
    exit;
    end
  else
    begin
    FindClose(sr);
    if assocCount>0 then
    for i := 1 to assocCount do
      begin
      if (pos(assoc[i].flt, LowerCase(fname))<>0) then
        begin
        Result := i - 1;
        exit;
        end;
      end;
    end;

End;

function TFinderForm.ResolveAssociation(fname: string): integer;
var
  i: Integer;
Begin

//।塞  ७ 䠩,  ணࠬ ᪠
Result := 1;
if assocCount>0 then
  for i := 1 to assocCount do
    begin
    if (pos(assoc[i].flt, LowerCase(fname))<>0) then
      begin
      shellexecute(assoc[i].pgm, ExtractFilePath(assoc[i].pgm), fname, false);
      Result := 0;
      exit;
      end;
    end;

End;

//-----eDirectory routines------------------
Procedure TFinderForm.mDirExportOnClick (Sender: TObject);
var
  savename, ext: String;
  i: Integer;
  afile: TextFile;
  tmp, tmp2: String;
Begin

  if oDirList.ItemCount =0 then exit;

  savename := pdeOpenFileDialog(pdeLoadNLS('eD2Str32','࠭ 䠩')
    , pdebase+pdeLoadCfgStr('general.cfg', 'userhome')+'\',
    'HTML (*.htm;*.html)|'
    +pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|');
  if savename <> '' then
    Begin
    try
    ext := UpperCase(ExtractFileExt(savename));
    AssignFile(afile, savename);
    Rewrite(afile);
    if (ext = '.HTM') or (ext = '.HTML') then  //hypertext
      Begin
      Writeln(afile, '<HTML><HEAD><TITLE>');
      Writeln(afile, '</TITLE></HEAD><BODY><TABLE border="1" width="100%">');
      Writeln(afile, '<TR><TH>Caption</TH><TH>Data</TH></TR>');
      for i:= 0 to oDirList.ItemCount - 1 do
        begin
        tmp := oDirList.Items[i].Text;
        tmp2 := oDirList.Items[i].PathName;
        Writeln(afile, '<TR><TD>'+tmp+'</TD><TD>'+tmp2+'</TD></TR>');
        end;
      Writeln(afile, '</TABLE></BODY></HTML>');
      End;

    CloseFile(afile);
    except
        pdeMessageBoxOK(pdeLoadNLS('eDstr36', ' 㤠 ࠭ 䠩')
          , pdeLoadNLS('dlgError','訡'), FinderForm.Icon.Handle);
      end;
    End;

End;

Procedure TFinderForm.LoadDirNow;
var
  afile: TextFile;
  loadname: String;
  tmp, capt: String;
  i, j: Integer;
  itm: Integer;
  //bmp: TBitmap;
Begin

  {load e-Directory}
  DirLoaded := True;
  loadname := pdebase+pdeLoadCfgStr('general.cfg', 'userhome')+'\eCatalog.txt';
  if FileExists(loadname) then
    begin
    AssignFile(afile, loadname);
    Reset(afile);
    Readln(afile);Readln(afile);
    itm := 0;
    j := 0;
    //bmp := TBitmap.Create;
    While not(eof(afile)) do
      begin

      Readln(afile, tmp);
      i := 0;
      while pos('|', tmp) <> 0 do
        begin
        inc(i);
        delete(tmp, 1, pos('|', tmp) + 1);
        end;
      capt := Copy(tmp, 1, pos('::', tmp)-1);
      Delete(tmp, 1, pos('::', tmp)+1);
      if i = 0 then
        begin
        j := 0;
        itm := oDirList.Add(0, capt);
        end
      else if i = 1 then
        begin
        if j > 0 then
            begin
            if j = 2 then
              itm := oDirList.Items[itm].parent.index
            else if j = 3 then
              itm := oDirList.Items[itm].parent.parent.index;
            j := 0;
            end;

        if tmp <> '' then
          begin
          //ImageList.GetBitmap(ResolveBmpIndex(tmp), bmp);
          //oDirList.AddChildD(itm, capt, tmp, bmp);
          oDirList.AddChildD(itm, capt, tmp, imgFile.Bitmap);
          end
          else
          itm := oDirList.AddChild(itm, capt);

        end
      else if i = 2 then
        begin
        if j > 2 then
          begin
          itm := oDirList.Items[itm].parent.index;
          j := 2;
          end;
        j := 2;

        if tmp <> '' then
        begin
        //ImageList.GetBitmap(ResolveBmpIndex(tmp), bmp);
        //oDirList.AddChildD(itm, capt, tmp, bmp);
        oDirList.AddChildD(itm, capt, tmp, imgFile.Bitmap);
        end
          else
          itm := oDirList.AddChild(itm, capt);
        end
      else if i = 3 then
        begin
        j := 3;
        if tmp <> '' then
          begin
          //ImageList.GetBitmap(ResolveBmpIndex(tmp), bmp);
          //oDirList.AddChildD(itm, capt, tmp, bmp);
          oDirList.AddChildD(itm, capt, tmp, imgFile.Bitmap);
          end
          else
          itm := oDirList.AddChild(itm, capt);
        end;

      end;
    CloseFile(afile);
    end;

End;

Procedure TFinderForm.mDirLoadOnStartOnClick (Sender: TObject);
Begin

  {open e-directory when program start}
  mDirLoadOnStart.Checked := not (mDirLoadOnStart.Checked);

End;

Procedure TFinderForm.oDirListOnItemFocus (Sender: TObject; Index: LongInt);
var
  tmp: String;
  wth: Integer;
Begin

  {show selected item data in statusbar}
  tmp := oDirList.SelectedNode.PathName;
  if sbDStatus.Canvas.TextWidth(tmp) < sbDStatus.Width then
    sbDStatus.SimpleText := tmp
  else
    begin
    insert('...', tmp, 4);
    while sbDStatus.Canvas.TextWidth(tmp) > (sbDStatus.Width - 10) do
      delete(tmp, 7, 2);
    sbDStatus.SimpleText := tmp;
    end;

End;

Procedure TFinderForm.oDirListOnItemSelect (Sender: TObject; Index: LongInt);
var
  ext, txt, tmp: String;
  sr: TSearchRec;
Begin

  {open/load from e-directory}
  if oDirList.SelectedItem = -1 then exit;

  tmp := oDirList.SelectedNode.PathName;

  if tmp = '' then exit; //section

  ext := LowerCase(ExtractFileExt(tmp));

  if (FindFirst(tmp+'\*.*', faAnyFile, sr)=0) then  // 䠩    㣨 䠩 :-)
    begin  // ha-ha, directory :-)
    FindClose(sr);
    ShellExecute(pdebase+'\FileHalf.exe', pdebase+'\', tmp + '\', false);
    end
  else
    begin
    FindClose(sr);
    if (ext = '.exe') or (ext='.com') or (ext='.cmd') or (ext='.bat') then
      ShellExecute(tmp, ExtractFilePath(tmp), '', false)
      else
      if ResolveAssociation(tmp) <> 0 then
        begin
        txt := pdeLoadCfgStr('filehalf.cfg', 'TextUtil');
        if txt[2] <> ':' then txt := pdebase+'\'+txt;
          ShellExecute(txt, ExtractFilePath(txt), tmp, false);
        end;
    end;

End;

Procedure TFinderForm.xbPropertiesOnClick (Sender: TObject);
Begin

  if oDirList.SelectedItem = -1 then exit;
  if oDirList.SelectedNode.PathName = '' then exit;
  PropForm.Show;
  PropForm.BringToFront;
  DirChanged := True;

End;

Procedure TFinderForm.xbRenameOnClick (Sender: TObject);
var
  newcapt: String;
Begin

  {rename selected item}
  if oDirList.SelectedItem = -1 then exit;

  newcapt := pdePromptDialog(pdeLoadNLS('dlgDestName', ' :')
    , pdeLoadNLS('dlgRenaming', '२'), oDirList.SelectedNode.Text);
  if newcapt <> '' then
    oDirList.SelectedNode.Text := newcapt;

  DirChanged := True;

End;

Procedure TFinderForm.mDirSaveNowOnClick (Sender: TObject);
var
  savename, ext: String;
  i, j: Integer;
  afile: TextFile;
  tmp, tmp2, tmp3: String;
Begin

  {save e-Directory into file}
  if oDirList.ItemCount = 0 then exit;

  try
  savename := pdebase+pdeLoadCfgStr('general.cfg', 'userhome')+'\eCatalog.txt';
  AssignFile(afile, savename);
  Rewrite(afile);
  Writeln(afile, 'PDE Finder catalogization service, v0.1');

  for i := 0 to oDirList.ItemCount do
    Begin
    tmp2 := oDirList.Items[i].Text;
    tmp := oDirList.Items[i].PathName;
    tmp3 := oDirList.Items[i].FullPath;
    j := 0;
    while pos('\', tmp3) <> 0 do
      begin
      inc(j);
      delete(tmp3, 1, pos('\', tmp3));
      end;

    while j > 1 do
      begin
      dec(j);
      Write(afile, '| ');
      end;

    if j>0 then
      Write(afile, '|_');

    Writeln(afile, tmp2 + '::' + tmp);
    End;

  CloseFile(afile);
  except
    pdeMessageBoxOK(pdeLoadNLS('eDstr36', ' 㤠 ࠭ 䠩')
      , pdeLoadNLS('dlgError','訡'), FinderForm.Icon.Handle);
  end;
  DirChanged := False;

End;

Procedure TFinderForm.xbAddFilterOnClick (Sender: TObject);
var
  flt: String;
  path, name: String;
  //bmp: TBitmap;
  i: Integer;
Begin

  {add by filter}
  if ResultsBox.Items.Count = 0 then exit;

  flt := pdePromptDialog('' , ' 䨫', '');
  if flt <> '' then
  begin
  //bmp := TBitmap.Create;
  for i := 0 to ResultsBox.Items.Count - 1 do
    Begin
    path := ResultsBox.Items[i];
    //ImageList.GetBitmap(StrToInt(path[2] + path[3] + path[4]), bmp);
    Delete(path, 1, 4);
    name := Copy(path, 1, pos(chr(9), path)-1);
    Delete(path, 1, pos(chr(9), path));
    Delete(path, 1, pos(chr(9), path));

    if oDirList.SelectedItem = -1 then
      oDirList.Add(0, '[Untitled]');

    //oDirList.AddChildD(oDirList.SelectedItem, name, path + name, bmp);
    oDirList.AddChildD(oDirList.SelectedItem, name, path + name, imgFile.Bitmap);
    End;

  oDirList.SelectedNode.Expand;
  //bmp.Free;
  DirChanged := True;
  end;

End;

Procedure TFinderForm.xbAddAllOnClick (Sender: TObject);
var
  path, name: String;
  //bmp: TBitmap;
  i: Integer;
Begin

  {add all items from finded}
  if ResultsBox.Items.Count = 0 then exit;
  //bmp := TBitmap.Create;
  for i := 0 to ResultsBox.Items.Count - 1 do
  Begin
  path := ResultsBox.Items[i];
  //ImageList.GetBitmap(StrToInt(path[2] + path[3] + path[4]), bmp);
  Delete(path, 1, 4);
  name := Copy(path, 1, pos(chr(9), path)-1);
  Delete(path, 1, pos(chr(9), path));
  Delete(path, 1, pos(chr(9), path));

  if oDirList.SelectedItem = -1 then
    oDirList.Add(0, '[Untitled]');

  //oDirList.AddChildD(oDirList.SelectedItem, name, path + name, bmp);
  oDirList.AddChildD(oDirList.SelectedItem, name, path + name, imgFile.Bitmap);
  End;

  oDirList.SelectedNode.Expand;
  //bmp.Free;
  DirChanged := True;

End;

Procedure TFinderForm.xbAddOnClick (Sender: TObject);
var
  path, name: String;
  //bmp: TBitmap;
  ii: LongInt;
Begin

  {add new item(s) from finded}
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  if oDirList.SelectedItem = -1 then
    oDirList.Add(0, '[Untitled]');

  //bmp := TBitmap.Create;

  for ii := 0 to ResultsBox.Items.Count - 1 do
  if ResultsBox.FListBox.Selected[ii] then {make list of selected}
    begin
    path := ResultsBox.Items[ii];
    //ImageList.GetBitmap(StrToInt(path[2] + path[3] + path[4]), bmp);
    Delete(path, 1, 4);
    name := Copy(path, 1, pos(chr(9), path)-1);
    Delete(path, 1, pos(chr(9), path));
    Delete(path, 1, pos(chr(9), path));

    //oDirList.AddChildD(oDirList.SelectedItem, name, path + name, bmp);
    oDirList.AddChildD(oDirList.SelectedItem, name, path + name, imgFile.Bitmap);
    end;

  oDirList.SelectedNode.Expand;
  //bmp.Free;
  DirChanged := True;

End;

Procedure TFinderForm.xbDelSectionOnClick (Sender: TObject);
Begin

  if oDirList.SelectedItem = -1 then exit;
  oDirList.Delete(oDirList.SelectedItem);
  DirChanged := True;

End;

Procedure TFinderForm.xbAddSubSectionOnClick (Sender: TObject);
Begin

  if oDirList.SelectedItem = -1 then
    oDirList.Add(0, '[Untitled]')
  else
  begin
  oDirList.AddChild(oDirList.SelectedItem, '[Untitled]');
  oDirList.SelectedNode.Expand;
  end;

  DirChanged := True;

End;

Procedure TFinderForm.xbAddSectionOnClick (Sender: TObject);
Begin

  if oDirList.SelectedItem = -1 then
    oDirList.Add(0, '[Untitled]')
  else
    oDirList.Add(oDirList.SelectedItem, '[Untitled]');
  DirChanged := True;

End;

Procedure TFinderForm.tbDirectoryOnResize (Sender: TObject);
Begin

  lDirCaption.Width := tbDirectory.Width - 10;
  oDirList.Width := tbDirectory.Width - 36;
  oDirList.Height := FinderForm.ClientHeight - 28 - 18;
  xbAddSection.Left := tbDirectory.Width - 35;
  xbAddSection.Top := 26;
  xbAddSubSection.Left := tbDirectory.Width - 35;
  xbAddSubSection.Top := 58;
  xbDelSection.Left := tbDirectory.Width - 35;
  xbDelSection.Top := 90;
  xbAdd.Left := tbDirectory.Width - 35;
  xbAdd.Top := 122;
  xbAddAll.Left := tbDirectory.Width - 35;
  xbAddAll.Top := 154;
  xbRename.Left := tbDirectory.Width - 35;
  xbRename.Top := 186;
  xbProperties.Left := tbDirectory.Width - 35;
  xbProperties.Top := 218;

End;

Procedure TFinderForm.mDirPanelOnClick (Sender: TObject);
Begin

if tbDirectory.Size = 0 then
    tbDirectory.Size := 200
  else
    tbDirectory.Size := 0;

  if not DirLoaded then
    LoadDirNow;

  FinderFormOnResize (Sender);

End;
//------------------------------------------

Procedure TFinderForm.mShowHelpOnClick (Sender: TObject);
Begin

//from v0.1 help files are in [PDE_HOME]\Help folder
  if FileExists(pdebase+'\Help\pfinder.inf') then
    ShellExecute('view.exe', '', pdebase+'\Help\pfinder.inf', false)
  else if FileExists(pdebase+'\pde_help_ru.inf') then
    ShellExecute('view.exe', '', pdebase+'\pde_help_ru.inf', false)
  else if FileExists(pdebase+'\pde_help_en.inf') then
    ShellExecute('view.exe', '', pdebase+'\pde_help_en.inf', false)
  else if FileExists(pdebase+'\readme_ru.txt') then
    ShellExecute('e.exe', '', pdebase+'\readme_ru.txt', false)
  else if FileExists(pdebase+'\readme_en.txt') then
    ShellExecute('e.exe', '', pdebase+'\readme_en.txt', false);

End;

Procedure TFinderForm.lFullOnDblClick (Sender: TObject);
Begin

  { 㤠\ :-)}
  ResultsBox.Align := alNone;
  if (ResultsBox.Top = 0) then
    begin
    ResultsBox.Top := 230;
    lFull.Caption := chr(30);
    end
  else
    begin
    ResultsBox.Top := 0;
    lFull.Caption := chr(31);
    end;
  ResultsBox.Align := alFixedLeftTop;
  ResultsBox.Height := ClientHeight - ResultsBox.Top - 18;
  ResultsBox.Align := alFrame;

End;

{=File operations==========================}

Procedure TFinderForm.bRenameOnClick (Sender: TObject);
var
  newname, tmp1, tmp2, name, path: String;
  rc: APIRET;
  s, d: cstring;
Begin

  if FinderForm.ActiveControl = oDirList then
    begin
    ;
    end
  else
  begin
  {२ 뤥 䠩\}
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  path := ResultsBox.Items[ResultsBox.ItemIndex];
  tmp1 := Copy(path, 1, 4);
  Delete(path, 1, 4);
  name := Copy(path, 1, pos(chr(9), path)-1);
  Delete(path, 1, pos(chr(9), path));
  tmp2 := Copy(path, 1, pos(chr(9), path)-1);
  Delete(path, 1, pos(chr(9), path));
  newname := pdePromptDialog(pdeLoadNLS('dlgDestName', ' :')
    , pdeLoadNLS('dlgRenaming', '२'), name);
  if newname <> '' then
    begin
    s:=path + name;
    d:=path + newname;
    rc:=DosMove(s, d); //move files and subdirectories (in same drive)
    if rc<>0 then
      Begin
      pdeMessageBoxOK(''+chr(13)+chr(10)+
        pdeLoadNLS('dlgErrorFileAllreadyExists', ' 䠩    㦥 .')
        +chr(13)+chr(10)+pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc),
        pdeLoadNLS('dlgErrorOnRename', '訡 ६饭'), FinderForm.Icon.Handle);
      End
    else
      ResultsBox.Items[ResultsBox.ItemIndex] := tmp1 + newname + chr(9)
        + tmp2 + chr(9) + path;
    end;

  End;

End;

Procedure TFinderForm.bDeleteOnClick (Sender: TObject);
var
  name, path: String;
  ii: LongInt;
Begin

  if FinderForm.ActiveControl = oDirList then
    begin
    ;
    end
  else
  Begin
  {㤠 뤥 䠩\}
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  if pdeMessageBox(pdeLoadNLS('dlgDelete', ':')+chr(13)+chr(10)
    + pdeLoadNLS('pFinder30', '뤥 䠩')
    , pdeLoadNLS('dlgAffirmate', '⢥न'), FinderForm.Icon.Handle) = 0 then
    begin
  l_case.Clear;

  l_case_dest := '';

  for ii := 0 to ResultsBox.Items.Count - 1 do
  if ResultsBox.FListBox.Selected[ii] then {make list of selected}
    begin
    path := ResultsBox.Items[ii];
    Delete(path, 1, 4);
    name := Copy(path, 1, pos(chr(9), path)-1);
    Delete(path, 1, pos(chr(9), path));
    Delete(path, 1, pos(chr(9), path));
    l_case.Add(path + name);
    ResultsBox.Items.Delete(ii);
    dec(ii);
    end;

    OpComodo('2', pdeLoadNLS('dlgDeleting', ''));

    end;

  End;

End;

Procedure TFinderForm.bMoveOnClick (Sender: TObject);
var
  newname, name, path: String;
  ii: LongInt;
Begin

  if FinderForm.ActiveControl = oDirList then
    begin
    ;
    end
  else
  Begin
  {६饭 뤥 䠩\}
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  l_case.Clear;

  newname := pdeCopyDialog(pdeLoadNLS('pFinder30', '뤥 䠩')
    , pdeLoadNLS('dlgMoving', '६饭'));
  if newname <> '' then
    begin
    l_case_dest := ExtractFilePath(newname);

  for ii := 0 to ResultsBox.Items.Count - 1 do
  if ResultsBox.FListBox.Selected[ii] then {make list of selected}
    begin
    path := ResultsBox.Items[ii];
    Delete(path, 1, 4);
    name := Copy(path, 1, pos(chr(9), path)-1);
    Delete(path, 1, pos(chr(9), path));
    Delete(path, 1, pos(chr(9), path));
    l_case.Add(path + name);
    ResultsBox.Items.Delete(ii);
    dec(ii);
    end;

    OpComodo('1', pdeLoadNLS('dlgMoving', '६饭'));

    end;

  End;

End;

Procedure TFinderForm.bCopyOnClick (Sender: TObject);
var
  newname, name, path: String;
  ii: LongInt;
Begin

  if FinderForm.ActiveControl = oDirList then
    begin
    ;
    end
  else
  Begin
  {஢ 뤥 䠩\}
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  l_case.Clear;

  newname := pdeCopyDialog(pdeLoadNLS('pFinder30', '뤥 䠩')
    , pdeLoadNLS('dlgCopying', '஢'));
  if newname <> '' then
    begin
    l_case_dest := ExtractFilePath(newname);

  for ii := 0 to ResultsBox.Items.Count - 1 do
  if ResultsBox.FListBox.Selected[ii] then {make list of selected}
    begin
    path := ResultsBox.Items[ii];
    Delete(path, 1, 4);
    name := Copy(path, 1, pos(chr(9), path)-1);
    Delete(path, 1, pos(chr(9), path));
    Delete(path, 1, pos(chr(9), path));
    l_case.Add(path + name);
    end;

    OpComodo('0', pdeLoadNLS('dlgCopying', '஢'));

    end;

  End;

End;

{==========================================}

Procedure TFinderForm.FinderFormOnCreate (Sender: TObject);
var
  cfgfile: TextFile;
  tmp: String;
  tmpi: LongInt;
Begin

l_case := TStringList.Create;
l_case2 := TStringList.Create;

//--current FileHalfs' THEME and pIctograms ITHEME
Theme := pdeLoadCfgStrD('filehalf.cfg', 'Theme', 'Default_theme');
ITheme := pdeLoadCfgStrD('filehalf.cfg', 'ITheme', 'Default_theme');

 {㧪 NLS    祣}
 Caption := pdeLoadNLS('pFinderInfo1', 'DE ᪠');
 mFile.Caption := pdeLoadNLS('menuFile', '');
   mOpen.Caption := pdeLoadNLS('popupmenuOpen', '');
   mOpenWith.Caption := pdeLoadNLS('popupmenuOpenWith', ' c');
   mNewFind.Caption := pdeLoadNLS('pFinder1', ' ')+'\tCtrl+F';
   mCopy.Caption := pdeLoadNLS('menuCopy', 'p...\tCtrl+C');
   mMove.Caption := pdeLoadNLS('menuMove', 'p...\tCtrl+X');
   mDelete.Caption := pdeLoadNLS('menuDelete', '...\tF8');
   mRename.Caption := pdeLoadNLS('menuRename', '२\tF2');
   mExit.Caption := pdeLoadNLS('eD2Str6', '~室\tAlt+X');
 mResults.Caption := pdeLoadNLS('pFinder2', '');
   mRefresh.Caption := pdeLoadNLS('menuRefresh', '\tF5');
   mSave.Caption := pdeLoadNLS('eD2Str4', '࠭') + '\tF12';
//   mPrint.Caption :', ' pdeLoadNLS('');
 mSettings.Caption := pdeLoadNLS('dlgShortcutParams', 'ࠬ');
   mShowHidden.Caption := pdeLoadNLS('menuShowHidden', ' 䠩\tCtrl+H');
   mShowFolders.Caption := pdeLoadNLS('pFinder3', '');
   mItemSize.Caption := pdeLoadNLS('pFinder28', ' 窮');
 mHelp.Caption := pdeLoadNLS('menuHelp', 'ࠢ');
   mShowHelp.Caption := pdeLoadNLS('menuShowHelp', '맮 ࠢ');
   mAbout.Caption := pdeLoadNLS('menuAbout', '(][)  ଠ  த');
 mCatalog.Caption := pdeLoadNLS('pFinder13', '⠫');
   mDirPanel.Caption := pdeLoadNLS('pFinder14', '/');
   mDirSaveNow.Caption := pdeLoadNLS('pFinder15', '࠭ ᥩ');
   mDirExport.Caption := pdeLoadNLS('pFinder16', 'ᯮ஢...');
   mDirLoadOnStart.Caption := pdeLoadNLS('pFinder17', '㦠  ᪥');
   mDirAddSection.Caption := pdeLoadNLS('pFinder18', ' ࠧ');
   mDirAddSubSection.Caption := pdeLoadNLS('pFinder19', ' ࠧ');
   mDirDelSection.Caption := pdeLoadNLS('pFinder20', ' ') + '\tCtrl+D';
   mDirAdd.Caption := pdeLoadNLS('pFinder21', '  ')+'\tCtrl+A';
   mDirAddAll.Caption := pdeLoadNLS('pFinder22', '  ')+'\tCtrl+L';
   mDirRename.Caption := pdeLoadNLS('pFinder23', ' ')+'\tCtrl+T';
   mDirProperties.Caption := pdeLoadNLS('menuProperties', '⢠\tCtrl+S');
 lDirCaption.Caption := pdeLoadNLS('pFinder24', '஭ ⠫');
 mIOpen.Caption := pdeLoadNLS('popupmenuOpen', '');
 mIAddSection.Caption := pdeLoadNLS('pFinder18', ' ࠧ');
 mIAddSubSection.Caption := pdeLoadNLS('pFinder19', ' ࠧ');
 mIDelete.Caption := pdeLoadNLS('pFinder20', ' ');
 mIFindOriginal.Caption := pdeLoadNLS('pFinder25', ' ਣ');
 mIProperties.Caption := pdeLoadNLS('popupmenuProperies', '⢠');
 xbAddSection.Hint := pdeLoadNLS('pFinder18', ' ࠧ');
 xbAddSubSection.Hint := pdeLoadNLS('pFinder19', ' ࠧ');
 xbDelSection.Hint := pdeLoadNLS('pFinder20', ' ');
 xbAdd.Hint := pdeLoadNLS('pFinder21', '  ');
 xbAddAll.Hint := pdeLoadNLS('pFinder22', '  ');
 xbRename.Hint := pdeLoadNLS('pFinder23', ' ');
 xbProperties.Hint := pdeLoadNLS('popupmenuProperies', '⢠');

 Find.Caption := pdeLoadNLS('eD2Str27', '');
 Stop.Caption := pdeLoadNLS('pFinder4', '⮯');
 lName.Caption := pdeLoadNLS('dlgShortcutName', '')+':';
 gbOptions.Caption := pdeLoadNLS('pFinder5', '᪠ :');
 rbPath.Caption := pdeLoadNLS('dlgPath', '');
 rbDrives.Caption := pdeLoadNLS('menuGotoDrives', '᪨');
 chSubDirs.Caption := pdeLoadNLS('pFinder12', '⠫');
 ResultsBox.HeaderColumns.Items[0].Text := pdeLoadNLS('dlgShortcutName', '')+':';
 ResultsBox.HeaderColumns.Items[1].Text := pdeLoadNLS('dlgPropertiesSize', ':');
 ResultsBox.HeaderColumns.Items[2].Text := pdeLoadNLS('dlgPath', '')+':';
//  MessageBox('NLS passed!', mtInformation, [mbOK]);
//--load config file---
  if FileExists(extractfilepath(application.exename)+'pFinder.cfg') then
  begin
  try
    AssignFile(cfgfile, extractfilepath(application.exename)+'pFinder.cfg');
    Reset(cfgfile);

    Readln(cfgfile);
    Readln(cfgfile, tmp);
    FinderForm.Top := StrToInt(tmp);
    Readln(cfgfile, tmp);
    FinderForm.Left := StrToInt(tmp);
    Readln(cfgfile, tmp);
    FinderForm.Width := StrToInt(tmp);
    Readln(cfgfile, tmp);
    FinderForm.Height := StrToInt(tmp);
    Readln(cfgfile, tmp);
    mShowHidden.Checked := (tmp = 'TRUE');
    Readln(cfgfile, tmp);
    mShowFolders.Checked := (tmp = 'TRUE');
    Readln(cfgfile, tmp);
    mDirLoadOnStart.Checked := (tmp = 'TRUE');
    Readln(cfgfile, tbSize);
    Readln(cfgfile, tmpi);
    ResultsBox.Color := TColor(tmpi);
    Readln(cfgfile, tmpi);
    oDirList.Color := TColor(tmpi);
    Readln(cfgfile, oItemSize);
    except

    end;
    CloseFile(cfgfile);
  end;
//  MessageBox('Create passed!', mtInformation, [mbOK]);
End;

{==========================================}

function TFinderForm.AnyDriveSelect: Boolean;
var
  i: Integer;
Begin
  Result := False;
  if lbDrives.Items.Count > 0 then
    for i:= 0 to lbDrives.Items.Count - 1 do
      Result := Result or (lbDrives.State[i] = clsChecked);
End;

{==========================================}

function GetAssocNumber(ext: String): String;
var
  i: Integer;
Begin

if assocCount>0 then
  for i := 1 to assocCount do
    begin
    if assoc[i].flt = LowerCase(ext) then
      begin
      Result := IntToStr(i - 1);
      if length(Result) < 3 then Result := '0'+Result;
      if length(Result) < 3 then Result := '0'+Result;
      Result := '_'+Result;
      exit;
      end;
    end;

Result := '_004';

End;

{==========================================}

function ListDirectory(path: String): Integer; // [path]\
var
  sr: TSearchRec;
  attr, rez: Integer;
Begin


if NeedStop then exit;

FinderForm.sbStatus.SimpleText := pdeLoadNLS('pFinder6', ' ')+': '+ExtractFilePath(path);
FinderForm.sbStatus.Invalidate;
Application.ProcessMessages;

attr := faReadOnly Or faSysFile Or faArchive or faDirectory;
  if FinderForm.mShowHidden.Checked then attr := attr or faHidden;
  //if FinderForm.mShowFolders.Checked then attr := attr or faDirectory;

  rez := FindFirst(path, attr, sr);
  if rez = 0 then
  if (sr.attr and faDirectory)=0 then //file
      begin
      FinderForm.ResultsBox.Items.Add(GetAssocNumber(ExtractFileExt(sr.name))
        + sr.name+ chr(9)+ IntToStr(sr.size) + chr(9)+ ExtractFilePath(path));
      end;

  while rez=0 do
    begin
    Application.ProcessMessages;
    if NeedStop then begin FindClose(sr); exit; end;
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then //file
      begin
      FinderForm.ResultsBox.Items.Add(GetAssocNumber(ExtractFileExt(sr.name))
        + sr.name+ chr(9)+ IntToStr(sr.size) + chr(9)+ ExtractFilePath(path));
      end;

    end;

FindClose(sr);

//------//

attr := faReadOnly Or faSysFile Or faArchive or faDirectory;
  if FinderForm.mShowHidden.Checked then attr := attr or faHidden;
  //if FinderForm.mShowFolders.Checked then attr := attr or faDirectory;

  rez := FindFirst(ExtractFilePath(path)+'*', attr, sr);
  if rez = 0 then
  if (sr.attr and faDirectory)=0 then //file
      begin
      ;
      end
      else
      begin
      if (sr.name <> '..') and (sr.name <> '.') then
        begin
        if FinderForm.mShowFolders.Checked then
          FinderForm.ResultsBox.Items.Add('_000' + sr.name + chr(9)+ IntToStr(sr.size) + chr(9)+ ExtractFilePath(path));

        if (FinderForm.chSubdirs.Checked) or (FinderForm.rbDrives.Checked) then //search subdirectories
          ListDirectory(ExtractFilePath(path) + sr.name + '\' + ExtractFileName(path));
        end;
      end;

  while rez=0 do
    begin
    if NeedStop then begin FindClose(sr); exit; end;
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then //file
      begin
      ;
      end
      else
      begin
      Application.ProcessMessages;
      if (sr.name <> '..') and (sr.name <> '.') then
        begin
        if FinderForm.mShowFolders.Checked then
          FinderForm.ResultsBox.Items.Add('_000' + sr.name + chr(9)+ IntToStr(sr.size) + chr(9)+ ExtractFilePath(path));

        if (FinderForm.chSubdirs.Checked) or (FinderForm.rbDrives.Checked) then //search subdirectories
          ListDirectory(ExtractFilePath(path) + sr.name + '\' + ExtractFileName(path));
        end;
      end;

    end;

FindClose(sr);

Result := 0;

End;

{==========================================}

function TFinderForm.DoSearch: Integer; //,   ࠧ 祬  ⮪
var
  i: Integer;
begin

  if rbPath.Checked then //path find
    begin
      ListDirectory(ConcatFileName(edPath.Text, edFilename.Text));
    end
  else //drives find
    begin
      for i := 0 to lbDrives.Items.Count - 1 do
      begin
      if NeedStop then break;
      if (lbDrives.State[i] = clsChecked) then
        ListDirectory(lbDrives.Items[i][1]+':\'+edFilename.Text);
      end;
    end;


  Stop.Enabled := False;
  Find.Enabled := True;
  Find.Default := True;

  sbStatus.SimpleText := pdeLoadNLS('pFinder7', ':')+' '+IntToStr(ResultsBox.Items.Count);

end;

Procedure TSThread.Execute;
var
  sr: TSearchRec;
  attr: Integer;
  fname, fsize, sname, curpath: String;
  list: TStringList;
Begin

  if FinderForm.rbPath.Checked then //path find
    begin
    if FinderForm.chSubdirs.Checked then //search subdirectories
      begin

      end
      else
      begin

      end;
    end
  else //drives find
    begin

    end;

  FinderForm.Stop.Enabled := False;
  FinderForm.Find.Enabled := True;
  FinderForm.Find.Default := True;

End;

{==========================================}

Procedure TFinderForm.StopOnClick (Sender: TObject);
Begin
  Stop.Enabled := False;
  Find.Enabled := True;
  Find.Default := True;

  //if fnd <> nil then
  //  fnd.NeedTerminate := True;
  NeedStop := True;

End;

{==========================================}

Procedure TFinderForm.bFindOnClick (Sender: TObject);
Begin

if edFilename.Text = '' then
  begin
  pdeMessageBoxOK(pdeLoadNLS('pFinder8', '室   䠩.')
    , pdeLoadNLS('pFinder10', ' ⥫!')
    , FinderForm.Icon.Handle);
  FinderForm.ActiveControl := edFilename;
  Exit;
  end;

if rbPath.Checked then
  if edPath.Text = '' then
    begin
    pdeMessageBoxOK(pdeLoadNLS('pFinder9', '室   ᪠.')
      , pdeLoadNLS('pFinder10', ' ⥫!'), FinderForm.Icon.Handle);
    FinderForm.ActiveControl := edFilename;
    Exit;
    end;

if rbDrives.Checked then
  if not AnyDriveSelect then
    begin
    pdeMessageBoxOK(pdeLoadNLS('pFinder11', '室  ()  ᪠.')
      , pdeLoadNLS('pFinder10', ' ⥫!'), FinderForm.Icon.Handle);
    FinderForm.ActiveControl := edFilename;
    Exit;
    end;

NeedStop := False;
Stop.Enabled := True;
Find.Enabled := False;
Stop.Default := True;
ResultsBox.Items.Clear;


sbStatus.SimpleText := pdeLoadNLS('pFinder6', ' ')+' ...';
DoSearch;

End;

{==========================================}

Procedure TFinderForm.rbPathOnClick (Sender: TObject);
Begin
  edPath.Enabled := True;
  chSubDirs.Enabled := True;
  lbDrives.Enabled := False;
End;

{==========================================}

Procedure TFinderForm.rbDrivesOnClick (Sender: TObject);
Begin
  lbDrives.Enabled := True;
  edPath.Enabled := False;
  chSubDirs.Enabled := False;
End;

{==========================================}

Procedure TFinderForm.FinderFormOnShow (Sender: TObject);
var
  afile: TextFile;
  tbmp: TPicture;
  i, col: Integer;
  openwithitem: TMenuItem;
  fbase, fbmp, fupbmp, tmp, itext, ihint: String;
Begin

  ClientHeight := 275 + 18 + 40;
  lbDrives.Clear;
  lbDrives.Items := cbDrives.Items;

//--PDE home directory from config.sys--
  pdebase := getenv('PDE_HOME');
  if pdebase = '' then
    pdebase := 'c:\pde';

//--tool buttons--
tbmp := TPicture.Create(Self);

fbase := pdebase+'\Bitmaps\'+Theme+'\FileHalf\';
col :=pdeLoadThemeIntD(Theme, 'ToolbarSize', 36);
tbmp.Bitmap.Width := col;
tbmp.Bitmap.Height := col;
btnPanel2.Size := col+4;
FinderForm.Color := pdeLoadThemeColor(Theme, 'ToolbarColor');
SetButtonsTextNPos(col);

//--refresh--
fbmp := 'refresh.bmp';
fupbmp := 'refresh2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bRefresh.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bRefresh.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bRefresh.Hint:=pdeLoadNLS('RefreshButton', '');
//--copy--
fbmp := 'copy.bmp';
fupbmp := 'copy2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bCopy.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bCopy.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bCopy.Hint:=pdeLoadNLS('CopyButton', '஢...');
//--move--
fbmp := 'move.bmp';
fupbmp := 'move2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bMove.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bMove.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bMove.Hint:=pdeLoadNLS('MoveButton', '६...');
//--delete--
fbmp := 'delete.bmp';
fupbmp := 'delete2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bDelete.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bDelete.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bDelete.Hint:=pdeLoadNLS('DeleteButton', '...');
//--rename--
fbmp := 'rename.bmp';
fupbmp := 'rename2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bRename.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bRename.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bRename.Hint:=pdeLoadNLS('RenameButton', '२...');
//--new search--
fbmp := 'find.bmp';
fupbmp := 'find2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bNewFind.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bNewFind.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bNewFind.Hint:=pdeLoadNLS('FindButton', '');

//--loading associations--
if FileExists(pdebase + '\PDEConf\Associations.cfg') then
begin
assignfile(afile, pdebase + '\PDEConf\Associations.cfg');
reset(afile);
readln(afile); //header
readln(afile); //header
assocCount := 0;
while not(eof(afile)) do
  begin
  inc(assocCount);
  readln(afile, assoc[assocCount].flt);
  readln(afile, assoc[assocCount].pgm);
  readln(afile, assoc[assocCount].bmp);
  readln(afile);
  end;
closefile(afile);
end;

if assocCount>0 then
  for i := 1 to assocCount do
    begin
    if FileExists(pdebase + '\Bitmaps\'+ITheme+'\FileTypes\'+assoc[i].bmp) then
      tbmp.LoadFromFile(pdebase + '\Bitmaps\'+ITheme+'\FileTypes\'+assoc[i].bmp);
    ImageList.AddIcon(tbmp.icon);
    end;
tbmp.free;

  i := pdeLoadThemeIntD(Theme, 'FilelistIconSize', 32);
  if oItemSize <> 0 then
    begin
    ResultsBox.ItemHeight := oItemSize;
    oDirItemSize(oItemSize);
    end
  else if i <> 0 then
    begin
    ResultsBox.ItemHeight := i div 2;
    oDirItemSize(i div 2);
    end
    else
    begin
    ResultsBox.ItemHeight := 18;
    oDirItemSize(18);
    end;

//㧪 ᯨ᪠ Open With
mOpenWith.submenu:=true;
if FileExists(pdebase +'\PDEConf\openwith.cfg') then
begin
  assignfile(afile, pdebase+'\PDEConf\openwith.cfg');
  reset(afile);
  while not(eof(afile)) do
    begin
    openwithitem := TMenuItem.Create(self);
    readln(afile, itext);
    readln(afile, ihint);
    openwithitem.Caption:=itext;
    openwithitem.hint:=ihint;
    openwithitem.onclick := OpenWithMenuClick;
    mOpenWith.add(openwithitem);
    end;
  closefile(afile);
end;

//--check, if we have command line options---
if ParamStr(1)<>'' then
  begin
  tmp:='';
  for i:=1 to paramcount do
    tmp:=tmp+ParamStr(i)+' ';
  Delete(tmp, length(tmp), 1);
  edPath.Text := tmp;
  if tmp[1] = '"' then
    begin
    Delete(tmp, length(tmp), 1);
    Delete(tmp, 1, 1);
    end;
  end;
//-----

  if mDirLoadOnStart.Checked then
    begin
    mDirPanelOnClick(Sender);
    if tbSize <> 0 then
      tbDirectory.Size := tbSize;
    FinderForm.ActiveControl := oDirList;
    end
    else
    FinderForm.ActiveControl := edFilename;

End;

{==========================================}

Procedure TFinderForm.FinderFormOnResize (Sender: TObject);
Begin

  LName.Left := 20;
  LName.Top := 20;
  edFilename.Left := 110;
  edFilename.Top := 19;
  edFilename.Width := FinderForm.ClientWidth - 235;
  gbOptions.Left := 10;
  gbOptions.Top := 47;
  gbOptions.Width := FinderForm.ClientWidth - 135;
  edPath.Width := FinderForm.ClientWidth - 280;
  lbDrives.Width := FinderForm.ClientWidth - 250;
  Find.Right := 8;
  Find.Top := 17;
  Stop.Right := 8;
  Stop.Top := 52;
  imgLogo.Right := 8;
  imgLogo.Top := 152;

End;

{==========================================}

Procedure TFinderForm.bPrintOnClick (Sender: TObject);
Begin

  {ᯥ १}
  //ResultsBox.Items.Add('_000Hallo'+chr(9)+'Warped'+chr(9)+'World!!!');

End;

{==========================================}

Procedure TFinderForm.OpenWithMenuClick (Sender: TObject);
var
  tmp, ftype, fname: String;
Begin

  {⨥/ c}
  if FinderForm.ActiveControl = oDirList then
    begin
    if oDirList.SelectedItem = -1 then exit;
    ShellExecute(TMenuItem(Sender).Hint
      , ExtractFilePath(TMenuItem(Sender).Hint)
      , oDirList.SelectedNode.PathName, false);
    end
  else
  begin
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  tmp := ResultsBox.Items[ResultsBox.ItemIndex];
  ftype := Copy(tmp, 1, 4);
  delete(ftype, 1, 1);
  delete(tmp, 1, 4);
  fname := Copy(tmp, 1, pos(chr(9), tmp)-1);
  delete(tmp, 1, pos(chr(9), tmp));
  delete(tmp, 1, pos(chr(9), tmp));

  ShellExecute(TMenuItem(Sender).Hint
    , ExtractFilePath(TMenuItem(Sender).Hint), tmp + fname, false);
  end;

End;

{==========================================}

//-----------------------------------------
// ணࠬ
{function TFinderForm.ShellExecute(fname, fdir, fparam: string; shortcut: Boolean): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2, fdir2: pchar;
  rc, rc2: APIRET;
begin
if (not shortcut) and (fparam <> '') then
  fparam := '"'+fparam+'"';
new(fname2);
new(fparam2);
new(fdir2);
StrPCopy(fname2, fname);
StrPCopy(fparam2, fparam);
StrPCopy(fdir2, fdir);
with sd do
  begin
      Length   := sizeof(StartData);
      Related  := ssf_Related_Independent; // start an independent session
      FgBg     := ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := ssf_InhertOpt_Parent;
      SessionType := ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"
rc:=DosSetCurrentDir(fdir);
rc2:=DosStartSession(sd, idSession, apid);

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));
freemem(fdir2, sizeof(fdir2));

if (rc2 <> 0) and (rc2 <> 457) then //ERROR!!!
  if pdeloadcfgint('general.cfg', 'execerrors') = 1 then
  pdeMessageBoxOK(pdeLoadNLS('dlgRunErrorProgram', 'ணࠬ:')+' '+fname+chr(13)+
    chr(10)+pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc2)
  , pdeLoadNLS('dlgRunErrorCaption', '訡 ᪠'), FinderForm.Icon.Handle);

result:=true;
end;}
//--ShellExecute----------------------------

Procedure TFinderForm.mExitOnClick (Sender: TObject);
Begin

  {室  ணࠬ}
  Application.Terminate;

End;

{==========================================}

Procedure TFinderForm.ResultsBoxOnDblClick (Sender: TObject);
Begin

  { 饫祪 - ⨥}
  bOpenOnClick (Sender);

End;

{==========================================}

Procedure TFinderForm.bOpenOnClick (Sender: TObject);
var
  ext, txt, tmp, ftype, fname: String;
Begin

  {⨥   ணࠬ}
  if FinderForm.ActiveControl = oDirList then
    begin
    if oDirList.SelectedItem = -1 then exit;
    oDirListOnItemSelect (Sender, oDirList.SelectedItem);
    end
  else
  begin
  if ResultsBox.Items.Count = 0 then exit;
  if ResultsBox.ItemIndex = - 1 then exit;

  tmp := ResultsBox.Items[ResultsBox.ItemIndex];
  ftype := Copy(tmp, 1, 4);
  delete(ftype, 1, 1);
  delete(tmp, 1, 4);
  fname := Copy(tmp, 1, pos(chr(9), tmp)-1);
  delete(tmp, 1, pos(chr(9), tmp));
  delete(tmp, 1, pos(chr(9), tmp));
  ext := LowerCase(ExtractFileExt(fname));

  if ftype = '000' then // ha-ha, directory :-)
    ShellExecute(pdebase+'\FileHalf.exe', pdebase+'\', tmp + fname + '\', false)
    else if (ext = '.exe') or (ext='.com') or (ext='.cmd') or (ext='.bat') then
    ShellExecute(tmp + fname, ExtractFilePath(tmp + fname), '', false)
    else if ftype = '004' then // unknown
      begin
      txt := pdeLoadCfgStr('filehalf.cfg', 'TextUtil');
      if txt[2] <> ':' then txt := pdebase+'\'+txt;
      ShellExecute(txt, ExtractFilePath(txt), tmp + fname, false);
      end
    else
    ShellExecute(assoc[StrToInt(ftype)+1].pgm
      , ExtractFilePath(assoc[StrToInt(ftype)+1].pgm), tmp + fname, false);
  end;

End;

{==========================================}

Procedure TFinderForm.mAboutOnClick (Sender: TObject);
var
  about, authors, thanks: String;
  cptn, text, licensefile: String;
  logo: LongInt;
  afile: TextFile;
Begin

  {ଠ  த}
  about := GetEnv('TEMP')+'\~pfinder1.tmp';
  AssignFile(afile, about);
  Rewrite(afile);
  Writeln(afile, pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.20');
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  Writeln(afile, pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pFinderInfo1', 'DE ᪠'));
  Writeln(afile, pdeLoadNLS('pFinderInfo2', '⨫  ᪠ 䠩  .'));
  CloseFile(afile);

  authors := pdebase+'\AUTHORS';
  {:= GetEnv('TEMP')+'\~pfinder2.tmp';
  AssignFile(afile, authors);
  Rewrite(afile);
  Writeln(afile, 'Vladymyr Sergeyev, stVova');
  Writeln(afile, 'Sergey Sergeyev, SERG');
  Writeln(afile, 'e-mail: stVova@ukrpost.com.ua or stVova@ukr.net');
  Writeln(afile, 'web: http://os2progg.by.ru');
  CloseFile(afile);}

  thanks := pdebase+'\THANKS';
  {:= GetEnv('TEMP')+'\~pfinder3.tmp';
  AssignFile(afile, thanks);
  Rewrite(afile);
  Writeln(afile, 'Ludmyla Sergeyeva');
  Writeln(afile, '');
  Writeln(afile, 'Sergey Posokhov');
  Writeln(afile, 'Andy Key (Generalized Bitmap Module)');
  Writeln(afile, 'Independent JPEG group (JPEG support)');
  Writeln(afile, 'Salvador Parra Camacho');
  Writeln(afile, 'KDE Team for graphics and icons (www.kde.org)');
  Writeln(afile, 'GNOME Team for graphics and icons (www.gnome.org)');
  Writeln(afile, 'Aaron Lawrence (ACL Library)');
  Writeln(afile, 'Adam Ritchie');
  Writeln(afile, '');
  Writeln(afile, 'And all friends from native sity Lutsk (Ukraine, Volyn Region)');
  CloseFile(afile);}

  cptn := pdeLoadNLS('dlgAboutProgram', 'ଠ  த');
  text := pdeLoadNLS('pFinderInfo1', 'DE ᪠');
  licensefile := pdebase+'\copying';
  logo := FinderForm.Icon.Handle;
  pdeAboutDialogS(about, authors, thanks, cptn, text, licensefile, logo);
  //pdeAboutDialog(about, authors, thanks, cptn, text, licensefile, logo);

End;

{==========================================}

Procedure TFinderForm.mSaveOnClick (Sender: TObject);
var
  savename, ext: String;
  i: Integer;
  afile: TextFile;
  tmp, tmp2, tmp3: String;
Begin

  if FinderForm.ActiveControl = oDirList then
    begin
    mDirSaveNowOnClick (Sender);
    end
  else
  begin
  {࠭ ᯨ᮪   䠩}
if ResultsBox.Items.Count =0 then exit;

savename := pdeOpenFileDialog(pdeLoadNLS('eD2Str32','࠭ 䠩')
  , pdebase+pdeLoadCfgStr('general.cfg', 'userhome')+'\',
  pdeLoadNLS('eD2Str33', '⮢ 䠩')+' (*.txt)|'
  +'HTML (*.htm;*.html)|'+'WarpAmp playlist (*.mpl)|'
  +pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|');
if savename <> '' then
    Begin
    try
    ext := UpperCase(ExtractFileExt(savename));
    AssignFile(afile, savename);
    Rewrite(afile);
    if (ext = '.HTM') or (ext = '.HTML') then  //hypertext
      Begin
      Writeln(afile, '<HTML><HEAD><TITLE>');
      if rbPath.Checked then
        Writeln(afile, 'Search results for ['+edFileName.Text+'] in ['
          +edPath.Text+']. Date/time: '+DateTimeToStr(Now))
        else
        Writeln(afile, 'Search results for ['+edFileName.Text+']. Date/time: '
          +DateTimeToStr(Now));
      Writeln(afile, '</TITLE></HEAD><BODY><TABLE border="1" width="100%">');
      Writeln(afile, '<TR><TH>Filename</TH><TH>Path'
        +'</TH><TH>Size in bytes</TH></TR>');
      for i:= 0 to ResultsBox.Items.Count - 1 do
        begin
        tmp := ResultsBox.Items[i];
        Delete(tmp, 1, 4);
        tmp2 := Copy(tmp, 1, pos(chr(9), tmp)-1);  //name
        Delete(tmp, 1, pos(chr(9), tmp));
        tmp3 := Copy(tmp, 1, pos(chr(9), tmp)-1);  //size
        Delete(tmp, 1, pos(chr(9), tmp));  //path
        Writeln(afile, '<TR><TD>'+tmp2+'</TD><TD>'+tmp+'</TD><TD>'+tmp3
          +'</TD></TR>');
        end;
      Writeln(afile, '</TABLE></BODY></HTML>');
      End
      else if (ext = '.MPL') then  //WarpAmp playlist
      Begin
      Writeln(afile, '[playlist]');
      for i:= 0 to ResultsBox.Items.Count - 1 do
        begin
        tmp := ResultsBox.Items[i];
        Delete(tmp, 1, 4);
        tmp2 := Copy(tmp, 1, pos(chr(9), tmp)-1);  //name
        Delete(tmp, 1, pos(chr(9), tmp));
        tmp3 := Copy(tmp, 1, pos(chr(9), tmp)-1);  //size
        Delete(tmp, 1, pos(chr(9), tmp));  //path
        Writeln(afile, 'File'+IntToStr(i+1)+'='+tmp+tmp2);
        end;
      Writeln(afile, 'NumberOfEntries='+IntToStr(i));
      End
      else //  TXT
      Begin
      Writeln(afile, 'Search results for ['+edFileName.Text
        +']. Date/time: '+DateTimeToStr(Now));
      for i:= 0 to ResultsBox.Items.Count - 1 do
        begin
        tmp := ResultsBox.Items[i];
        Delete(tmp, 1, 4);
        //Insert(chr(9), tmp, pos(chr(9), tmp));
        Writeln(afile, tmp);
        end;
      End;
    CloseFile(afile);
    except
        pdeMessageBoxOK(pdeLoadNLS('eDstr36', ' 㤠 ࠭ 䠩')
          , pdeLoadNLS('dlgError','訡'), FinderForm.Icon.Handle);
      end;
    End;

  End;

End;

{==========================================}

Procedure TFinderForm.bRefreshOnClick (Sender: TObject);
Begin

  { १ - २᪠}
  bFindOnClick(Sender);

End;

{==========================================}

Procedure TFinderForm.bNewFindOnClick (Sender: TObject);
Begin

  { }
  ResultsBox.Items.Clear;
  edFilename.Text := '*.*';
  //edPath.Text := '';
  //chSubDirs.Checked := False;
  rbPath.OnClick(Sender);
  rbPath.Checked := True;
  FinderForm.ActiveControl := edFilename;

End;

{==========================================}

Procedure TFinderForm.mShowFoldersOnClick (Sender: TObject);
Begin
  mShowFolders.Checked := not (mShowFolders.Checked);
End;

Procedure TFinderForm.mShowHiddenOnClick (Sender: TObject);
Begin
  mShowHidden.Checked := not (mShowHidden.Checked);
End;

{==========================================}

function TFinderForm.ObjMove(source, dest: cstring): integer;
var
  rc: apiret;
  fsrc, fdest: CString;
  option: ULong;
Begin

option := 0;
if pdeLoadCfgInt('general.cfg', 'overwritefiles') = 1 then
    option := DCPY_Existing;
fsrc:=source;
fdest:=dest;
rc:=DosCopy(fsrc, fdest, option);
if rc<>0 then
  begin
  pdeMessageBoxOK(pdeLoadNLS('dlgErrorDeleteCanceled', ' ⬥.')
  , pdeLoadNLS('dlgErrorOnCopy', '訡  ஢'), FinderForm.Icon.Handle);
  exit;
  end;

  ObjDel(source);

End;

function TFinderForm.ObjDel(source: string): integer;
var
  rc: boolean;
  rez: integer;
  rc2, rc3: APIRET;
  sr2: TSearchRec;
  cdir: string;
  curdir: cstring;
Begin

if (FindFirst(source+'\*.*', faAnyFile, sr2)=0) then  // 䠩    㣨 䠩 :-)
  begin  //directory
  rez:=0;
  while rez=0 do
    begin
    rez:=FindNext(sr2);
    if rez<>0 then break;
    if (sr2.name<>'..')and(sr2.name<>'.') then
      begin
      //if not(newForm.Visible) then
      //  exit;
      curdir:=source[1]+source[2]+source[3];
      DosSetCurrentDir(curdir);
      ObjDel(source+'\'+sr2.name);
      end;
    end;
  FindClose(sr2);
  FileSetAttr(source, 0);
  cdir:=source[1]+source[2]+source[3];
  curdir:=cdir;
  rc3:=DosSetCurrentDir(curdir);
  rc2:=DosDeleteDir(source);
  if rc2<>0 then
    pdeMessageBoxOK(pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc2)+
      chr(13)+chr(10)+source,
      pdeLoadNLS('dlgErrorOnFolderDelete', '訡  㤠 '), FinderForm.Icon.Handle);

  end
else
  begin  //file
  FindClose(sr2);
  FileSetAttr(source, 0);
  DosSleep(0);
  rc:=DeleteFile(source);
  if rc=false then
    pdeMessageBoxOK(source, pdeLoadNLS('dlgErrorOnFileDelete', '訡  㤠 䠩'), FinderForm.Icon.Handle);
  end;

End;

{==========================================}

Procedure TFinderForm.oDirItemSize(new: Integer);
Var
  acnrInfo: CNRINFO;
  Flags:    LongWord;
Begin

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;

  With acnrInfo Do
  Begin
    cb:=SizeOf(CNRINFO);
    flWindowAttr:=CV_TREE Or CV_ICON;
    flWindowAttr:=flWindowAttr Or CA_TREELINE;
    slTreeBitmapOrIcon.CX:=16;
    slTreeBitmapOrIcon.CY:=16;
    Flags:=Flags Or CMA_SLTREEBITMAPORICON;
    slBitmapOrIcon.CX:=new;
    slBitmapOrIcon.CY:=new;
    Flags:=Flags Or CMA_SLBITMAPORICON;
    flWindowAttr:=flWindowAttr Or CA_DRAWBITMAP;
  End;
  WinSendMsg(oDirList.Handle, CM_SETCNRINFO, LongWord(@acnrInfo), Flags);

End;

{==========================================}

Initialization
  RegisterClasses ([TFinderForm, TMainMenu, TMenuItem, TExplorerButton,
    TBevel, TStatusBar, TMultiColumnListBox, TImageList, TGroupBox, TLabel,
    TEdit, TButton, TRadioButton, TCheckListBox, TCheckBox,
    TImage, TToolbar, TOutline, TPopupMenu, TDriveComboBox]);
End.
