// Advanced Controls library (C) Dmitry Zaharov, 2001

#ifndef __ACTL_H__  // mutex protection
  #define __ACTL_H__
  #pragma pack(1)

  #ifndef DP_MINI
     #define DP_MINI 4
  #endif

  #define FRAMETYPE_AUTOSIZE    0x0001
  #define FRAMETYPE_HIDEBUTTON  0x0002

  #define BORDERTYPE_INVISIBLE  0
  #define BORDERTYPE_SUNKEN     1
  #define BORDERTYPE_NORMAL     2
  #define BORDERTYPE_BLACK      3
  #define BORDERTYPE_SUPER      4
  #define BORDERTYPE_ENTRY      5

  typedef BOOL (EXPENTRY FNWPX)(HWND, ULONG, MPARAM, MPARAM, MRESULT*);
  typedef FNWPX *PFNWPX;

  typedef struct _FRAMEPACK
  {
     short      frameType;
     short      borderType;
     int        size;

     PSZ        windowClass, windowText;

     int        windowStyle, windowID;
     PVOID      windowData;

     int        leftMargin, topMargin, rightMargin, bottomMargin;

     //PFNWPX     frameWindowProc;

  } FRAMEPACK, *PFRAMEPACK;

  typedef struct _FRAMEDATA
  {
    FRAMEPACK   fp;
    HWND        hwnd;
  } FRAMEDATA, *PFRAMEDATA;

  #define SPLITTYPE_VERTICAL    0x0001          // Horizontal if bit unset
  #define SPLITTYPE_SIZEABLE    0x0002          // Fixed if bit unset
  #define SPLITTYPE_HIDEABLE    0x0004          // One can be hidden if set
  #define SPLITTYPE_SPACEBAR    0x0008          // Spacebar invisible if unset

  typedef struct _SPLITPACK
  {
     short      splitType;
     long       bgColor;

     FRAMEPACK  leftTop, rightBottom; // left/top and right/bottom frames
     PFNWPX     splitWindowProc;

  } SPLITPACK, *PSPLITPACK;

  typedef struct _SPLITDATA
  {
     PSPLITPACK splitPack;
     FRAMEDATA  leftTop, rightBottom;
     HWND       hwnd;
  } SPLITDATA, *PSPLITDATA;


  #define WC_SPLITFRAME         "SplitFrameClass"

  #define ITEMTYPE_TEXT         1
  #define ITEMTYPE_ICON         2
  #define ITEMTYPE_MINIICON     3
  #define ITEMTYPE_BITMAP       4
  #define ITEMTYPE_OBJECT       5 // text and mini-icon combined

  #define ITEMTYPE_MASK         15

  #define ITEMALIGN_LEFT        1 // text only
  #define ITEMALIGN_CENTER      2 // //...//
  #define ITEMALIGN_RIGHT       3 // //...//
  #define ITEMALIGN_STRETCH     4 // bitmap only!

  #define ITEMFLAGS_NOTSELECT   0x0001
  #define ITEMFLAGS_DISABLED    0x0002
  #define ITEMFLAGS_FIXEDSIZE   0x0004

  typedef struct _ITEM
  {
     int        itemType, itemAlign, itemFlags;

     long       bgColor, fgColor;
     char       *text;

     ULONG      imageHandle,  // HPOINTER or HBITMAP
                itemHandle;   // Unique value to find.
  } ITEM, *PITEM;

  typedef struct _ITEMPACK
  {
     short      itemPackType;

     ITEM       item;

     RECTL      rcl;

     struct     _ITEMPACK *nextItem;
  } ITEMPACK, *PITEMPACK;

  #define COLUMNTYPE_FIXED      0x0001
  #define COLUMNTYPE_DEFAULT    0x0002

  typedef struct _COLUMN
  {
     short      columnType, columnWidth;

     short      items;
     ITEMPACK   columnItem;

     PITEMPACK  firstItem, tempItem;

     int        itemIndex;

     struct     _COLUMN *nextColumn;

  } COLUMN, *PCOLUMN;

  typedef struct _LISTBOXDATA
  {
     HWND       hwnd;
     BOOL       reformatHeaders;
     BOOL       reformatItems;
     BOOL       reformatScrollbars;
     BOOL       haveFocus, leftDown;

     short      columns;
     PCOLUMN    firstColumn;

     short      currentX, currentY;
     short      boxWidth, boxHeight;
     short      windowWidth, windowHeight;
     short      headerHeight, scrollbarWidth;

     int        currentRow;

  } LISTBOXDATA, *PLISTBOXDATA;

  #define ITEMMSG_BYXY          0
  #define ITEMMSG_BYHANDLE      1

  #define WID_HSCROLLBAR        101
  #define WID_VSCROLLBAR        102

  typedef struct _ITEMMSG
  {
     short      msgType;

     ULONG      itemHandle;
     short      itemX, itemY;
  } ITEMMSG, PITEMMSG;

  // advanced listbox messages

  #define ALM_INSERTITEM        12000
  #define ALM_REMOVEITEM        12001
  #define ALM_QUERYITEM         12002
  #define ALM_CHANGEITEM        12003

  #define ALM_INSERTCOLUMN      12004
  #define ALM_REMOVECOLUMN      12005
  #define ALM_QUERYCOLUMN       12006
  #define ALM_CHANGECOLUMN      12007

  #define ALM_QUERYITEMRECT     12008
  #define ALM_QUERYCOLUMNRECT   12009

  #define ALM_XYHANDLE          12010
  #define ALM_QUERYITEMCOUNT    12011

  #define ALM_QUERYSELECTION    12012

  #define WC_ALISTBOX           "AdvancedListboxClass"

  #define ALN_SELECT            21000
  #define ALN_CONTEXTMENU       21001
  #define ALN_OPEN              21002
  #define ALN_DRAG              21003

  // debug stuff

  #ifdef __ACTL_DEBUG__
     #define adprintf(n) printf(n)
  #else
     #define adprintf(n)
  #endif

  #define SWM_ADDWINDOW         13000
  #define SWM_REMOVEWINDOW      13001
  #define SWM_SWITCHWINDOW      13002

  #define WC_SPINWINDOW         "SpinWindowClass"

  typedef struct _SPINWINDOWDATA
  {
     long       bgColor;
     int        currentWindowID;

     PFNWPX     spinWindowProc;
  } SPINWINDOWDATA, *PSPINWINDOWDATA;

  typedef struct _SPINPACK
  {
     PSZ        windowClass, windowText;

     int        windowStyle, windowID;
     PVOID      windowData;

  } SPINPACK, *PSPINPACK;


#ifdef __cplusplus
extern "C" {
#endif

void EXPENTRY setItemTextColor(HWND hwnd, LONG lColor);

void EXPENTRY setItemBackColor(HWND hwnd, LONG lColor);

void EXPENTRY setItemFont(HWND hwnd, PSZ pszFont);

void EXPENTRY registerListbox (HAB hab);
void EXPENTRY registerSplitframe (HAB hab);
void EXPENTRY registerSpinWindow (HAB hab);

#ifdef __cplusplus
        }
#endif

#endif // __ACTL_H__
