MRESULT EXPENTRY spinWindowProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PSPINWINDOWDATA pswd;
   MRESULT mrc;

   if (msg == WM_CREATE)
   {
      pswd = (PSPINWINDOWDATA) malloc (sizeof (*pswd));

      if (pswd)
      {
         memset (pswd, 0, sizeof (*pswd));
         pswd->spinWindowProc = (PFNWPX)mp1;
         pswd->bgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0);
         WinSetWindowULong (hwnd, 0, (ULONG)pswd);
      }
   } else
   {
      HPS hps;
      RECTL rcl;
      SWP swp;

      pswd = (PSPINWINDOWDATA) WinQueryWindowULong (hwnd, 0);

      if (pswd->spinWindowProc &&
          pswd->spinWindowProc (hwnd, msg, mp1, mp2, &mrc))
         return mrc;

      switch (msg)
      {
         case SWM_REMOVEWINDOW:
         {
            int windowID = (int)mp1;

            WinQueryWindowPos (hwnd, &swp);

            if (WinWindowFromID (hwnd, windowID))
            {
               WinDestroyWindow (WinWindowFromID (hwnd, windowID));

               if (windowID == pswd->currentWindowID)
               {
                  HENUM henum = WinBeginEnumWindows (hwnd);

                  //WinShowWindow (WinGetNextWindow (henum), TRUE);
                  WinSetWindowPos (WinGetNextWindow (henum), 0, 0, 0, swp.cx, swp.cy,
                                   SWP_SIZE | SWP_SHOW);

                  WinEndEnumWindows (henum);

               }
            }

         return (MRESULT)0L;
         }

         case SWM_SWITCHWINDOW:
         {
            int windowID = (int)mp1;
            //HWND hwndSw = (HWND)mp1;
            if (windowID)
            {

               if (windowID != pswd->currentWindowID)
               {
                  WinShowWindow (WinWindowFromID (hwnd, pswd->currentWindowID), FALSE);
                  pswd->currentWindowID = windowID;
               }

               WinQueryWindowRect (hwnd, &rcl);
               WinSetWindowPos (WinWindowFromID (hwnd, windowID), HWND_TOP,
                                0, 0, rcl.xRight, rcl.yTop, SWP_SIZE | SWP_SHOW | SWP_ZORDER);

               //WinInvalidateRect (WinWindowFromID (hwnd, windowID), NULL, TRUE);
            }

         return (MRESULT)0L;
         }

         case SWM_ADDWINDOW:
         {
            HWND hwndAdd = NULLHANDLE;
            PSPINPACK psp = (PSPINPACK)mp1;
            RECTL rcl;

            WinQueryWindowRect (hwnd, &rcl);

            if (psp)
            {
               HWND hwndNext;
               HENUM henum = WinBeginEnumWindows (hwnd);

               for (hwndNext = WinGetNextWindow (henum);
                    hwndNext;
                    hwndNext = WinGetNextWindow (henum))
               {
                   if (psp->windowID <= WinQueryWindowUShort (hwndNext, QWS_ID))
                      psp->windowID = WinQueryWindowUShort (hwndNext, QWS_ID) + 1;
               } // get unique window id

               WinEndEnumWindows (henum);

               hwndAdd = WinCreateWindow (hwnd,
                                          psp->windowClass,
                                          psp->windowText,
                                          psp->windowStyle,
                                          0, 0, rcl.xRight, rcl.yTop,
                                          hwnd,
                                          HWND_TOP,
                                          psp->windowID,
                                          psp->windowData,
                                          NULL);
            }

         return (MRESULT)hwndAdd;
         }

         case WM_SIZE:
         if (pswd->currentWindowID &&
             WinWindowFromID (hwnd, pswd->currentWindowID))
         {
             WinSetWindowPos (WinWindowFromID (hwnd, pswd->currentWindowID),
                              HWND_TOP,
                              0, 0, SHORT1FROMMP (mp2), SHORT2FROMMP (mp2),
                              SWP_SIZE | SWP_ZORDER);
         }
         break;

         case WM_PAINT:

         hps = WinBeginPaint (hwnd, 0, &rcl);
         GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
         WinFillRect (hps, &rcl, pswd->bgColor);
         WinEndPaint (hps);
         break;

         case WM_DESTROY: // delete instance data
         free (pswd);
         break;
      }
   }

return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

void EXPENTRY registerSpinWindow (HAB hab)
{
   WinRegisterClass (hab, WC_SPINWINDOW, (PFNWP)spinWindowProc,
                     CS_SIZEREDRAW, sizeof (ULONG));
}

