/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

#include "systray.h" // our base header

ULONG   ulCbUnits[MAXUNITS];

extern  PWCLASS pWClasses;
extern  ULONG   ulClasses;

extern	HWND	hwnd_Object;

VOID	DefaultViewConfig(PVIEWCONFIG pvc, ULONG ulPage)
{
if(ulPage & 1)
  {
  pvc->page1.fBottom=TRUE;
  pvc->page1.fResizeDesktop=TRUE;
  pvc->page1.bOntopMethod=ONTOP_NONE;
  pvc->page1.bHideDelay=2;
  }

if(ulPage & 2)
  {
  pvc->page2.fFramedAll=FALSE;
  pvc->page2.fFramedUnits=FALSE;
  pvc->page2.bRowHeight=24; // depend to default icon height??? Not sure ;(
  pvc->page2.bBorderWidth=1;
  pvc->page2.bViewSpacing=1;
  pvc->page2.bUnitSpacing=2;
  pvc->page2.fHideSpacebars=FALSE;
  pvc->page2.fDisableHint=FALSE;
  pvc->page2.fFastHints=FALSE;
  pvc->page2.fDrawVertbars=TRUE;
  }

if(ulPage & 0x8000)
  {
  pvc->bRows=1;
  pvc->ulBackColor=WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONMIDDLE, 0L);
  pvc->fFirstRun=TRUE;
  }
}

VOID	LoadViewConfig(PVIEWCONFIG pvc, ULONG ulPage)
{
DefaultViewConfig(pvc, ulPage);

if(ulPage & 1)
  {
  DbgPrintf("Reading viewConfig, page #1\n");
  profile_loadint("fBottom", (int*)&pvc->page1.fBottom);
  profile_loadint("fResizeDesktop", (int*)&pvc->page1.fResizeDesktop);
  profile_loadbyte("bOntopMethod", &pvc->page1.bOntopMethod);
  profile_loadbyte("bHideDelay", &pvc->page1.bHideDelay);
  }

if(ulPage & 2)
  {
  DbgPrintf("Reading viewConfig, page #2\n");
  profile_loadint("fDisableHint", (int*)&pvc->page2.fDisableHint);
  profile_loadint("fFramedUnits", (int*)&pvc->page2.fFramedUnits);
  profile_loadbyte("bRowHeight", (int*)&pvc->page2.bRowHeight);
  profile_loadbyte("bBorderWidth", &pvc->page2.bBorderWidth);
  profile_loadbyte("bViewSpacing", &pvc->page2.bViewSpacing);
  profile_loadbyte("bUnitSpacing", &pvc->page2.bUnitSpacing);
  profile_loadint("fHideSpacebars", (int*)&pvc->page2.fHideSpacebars);
  profile_loadint("fFramedAll", (int*)&pvc->page2.fFramedAll);
  profile_loadint("fFastHints", (int*)&pvc->page2.fFastHints);
  profile_loadint("fDrawVertbars", (int*)&pvc->page2.fDrawVertbars);
  }

if(ulPage & 0x8000)
  {
  DbgPrintf("Reading viewConfig, unpaged\n");
  profile_loadbyte("bRows", &pvc->bRows);
  profile_loadint("ulBackColor", (int*)&pvc->ulBackColor);
  profile_loadint("fFirstRun", (int*)&pvc->fFirstRun);
  }
}

VOID	SaveViewConfig(PVIEWCONFIG pvc, ULONG ulPage)
{
if(ulPage & 1)
  {
  DbgPrintf("Writing viewConfig, page #1\n");
  profile_saveint("fBottom", (int*)&pvc->page1.fBottom);
  profile_saveint("fResizeDesktop", (int*)&pvc->page1.fResizeDesktop);
  profile_savebyte("bOntopMethod", &pvc->page1.bOntopMethod);
  profile_savebyte("bHideDelay", &pvc->page1.bHideDelay);
  }

if(ulPage & 2)
  {
  DbgPrintf("Writing viewConfig, page #2\n");
  profile_saveint("fDisableHint", (int*)&pvc->page2.fDisableHint);
  profile_saveint("fFramedUnits", (int*)&pvc->page2.fFramedUnits);
  profile_savebyte("bRowHeight", (int*)&pvc->page2.bRowHeight);
  profile_savebyte("bBorderWidth", &pvc->page2.bBorderWidth);
  profile_savebyte("bViewSpacing", &pvc->page2.bViewSpacing);
  profile_savebyte("bUnitSpacing", &pvc->page2.bUnitSpacing);
  profile_saveint("fHideSpacebars", (int*)&pvc->page2.fHideSpacebars);
  profile_saveint("fFramedAll", (int*)&pvc->page2.fFramedAll);
  profile_saveint("fFastHints", (int*)&pvc->page2.fFastHints);
  profile_saveint("fDrawVertbars", (int*)&pvc->page2.fDrawVertbars);
  }

if(ulPage & 0x8000)
  {
  DbgPrintf("Writing viewConfig, unpaged\n");
  profile_savebyte("bRows", &pvc->bRows);
  profile_saveint("ulBackColor", (int*)&pvc->ulBackColor);
  profile_saveint("fFirstRun", (int*)&pvc->fFirstRun);
  }
}


VOID    CnfSaveUnits(PVIEWDATA pViewData)
{
USHORT i;
ULONG ulTotal = 0L;
PVOID ptemp, ptmp2;

if(!pViewData->usUnits) return;

for(i=0; i<pViewData->usUnits; i++)
  {
  ulCbUnits[i] = pViewData->pUnits[i]->cbFix;
  ulTotal += ulCbUnits[i];
  }

DbgPrintf("Saving %d units (ulTotal=%d)\n", pViewData->usUnits, ulTotal);

profile_saveblob("aulong.cbunits", &ulCbUnits[0], sizeof(ULONG)*pViewData->usUnits);

ptemp = ptmp2 = malloc(ulTotal);

for(i=0; i<pViewData->usUnits; i++)
  {
  ULONG rc = (ULONG)WinSendMsg(pViewData->pUnits[i]->hwnd, USTM_SAVING, (MPARAM)0L, (MPARAM)0L);

  DbgPrintf("Saved unit %s (rc=%d, cbFix=%d)\n",
            pViewData->pUnits[i]->szClass, rc, pViewData->pUnits[i]->cbFix);

  memcpy(ptemp, pViewData->pUnits[i], pViewData->pUnits[i]->cbFix);
  ptemp = (PVOID)((ULONG)ptemp + pViewData->pUnits[i]->cbFix);
  }

profile_saveblob("blob.units", ptmp2, ulTotal);
free(ptmp2);
}

VOID    CnfLoadUnits(PVIEWDATA pViewData)
{
USHORT i,j;
ULONG  ulTotal = 0L, ul;
PUNIT  punit;
PVOID  ptemp, ptmp2;

/* Array of each unit configuration data size */

if(!pViewData->usUnits) return;

memset(&ulCbUnits, 0, sizeof(ulCbUnits));
profile_loadblob("aulong.cbunits", &ulCbUnits[0], sizeof(ULONG)*pViewData->usUnits);

for(i=0; i<pViewData->usUnits; i++) ulTotal += ulCbUnits[i]; // Jesus!

DbgPrintf("Loading %d units (ulTotal=%d)\n", pViewData->usUnits, ulTotal);

ptemp = malloc(ulTotal);
ptmp2 = ptemp;

profile_loadblob("blob.units", ptemp, ulTotal);  // EACH Unit configuration,
                                                // stored in INI file as BLOB

for(i=0; i<pViewData->usUnits; i++)
  {
  PWCLASS pwc;
  punit = (PUNIT)ptemp;
  pwc = GenSearchClass(punit->szClass);
  // 0.3.3
  if(pwc) 
    {
    ul = max(pwc->ulSafeAlloc, max(sizeof(UNIT), ulCbUnits[i]));
    pViewData->pUnits[i] = (PUNIT)malloc(ul);
    DbgPrintf("Unit class %s allocated %d/%d\n", punit->szClass, ul, ulCbUnits[i]);
    }
  else
    {
    ul = ulCbUnits[i];
    pViewData->pUnits[i] = (PUNIT)malloc(ul);
    DbgPrintf("Unit class %s allocated %d (class absent!!!)\n", punit->szClass, ul);
    }

/*  punit = (PUNIT)ptemp;
  for(j=0; j<ulClasses; j++)
    if(!strcmp(punit->szClass, pWClasses[j].pszName))
      {
      ul = max(pWClasses[j].ulSafeAlloc,sizeof(UNIT));
      pViewData->pUnits[i] = (PUNIT)malloc(ul);
      DbgPrintf("Unit class %s allocated %d\n", punit->szClass, ul);
      break;
      }
*/
  ptemp = (PVOID)((ULONG)ptemp+ulCbUnits[i]);
  }

ptemp = ptmp2;

for(i=0; i<pViewData->usUnits; i++)
  {
  memcpy(pViewData->pUnits[i], ptemp, ulCbUnits[i]);
  ptemp = (PVOID)((ULONG)ptemp + ulCbUnits[i]);
  }

free(ptmp2); // oh, mind...

}

VOID    CnfConfigLoad(char *inifile, char *iniapp, PVIEWDATA pViewData)
{
int i;
ULONG ul;
BOOL fFirstStart = FALSE;

DbgPrintf("Loading configuration (%s/%s)\n", inifile, iniapp);
DosEnterMustComplete(&ul); // super safe?

profile_open(WinQueryAnchorBlock(hwnd_Object),inifile);
profile_setapp("Default");
profile_loadint("fFirstStart", (int*)&fFirstStart);

if(fFirstStart)
  {
  fFirstStart = FALSE;
  DbgPrintf("First start (default!!!)\n");
  profile_saveint("fFirstStart", (int*)&fFirstStart);
  }
else profile_setapp(iniapp);

// set defaults

LoadViewConfig(&pViewData->viewConfig, 0xFFFF);

pViewData->usUnits = 0;

profile_loadushort("usNumUnits", &pViewData->usUnits);

CnfLoadUnits(pViewData);
profile_close();

DosExitMustComplete(&ul);
DbgPrintf("Loading configuration done\n");
}

VOID    CnfConfigSave(char *inifile, char *iniapp, PVIEWDATA pViewData)
{
int i;
ULONG ul;

DbgPrintf("Writing configuration (%s/%s)\n", inifile, iniapp);
DosEnterMustComplete(&ul); // super safe?

profile_open(WinQueryAnchorBlock(hwnd_Object),inifile);
profile_setapp(iniapp);

SaveViewConfig(&pViewData->viewConfig, 0xFFFF);

profile_saveushort("usNumUnits", &pViewData->usUnits);

CnfSaveUnits(pViewData);

profile_close();

DosExitMustComplete(&ul);
DbgPrintf("Writing configuration done\n");
}

VOID    CnfViewConfigLoad(HAB hab, char *inifile, char *iniapp, PVIEWCONFIG pvc, ULONG ulPages)
{
int i;
ULONG ul;

DosEnterMustComplete(&ul); // super safe?

profile_open(hab,inifile);
profile_setapp(iniapp);

LoadViewConfig(pvc, ulPages);

profile_close();

DosExitMustComplete(&ul);
}

VOID    CnfViewConfigSave(HAB hab, char *inifile, char *iniapp, PVIEWCONFIG pvc, ULONG ulPages)
{
int i;
ULONG ul;

DosEnterMustComplete(&ul); // super safe? yo, man... that is IBM, you know!

profile_open(hab, inifile);
profile_setapp(iniapp);

SaveViewConfig(pvc, ulPages);

profile_close();

DosExitMustComplete(&ul);
}
