// ____________________________________________________________________________
//
// POP3 Monitor for Systray/WPS version 0.1         (C) Dmitry Zaharov, 2001
// ____________________________________________________________________________

#include "inetplug.h"

#include <netdb.h>              // NOTE: use headers from OS/2 Warp 4.0 MPTN
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>

//int _System soclose (int);

extern HMODULE hmod;
extern HAB hab;

HPOINTER hptrEmpty, hptrNew, hptrError, hptrExplore;

CHAR szSubjInfoClass[] = "PopMonSubjInfoClass";

BOOL FileBrowser(HWND hwnd, PSZ name, PSZ title)
{
FILEDLG fileDialog;

memset(&fileDialog,0,sizeof(FILEDLG));
fileDialog.cbSize = sizeof(FILEDLG);

fileDialog.pszTitle = title;
fileDialog.fl = FDS_CENTER | FDS_OPEN_DIALOG;
strcpy(fileDialog.szFullFile, name);

if(!WinFileDlg(HWND_DESKTOP, hwnd, (PFILEDLG)&fileDialog))
  return FALSE;

strcpy(name, fileDialog.szFullFile);

return (fileDialog.lReturn == 1);
}

BOOL StartProgram(PSZ pszProgram, PSZ pszKeys)
{
PROGDETAILS pDetails;
CHAR        szBuffer[CBMAXSTRING], *t;
INT i;

strcpy(szBuffer, pszProgram);

t = strrchr(szBuffer, '\\');

if(t) *t = '\0';

pDetails.Length          = sizeof(PROGDETAILS);
pDetails.progt.progc     = PROG_DEFAULT;
pDetails.progt.fbVisible = SHE_VISIBLE;
pDetails.pszTitle        = NULL;
pDetails.pszExecutable   = pszProgram;
pDetails.pszParameters   = NULL;
pDetails.pszStartupDir   = szBuffer;
pDetails.pszIcon         = NULL;
pDetails.pszEnvironment  = NULL;
pDetails.swpInitial.fl   = 0;
pDetails.swpInitial.cy   = pDetails.swpInitial.cx = 0;
pDetails.swpInitial.y    = pDetails.swpInitial.x  = 0;
pDetails.swpInitial.hwndInsertBehind = NULLHANDLE;
pDetails.swpInitial.hwnd             = HWND_DESKTOP;
pDetails.swpInitial.ulReserved1      = 0;
pDetails.swpInitial.ulReserved2      = 0;

if(!WinStartApp(NULLHANDLE, &pDetails, pszKeys, NULL, 0))
  return FALSE;

return TRUE;
}

MRESULT EXPENTRY Pop3MonDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PUNITPM pUnit = (PUNITPM)WinQueryWindowULong(hwnd, QWL_USER);
BTNCDATA bcd = {sizeof(BTNCDATA), 0L, 0L, NULLHANDLE};
SWP swp;

switch(msg)
  {
  case WM_INITDLG:
  pUnit = (PUNITPM)mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)mp2);

  WinSendDlgItemMsg(hwnd, IDR_HOST, EM_SETTEXTLIMIT, (MPARAM)CBMAXSTRING, (MPARAM)0L);
  WinSendDlgItemMsg(hwnd, IDR_USER, EM_SETTEXTLIMIT, (MPARAM)CBMAXSTRING, (MPARAM)0L);
  WinSendDlgItemMsg(hwnd, IDR_PASS, EM_SETTEXTLIMIT, (MPARAM)CBMAXSTRING, (MPARAM)0L);
  WinSendDlgItemMsg(hwnd, IDR_PROGRAM, EM_SETTEXTLIMIT, (MPARAM)CBMAXSTRING, (MPARAM)0L);
  WinSendDlgItemMsg(hwnd, IDR_KEYS, EM_SETTEXTLIMIT, (MPARAM)CBMAXSTRING, (MPARAM)0L);

  WinSetDlgItemText(hwnd, IDR_HOST, pUnit->szHost);
  WinSetDlgItemText(hwnd, IDR_USER, pUnit->szUser);
  WinSetDlgItemText(hwnd, IDR_PASS, pUnit->szPass);
  WinSetDlgItemText(hwnd, IDR_PROGRAM, pUnit->szProgram);
  WinSetDlgItemText(hwnd, IDR_KEYS, pUnit->szKeys);
  WinSetDlgItemShort(hwnd, IDR_PORT, (SHORT)pUnit->usPort, FALSE);

  WinCheckButton(hwnd, IDR_ALARMONNEW,
                 ((pUnit->ulFlags & PMF_ALARMONNEW) != 0L));

  WinCheckButton(hwnd, IDR_STARTONNEW,
                 ((pUnit->ulFlags & PMF_STARTONNEW) != 0L));

  WinSendDlgItemMsg(hwnd, IDR_PERIOD, SPBM_SETLIMITS, (MPARAM)9999L,(MPARAM)1L);
  WinSendDlgItemMsg(hwnd, IDR_PERIOD, SPBM_SETCURRENTVALUE,
                    (MPARAM)pUnit->ulPeriod, (MPARAM)0L);

  WinQueryWindowPos(WinWindowFromID(hwnd, IDR_BROWSE), &swp);
  WinDestroyWindow(WinWindowFromID(hwnd, IDR_BROWSE));

  bcd.hImage = hptrExplore;

  WinCreateWindow(hwnd, WC_BUTTON, "",
                  BS_PUSHBUTTON | BS_MINIICON |
                  WS_VISIBLE    | WS_GROUP    | WS_TABSTOP,
                  swp.x, swp.y, swp.cx, swp.cy,
                  hwnd, WinWindowFromID(hwnd, IDR_STARTONNEW),
                  IDR_BROWSE, (PVOID)&bcd, NULL);

  if(!(pUnit->ulFlags & PMF_STARTONNEW))
    {
    WinEnableControl(hwnd, IDR_PROGRAM, FALSE);
    WinEnableControl(hwnd, IDR_BROWSE, FALSE);
    }

  break;

  case WM_CONTROL:

  if(((SHORT2FROMMP(mp1) == BN_CLICKED) ||
      (SHORT2FROMMP(mp1) == BN_DBLCLICKED)) &&
     (SHORT1FROMMP(mp1) == IDR_STARTONNEW))
    {
    BOOL fEnabled = WinQueryButtonCheckstate(hwnd, IDR_STARTONNEW);
    WinEnableControl(hwnd, IDR_PROGRAM, fEnabled);
    WinEnableControl(hwnd, IDR_BROWSE, fEnabled);
    }

  break;

  case WM_COMMAND:
  if((SHORT)mp1 == IDR_BROWSE)
    {
    static CHAR buf[CBMAXSTRING];
    WinQueryDlgItemText(hwnd, IDR_PROGRAM, CBMAXSTRING, buf);

    if(FileBrowser(hwnd, buf, "Mail checker program"))
      WinSetDlgItemText(hwnd, IDR_PROGRAM, buf);
    }
  return (MRESULT)0L;

  case WM_DESTROY:
  WinQueryDlgItemText(hwnd, IDR_HOST, CBMAXSTRING, pUnit->szHost);
  WinQueryDlgItemText(hwnd, IDR_USER, CBMAXSTRING, pUnit->szUser);
  WinQueryDlgItemText(hwnd, IDR_PASS, CBMAXSTRING, pUnit->szPass);
  WinQueryDlgItemText(hwnd, IDR_PROGRAM, CBMAXSTRING, pUnit->szProgram);
  WinQueryDlgItemText(hwnd, IDR_KEYS, CBMAXSTRING, pUnit->szKeys);
  WinQueryDlgItemShort(hwnd, IDR_PORT, (PSHORT)&pUnit->usPort, FALSE);

  pUnit->ulFlags = 0L;

  if(WinQueryButtonCheckstate(hwnd, IDR_ALARMONNEW))
    pUnit->ulFlags |= PMF_ALARMONNEW;

  if(WinQueryButtonCheckstate(hwnd, IDR_STARTONNEW))
    pUnit->ulFlags |= PMF_STARTONNEW;

  WinSendDlgItemMsg(hwnd, IDR_PERIOD, SPBM_QUERYVALUE,
                    (MPARAM)&pUnit->ulPeriod, MPFROM2SHORT(0, SPBQ_UPDATEIFVALID));

  pUnit->Unit.ulRefresh = pUnit->ulPeriod * 60L;
  break;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

VOID Pop3MonPaint(HWND hwnd, PUNITPM pUnit, BOOL fForced)
{
HPS hps;
RECTL rcl, rclReg;
CHAR szText[40];
HPOINTER hptrIcon;
INT cxIcon = WinQuerySysValue(HWND_DESKTOP, SV_CXICON)/2;

//GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
//pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
//pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);

switch(pUnit->priv.bState)
  {
  case PMS_EMPTY:
  if(!pUnit->priv.ulMessages)
    {
    hptrIcon = hptrEmpty;
    strcpy(szText, "No mail");
    }
  else
    {
    sprintf(szText, "%d (%d)", pUnit->priv.ulMessages, pUnit->priv.ulSize);
    hptrIcon = hptrNew;
    }
  break;

  case PMS_ERROR:
  strcpy(szText, "Error");
  hptrIcon = hptrError;
  break;

  case PMS_NEW:
  sprintf(szText, "%d (%d)", pUnit->priv.ulMessages, pUnit->priv.ulSize);
  hptrIcon = hptrNew;
  break;

  default:
  strcpy(szText, "???");
  hptrIcon = hptrError;
  break;
  }

WinQueryWindowRect(hwnd, &rcl);

rclReg = rcl; rclReg.xRight = cxIcon + 2;
rcl.xLeft += cxIcon + 2;

hps = fForced ? WinGetPS(hwnd) : WinBeginPaint(hwnd, 0L, 0L);

GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);

WinFillRect(hps, &rclReg, pUnit->fcInfo[pUnit->priv.bState].lBackColor);
WinDrawPointer(hps, rclReg.xLeft + (rclReg.yTop - cxIcon)/2,
                    rclReg.yBottom + (rclReg.yTop - cxIcon)/2, hptrIcon, DP_MINI);

WinDrawText(hps, -1, szText, &rcl,
            pUnit->fcInfo[pUnit->priv.bState].lTextColor,
            pUnit->fcInfo[pUnit->priv.bState].lBackColor,
            DT_CENTER | DT_VCENTER | DT_ERASERECT);

//WinFillRect(hps, &rcl, pUnit->fcInfo[0].lBackColor);

if(fForced) WinReleasePS(hps);
else        WinEndPaint(hps);
}

int  log(char *s)
{
#ifndef NOPOP3LOG
char *logfile = getenv("POP3UNIT_LOG");
if(logfile)
  {
  FILE *f=fopen(logfile,"at");
  if(f) {fprintf(f,"%s\n",s);  fclose(f);}
  }
#endif
return 0;
}

int  recvline(int socket_n, unsigned char *buf)
{
unsigned char *t, ch;
int r = 1;
t = buf;
do
  {
  r = recv(socket_n, &ch, 1, 0);
  if(r < 1) return (0);
  /* Skip line-feed and carriage-return characters */
  *t++ = ch;
  }
  while(ch != '\n');

t = strchr(buf, '\n');

if(t) *t = '\0';

t = strchr(buf, '\r');
if(t) *t = '\0';

return strlen(buf);
}
//#endif

int  sendline(int socket_n, char *buf)
{
char crlf[] = "\r\n";
int  i;
if((i = send(socket_n, buf, strlen(buf), 0)) <= 0) return i;
if((i = send(socket_n, crlf, strlen(crlf), 0)) <= 0) return i;

return strlen(buf);
}

void pop3scanthread(void FAR* pv)
{
PUNITPM punit;
static ULONG i, ulTemp = 0, ulIpAddr = 0;
int socket_n = 0;
struct hostent *hp;
static struct sockaddr_in sa;
static char buffer[512];
char popquit[] = "QUIT";
char poperror[] = "Connection closed: error";

punit = (PUNITPM)pv;

log("Thread start");

while(TRUE)
  {
  log("Waiting for semaphore...");

  DosWaitEventSem(punit->priv.hSem, -1L);
  DosResetEventSem(punit->priv.hSem, &ulTemp);

  if(punit->priv.fTerminate)
    {
    log("Terminating flag received, exiting...");
    break;
    }

  log("Opening connection:");

  if(!punit->szHost[0])
    {
    log("No hostname specified, still resting");
    continue;
    }

  ulIpAddr = inet_addr(punit->szHost);

  if(ulIpAddr == 0xFFFFFFFFUL)
  {
  sprintf(buffer, "Resolving %s...",punit->szHost);
  log(buffer);
  hp = gethostbyname(punit->szHost);
  if(hp) ulIpAddr = *(unsigned long*)hp->h_addr;
  else
    {
    log("Cant resolve : gethostbyname returned NULL");
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  if(ulIpAddr == 0xFFFFFFFFUL)
    {
    log("Cant resolve : hp->h_addr is still -1...");
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }
  }

  socket_n = socket(AF_INET, SOCK_STREAM, 0);

  if(socket_n == -1)
    {
    log("Cant connect: socket is -1");
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  /* Connect to given ip */

  memset(&sa, 0, sizeof(sa));
//  sa.sin_len = sizeof(sa);
  sa.sin_family = AF_INET;
  sa.sin_addr.s_addr = ulIpAddr;
  sa.sin_port = bswap(punit->usPort);

  sprintf(buffer, "Connecting %s:%u (%d.%d.%d.%d) (%d)...", punit->szHost,
          punit->usPort, ulIpAddr&0xFF, (ulIpAddr>>8)&0xFF, (ulIpAddr>>16)&0xFF,
          (ulIpAddr>>24)&0xFF, socket_n);

  log(buffer);

  connect(socket_n, (struct sockaddr*)&sa, sizeof(sa));

  sprintf(buffer, "Connected to remote... (socket %d)", socket_n);
  log(buffer);

  if(recvline(socket_n, buffer) <= 0)
    {
    soclose(socket_n);
    log("Bad recv() status, connection closed :(");
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log(buffer);

  /* Do login */

  sprintf(buffer, "USER %s", punit->szUser);

  if(sendline(socket_n, buffer) <= 0)
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log(buffer);

  if(recvline(socket_n, buffer) <= 0)
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log(buffer);

  if(buffer[0] == '-') /* server error */
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  /* Send password */

  sprintf(buffer, "PASS %s", punit->szPass);

  if(sendline(socket_n, buffer) <= 0)
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log("PASS *");

  if(recvline(socket_n, buffer) <= 0)
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log(buffer);

  if(buffer[0] == '-') /* error */
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  /* send status request */

  if(sendline(socket_n, "STAT") <= 0)
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log(buffer);

  if(recvline(socket_n, buffer) <= 0)
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  log(buffer);

  if(buffer[0] == '-') /* error */
    {
    sendline(socket_n, popquit);
    soclose(socket_n);
    log(poperror);
    punit->priv.bState = PMS_ERROR;
    WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
    continue;
    }

  sscanf(buffer, "+OK %d %d", &ulTemp, &punit->priv.ulSize);

#ifdef POP3_SUBJECTS
  if(punit->priv.apszSubjects) free(punit->priv.apszSubjects);
  if(punit->priv.apszSenders) free(punit->priv.apszSenders);
  punit->priv.apszSubjects = (PSZ*)malloc((80 + sizeof(PSZ))*ulTemp);
  punit->priv.apszSenders = (PSZ*)malloc((80 + sizeof(PSZ))*ulTemp);

  if(punit->priv.apszSubjects && punit->priv.apszSenders)
    {
    for(i = 0; i<ulTemp; i++)
      {
      punit->priv.apszSubjects[i] = (PSZ)((ULONG)punit->priv.apszSubjects + i*80L +
                                    ulTemp*sizeof(PSZ)); // fixme
      punit->priv.apszSenders[i] = (PSZ)((ULONG)punit->priv.apszSenders + i*80L +
                                    ulTemp*sizeof(PSZ));
      *(punit->priv.apszSubjects[i]) = '\0';
      *(punit->priv.apszSenders[i]) = '\0';
      }

    getSubjects(socket_n, ulTemp, punit->priv.apszSubjects, punit->priv.apszSenders);
    for(i = 0; i<ulTemp; i++)
      {
      log(punit->priv.apszSubjects[i]);
      log(punit->priv.apszSenders[i]);
      }
    }
#endif

  sendline(socket_n, popquit);
  soclose(socket_n);

  log("Connection closed: status OK");

  punit->priv.bState = (punit->priv.ulMessages < ulTemp) ? PMS_NEW : PMS_EMPTY;
  punit->priv.ulMessages = ulTemp;
  WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
  WinPostMsg(punit->priv.hwndSubjInfoClient, WM_USER, NULL, NULL);
  }

if(punit->priv.apszSubjects) free(punit->priv.apszSubjects);
if(punit->priv.apszSenders) free(punit->priv.apszSenders);

DosCloseEventSem(punit->priv.hSem);
log("Thread ends");
_endthread();
}

#ifdef POP3_SUBJECTS

BOOL    CreateSubjInfoWindow(PUNITPM pUnit)
{
ULONG flStyle = FCF_BORDER;

pUnit->priv.hwndSubjInfo = WinCreateStdWindow(HWND_DESKTOP, 0,
                                              &flStyle, szSubjInfoClass,
                                              "",
                                              0, NULLHANDLE, 0,
                                              &pUnit->priv.hwndSubjInfoClient);

WinSetWindowULong(pUnit->priv.hwndSubjInfo, QWL_USER, (ULONG)pUnit);

return (pUnit->priv.hwndSubjInfo != 0);
}

MRESULT EXPENTRY SubjMonWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HPS hps;
  POINTL ptl;
  RECTL rcl, rcl2;
  SIZEL szl;
  ULONG i;
  PVIEWDATA pvd;
  PUNITPM pUnit = (PUNITPM) WinQueryWindowPtr(WinQueryWindow(hwnd, QW_PARENT), QWL_USER);

  switch(msg)
    {
    case WM_CREATE:
    //SetItemFont(hwnd, pUnit->fcInfo[0].szFont);
    //SetItemTextColor(hwnd, pUnit->fcInfo[1].lTextColor);
    //SetItemBackColor(hwnd, pUnit->fcInfo[1].lBackColor);
    break;

    case WM_USER:
    SetItemFont(hwnd, pUnit->fcInfo[0].szFont);
    ptl.x = rcl.xLeft = 0;
    ptl.y = rcl.yBottom = 0;
    hps = WinGetPS(hwnd);
    QueryTextBox(hps, pUnit->szHost, &szl);
    rcl.yTop = szl.cy + 2;
    rcl.xRight = szl.cx + 2;

    for(i = 0; (i < pUnit->priv.ulMessages) && pUnit->priv.apszSubjects; i ++)
      {
      QueryTextBox(hps, pUnit->priv.apszSubjects[i], &szl);
      rcl.yTop += szl.cy + 2;
      if(rcl.xRight < (szl.cx + 2)) rcl.xRight = szl.cx + 2;
      }
    WinReleasePS(hps);

    rcl.xRight += 3;
    rcl.yTop += 2;

    pvd = (PVIEWDATA)pUnit->Unit.pViewData;

    WinQueryWindowRect(pUnit->Unit.hwnd, &rcl2);
    WinMapWindowPoints(pUnit->Unit.hwnd, HWND_DESKTOP, &ptl, 1);
    if(pvd->viewConfig.page1.fBottom)
      ptl.y += rcl2.yTop + 2;
    else
      ptl.y -= rcl.yTop;

    if((ptl.x + rcl.xRight) > WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN))
      ptl.x = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - rcl.xRight;

    WinSetWindowPos(WinQueryWindow(hwnd, QW_PARENT), 0L,
                    ptl.x, ptl.y, rcl.xRight, rcl.yTop,
                    SWP_MOVE | SWP_SIZE);
    break;

    case WM_PAINT:
    hps = WinBeginPaint (hwnd, NULL, NULL);
    GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
    WinQueryWindowRect(hwnd, &rcl);
    WinFillRect(hps, &rcl, pUnit->fcInfo[0].lBackColor);
    QueryTextBox(hps, pUnit->szHost, &szl);
    rcl.yBottom = rcl.yTop - szl.cy - 2;
    WinDrawText(hps, -1, pUnit->szHost, &rcl,
                pUnit->fcInfo[1].lTextColor,
                pUnit->fcInfo[1].lBackColor,
                DT_CENTER | DT_VCENTER | DT_ERASERECT);

    rcl.xLeft += 2;

    for(i = 0; (i < pUnit->priv.ulMessages) && pUnit->priv.apszSubjects; i++)
      {
      QueryTextBox(hps, pUnit->priv.apszSubjects[i], &szl);
      rcl.yTop = rcl.yBottom;
      rcl.yBottom -= szl.cy + 2;
      WinDrawText(hps, -1, pUnit->priv.apszSubjects[i], &rcl,
                  pUnit->fcInfo[0].lTextColor,
                  pUnit->fcInfo[0].lBackColor,
                  DT_VCENTER | DT_ERASERECT);
      }
    WinEndPaint(hps);
    return (MRESULT)0L;

    }

  return (WinDefWindowProc(hwnd, msg, mp1, mp2));
  }

#endif

MRESULT	Pop3MonPresParam(HWND hwnd, INT idAttr, PUNITPM pUnit)
{
BOOL fRepaint = TRUE;

switch(idAttr)
  {
  case 0: // Scheme palette dropped
  GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
  pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
  pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);
  break;

  case PP_FOREGROUNDCOLOR:
  pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
  break;

  case PP_BACKGROUNDCOLOR:
  pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);
  break;

  case PP_FONTNAMESIZE:
  GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
  break;

  default: fRepaint = FALSE;
  }

if(fRepaint)
  {
  RECTL rcl;
  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, &rcl, FALSE);
  }

return (MRESULT)fRepaint;
}

MRESULT EXPENTRY Pop3MonWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
RECTL rcl;
PUNITPM pUnit;
pUnit = (PUNITPM)WinQueryWindowULong(hwnd, 0L);

switch(msg)
  {
  case WM_CREATE:
  // Setup Unit instance data
  pUnit = (PUNITPM)mp1;
  pUnit->Unit.ulCounter = 0L;
  WinSetWindowULong(hwnd, 0L, (ULONG)pUnit);

  if(pUnit->Unit.fJustCreated)
    {
    pUnit->fcInfo[0].lTextColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_WINDOWSTATICTEXT, 0L);
    pUnit->fcInfo[0].lBackColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONMIDDLE, 0L);
    pUnit->fcInfo[1].lTextColor = 0x00000000;
    pUnit->fcInfo[1].lBackColor = 0x00AADDCC;
    pUnit->fcInfo[2].lTextColor = 0x00FFFFFF;
    pUnit->fcInfo[2].lBackColor = 0x00FF0000;
    strcpy(pUnit->fcInfo[0].szFont, "9.WarpSans");
    strcpy(pUnit->fcInfo[1].szFont, pUnit->fcInfo[0].szFont);
    strcpy(pUnit->fcInfo[2].szFont, pUnit->fcInfo[0].szFont);
    pUnit->usPort = 110;
    pUnit->szHost[0] = pUnit->szUser[0] = pUnit->szPass[0] = '\0';
    pUnit->szProgram[0] = pUnit->szKeys[0] = '\0';
    pUnit->Unit.fJustCreated = FALSE;
    WinPostMsg(hwnd, WM_COMMAND, (MPARAM)STIDC_UNITSETTINGS, (MPARAM)0L);
    }
  memset(&pUnit->priv, 0, sizeof(POP3PRIVATE));
#ifdef POP3_SUBJECTS
  CreateSubjInfoWindow(pUnit);
#endif
  pUnit->Unit.ulRefresh = pUnit->ulPeriod * 60L;
  SetItemFont(hwnd, pUnit->fcInfo[0].szFont);
  SetItemTextColor(hwnd, pUnit->fcInfo[0].lTextColor);
  SetItemBackColor(hwnd, pUnit->fcInfo[0].lBackColor);

  if(!DosCreateEventSem(NULL, &pUnit->priv.hSem, NULL, TRUE))
    _beginthread(pop3scanthread, NULL, 32768, (PVOID)pUnit);
  break;

  case USTM_REFRESHTIMER:
  pUnit->priv.fTerminate = FALSE;
  DosPostEventSem(pUnit->priv.hSem);
  break;

  case USTM_FILLGROUPTITLE:
    {
    PSZ pszTitle = (PSZ)mp1;
    sprintf(pszTitle, "Mail checker (%s)", pUnit->szUser);
    return (MRESULT)TRUE;
    }

  case USTM_QUERYWIDTH:
  // Return default unit width
  return (MRESULT) 90L; // 140 pixels wide (default)

  case USTM_QUERYICON:
  return (MRESULT)hptrNew;

  case USTM_QUERYNBINFO:
    {
    PUNITNBINFO punbInfo = (PUNITNBINFO)mp1;
    static PSZ ppszfcInfo[] = {"No mail",
                               "New messages in mailbox",
                               "Error"};
    static UNITPGINFO upgInfo;
    upgInfo.pszTabText = "Monitor";
    upgInfo.pszStatusText = "Mail checker";
    upgInfo.res = hmod;
    upgInfo.id = IDR_POP3DLG;
    upgInfo.mp2InsertFlags = MPFROM2SHORT((BKA_STATUSTEXTON |
                                           BKA_AUTOPAGESIZE |
                                           BKA_MAJOR), BKA_FIRST);

    upgInfo.pfnDlgProc = (PFNWP)Pop3MonDlgProc;
    upgInfo.pCreateParams = (PVOID)pUnit;
    upgInfo.hwnd = NULLHANDLE;
    upgInfo.pupgInfoNext = NULL;
    upgInfo.ulPageFlags = NPF_ALL;

    punbInfo->sNumfcInfo = 3;
    punbInfo->ppszfcInfo = (PSZ*)ppszfcInfo;
    punbInfo->pfcInfo = &pUnit->fcInfo[0];
    punbInfo->pupgInfo = &upgInfo;
    punbInfo->idTurnTo = IDR_POP3DLG;
    punbInfo->hptrWindowIcon = hptrNew;
    return (MRESULT) TRUE;
    }

  case WM_USER: // thread signal
  if(pUnit->priv.bState == PMS_NEW)
    {
    if(pUnit->ulFlags & PMF_ALARMONNEW)
      WinAlarm(HWND_DESKTOP, WA_NOTE);
    if(pUnit->szProgram[0] && (pUnit->ulFlags & PMF_STARTONNEW))
      StartProgram(pUnit->szProgram, pUnit->szKeys);
    }
  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, &rcl, FALSE);
  break;

  case WM_PAINT:
  Pop3MonPaint(hwnd, pUnit, FALSE);
  return (MRESULT)TRUE;

  case WM_PRESPARAMCHANGED:
  return Pop3MonPresParam(hwnd, (INT)mp1, pUnit);
//  WinQueryWindowRect(hwnd, &rcl);
//  WinInvalidateRect(hwnd, &rcl, FALSE);
//  break;

  case WM_BUTTON1DBLCLK:
  if(pUnit->szProgram[0])
    StartProgram(pUnit->szProgram, pUnit->szKeys);
  break;

  case WM_DESTROY:
  pUnit->priv.fTerminate = TRUE;
  DosPostEventSem(pUnit->priv.hSem);
  if(pUnit->priv.hwndSubjInfo) WinDestroyWindow(pUnit->priv.hwndSubjInfo);
  break;

#ifdef POP3_SUBJECTS
  case u_WM_MOVEACROSSWINDOW:
  WinShowWindow(pUnit->priv.hwndSubjInfo, FALSE);
  break;

  case u_WM_MOVEALONGWINDOW:
    {
    WinSetWindowPos(pUnit->priv.hwndSubjInfo, HWND_TOP, 0, 0, 0, 0,
                    SWP_SHOW | SWP_ZORDER);
    break;
    }
#endif
  }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

BOOL    Pop3MonRegister(HAB _hab, HMODULE _hmod, PWCLASS _pwc)
{
_pwc->pszName = "IPLG_POP3Class";
_pwc->pszViewName = "Mail checker (POP3)";
_pwc->pszHelpFileName = "inetplug.hlp";
_pwc->ulHelpPanelID = 100;

_pwc->usMaxUnits = 0;
_pwc->usFlags = STUF_MANUAL | STUF_STATIC | STUF_NOHINT;

_pwc->ulFix = sizeof(UNITPM) - sizeof(POP3PRIVATE);
_pwc->ulSafeAlloc = sizeof(UNITPM);

WinRegisterClass(_hab, _pwc->pszName, (PFNWP)Pop3MonWndProc, CS_SIZEREDRAW, sizeof(PVOID));
#ifdef POP3_SUBJECTS
WinRegisterClass(_hab, szSubjInfoClass, (PFNWP)SubjMonWndProc, CS_SIZEREDRAW, sizeof(PVOID));
#endif

hptrNew = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_POP3NEW);
hptrEmpty = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_POP3EM);
hptrError = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_POP3ERR);
hptrExplore = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_EXPLORE);

return TRUE;
}

BOOL    Pop3MonDeregister(HAB _hab, HMODULE _hmod)
{
if(hptrNew) WinDestroyPointer(hptrNew);
if(hptrEmpty) WinDestroyPointer(hptrEmpty);
if(hptrError) WinDestroyPointer(hptrError);
if(hptrExplore) WinDestroyPointer(hptrExplore);

return TRUE;
}