// ____________________________________________________________________________
//
// POP3 Subjects gatherer module. Written by Sergey Levin, Dmitry Zaharov 2000
// ____________________________________________________________________________

#include "inetplug.h"

#include <netdb.h>              // NOTE: use headers from OS/2 Warp 4.0 MPTN
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>

#include "iconv.h"

int  log(char *s);
int  recvline(int socket_n, unsigned char *buf);

int readline(char *line, int size, int sock)
{
   int rc, recved;

   recved=-1;
   do
   {
      rc=recv(sock, &line[++recved], 1, 0);
   }
   while (recved+1<size && line[recved]!=0x0a);

   if (recved+1<size)
   {
      recved--;
      line[recved]=0;
   }
   else
   {
     line[recved]=0;
     recved=-1;
   }

   return recved;
}


int strDecodeB64(char* strIn, char *strOut, int *decoded)
{
   char alph[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
   long word, j, i;
   static char bits, bytes[127], *q;


   if (bits==0) for(i=0;alph[i]!=0;i++)
   bytes[alph[i]]=i; else bits=0;

   j=word=i=0;
   while (strIn[i]!=0 && strIn[i]!='=' && strIn[i]!='?')
   {
      word<<=6;
      word|=bytes[strIn[i++]];
      bits++;

      if (bits>3)
      {
         strOut[j++]=(word>>16)&0xff;
         strOut[j++]=(word>>8)&0xff;
         strOut[j++]=word&0xff;

         bits=0;
         word=0;
      }
   }

   switch (bits)
   {
      case 3:strOut[j++]=(word>>10)&0xff; strOut[j++]=(word>>2)&0xff;break;
      case 2:strOut[j++]=(word>>4)&0xff;
   }

*decoded=j;
i+=3;
return i;
}


int sbjDecodeB(char *strOut, char *strIn, int *decoded)
{

return strDecodeB64(strIn, strOut, decoded);
}

int sbjDecodeQ(char *strDecoded, char *strOrig, int *jj)
{
   char strHexHolder[3], code, k;
   int i, j;

   k=strHexHolder[2]=0;
   i=j=0;

   while(strOrig[i]!='?')
   {
      switch (strOrig[i])
      {
         case '=':k=0;strHexHolder[k++]=strOrig[++i];strHexHolder[k++]=strOrig[++i];i++;
                  sscanf(strHexHolder, "%X", &code);
                  strDecoded[j++]=code;
                  break;
         case ' ':strDecoded[j++]=' ';i++; break;
         case '?':i+=2;break;
         default: strDecoded[j++]=strOrig[i++];
      }
   }

*jj=j;
return ++i;
}


char *cpConvert ( char *strIn, char *strOut, char *cpFrom, char *cpTo)
{
   unsigned int strLen;
   char *obuf = strOut, *ibuf=strIn;
   iconv_t  cd;

// printf("%s\n", cpFrom);
   cd=iconv_open(cpTo, cpFrom);

   if (cd!=(iconv_t)-1)
   {
      strLen = strlen(strIn);
      iconv( cd, (char const**)&ibuf, &strLen, &obuf, &strLen);
      iconv_close(cd);

   }
   else printf("unsucc\n");

// printf("%s\n", strOut);
return strOut;
}


int GetCP(char *strDest, char *strOrig)
{
   int i,j;

   for (j=0,i=0;strOrig[i]!='?';i++)
      strDest[j++]=strOrig[i];
   strDest[j]=0;

return j;
}

char * sbjDecode(char *strDecoded, char *strOrig)
{
// decode subject and translate CP
   short int wrdEnc=('?'<<8)|'=';
   char CharSet[1024], strBuff[1024]; // *** according to rfc string size may not exceed 76 chars... so it must work, I hope.
   int i, j, ii, jj;

   strOrig[79]=0; // *** take just 80 very first chars to avoid overflow :)

   for(j=i=0;strOrig[i]!=0;i++)
   {
      if(strOrig[i]=='=' && *(short int*)&strOrig[i]==wrdEnc)
      {
         i+=GetCP(CharSet, &strOrig[i+2])+2;
         //strupr(CharSet);
         log(CharSet);

// *** parse according to rfc 1252
         ii=0;
         switch (strOrig[++i]&~0x20)
         {
            case 'Q':ii=sbjDecodeQ(&strDecoded[j], &strOrig[i+2], &jj);i+=2;break;
            case 'B':ii=sbjDecodeB(&strDecoded[j], &strOrig[i+2], &jj);i+=2;break;
             default: return NULL; // !!! indicate error
         }

         cpConvert(&strDecoded[j],  strBuff, CharSet, "IBM-866");
         log(strBuff);
         strcpy(&strDecoded[j], strBuff);
         i+=ii;j+=jj;
      }
      else strDecoded[j++]=strOrig[i];
   }

   if (CharSet[0]==0) // *** default conversion to KOI-8r
   {
      strDecoded[j]=0;
      cpConvert(&strDecoded[0],  strBuff, "IBM-878", "IBM-866");
      strcpy(&strDecoded[0], strBuff);
   }


strDecoded[j]=0;
return strDecoded;
}


int     getSubjects(int sockSocket, int messages, char **subjects, char **senders)
{
char *LineToSend;
char *strDecoded;
int  rc = 0, i, word, wrdSubj=(('j'<<24)|('b'<<16)|('u'<<8)|'s'), wrdFrom=(('m'<<24)|('o'<<16)|('r'<<8)|'f');
int *ii;

LineToSend = (char*)malloc(1024); if(!LineToSend) return -1;

strDecoded = (char*)malloc(1024); if(!strDecoded) {free(LineToSend); return -1;}

for(i = 1; i <= messages; i++)
  {
  sprintf(LineToSend, "top %d 0\r\n", i);
  rc = send(sockSocket, LineToSend, strlen(LineToSend), 0);

  if(rc < 1) break;

  do{
    readline(&(LineToSend[0]), 1024, sockSocket);
    log(LineToSend);

    if((word == wrdSubj) && (LineToSend[0] == '\t'))
      {
      log(LineToSend);
      strcat(subjects[i - 1], sbjDecode(strDecoded, (char*)&LineToSend[1]));
      log(strDecoded);
      }

    ii = (int*)LineToSend;
    word = *ii;
    word |= 0x20202020;

    if(word == wrdSubj)
      {
      log("---");
      sbjDecode(strDecoded, LineToSend);
      log(strDecoded);
      strcpy(subjects[i - 1], strDecoded);
      }

/*    if(word == wrdFrom)
      {
      log(LineToSend);
      strcpy(senders[i - 1], sbjDecode(strDecoded, (char*)LineToSend));
      log(strDecoded);
      }*/

    } while(LineToSend[0] != '.');
  }

free(strDecoded);
free(LineToSend);

if(rc > 0) rc = 0;

return rc;
}

