/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

#include "systray.h"
#include "settings.h"
#include "lang\str_ids.h"
#include "actl\actl.h"

/*
 * Systray settings notebook and other usable stuff
 */

extern CHAR szSystrayViewClass[];
extern CHAR szHelpPath[];
extern HMODULE hmSystrayRes;
extern INT iViews;
extern PVIEWDATA SystrayView[MAXVIEWS];
extern HMODULE hmSystray;
extern HMODULE hmSystrayRes;
extern P_WINSETDESKTOPWORKAREA _SetDesktopWorkarea;
extern PWCLASS pWClasses;
extern PPLUGIN pPlugin;
extern ULONG   ulPlugins;

PSZ	pszView = NULL,
        pszSystray = NULL,
        pszPlugins = NULL,
        pszPTitle = NULL;

BOOL	fWarp3 = FALSE;

// {{{ 0.3.5

void SetupPage1(HWND hwnd, PVIEWCONFIG pvc)
{
// Popup control
WinCheckButton(hwnd, IDR_NOAUTOPOPUP, (pvc->page1.bOntopMethod == ONTOP_NONE));
WinCheckButton(hwnd, IDR_ALWAYSONTOP, (pvc->page1.bOntopMethod == ONTOP_ALWAYS));
WinCheckButton(hwnd, IDR_POPUP, (pvc->page1.bOntopMethod == ONTOP_POPUP));
WinCheckButton(hwnd, IDR_POPHIDE, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
WinEnableControl(hwnd, IDR_HIDEDELAYSLIDER, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
WinEnableControl(hwnd, IDR_HIDEDELAYTEXT, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
WinEnableControl(hwnd, IDR_REDUCEDESKTOPAREA, !(pvc->page1.bOntopMethod == ONTOP_POPHIDE));
// Resize Desktop
WinCheckButton(hwnd, IDR_REDUCEDESKTOPAREA, pvc->page1.fResizeDesktop);
// Position
if(pvc->page1.fBottom)
  WinCheckButton(hwnd, IDR_POSITIONBOTTOM, TRUE);
else
  WinCheckButton(hwnd, IDR_POSITIONTOP, TRUE);
// Hide delay
WinSendDlgItemMsg(hwnd, IDR_HIDEDELAYSLIDER, SLM_SETTICKSIZE,
                  MPFROM2SHORT(SMA_SETALLTICKS, 4), (MPARAM)0L);
SetSliderPos(hwnd, IDR_HIDEDELAYSLIDER, (ULONG)pvc->page1.bHideDelay);
SetTextInt(hwnd, IDR_HIDEDELAYTEXT, (INT)pvc->page1.bHideDelay);
}


MRESULT EXPENTRY Page1SettingsProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PSETTINGSDATA psd = (PSETTINGSDATA) WinQueryWindowULong(hwnd, QWL_USER);
PVIEWCONFIG pvc;
ULONG tmp;

switch(msg)
  {
  case WM_INITDLG:
  if(fWarp3)
    {
    WinSetWindowULong(WinWindowFromID(hwnd, IDD_UNDO), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(hwnd, IDD_DEFAULT), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(hwnd, IDD_HELP), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE | BS_HELP);

    }

  psd = (PSETTINGSDATA)malloc(sizeof(SETTINGSDATA));
  psd->somSelf = (PVOID)mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)psd); // setup instancedata
  GenImportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, 1);
  memcpy(&psd->vcBak.page1, &psd->vc.page1, sizeof(psd->vc.page1));
  pvc = &psd->vc;
  SetupPage1(hwnd, pvc);

  break;

  case WM_CONTROL:
    {
    BOOL fReExport = TRUE;
    pvc = &psd->vc;

    switch(SHORT1FROMMP(mp1))
      {
      case IDR_NOAUTOPOPUP:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      if(WinQueryButtonCheckstate(hwnd, IDR_NOAUTOPOPUP))
        pvc->page1.bOntopMethod = ONTOP_NONE;
      WinEnableControl(hwnd, IDR_HIDEDELAYSLIDER, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_HIDEDELAYTEXT, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_REDUCEDESKTOPAREA, !(pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      break;

      case IDR_ALWAYSONTOP:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      if(WinQueryButtonCheckstate(hwnd, IDR_ALWAYSONTOP))
        pvc->page1.bOntopMethod = ONTOP_ALWAYS;
      WinEnableControl(hwnd, IDR_HIDEDELAYSLIDER, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_HIDEDELAYTEXT, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_REDUCEDESKTOPAREA, !(pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      break;

      case IDR_POPUP:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      if(WinQueryButtonCheckstate(hwnd, IDR_POPUP))
        pvc->page1.bOntopMethod = ONTOP_POPUP;
      WinEnableControl(hwnd, IDR_HIDEDELAYSLIDER, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_HIDEDELAYTEXT, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_REDUCEDESKTOPAREA, !(pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      break;

      case IDR_POPHIDE:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      if(WinQueryButtonCheckstate(hwnd, IDR_POPHIDE))
        pvc->page1.bOntopMethod = ONTOP_POPHIDE;
      WinEnableControl(hwnd, IDR_HIDEDELAYSLIDER, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_HIDEDELAYTEXT, (pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      WinEnableControl(hwnd, IDR_REDUCEDESKTOPAREA, !(pvc->page1.bOntopMethod == ONTOP_POPHIDE));
      break;

      case IDR_REDUCEDESKTOPAREA:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      pvc->page1.fResizeDesktop = WinQueryButtonCheckstate(hwnd, IDR_REDUCEDESKTOPAREA);
      break;

      case IDR_POSITIONTOP:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      if(WinQueryButtonCheckstate(hwnd, IDR_POSITIONTOP))
        pvc->page1.fBottom = FALSE;
      break;

      case IDR_POSITIONBOTTOM:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      if(WinQueryButtonCheckstate(hwnd, IDR_POSITIONBOTTOM))
        pvc->page1.fBottom = TRUE;
      break;

      case IDR_HIDEDELAYSLIDER:
      if((SHORT2FROMMP(mp1) == SLN_CHANGE) ||
         (SHORT2FROMMP(mp1) == SLN_SLIDERTRACK))
        {
        pvc->page1.bHideDelay = (BYTE)GetSliderPos(hwnd, IDR_HIDEDELAYSLIDER);
        SetTextInt(hwnd, IDR_HIDEDELAYTEXT, (INT)pvc->page1.bHideDelay);
        }
      break;

      default: fReExport = FALSE;
      }

    if(fReExport)
      GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 1);

    break;
    }

  case WM_DESTROY:
  //GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 1);
  free(psd);
  return (MRESULT) 0L;

  case WM_COMMAND:
  switch((SHORT)mp1)
    {
    case IDD_UNDO:
    memcpy(&psd->vc.page1, &psd->vcBak.page1, sizeof(psd->vc.page1));
    SetupPage1(hwnd, &psd->vc);
    GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 1);
    break;

    case IDD_DEFAULT:
    DefaultViewConfig(&psd->vc, 1);
    SetupPage1(hwnd, &psd->vc);
    GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 1);
    break;
    }
  return (MRESULT) 0L;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

void SetupPage2(HWND hwnd, PVIEWCONFIG pvc)
{
/*
#define IDR_BORDERWIDTHTEXT         404
#define IDR_BORDERWIDTHSLIDER       407
#define IDR_BARSPACINGSLIDER        406
#define IDR_BARSPACINGTEXT          408
#define IDR_UNITSPACINGSLIDER       410
#define IDR_UNITSPACINGTEXT         411
#define IDR_HINTSENABLED            414
#define IDR_FASTHINTS               415
#define IDR_FRAMEAROUNDSTATICS      417
#define IDR_FRAMEAROUNDOTHER        418
#define IDR_NOSIZINGBARS            419
#define IDR_VERTICALLINES           420
#define IDR_BARHEIGHTSLIDER         421
#define IDR_BARHEIGHTTEXT           422
*/
// Draw controls
WinCheckButton(hwnd, IDR_FRAMEAROUNDSTATICS, pvc->page2.fFramedUnits);
WinCheckButton(hwnd, IDR_FRAMEAROUNDOTHER, pvc->page2.fFramedAll);
WinCheckButton(hwnd, IDR_NOSIZINGBARS, pvc->page2.fHideSpacebars);
WinCheckButton(hwnd, IDR_VERTICALLINES, pvc->page2.fDrawVertbars);
// Hints
WinCheckButton(hwnd, IDR_HINTSENABLED, (!pvc->page2.fDisableHint)); // @#$%^
WinCheckButton(hwnd, IDR_FASTHINTS, pvc->page2.fFastHints);
// Dimensions
WinSendDlgItemMsg(hwnd, IDR_BORDERWIDTHSLIDER, SLM_SETTICKSIZE,
                  MPFROM2SHORT(SMA_SETALLTICKS, 4), (MPARAM)0L);
SetSliderPos(hwnd, IDR_BORDERWIDTHSLIDER, (ULONG)pvc->page2.bBorderWidth);
SetTextInt(hwnd, IDR_BORDERWIDTHTEXT, (INT)pvc->page2.bBorderWidth);

WinSendDlgItemMsg(hwnd, IDR_BARSPACINGSLIDER, SLM_SETTICKSIZE,
                  MPFROM2SHORT(SMA_SETALLTICKS, 4), (MPARAM)0L);
SetSliderPos(hwnd, IDR_BARSPACINGSLIDER, (ULONG)pvc->page2.bViewSpacing);
SetTextInt(hwnd, IDR_BARSPACINGTEXT, (INT)pvc->page2.bViewSpacing);

WinSendDlgItemMsg(hwnd, IDR_UNITSPACINGSLIDER, SLM_SETTICKSIZE,
                  MPFROM2SHORT(SMA_SETALLTICKS, 4), (MPARAM)0L);
SetSliderPos(hwnd, IDR_UNITSPACINGSLIDER, (ULONG)pvc->page2.bUnitSpacing);
SetTextInt(hwnd, IDR_UNITSPACINGTEXT, (INT)pvc->page2.bUnitSpacing);

WinSendDlgItemMsg(hwnd, IDR_BARHEIGHTSLIDER, SLM_SETTICKSIZE,
                  MPFROM2SHORT(SMA_SETALLTICKS, 4), (MPARAM)0L);
SetSliderPos(hwnd, IDR_BARHEIGHTSLIDER, (ULONG)pvc->page2.bRowHeight);
SetTextInt(hwnd, IDR_BARHEIGHTTEXT, (INT)pvc->page2.bRowHeight);

}

MRESULT EXPENTRY Page2SettingsProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PSETTINGSDATA psd = (PSETTINGSDATA) WinQueryWindowULong(hwnd, QWL_USER);
PVIEWCONFIG pvc;
ULONG tmp;

switch(msg)
  {
  case WM_INITDLG:
  if(fWarp3)
    {
    WinSetWindowULong(WinWindowFromID(hwnd, IDD_UNDO), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(hwnd, IDD_DEFAULT), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(hwnd, IDD_HELP), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE | BS_HELP);

    }

  psd = (PSETTINGSDATA)malloc(sizeof(SETTINGSDATA));
  psd->somSelf = (PVOID)mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)psd); // setup instancedata
  GenImportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, 2);
  memcpy(&psd->vcBak.page2, &psd->vc.page2, sizeof(psd->vc.page2));
  pvc = &psd->vc;
  SetupPage2(hwnd, pvc);

  if(fWarp3)
    {
    WinSetWindowULong(WinWindowFromID(hwnd, IDD_UNDO), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(hwnd, IDD_DEFAULT), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(hwnd, IDD_HELP), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE | BS_HELP);

    }

  break;

  case WM_CONTROL:
    {
    BOOL fReExport = TRUE;
    pvc = &psd->vc;

    switch(SHORT1FROMMP(mp1))
      {
      case IDR_FASTHINTS:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;
      pvc->page2.fFastHints = WinQueryButtonCheckstate(hwnd, IDR_FASTHINTS);
      break;

      case IDR_HINTSENABLED:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;
      pvc->page2.fDisableHint = !(WinQueryButtonCheckstate(hwnd, IDR_HINTSENABLED));
      break;

      case IDR_FRAMEAROUNDSTATICS:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      pvc->page2.fFramedUnits = WinQueryButtonCheckstate(hwnd, IDR_FRAMEAROUNDSTATICS);
      break;

      case IDR_FRAMEAROUNDOTHER:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      pvc->page2.fFramedAll = WinQueryButtonCheckstate(hwnd, IDR_FRAMEAROUNDOTHER);
      break;

      case IDR_NOSIZINGBARS:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      pvc->page2.fHideSpacebars = WinQueryButtonCheckstate(hwnd, IDR_NOSIZINGBARS);
      break;

      case IDR_VERTICALLINES:
      if((SHORT2FROMMP(mp1) != BN_CLICKED) && (SHORT2FROMMP(mp1) != BN_DBLCLICKED))
        break;

      pvc->page2.fDrawVertbars = WinQueryButtonCheckstate(hwnd, IDR_VERTICALLINES);
      break;

      case IDR_BORDERWIDTHSLIDER:
      if((SHORT2FROMMP(mp1) == SLN_CHANGE) ||
         (SHORT2FROMMP(mp1) == SLN_SLIDERTRACK))
        {
        pvc->page2.bBorderWidth = (BYTE)GetSliderPos(hwnd, IDR_BORDERWIDTHSLIDER);
        SetTextInt(hwnd, IDR_BORDERWIDTHTEXT, (INT)pvc->page2.bBorderWidth);
        }
      break;

      case IDR_BARSPACINGSLIDER:
      if((SHORT2FROMMP(mp1) == SLN_CHANGE) ||
         (SHORT2FROMMP(mp1) == SLN_SLIDERTRACK))
        {
        pvc->page2.bViewSpacing = (BYTE)GetSliderPos(hwnd, IDR_BARSPACINGSLIDER);
        SetTextInt(hwnd, IDR_BARSPACINGTEXT, (INT)pvc->page2.bViewSpacing);
        }
      break;

      case IDR_UNITSPACINGSLIDER:
      if((SHORT2FROMMP(mp1) == SLN_CHANGE) ||
         (SHORT2FROMMP(mp1) == SLN_SLIDERTRACK))
        {
        pvc->page2.bUnitSpacing = (BYTE)GetSliderPos(hwnd, IDR_UNITSPACINGSLIDER);
        SetTextInt(hwnd, IDR_UNITSPACINGTEXT, (INT)pvc->page2.bUnitSpacing);
        }
      break;

      case IDR_BARHEIGHTSLIDER:
      if((SHORT2FROMMP(mp1) == SLN_CHANGE) ||
         (SHORT2FROMMP(mp1) == SLN_SLIDERTRACK))
        {
        pvc->page2.bRowHeight = (BYTE)GetSliderPos(hwnd, IDR_BARHEIGHTSLIDER);
        SetTextInt(hwnd, IDR_BARHEIGHTTEXT, (INT)pvc->page2.bRowHeight);
        }
      break;

      default: fReExport = FALSE;
      }

    if(fReExport)
      GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 2);

    break;
    }

  case WM_DESTROY:
  //GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 2);
  free(psd);
  return (MRESULT) 0L;

  case WM_COMMAND:
  switch((SHORT)mp1)
    {
    case IDD_UNDO:
    memcpy(&psd->vc.page2, &psd->vcBak.page2, sizeof(psd->vc.page2));
    SetupPage2(hwnd, &psd->vc);
    GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 2);
    break;

    case IDD_DEFAULT:
    DefaultViewConfig(&psd->vc, 2);
    SetupPage2(hwnd, &psd->vc);
    GenExportViewConfig(WinQueryAnchorBlock(hwnd), psd->somSelf, &psd->vc, TRUE, 2);
    break;
    }
  return (MRESULT) 0L;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY Page3SettingsProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
ITEM item;
ULONG i, n;

switch(msg)
  {
  case WM_INITDLG:
  if(fWarp3)
    {
    WinSetWindowULong(WinWindowFromID(hwnd, IDD_HELP), QWL_STYLE, BS_PUSHBUTTON);

    }

  registerListbox(WinQueryAnchorBlock(hwnd));
  WinCreateWindow(hwnd, WC_ALISTBOX, NULL, 0, 0, 0, 0, 0, hwnd, HWND_TOP,
                  IDR_PLUGINLIST, NULL, NULL);

  item.itemFlags = 0;
  item.itemType = ITEMTYPE_TEXT;
  item.itemAlign = ITEMALIGN_LEFT;
  item.bgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0);
  item.fgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_WINDOWTEXT, 0);
  item.text = pszPTitle ? pszPTitle : "Title";
  item.imageHandle = 0;
  item.itemHandle = 0;

  WinSendDlgItemMsg (hwnd, IDR_PLUGINLIST, ALM_INSERTCOLUMN,
                     (MPARAM)&item,
                     MPFROM2SHORT(0, 200));

  item.itemFlags = 0;
  item.itemType = ITEMTYPE_TEXT;
  item.itemAlign = ITEMALIGN_LEFT;
  item.bgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0);
  item.fgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_WINDOWTEXT, 0);
  item.text = pszPlugins ? pszPlugins : "Module";
  item.imageHandle = 0;
  item.itemHandle = 0;

  WinSendDlgItemMsg (hwnd, IDR_PLUGINLIST, ALM_INSERTCOLUMN,
                     (MPARAM)&item,
                     MPFROM2SHORT(0, 300));
  n = 0;

  for(i = 0; i < ulPlugins; i ++)
    {
    USHORT j;
    for(j = 0; j < pPlugin[i].usNumClasses; j ++)
      {
      item.itemFlags = 0;
      item.itemType = ITEMTYPE_TEXT;
      item.itemAlign = ITEMALIGN_LEFT;
      item.bgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_WINDOW, 0);
      item.fgColor = WinQuerySysColor (HWND_DESKTOP, SYSCLR_WINDOWTEXT, 0);
      item.text = pPlugin[i].pwc[j].pszViewName;
      item.imageHandle = 0;
      item.itemHandle = 0;
      WinSendDlgItemMsg(hwnd, IDR_PLUGINLIST, ALM_INSERTITEM, (MPARAM)&item, MPFROM2SHORT(1, n));

      item.itemFlags = 0;
      item.itemType = ITEMTYPE_OBJECT;
      item.itemAlign = ITEMALIGN_LEFT;
      item.text = pPlugin[i].szModule;
      item.imageHandle = WinLoadFileIcon(pPlugin[i].szModule, FALSE);
      item.itemHandle = 0;

      WinSendDlgItemMsg(hwnd, IDR_PLUGINLIST, ALM_INSERTITEM, (MPARAM)&item, MPFROM2SHORT(0, n));

      n ++;
      }
    }

  break;

  case WM_WINDOWPOSCHANGED: // use WM_WINDOWPOSCHANGED instead of WM_SIZE
    {
    PSWP pswp = (PSWP)mp1;

    if(pswp && (pswp->fl & SWP_SIZE) &&
       pswp->cx && pswp->cy && !(pswp->fl & SWP_MINIMIZE))
      {
      WinSetWindowPos(WinWindowFromID(hwnd, IDR_PLUGINLIST), HWND_TOP,
                      0, 0, pswp->cx, pswp->cy, SWP_MOVE | SWP_SIZE | SWP_SHOW);
      }

    break;
    }

  case WM_DESTROY:
  return (MRESULT) 0L;

  case WM_COMMAND:
  return (MRESULT) 0L;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

BOOL	NtbAddSettingsPage(PVOID somSelf, HWND hwndNotebook)
{
PAGEINFO pageinfo;
BOOL brc = TRUE;
fWarp3 = (((WinQueryVersion(WinQueryAnchorBlock(hwndNotebook)) >> 8) & 255) < 40);

if((_wpQueryStyle(somSelf) & OBJSTYLE_TEMPLATE) == 0)
  {
  memset(&pageinfo, 0, sizeof(PAGEINFO));

  pageinfo.cb = sizeof(PAGEINFO);
//  pageinfo.hwndPage = WinLoadDlg(HWND_DESKTOP, NULLHANDLE, (PFNWP)Page3SettingsProc,
//                                 hmSystrayRes, IDR_SYSTRAYPAGE3, NULL);
//
//  if(fWarp3)
//    {
//    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDC_UNDO), QWL_STYLE,
//                      BS_PUSHBUTTON | WS_VISIBLE);
//
//    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDC_DEFAULT), QWL_STYLE,
//                      BS_PUSHBUTTON | WS_VISIBLE);
//
//    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_HELP), QWL_STYLE,
//                      0L); //BS_PUSHBUTTON | WS_VISIBLE | BS_HELP);
//
//    }

  pageinfo.usPageStyleFlags = BKA_MAJOR;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  pageinfo.pfnwp = Page3SettingsProc;
  pageinfo.resid = hmSystrayRes;
  pageinfo.dlgid = IDR_SYSTRAYPAGE3;

  if(!pszPlugins)
    pszPlugins = strdup(GenLoadNls(NULL, IDS_PLUGINS, "Plugins"));

  if(!pszPTitle)
    pszPTitle = strdup(GenLoadNls(NULL, IDS_HEADER, "Title"));

  pageinfo.pszName = pszPlugins;
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;

  pageinfo.pCreateParams = somSelf;
  pageinfo.idDefaultHelpPanel = 100;
  pageinfo.pszHelpLibraryName = szHelpPath;

  _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

  memset(&pageinfo, 0, sizeof(PAGEINFO));

  pageinfo.cb = sizeof(PAGEINFO);
/*  pageinfo.hwndPage = WinLoadDlg(HWND_DESKTOP, NULLHANDLE, (PFNWP)Page2SettingsProc,
                                 hmSystrayRes, IDR_SYSTRAYPAGE2, NULL);

  if(fWarp3)
    {
    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_UNDO), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_DEFAULT), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_HELP), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE | BS_HELP);

    }*/

  pageinfo.usPageStyleFlags = BKA_MAJOR;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  pageinfo.pfnwp = Page2SettingsProc;
  pageinfo.resid = hmSystrayRes;
  pageinfo.dlgid = IDR_SYSTRAYPAGE2;

  if(!pszView)
    pszView = strdup(GenLoadNls(NULL, IDS_VIEW, "View"));

  pageinfo.pszName = pszView;
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;

  pageinfo.pCreateParams = somSelf;
  pageinfo.idDefaultHelpPanel = 100;
  pageinfo.pszHelpLibraryName = szHelpPath;

  _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

  memset(&pageinfo, 0, sizeof(PAGEINFO));

  pageinfo.cb = sizeof(PAGEINFO);
/*  pageinfo.hwndPage = WinLoadDlg(HWND_DESKTOP, NULLHANDLE, (PFNWP)Page1SettingsProc,
                                 hmSystrayRes, IDR_SYSTRAYPAGE1, NULL);

  if(fWarp3)
    {
    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_UNDO), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_DEFAULT), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE);

    WinSetWindowULong(WinWindowFromID(pageinfo.hwndPage, IDD_HELP), QWL_STYLE,
                      BS_PUSHBUTTON | WS_VISIBLE | BS_HELP);

    }*/
  pageinfo.usPageStyleFlags = BKA_MAJOR;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  pageinfo.pfnwp = Page1SettingsProc;
  pageinfo.resid = hmSystrayRes;
  pageinfo.dlgid = IDR_SYSTRAYPAGE1;

  if(!pszSystray)
    pszSystray = strdup(GenLoadNls(NULL, IDS_SYSTRAY, "Systray"));

  pageinfo.pszName = pszSystray;
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;

  pageinfo.pCreateParams = somSelf;
  pageinfo.idDefaultHelpPanel = 101;
  pageinfo.pszHelpLibraryName = szHelpPath;

  brc = _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);
  }

return brc;
}
