/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

#include "systray.h"
#include "settings.h"
#include "lang\str_ids.h"

LONG GetItemTextColor(HWND hwnd)
{
ULONG ulTemp, ulfg;

WinQueryPresParam(hwnd, PP_FOREGROUNDCOLOR, NULL, &ulTemp, sizeof(LONG),
                  &ulfg, QPF_PURERGBCOLOR);

return (LONG)ulfg;
}

LONG GetItemBackColor(HWND hwnd)
{
ULONG ulTemp,ulbg;
WinQueryPresParam(hwnd, PP_BACKGROUNDCOLOR, NULL, &ulTemp, sizeof(LONG),
                  &ulbg, QPF_PURERGBCOLOR);

return (LONG)ulbg;
}

LONG GetItemFont(HWND hwnd, PSZ pszFont)
{
ULONG ulTemp,ulbg;
WinQueryPresParam(hwnd, PP_FONTNAMESIZE, NULL, &ulTemp, 56, pszFont, 0);

return (LONG)strlen(pszFont);
}

VOID SetItemTextColor(HWND hwnd, LONG lColor)
{
WinSetPresParam(hwnd, PP_FOREGROUNDCOLOR, sizeof(LONG), &lColor);
}

VOID SetItemBackColor(HWND hwnd, LONG lColor)
{
WinSetPresParam(hwnd, PP_BACKGROUNDCOLOR, sizeof(LONG), &lColor);
}

VOID SetItemFont(HWND hwnd, PSZ pszFont)
{
WinSetPresParam(hwnd, PP_FONTNAMESIZE, 56, pszFont);
}

INT GetSliderPos(HWND hwnd, ULONG id)
{
return (INT)WinSendDlgItemMsg(hwnd, id, SLM_QUERYSLIDERINFO,
                              MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                              SMA_INCREMENTVALUE), (MPARAM)0L);
}

VOID SetSliderPos(HWND hwnd, ULONG id, ULONG value)
{
WinSendDlgItemMsg(hwnd, id, SLM_SETSLIDERINFO,
                  MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                  SMA_INCREMENTVALUE), (MPARAM)value);
}

INT GetTextInt(HWND hwnd, ULONG id)
{
CHAR buf[CBMAXSTRING];
INT i;

WinQueryDlgItemText(hwnd, id, CBMAXSTRING, buf);
sscanf(buf, "%d", &i);

return i;
}

VOID SetTextInt(HWND hwnd, ULONG id, INT i)
{
CHAR buf[CBMAXSTRING];

sprintf(buf, "%d", i);
WinSetDlgItemText(hwnd, id, buf);
}
