
/*
 *@@sourcefile dlgids.h:
 *      This file declares all the dialog id's common to
 *      all XFolder parts, but only those which are needed
 *      by both the XFolder code and the NLS resource DLLs.
 *
 *      This file is #include'd by the XFolder C code itself
 *      and all the .RC and .DLG files.
 *
 *      DO NOT CHANGE! This is a highly complex system of
 *      id's which has evolved over time, and which I don't
 *      fully understand myself any more. If you alter any
 *      codes here, everything will blow up.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */


#ifndef DLGIDS_HEADER_INCLUDED
    #define DLGIDS_HEADER_INCLUDED

/* Naming conventions:
   All ID's (= def's for integers) begin with "ID_",
   then comes an abbreviation of the usage of the ID:
   -    XF   for XFolder,
   -    XS   for XFolder settings (mostly XFldSystem class),
   -    SD   for XShutdown,
   -    WP   for previously undocumented WPS ID's;
   then comes an abbreviation of the ID type:
   -    M    for a menu template,
   -    MI   for a menu item,
   -    D    for a dialog template,
   -    DI   for a dialog item;
   -    H    for a help panel res id.

   Example:
        ID_SDDI_SKIPAPP is a dlg item ID for use with XShutdown
                        (the "Skip" button in the status window).
*/

// XFolder version flags; since this file is
// #include'd in the NLS DLLs also, this string
// will be readable as a resource in the NLS DLL
#define XFOLDER_VERSION        "0.85"
#define XFOLDER_VERSION_MAJOR  0
#define XFOLDER_VERSION_MINOR  85

// this sets the minimum version number for NLS DLLS
// which XFolder will accept
#define MINIMUM_NLS_VERSION    "0.81 beta"

// icons / bitmaps
#define ID_ICON1               100
#define ID_ICON2               101
#define ID_ICONDLG             102
#define ID_ICONSHUTDOWN        103

#define ID_STARTICON1          104
#define ID_STARTICON2          105
#define ID_SHUTICON1           106
#define ID_SHUTICON2           107

#define ID_ICONSYS             108
#define ID_ICONWPS             109

#define ID_ICONSDANIM1         110
#define ID_ICONSDANIM2         111
#define ID_ICONSDANIM3         112
#define ID_ICONSDANIM4         113
#define ID_ICONSDANIM5         114

#define ID_ICONMENUARROW4      115
#define ID_ICONMENUARROW3      116

#define ID_XFLDRBITMAP         120
/* #define ID_XFLDRBIGLOGO        121 */

/******************************************
 *          Dialog templates              *
 ******************************************/

#define DID_APPLY              98
#define DID_HELP               97
#define DID_UNDO               96
#define DID_DEFAULT            95
#define DID_OPTIMIZE           94
#define DID_REFRESH            93

/* Dialog box templates */
#define ID_XFD_PRODINFO        200
#define ID_XFD_PRODLOGO        201
#define ID_XFD_NOCONFIG        202
#define ID_XFD_NOOBJECT        203
#define ID_XFD_LIMITREACHED    207
#define ID_XFD_WRONGVERSION    208

#define ID_XFD_NOTEXTCLIP      211
#define ID_XFD_NOICONVIEW      212

#define ID_XFD_WELCOME         213
#define ID_XFD_CREATINGCONFIG  214

#define ID_XFD_STARTUPSTATUS   215
#define ID_XFD_NOSTARTUPFLDR   216

#define ID_XFD_SELECTSOME      217

#define ID_XFD_GENERICDLG      219

#define ID_XFD_BOOTUPSTATUS    220

#define ID_XFD_TITLECLASH      230

/******************************************
 *          Dialog items therin           *
 ******************************************/

// for product info
#define ID_XFDI_XFLDVERSION         250

/* Notebook pages */
#define ID_XSD_SET1XFOLDER          401
#define ID_XSD_SET2REMOVEMENUS      402
#define ID_XSD_SET25ADDMENUS        425
#define ID_XSD_SET26CONFIGMENUS     426
#define ID_XSD_SET27STATUSBARS      427
#define ID_XSD_SET28STATUSBARS2     428
#define ID_XSD_SET3SNAPTOGRID       403
#define ID_XSD_SET4ACCELS           404
#define ID_XSD_SET5INTERNALS        405
#define ID_XSD_SETTINGS_DTP1        406
#define ID_XSD_SETTINGS_DTP2        407
#define ID_XSD_SETTINGS_FLDR1       408
#define ID_XSD_SETTINGS_FILEOPS     409

#define ID_XSD_REBOOTEXT            410

#define ID_XSD_AUTOCLOSE            411

#define ID_XSD_SETTINGS_FLDRSORT    412

#define ID_XSD_OBJECTDETAILS        413

#define ID_XSD_SETTINGS_KERNEL1     414
#define ID_XSD_SETTINGS_KERNEL2     415
#define ID_XSD_SETTINGS_HPFS        416
#define ID_XSD_SETTINGS_FAT         417
#define ID_XSD_SETTINGS_CDFS        418
#define ID_XSD_SETTINGS_ERRORS      419
#define ID_XSD_SETTINGS_WPS         420

// "WPSCLASSES" dlgs
#define ID_XSD_SELECTCLASS          450
#define ID_XSD_SETTINGS_WPSCLASSES  451
#define ID_XSD_SETTINGS_WPSCL_INFO  452
#define ID_XSD_SETTINGS_WPSCL_REGISTER 453

/* The following dlg items from the notebook
   settings pages all have a help panel assigned
   to them. This help panel is found in XFLDxxx.HLP
   by calculating the panel ID from the the dlg
   item ID; for this, ID_XSDI_FIRST is used, which
   must be set to the first dlg item which has a
   help panel. As a result, the order of the following
   items must not be changed, or XFolder will miss
   the associated help panels. */

// "XFolder" page
#define ID_XSDI_ADDINTERNALS        500
#define ID_XSDI_FIRST               500

#define ID_XSDI_REPLICONS           501
#define ID_XSDI_FULLPATH            502
#define ID_XSDI_KEEPTITLE           503
#define ID_XSDI_MAXPATHCHARS        504
#define ID_XSDI_MAXPATHCHARS_TX1    901     // text; ID needed for disabling
#define ID_XSDI_MAXPATHCHARS_TX2    902     // text; ID needed for disabling
#define ID_XSDI_TREEVIEWAUTOSCROLL  505

// default WPS menu items
#define ID_XSDI_FIND                506
#define ID_XSDI_SORT                507
#define ID_XSDI_SELECT              508
#define ID_XSDI_WARP4DISPLAY        509
#define ID_XSDI_ARRANGE             510
#define ID_XSDI_INSERT              511

#define ID_XSDI_CHECKDISK           512
#define ID_XSDI_FORMATDISK          513

#define ID_XSDI_HELP                514
#define ID_XSDI_CRANOTHER           515
#define ID_XSDI_COPY                516
#define ID_XSDI_MOVE                517
#define ID_XSDI_SHADOW              518
#define ID_XSDI_DELETE              519
#define ID_XSDI_PICKUP              520
#define ID_XSDI_LOCKINPLACE         521
#define ID_XSDI_PRINT               522

// new menu items
#define ID_XSDI_FILEATTRIBS         523
#define ID_XSDI_COPYFILENAME        524
#define ID_XSDI_MOVE4REFRESH        525
#define ID_XSDI_SELECTSOME          526
#define ID_XSDI_FLDRVIEWS           527
#define ID_XSDI_FOLDERCONTENT       528
#define ID_XSDI_FC_SHOWICONS        529        // skip five

// "XFolder Internals"
#define ID_XSDI_LANGUAGE            535
#define ID_XSDI_DEFAULTTITLE        536
#define ID_XSDI_VARMENUOFFSET       537
#define ID_XSDI_XFOLDERANIMATION    538
#define ID_XSDI_NOSUBCLASSING       539
#define ID_XSDI_NOWORKERTHREAD      540        // skip five plus one

// XDesktop / XShutdown
#define ID_XSDI_DTM_SYSTEMSETUP         547
#define ID_XSDI_DTM_LOCKUP              548
#define ID_XSDI_DTM_SHUTDOWN            549
#define ID_XSDI_SD_RESTARTWPS           550
#define ID_XSDI_SD_ENABLED              551
#define ID_XSDI_SD_REBOOT               552
#define ID_XSDI_SD_ANIMATE              553
#define ID_XSDI_SD_APMPOWEROFF          554
#define ID_XSDI_SD_CONFIRM              555
#define ID_XSDI_SD_AUTOCLOSEVIO         556
#define ID_XSDI_SD_LOG                  557

// misc other stuff
#define ID_XSDI_CASCADE          558
#define ID_XSDI_REMOVEX          559
#define ID_XSDI_APPDPARAM        560

#define ID_XSDI_TPL_DONOTHING    561
#define ID_XSDI_TPL_EDITTITLE    562
#define ID_XSDI_TPL_OPENSETTINGS 563
#define ID_XSDI_TPL_POSITION     564

#define ID_XSDI_CLEANUPINIS      565
#define ID_XSDI_REPLCONFIRMS     566

/* dlg items therein WITHOUT according help panels;
   help is only available for the whole page, which
   will be displayed by the dlg func because a
   corresponding help panel will not be found */

// snap to grid
#define ID_XSDI_SNAPTOGRID       651
#define ID_XSDI_GRID_X           652
#define ID_XSDI_GRID_Y           653
#define ID_XSDI_GRID_CX          654
#define ID_XSDI_GRID_CY          655

// folder hotkeys
#define ID_XSDI_ACCELERATORS     656
#define ID_XSDI_LISTBOX          657
#define ID_XSDI_DESCRIPTION      658
#define ID_XSDI_DESCRIPTION_TX1  659    // text
#define ID_XSDI_CLEARACCEL       660

// status bars 1
#define ID_XSDI_ENABLESTATUSBAR  661
#define ID_XSDI_SBFORICONVIEWS   662
#define ID_XSDI_SBFORTREEVIEWS   663
#define ID_XSDI_SBFORDETAILSVIEWS 664
#define ID_XSDI_SBSTYLE_3RAISED  667
#define ID_XSDI_SBSTYLE_3SUNKEN  668
#define ID_XSDI_SBSTYLE_4RECT    669
#define ID_XSDI_SBSTYLE_4MENU    670

// XFolder page in folder notebook
// (also uses some ID's def'd above)
#define ID_XSDI_FAVORITEFOLDER   671
#define ID_XSDI_QUICKOPEN        672

// extended sort
#define ID_XSDI_ALWAYSSORT       673
#define ID_XSDI_SORTLISTBOX      674
#define ID_XSDI_REPLACESORT      675
#define ID_XSDI_SORTTEXT         676

// XDesktop page 2
#define ID_XSDI_SD_CREATESHUTDOWNFLDR   680
#define ID_XSDI_SD_CREATESTARTUPFLDR    681
#define ID_XSDI_SD_SHOWSTARTUPPROGRESS  682
#define ID_XSDI_SD_STARTUPDELAY         683
#define ID_XSDI_SD_STARTUPDELAYTXT      684

// some more items on page 1
#define ID_XSDI_SD_REBOOTEXT            685
#define ID_XSDI_SD_AUTOCLOSEDETAILS     686
#define ID_XSDI_SD_APMVERSION           687

// "Internals" page in all object notebooks
#define ID_XSDI_DTL_CNR                 688

// status bars page 2
#define ID_XSDI_SBTEXTNONESEL           690
#define ID_XSDI_SBCURCLASS              691
#define ID_XSDI_SBSELECTCLASS           692
#define ID_XSDI_SBTEXT1SEL              693
#define ID_XSDI_SBTEXTMULTISEL          694

// "extended reboot" / "auto-close" dlg items
#define ID_XSDI_XRB_LISTBOX             700
#define ID_XSDI_XRB_NEW                 701
#define ID_XSDI_XRB_DELETE              702
#define ID_XSDI_XRB_UP                  703
#define ID_XSDI_XRB_DOWN                704
#define ID_XSDI_XRB_ITEMNAME            705
#define ID_XSDI_XRB_COMMAND             706
#define ID_XSDI_ACL_WMCLOSE             707
#define ID_XSDI_ACL_CTRL_C              708
#define ID_XSDI_ACL_KILLSESSION         709
#define ID_XSDI_ACL_SKIP                710

// "Select by name" dlg items
#define ID_XFDI_SOME_ENTRYFIELD         750
#define ID_XFDI_SOME_SELECT             751
#define ID_XFDI_SOME_DESELECT           752
#define ID_XFDI_SOME_SELECTALL          753
#define ID_XFDI_SOME_DESELECTALL        754

// generic dlg text
#define ID_XFDI_GENERICDLGTEXT          800
#define ID_XFDI_GENERICDLGICON          801

// "Select class" dlg items; both for separate
// dlg wnd and notebook page
#define ID_XSDI_SC_INTROTEXT            820
#define ID_XSDI_SC_CNR                  821
#define ID_XSDI_SC_TEXT2                822
#define ID_XSDI_SC_BOOTUPSTATUS         823
            // only on notebook page
#define ID_XSDI_SC_CLASSICON            824
            // only on notebook page
#define ID_XSDI_SC_CLASSNAME            825
#define ID_XSDI_SC_REPLACEDBY           826
#define ID_XSDI_SC_CLASSTITLE           827
#define ID_XSDI_SC_CLASSMODULE          828
// "new class" dlg
#define ID_XSDI_SC_DLL                  829
#define ID_XSDI_SC_BROWSE               830
#define ID_XSDI_SC_ICON                 831

// "Title clash" dlg
#define ID_XFDI_CLASH_TXT1              840
#define ID_XFDI_CLASH_RENAMENEW         841
#define ID_XFDI_CLASH_RENAMENEWTXT      842
#define ID_XFDI_CLASH_REPLACE           843
#define ID_XFDI_CLASH_APPEND            844
#define ID_XFDI_CLASH_RENAMEOLD         845
#define ID_XFDI_CLASH_RENAMEOLDTXT      846

#define ID_XFDI_CLASH_DATEOLD           847
#define ID_XFDI_CLASH_TIMEOLD           848
#define ID_XFDI_CLASH_SIZEOLD           849
#define ID_XFDI_CLASH_DATENEW           850
#define ID_XFDI_CLASH_TIMENEW           851
#define ID_XFDI_CLASH_SIZENEW           852

// bootup status
#define ID_XFDI_BOOTUPSTATUSTEXT        859

// CONFIG.SYS settings pages
#define ID_XSDI_OS_CURRENTTHREADS       860
#define ID_XSDI_OS_MAXTHREADS           861
#define ID_XSDI_OS_MAXWAIT              862
#define ID_XSDI_OS_PRIORITYDISKIO       863
#define ID_XSDI_OS_CURRENTSWAPSIZE      864
#define ID_XSDI_OS_PHYSICALMEMORY       865
#define ID_XSDI_OS_MINSWAPSIZE          866
#define ID_XSDI_OS_MINSWAPFREE          867
#define ID_XSDI_OS_SWAPPATH             868

#define ID_XSDI_OS_FSINSTALLED          870
#define ID_XSDI_OS_CACHESIZE            871
#define ID_XSDI_OS_CACHESIZE_AUTO       872
#define ID_XSDI_OS_CACHE_THRESHOLD      873
#define ID_XSDI_OS_CACHE_LAZYWRITE      874
#define ID_XSDI_OS_CACHE_MAXAGE         875
#define ID_XSDI_OS_CACHE_BUFFERIDLE     876
#define ID_XSDI_OS_CACHE_DISKIDLE       877
#define ID_XSDI_OS_AUTOCHECK            878
#define ID_XSDI_OS_AUTOCHECK_PROPOSE    879

#define ID_XSDI_OS_AUTOFAIL             880
#define ID_XSDI_OS_SUPRESSPOPUPS        881
#define ID_XSDI_OS_SUPRESSP_DRIVE       882
#define ID_XSDI_OS_REIPL                883

#define ID_XSDI_OS_AUTO_PROGRAMS        890
#define ID_XSDI_OS_AUTO_TASKLIST        891
#define ID_XSDI_OS_AUTO_CONNECTIONS     892
#define ID_XSDI_OS_AUTO_LAUNCHPAD       893
#define ID_XSDI_OS_AUTO_WARPCENTER      894
#define ID_XSDI_OS_RESTART_YES          895
#define ID_XSDI_OS_RESTART_NO           896
#define ID_XSDI_OS_RESTART_FOLDERS      897
#define ID_XSDI_OS_RESTART_REBOOT       898
#define ID_XSDI_OS_AUTOREFRESHFOLDERS   899

// logo window
#define ID_XFDI_LOGOBITMAP              990

/******************************************
 *          Shutdown defs                 *
 ******************************************/

#define ID_SDICON                       4100   // shutdown icon

/* dlg templates */
#define ID_SDD_MAIN                     4200
#define ID_SDD_STATUS                   4201
#define ID_SDD_CONFIRM                  4202
#define ID_SDD_CAD                      4203
#define ID_SDD_CLOSEVIO                 4204
#define ID_SDD_CONFIRMWPS               4205
#define ID_SDD_BOOTMGR                  4206

/* dlg items */
#define ID_SDDI_LISTBOX                 4301
#define ID_SDDI_BEGINSHUTDOWN           4302
#define ID_SDDI_CANCELSHUTDOWN          4303
#define ID_SDDI_TEXTSHUTTING            4304
#define ID_SDDI_PROGRESSBAR             4305
#define ID_SDDI_STATUS                  4306
#define ID_SDDI_SKIPAPP                 4307
#define ID_SDDI_REBOOT                  4308
#define ID_SDDI_PERCENT                 4309
#define ID_SDDI_MESSAGEAGAIN            4310
#define ID_SDDI_VDMAPPTEXT              4311
#define ID_SDDI_WPS_CLOSEWINDOWS        4312
#define ID_SDDI_ICON                    4313
#define ID_SDDI_BOOTMGR                 4314
#define ID_SDDI_WPS_STARTUPFOLDER       4315

/* command defs (used in the Shutdown wnd proc) */
#define ID_SDMI_CLOSEITEM               4400
#define ID_SDMI_UPDATESHUTLIST          4402
#define ID_SDMI_UPDATEPROGRESSBAR       4403
#define ID_SDMI_FLUSHBUFFERS            4404
#define ID_SDMI_CLOSEVIO                4405
#define ID_SDMI_PREPARESAVEWPS          4406
#define ID_SDMI_SAVEWPSITEM             4407
#define ID_SDMI_BEGINCLOSINGITEMS       4408
#define ID_SDMI_CLEANUPANDQUIT          4409

/******************************************
 *          Menu IDs                      *
 ******************************************/

// context menu in "WPS Classes" container
#define ID_XSM_WPSCLASSES_SEL           (WPMENUID_USER+1000)
#define ID_XSM_WPSCLASSES_NOSEL         (WPMENUID_USER+1001)
#define ID_XSMI_WPS_REGISTER            (WPMENUID_USER+1002)
#define ID_XSMI_WPS_DEREGISTER          (WPMENUID_USER+1003)
#define ID_XSMI_WPS_INFO                (WPMENUID_USER+1004)
#define ID_XSMI_WPS_REPLACE             (WPMENUID_USER+1005)
#define ID_XSMI_WPS_UNREPLACE           (WPMENUID_USER+1006)

// The following menu ID's (with _OFS_ in their names)
// are _variable_ menu ID's: XFolder will add the value
// on the "XFolder Internals" page ("menu item id offset")
// to them to avoid ID conflicts. This value is stored
// internally in the GlobalSettings structure.
#define ID_XFMI_OFS_SEPARATOR           (WPMENUID_USER+1)
#define ID_XFMI_OFS_PRODINFO            (WPMENUID_USER+2)
#define ID_XFMI_OFS_REFRESH             (WPMENUID_USER+3)
#define ID_XFMI_OFS_SNAPTOGRID          (WPMENUID_USER+4)
#define ID_XFMI_OFS_OPENPARENT          (WPMENUID_USER+5)
#define ID_XFMI_OFS_OPENPARENTANDCLOSE  (WPMENUID_USER+6)
#define ID_XFMI_OFS_CLOSE               (WPMENUID_USER+7)
#define ID_XFMI_OFS_RESTARTWPS          (WPMENUID_USER+9)
#define ID_XFMI_OFS_FLDRCONTENT         (WPMENUID_USER+10)
#define ID_XFMI_OFS_DUMMY               (WPMENUID_USER+11)
#define ID_XFMI_OFS_COPYFILENAME_MENU   (WPMENUID_USER+12)      // menu item
#define ID_XFMI_OFS_COPYFILENAME_SHORT  (WPMENUID_USER+13)      // folder hotkeys
#define ID_XFMI_OFS_COPYFILENAME_FULL   (WPMENUID_USER+14)      // folder hotkyes
#define ID_XFMI_OFS_BORED               (WPMENUID_USER+15)
#define ID_XFMI_OFS_SELECTSOME          (WPMENUID_USER+16)
#define ID_XFMI_OFS_PROCESSCONTENT      (WPMENUID_USER+17)

#define ID_XFMI_OFS_CONTEXTMENU         (WPMENUID_USER+18)

#define ID_XFMI_OFS_SORTBYCLASS         (WPMENUID_USER+21)
#define ID_XFMI_OFS_SORTBYEXT           (WPMENUID_USER+27)
#define ID_XFMI_OFS_SORTFOLDERSFIRST    (WPMENUID_USER+28)
#define ID_XFMI_OFS_ALWAYSSORT          (WPMENUID_USER+29)

#define ID_XFM_OFS_ATTRIBUTES           (WPMENUID_USER+31)
#define ID_XFMI_OFS_ATTR_ARCHIVED       (WPMENUID_USER+32)
#define ID_XFMI_OFS_ATTR_SYSTEM         (WPMENUID_USER+33)
#define ID_XFMI_OFS_ATTR_HIDDEN         (WPMENUID_USER+34)
#define ID_XFMI_OFS_ATTR_READONLY       (WPMENUID_USER+35)

#define ID_XFM_OFS_WARP3FLDRVIEW        (WPMENUID_USER+36)
#define ID_XFMI_OFS_SMALLICONS          (WPMENUID_USER+37)
#define ID_XFMI_OFS_FLOWED              (WPMENUID_USER+38)
#define ID_XFMI_OFS_NONFLOWED           (WPMENUID_USER+39)
#define ID_XFMI_OFS_NOGRID              (WPMENUID_USER+40)

#define ID_XFMI_OFS_SHOWSTATUSBAR       (WPMENUID_USER+41)

// this is the value used for variable menu items, i.e.
// those inserted according to the config folder and by
// the "folder content" functions; XFolder will use this
// value (i.e. WPMENUID_USER + "menu item id offset"
// + FIRST_VARIABLE) and increment it until 0x8000 is reached
#define FIRST_VARIABLE                  50
#define ID_XFMI_OFS_VARIABLE            (WPMENUID_USER+FIRST_VARIABLE)

/******************************************
 *          String IDs                    *
 ******************************************/

// XFolder uses the following ID's for language-
// dependent strings. These correspond to the
// string definitions in the NLS .RC file.
// Note that XFolder also uses a message file
// (.MSG) for messages which might turn out to
// be longer than 256 characters.
// These IDs should not have "gaps" in the
// numbers, because OS/2 loads string resources
// in blocks of 16 strings, which does not
// work if the IDs don't have following numbers.
#define ID_XSS_MAIN               2000
#define ID_XSSI_NOTDEFINED        2001
#define ID_XSSI_PRODUCTINFO       2002
#define ID_XSSI_REFRESHNOW        2003
#define ID_XSSI_SNAPTOGRID        2004
#define ID_XSSI_DLLLANGUAGE       2005
#define ID_XSSI_XFOLDERVERSION    2006

#define ID_XSSI_FLDRCONTENT       2007
#define ID_XSSI_COPYFILENAME      2008
#define ID_XSSI_BORED             2009
#define ID_XSSI_FLDREMPTY         2010
#define ID_XSSI_SELECTSOME        2011
// startup/shutdown folder context menu
#define ID_XSSI_PROCESSCONTENT    2012

#define ID_XFSI_QUICKSTATUS       2013

#define ID_XSSI_POPULATING        2014
#define ID_XSSI_SBTEXTNONESEL     2015
#define ID_XSSI_SBTEXTMULTISEL    2016
#define ID_XSSI_SBTEXTWPDATAFILE  2017
#define ID_XSSI_SBTEXTWPDISK      2018
#define ID_XSSI_SBTEXTWPPROGRAM   2019
#define ID_XSSI_SBTEXTWPOBJECT    2020

// folder hotkeys: key descriptions
#define ID_XSSI_KEY_CTRL             2201
#define ID_XSSI_KEY_Alt              2202
#define ID_XSSI_KEY_SHIFT            2203

#define ID_XSSI_KEY_BACKSPACE        2204
#define ID_XSSI_KEY_TAB              2205
#define ID_XSSI_KEY_BACKTABTAB       2206
#define ID_XSSI_KEY_ENTER            2207
#define ID_XSSI_KEY_ESC              2208
#define ID_XSSI_KEY_SPACE            2209
#define ID_XSSI_KEY_PAGEUP           2210
#define ID_XSSI_KEY_PAGEDOWN         2211
#define ID_XSSI_KEY_END              2212
#define ID_XSSI_KEY_HOME             2213
#define ID_XSSI_KEY_LEFT             2214
#define ID_XSSI_KEY_UP               2215
#define ID_XSSI_KEY_RIGHT            2216
#define ID_XSSI_KEY_DOWN             2217
#define ID_XSSI_KEY_PRINTSCRN        2218
#define ID_XSSI_KEY_INSERT           2219
#define ID_XSSI_KEY_DELETE           2220
#define ID_XSSI_KEY_SCRLLOCK         2221
#define ID_XSSI_KEY_NUMLOCK          2222

#define ID_XSSI_KEY_WINLEFT          2223
#define ID_XSSI_KEY_WINRIGHT         2224
#define ID_XSSI_KEY_WINMENU          2225

// folder hotkeys: action descriptions
#define ID_XSSI_LB_REFRESHNOW           3000
#define ID_XSSI_LB_SNAPTOGRID           3001
#define ID_XSSI_LB_SELECTALL            3002
#define ID_XSSI_LB_OPENPARENTFOLDER     3003

#define ID_XSSI_LB_OPENSETTINGSNOTEBOOK 3004
#define ID_XSSI_LB_OPENNEWDETAILSVIEW   3005
#define ID_XSSI_LB_OPENNEWICONVIEW      3006
#define ID_XSSI_LB_DESELECTALL          3007
#define ID_XSSI_LB_OPENNEWTREEVIEW      3008

#define ID_XSSI_LB_FIND                 3009

#define ID_XSSI_LB_PICKUP               3010
#define ID_XSSI_LB_PICKUPCANCELDRAG     3011

#define ID_XSSI_LB_SORTBYNAME           3012
#define ID_XSSI_LB_SORTBYSIZE           3013
#define ID_XSSI_LB_SORTBYTYPE           3014
#define ID_XSSI_LB_SORTBYREALNAME       3015
#define ID_XSSI_LB_SORTBYWRITEDATE      3016
#define ID_XSSI_LB_SORTBYACCESSDATE     3017
#define ID_XSSI_LB_SORTBYCREATIONDATE   3018

#define ID_XSSI_LB_SWITCHTOICONVIEW     3019
#define ID_XSSI_LB_SWITCHTODETAILSVIEW  3020
#define ID_XSSI_LB_SWITCHTOTREEVIEW     3021

#define ID_XSSI_LB_ARRANGEDEFAULT       3022
#define ID_XSSI_LB_ARRANGEFROMTOP       3023
#define ID_XSSI_LB_ARRANGEFROMLEFT      3024
#define ID_XSSI_LB_ARRANGEFROMRIGHT     3025
#define ID_XSSI_LB_ARRANGEFROMBOTTOM    3026
#define ID_XSSI_LB_ARRANGEPERIMETER     3027
#define ID_XSSI_LB_ARRANGEHORIZONTALLY  3028
#define ID_XSSI_LB_ARRANGEVERTICALLY    3029

#define ID_XSSI_LB_INSERT               3030

#define ID_XSSI_LB_SORTBYEXTENSION      3031
#define ID_XSSI_LB_SORTFOLDERSFIRST     3032
#define ID_XSSI_LB_SORTBYCLASS          3033
#define ID_XSSI_LB_OPENPARENTFOLDERANDCLOSE     3034
#define ID_XSSI_LB_SELECTSOME           3035

#define ID_XSSI_LB_CLOSEWINDOW          3036

#define ID_XSSI_LB_CONTEXTMENU          3037
#define ID_XSSI_LB_TASKLIST             3038

#define ID_XSSI_LB_COPYFILENAME_SHORT   3039
#define ID_XSSI_LB_COPYFILENAME_FULL    3040

// FIRST and LAST are used be the notebook func to
// calculate corresponding items
#define ID_XSSI_LB_FIRST                3000
#define ID_XSSI_LB_LAST                 3040

// shutdown strings
#define ID_SDSI_FLUSHING                3100
#define ID_SDSI_CAD                     3101
#define ID_SDSI_REBOOTING               3102
#define ID_SDSI_CLOSING                 3103
#define ID_SDSI_SHUTDOWN                3104
#define ID_SDSI_RESTARTWPS              3105
#define ID_SDSI_RESTARTINGWPS           3106
#define ID_SDSI_SAVINGDESKTOP           3107
#define ID_SDSI_SAVINGPROFILES          3108
#define ID_SDSI_STARTING                3109
#define ID_SDSI_DEFAULT                 3110

// settings page headings
#define ID_XSSI_1GENERIC                3120
#define ID_XSSI_2REMOVEITEMS            3121
#define ID_XSSI_25ADDITEMS              3122
#define ID_XSSI_26CONFIGITEMS           3123
#define ID_XSSI_27STATUSBAR             3124
#define ID_XSSI_3SNAPTOGRID             3125
#define ID_XSSI_4ACCELERATORS           3126
#define ID_XSSI_5INTERNALS              3127
#define ID_XSSI_FILEOPS                 3128

#define ID_XSSI_SORT                    3129
#define ID_XSSI_INTERNALS               3130
#define ID_XSSI_WPSCLASSES              3131

// sort criteria
#define ID_XSSI_SV_NAME                 3132
#define ID_XSSI_SV_TYPE                 3133
#define ID_XSSI_SV_CLASS                3134
#define ID_XSSI_SV_REALNAME             3135
#define ID_XSSI_SV_SIZE                 3136
#define ID_XSSI_SV_WRITEDATE            3137
#define ID_XSSI_SV_ACCESSDATE           3138
#define ID_XSSI_SV_CREATIONDATE         3139
#define ID_XSSI_SV_EXT                  3140
#define ID_XSSI_SV_FOLDERSFIRST         3141

#define ID_XSSI_SV_ALWAYSSORT           3142

// message box strings
// #define ID_XSSI_DLG_CONFIRMCONFIGSYS1   4000
// #define ID_XSSI_DLG_CONFIRMCONFIGSYS2   4001

// "Yes", "no", etc.
#define ID_XSSI_DLG_YES                 4100
#define ID_XSSI_DLG_NO                  4101
#define ID_XSSI_DLG_OK                  4102
#define ID_XSSI_DLG_CANCEL              4103
#define ID_XSSI_DLG_ABORT               4104
#define ID_XSSI_DLG_RETRY               4105
#define ID_XSSI_DLG_IGNORE              4106

// "status bars" page
#define ID_XSSI_SB_CLASSMNEMONICS       4107
#define ID_XSSI_SB_CLASSNOTSUPPORTED    4108

// "WPS Classes" page
#define ID_XSSI_WPSCLASSLOADED          4109
#define ID_XSSI_WPSCLASSLOADINGFAILED   4110
#define ID_XSSI_WPSCLASSREPLACEDBY      4111
#define ID_XSSI_WPSCLASSORPHANS         4112
#define ID_XSSI_WPSCLASSORPHANSINFO     4113

// CONFIG.SYS pages
#define ID_XSSI_SCHEDULER               4114
#define ID_XSSI_MEMORY                  4115
#define ID_XSSI_ERRORS                  4116
#define ID_XSSI_WPS                     4117

// settings submenu strings
#define ID_XFSI_SETTINGS                4118
#define ID_XFSI_SETTINGSNOTEBOOK        4119
#define ID_XFSI_ATTRIBUTES              4120
#define ID_XFSI_ATTR_ARCHIVED           4121
#define ID_XFSI_ATTR_SYSTEM             4122
#define ID_XFSI_ATTR_HIDDEN             4123
#define ID_XFSI_ATTR_READONLY           4124

#define ID_XFSI_FLDRSETTINGS            4125
#define ID_XFSI_SMALLICONS              4126
#define ID_XFSI_FLOWED                  4127
#define ID_XFSI_NONFLOWED               4128
#define ID_XFSI_NOGRID                  4129

#define ID_XFSI_SHOWSTATUSBAR           4131


#endif
