
/*
 * sound.h:
 *      header file for sound support. This is used by both sound.c
 *      (for SOUND.DLL) and various source files for the main DLL.
 *      See sound.c for details.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef SOUND_HEADER_INCLUDED
    #define SOUND_HEADER_INCLUDED

    /* keys for accessing sounds in MMPM.INI */
    #define MMINIKEY_SYSSOUNDS      "MMPM2_AlarmSounds"
    #define MMINIKEY_SOUNDSETTINGS  "MMPM2_AlarmSoundsData"

    // system sound indexes in MMPM.INI
    #define MMSOUND_WARNING         0
    #define MMSOUND_INFORMATION     1
    #define MMSOUND_LOCKUP          10
    #define MMSOUND_ALARMCLOCK      11
    #define MMSOUND_PRINTERROR      12
    #define MMSOUND_ERROR           2
    #define MMSOUND_ANIMATEOPEN     3
    #define MMSOUND_ANIMATECLOSE    4
    #define MMSOUND_DRAG            5
    #define MMSOUND_DROP            6
    #define MMSOUND_SYSTEMSTARTUP   7
    #define MMSOUND_SHUTDOWN        8
    #define MMSOUND_SHREDDER        9

    // new XFolder system sounds
    #define MMSOUND_XFLD_SHUTDOWN   555
    #define MMSOUND_XFLD_RESTARTWPS 556
    #define MMSOUND_XFLD_CTXTOPEN   558
    #define MMSOUND_XFLD_CTXTSELECT 559
    #define MMSOUND_XFLD_CNRDBLCLK  560

    // Quick thread msgs (QM_xxx) for xfdesk.c
    #define QM_BOOTUPSTATUS             WM_USER+140
    #define QM_PLAYSOUND                WM_USER+141
    #define QM_PLAYSYSTEMSOUND          WM_USER+142

    typedef VOID (FN_SNDOPENSOUND)(HWND, PUSHORT, PSZ);
    typedef FN_SNDOPENSOUND *PFN_SNDOPENSOUND;

    typedef VOID (FN_SNDPLAYSOUND)(HWND, PUSHORT, ULONG);
    typedef FN_SNDPLAYSOUND *PFN_SNDPLAYSOUND;

    typedef VOID (FN_SNDSTOPSOUND)(PUSHORT);
    typedef FN_SNDSTOPSOUND *PFN_SNDSTOPSOUND;

#endif
