
/*
 * xshutdwn.h:
 *      header file for xshutdwn.c.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef XSHUTDWN_HEADER_INCLUDED
    #define XSHUTDWN_HEADER_INCLUDED

    /********************************************************************
     *                                                                  *
     *   Declarations                                                   *
     *                                                                  *
     ********************************************************************/

    // shutdown structure for external calls
    typedef struct _SHUTDOWNPARAMS {
        BOOL        optReboot,
                    optConfirm,
                    optDebug,
                    optRestartWPS,
                    optWPSCloseWindows,
                    optAutoCloseVIO,
                    optLog,
                    optAnimate,
                    optAPMPowerOff,
                    optWPSReuseStartupFolder;
        CHAR        szRebootCommand[CCHMAXPATH];
    } SHUTDOWNPARAMS, *PSHUTDOWNPARAMS;

    // traffic light animation
    #define XSD_ANIM_COUNT 8            // animation steps
    typedef struct _SHUTDOWNANIM {
        HPOINTER    ahptr[XSD_ANIM_COUNT];
    } SHUTDOWNANIM, *PSHUTDOWNANIM;

    // this is the user-defined list of auto-close items
    typedef struct AUTOCLOSELISTITEM_STRUCT {
        struct AUTOCLOSELISTITEM_STRUCT
                            *pNext, *pPrevious;
        ULONG               ulSize;
        CHAR                szItemName[100];
        USHORT              usAction;
    } AUTOCLOSELISTITEM, *PAUTOCLOSELISTITEM;

    // auto-close actions
    #define ACL_CTRL_C              1
    #define ACL_WMCLOSE             2
    #define ACL_KILLSESSION         3
    #define ACL_SKIP                4

    // shutdown settings bits: composed by the
    // Shutdown settings pages, stored in
    // pGlobalSettings->XShutdown,
    // passed to xfInitiateShutdown
    #define XSD_DTM_SYSTEMSETUP     0x00001
    #define XSD_DTM_SHUTDOWN        0x00002
    #define XSD_DTM_LOCKUP          0x00004

    #define XSD_ENABLED             0x00010
    #define XSD_CONFIRM             0x00020
    #define XSD_REBOOT              0x00040
    #define XSD_RESTARTWPS          0x00100
    #define XSD_DEBUG               0x01000
    #define XSD_AUTOCLOSEVIO        0x02000
    #define XSD_WPS_CLOSEWINDOWS    0x04000
    #define XSD_LOG                 0x08000
    #define XSD_ANIMATE             0x10000
    #define XSD_APMPOWEROFF         0x20000

    #ifdef SOM_WPObject_h
        typedef struct SHUTLIST_STRUCT {
            struct SHUTLIST_STRUCT  *pNext, *pPrevious;
            ULONG                   ulSize;
            SWCNTRL                 swctl;          // system tasklist structure (see PM ref.)
            WPObject                *pObject;       // NULL for non-WPS windows
            CHAR                    szClass[100];   // window class of the task's main window
        } SHUTLISTITEM, *PSHUTLISTITEM;

        typedef struct _AUTOCLOSEWINDATA
        {
            PAUTOCLOSELISTITEM  pliAutoClose;
            SHORT               sSelected;
            PAUTOCLOSELISTITEM  pliSelected;
            USHORT              usItemCount;
            PSHUTLISTITEM       psliFirst,
                                psliLast;
        } AUTOCLOSEWINDATA, *PAUTOCLOSEWINDATA;

        typedef struct REBOOTLISTITEM_STRUCT {
            struct REBOOTLISTITEM_STRUCT *pNext, *pPrevious;
            ULONG               ulSize;
            CHAR                szItemName[100];
            CHAR                szCommand[CCHMAXPATH];
        } REBOOTLISTITEM, *PREBOOTLISTITEM;

        typedef struct _REBOOTWINDATA
        {
            PREBOOTLISTITEM pliReboot;
            SHORT           sSelected;
            PREBOOTLISTITEM pliSelected;
            USHORT          usItemCount;
        } REBOOTWINDATA, *PREBOOTWINDATA;

    #endif

    /********************************************************************
     *                                                                  *
     *   Prototypes                                                     *
     *                                                                  *
     ********************************************************************/

    BOOL xsdInitiateShutdownExt(PSHUTDOWNPARAMS psdp);

    VOID xsdLoadAnimation(PSHUTDOWNANIM psda);

    VOID xsdFreeAnimation(PSHUTDOWNANIM psda);

    void _Optlink xsd_fntShutdownThread(PVOID ptiMyself);

    MRESULT EXPENTRY fnwpAutoCloseDetails(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

    MRESULT EXPENTRY fnwpRebootExt(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

#endif
