
/*
 * xthreads.h:
 *      header file for xthreads.c.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

// required header files
#include "threads.h"

#ifndef XTHREADS_HEADER_INCLUDED
    #define XTHREADS_HEADER_INCLUDED

    /********************************************************************
     *                                                                  *
     *   Declarations                                                   *
     *                                                                  *
     ********************************************************************/

    // Worker thread msgs (WOM_xxx)
    #define WOM_ADDAWAKEOBJECT          WM_USER+100
    #define WOM_REMOVEAWAKEOBJECT       WM_USER+101
    #define WOM_SHOWFOLDERDATA          WM_USER+102
    #define WOM_REFRESHFOLDERVIEWS      WM_USER+103

    #define WOM_TREEVIEWAUTOSCROLL      WM_USER+110
    #define WOM_DESKTOPREADY            WM_USER+111
    #define WOM_RECREATECONFIGFOLDER    WM_USER+112
    #define WOM_WELCOME                 WM_USER+113
    #define WOM_DONEWITHSTARTUP         WM_USER+114

    #define WOM_INVALIDATEORDEREDCONTENT WM_USER+120
    #define WOM_DELETEICONPOSEA         WM_USER+121
    #define WOM_DELETEFOLDERPOS         WM_USER+122

    #define WOM_PROCESSORDEREDCONTENT   WM_USER+130
    #define WOM_WAITFORPROCESSNEXT      WM_USER+131
    #define WOM_DESKTOPOPENED           WM_USER+132

    #define WOM_UPDATEALLSTATUSBARS     WM_USER+133
    #define WOM_QUICKOPEN               WM_USER+135

    // Quick thread msgs (QM_xxx)
    #define QM_BOOTUPSTATUS             WM_USER+140
    #define QM_PLAYSOUND                WM_USER+141
    #define QM_PLAYSYSTEMSOUND          WM_USER+142

    #define QM_DESTROYLOGO              WM_USER+143

    // flags for recreating config folder (WOM_RECREATECONFIGFOLDER)
    #define RCF_QUERYACTION            0
            // display message box
    #define RCF_EMPTYCONFIGFOLDERONLY  1
            // create empty config folder
    #define RCF_DEFAULTCONFIGFOLDER    2
            // create default config folder
    #define RCF_MAININSTALLFOLDER      3
            // create "main" installation folder

    // MMPM/2 status flags in THREADGLOBALS structure
    #define MMSTAT_UNKNOWN             0
    #define MMSTAT_WORKING             1
    #define MMSTAT_MMDIRNOTFOUND       2
    #define MMSTAT_SOUNDLLNOTFOUND     3
    #define MMSTAT_SOUNDLLNOTLOADED    4
    #define MMSTAT_SOUNDLLFUNCERROR    5
    #define MMSTAT_CRASHED             6


    /*
     * THREADGLOBALS:
     *      global structure shared across all
     *      XFolder threads; accessible thru
     *      xthrQueryGlobals()
     */

    typedef struct _THREADGLOBALS {

        TID                 tidWorkplaceThread;
                                // Workplace thread (PMSHELL.EXE); should be 1

        // debugging flags
        ULONG               ulWorkplaceFunc2,
                            ulMenuFunc,
                            ulMenuFunc2;

        // XFolder Workplace object window handle
        HWND                hwndWorkplaceObject;

        // WPS startup date and time (xthrInitializeThreads)
        DATETIME            StartupDateTime;

        /*
         * Worker thread:
         *      this thread is always running.
         */

        PTHREADINFO         ptiWorkerThread;
        HWND                hwndWorkerObject;

        BOOL                WorkerThreadHighPriority;

        // debugging flags
        ULONG               ulWorkerFunc,
                            ulWorkerFunc2;

        // here comes the linked list to remember all objects which
        // have been awakened by the WPS; this list is maintained
        // by the Worker thread and evaluated during XShutdown

        // root of this linked list
        POBJECTLISTITEM     pliAwakeObjectsFirst,
                            pliAwakeObjectsLast;
        // mutex semaphore for access to this list
        HMTX                hmtxAwakeObjects;

        // count of currently awake objects
        LONG                lAwakeObjectsCount;

        // address of awake WarpCenter; stored by Worker
        // thread, read by Shutdown thread
        WPObject            *pAwakeWarpCenter;

        /*
         * Quick thread:
         *      this thread is always running.
         */

        PTHREADINFO         ptiQuickThread;
        HWND                hwndQuickObject;

        // sound data
        ULONG               ulMMPM2Working;      // MMSTAT_* flags above
        USHORT              usDeviceID;

        // debugging flags
        ULONG               ulQuickFunc,
                            ulQuickFunc2;

        /*
         * Shutdown threads:
         *      the following threads are only running
         *      while XShutdown is in progress.
         */

        PTHREADINFO         ptiShutdownThread,
                            ptiUpdateThread;

        BOOL                fShutdownRunning;

        // debugging flags
        ULONG               ulShutdownFunc,
                            ulShutdownFunc2;

        // shutdown icon; this is only loaded once
        HPOINTER            hSDIcon;

    } THREADGLOBALS, *PTHREADGLOBALS;


    /********************************************************************
     *                                                                  *
     *   Prototypes                                                     *
     *                                                                  *
     ********************************************************************/

    /*
     * xthrQueryGlobals:
     *      this returns the global THREADGLOBALS structure
     *      which contains all kinds of data which need to
     *      be accessed across threads. This structure is
     *      a global structure in xthreads.c.
     *      Note: access to this structure is not generally
     *      serialized. Most of this data is initialized and
     *      updated by the xthr* functions in xthreads.c.
     *      You should therefore only _read_ that data, not
     *      write to it.
     */

    PTHREADGLOBALS xthrQueryGlobals(VOID);

    /*
     * xthrPostWorkplaceObjectMsg:
     *      post msg to thread-1 object window.
     *      This is used from all kinds of places
     *      and different threads.
     */

    BOOL xthrPostWorkplaceObjectMsg(ULONG msg, MPARAM mp1, MPARAM mp2);

    /*
     * xthrSendWorkplaceObjectMsg:
     *      send msg to thread-1 object window.
     *      Note that sending a message from another
     *      thread will block that thread until we return.
     */

    MRESULT xthrSendWorkplaceObjectMsg(ULONG msg, MPARAM mp1, MPARAM mp2);

    /*
     * xthrPostWorkerMsg:
     *      this posts a msg to the XFolder Worker thread object window
     *      and controls this thread's priority at the same time; use this
     *      function instead of WinPostQueueMsg, cos otherwise the
     *      Worker thread gets confused
     */

    BOOL xthrPostWorkerMsg(ULONG msg, MPARAM mp1, MPARAM mp2);

    /*
     * xthrPostQuickMsg:
     *      this posts a msg to the XFolder Quick thread object window.
     */

    BOOL xthrPostQuickMsg(ULONG msg, MPARAM mp1, MPARAM mp2);

    /*
     * xthrPlaySystemSound:
     *      this posts a msg to the XFolder Sound thread in
     *      SOUND.DLL to play a system sound. This should be
     *      failsafe, since successful loading of that DLL
     *      is checked for.
     *      usIndex may be one of the MMSOUND_* values in
     *      "sound.h".
     */

    BOOL xthrPlaySystemSound(USHORT usIndex);

    /*
     * xthrIsPlayingSystemSound:
     *      returns TRUE if the Quick thread is
     *      currently playing a system sound.
     *      This is useful for waiting until it's done.
     */

    BOOL xthrIsPlayingSystemSound(VOID);

    /*
     * xthrInitializeThreads:
     *      this starts both the Worker and Quick threads.
     *      Also, we attempt to load SOUND.DLL and resolve
     *      a few exported functions from there.
     *      This is called from M_WPObject::wpclsInitData
     *      at WPS startup.
     */

    VOID xthrInitializeThreads(VOID);

#endif
