
/*
 * xwps.h:
 *      header file for xwps.c, which contains the
 *      "pseudo SOM methods". See xwps.c for details.
 *
 *      All the functions in this file have the xwps* prefix.
 *
 *      Note: before #include'ing this header, you must
 *      have at least wpobject.h #include'd. Functions which
 *      operate on other WPS classes will only be declared
 *      if the necessary header has been #include'd already.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef XWPS_HEADER_INCLUDED
    #define XWPS_HEADER_INCLUDED

    BOOL xwpsCheckObject(WPObject *pObject);

    #ifdef SOM_WPDisk_h
        WPFolder* xwpsQueryRootFolder(WPDisk* somSelf, APIRET *parc);
    #endif

    #ifdef SOM_WPFolder_h
        BOOL xwpsPopulateTree(WPFolder *somSelf);

        BOOL xwpsCheckIfPopulated(WPFolder *somSelf);

        double xwpsQueryDiskFreeFromFolder(WPFolder *somSelf);

        BOOL xwpsResidesBelow(WPObject *pChild, WPFolder *pFolder);

        WPFileSystem*  xwpsContainsFile(WPFolder *pFolder, PSZ pszRealName);

        WPObject* xwpsCreateFromTemplate(WPObject *pTemplate,
                                    WPFolder* pFolder,
                                    HWND hwndFrame,
                                    USHORT usOpenSettings,
                                    POINTL* pptlMenuMousePos);

        HWND xwpsQueryFrameFromView(WPFolder *somSelf, ULONG ulView);
    #endif

    ULONG xwpsQueryLogicalDriveNumber(WPObject *somSelf);

    BOOL xwpsCopyObjectFileName(WPObject *somSelf, HWND hwndCnr, BOOL fFullPath);

    /*
     * xwpsQueryCnrFromFrame:
     *      this returns the window handle of the container in
     *      a given folder frame. Since this container _always_
     *      has the ID 0x8008, we can safely define this macro.
     */

    #define xwpsQueryCnrFromFrame(hwndFrame) \
                WinWindowFromID(hwndFrame, 0x8008)

#endif
