/*
 * Install WinOS2 Euro support
 *
 * Function:
 *     Install WinOS2 Euro support from the current directory into
 *     the Windows system directory.
 *
 * Notes:
 *     The TTF files are done via both copy and repmod since the copy will
 *     fail if the font is in use by OS/2, and the repmod will fail if the
 *     file is not already installed.
 *
 *     This version does not have the WIN32S path support
 *
 *     To see what is copied do:  install debug
 */
call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'
'@echo off'

/*
 * Locate the windows directory
 */
winos2 = Translate(SysSearchPath('PATH', 'SYSLEVEL.EXE'))
where = pos('SYSLEVEL.EXE', winos2)
if where = 0 then do
   say 'Unable to locale OS/2 system directories.'
   exit 9
end
winos2 = left(winos2, where-1)||'mdos\winos2'
winos2 = translate(winos2, xrange('a','z'), xrange('A','Z'))
winsys = winos2'\system'
say 'Update' winsys

/*
 * Check for a debug request
 */
parse arg debug .
debug = translate(left(debug, 1))
if debug = 'D' then
    tonull = ''
else
    tonull = '>NUL'

/*
 * Do the copy
 */
'xcopy *.fon' winsys tonull
'xcopy *.dll' winsys tonull
'xcopy xlat850.bin' winsys tonull
'xcopy *.ttf' winsys tonull
'repmod arial.ttf  ' winsys'\arial.ttf  '  tonull
'repmod arialbd.ttf' winsys'\arialbd.ttf'  tonull
'repmod arialbi.ttf' winsys'\arialbi.ttf'  tonull
'repmod ariali.ttf ' winsys'\ariali.ttf '  tonull
'repmod cour.ttf   ' winsys'\cour.ttf   '  tonull
'repmod courbd.ttf ' winsys'\courbd.ttf '  tonull
'repmod courbi.ttf ' winsys'\courbi.ttf '  tonull
'repmod couri.ttf  ' winsys'\couri.ttf  '  tonull
'repmod times.ttf  ' winsys'\times.ttf  '  tonull
'repmod timesbd.ttf' winsys'\timesbd.ttf'  tonull
'repmod timesbi.ttf' winsys'\timesbi.ttf'  tonull
'repmod timesi.ttf ' winsys'\timesi.ttf '  tonull

/*
 * Patch GDI.EXE
 */
'wos2efix' winsys
if rc > 0 then do
    say ''
    say 'The GDI.EXE update failed.  Some Euro functions will not work'
    say ''
end

/*
 * Done.  Reboot is needed to get new TrueType fonts in PM
 */
say 'The WinOS2 Euro support is complete.  Some functions may not work'
say 'until you have rebooted your PC.'
