
/* Sccsid %Z% %M% %I% %G% */

/*
**
**	Sybase DB-LIBRARY Version 10
**	Confidential Property of Sybase, Inc.
**	(c) Copyright Sybase, Inc. 1995
**	All rights reserved
*/

/*
** db42to10.h - This is the header file for mapping the DB-Lib 4.2 to 10.0.
*/


#ifndef DB42TO10_H
#define	DB42TO10_H


#ifdef DBMSWIN
#define	WIN3		1
#endif /* DBMSWIN */


/* Include the DB-Lib 10 header files */
#include <sybfront.h>
#include <sybdb.h>
#include <syberror.h>



/*
** DB-Lib Errcode
**
** DB-Lib 4.2 uses errcode define names started with SQL.
** DB-Lib 10 uses errcode define names started with SYB.
** Map the 4.2 errcode define to the 10.
*/
#define	SQLEMEM		SYBEMEM
#define	SQLENULL	SYBENULL
#define	SQLENLOG	SYBEASNL
#define	SQLEPWD		SYBEPWD
#define	SQLECONN	SYBECONN
#define	SQLEDDNE	SYBEDDNE
#define	SQLENULLO	SYBEASNL
#define	SQLESMSG	SYBESMSG
#define	SQLEBTOK	SYBEBTOK
#define	SQLENSPE	SYBEGENOS
#define	SQLEREAD	SYBEREAD
#define	SQLECNOR	SYBECNOR
#define	SQLETSIT	SYBETSIT
#define	SQLEPARM	SYBETYPE
#define	SQLEAUTN	SYBEAUTN
#define	SQLECOFL	SYBECOFL
#define	SQLERDCN	SYBERDCN
#define	SQLEICN		SYBEICN
#define	SQLECLOS	SYBECLOS
#define	SQLENTXT	SYBEDNTI
#define	SQLEDNTI	SYBEDNTI
#define	SQLETMTD	SYBETMTD
#define	SQLEASEC	SYBEASEC
#define	SQLENTLL	SYBENTLL
#define	SQLETIME	SYBETIME
#define	SQLEWRIT	SYBEWRIT
#define	SQLEMODE	SYBEFCON
#define	SQLEOOB		SYBEOOB
#define	SQLEITIM	SYBEITIM
#define	SQLEDBPS	SYBEDBPS
#define	SQLEASNL	SYBEASNL
#define	SQLEASUL	SYBEASUL
#define	SQLENPRM	SYBENPRM
#define	SQLEDBOP	SYBEDPOR
#define	SQLENSIP	SYBENSIP
#define	SQLECNULL	SYBEACNV
#define	SQLESEOF	SYBESEOF
#define	SQLERPND	SYBERPND
#define	SQLECSYN	SYBECSYN
#define	SQLENONET	SYBENLNL
#define	SQLEBTYP	SYBEBTYP
#define	SQLEABNC	SYBEABNC
#define	SQLEABMT	SYBEABMT
#define	SQLEABNP	SYBEABNP
#define	SQLEBNCR	SYBEBNCR
#define	SQLEAAMT	SYBEAAMT
#define	SQLENXID	SYBENXID
#define	SQLEIFNB	SYBEIFNB
#define	SQLEKBCO	SYBEKBCO
#define	SQLEBBCI	SYBEBBCI
#define	SQLEKBCI	SYBEKBCI
#define	SQLEBCWE	SYBEBCWE
#define	SQLEBCNN	SYBEBCNN
#define	SQLEBCOR	SYBEBCOR
#define	SQLEBCPI	SYBEBCPI
#define	SQLEBCPN	SYBEBCPN
#define	SQLEBCPB	SYBEBCPB
#define	SQLEVDPT	SYBEVDPT
#define	SQLEBIVI	SYBEBIVI
#define	SQLEBCBC	SYBEBCBC
#define	SQLEBCFO	SYBEBCFO
#define	SQLEBCVH	SYBEBCVH
#define	SQLEBCUO	SYBEBCUO
#define	SQLEBUOE	SYBEBUOE
#define	SQLEBWEF	SYBEBWEF
#define	SQLEBTMT	SYBEBTMT
#define	SQLEBEOF	SYBEBEOF
#define	SQLEBCSI	SYBEBCSI
#define	SQLEPNUL	SYBENULL
#define	SQLEBSKERR	SYBEBCRE
#define	SQLEBDIO	SYBEBDIO
#define	SQLEBCNT	SYBEBCNT
#define	SQLCRSINV	SYBECRSINV
#define	SQLCRSCMD	SYBERPND
#define	SQLCRSNOIND	SYBECRSNOIND
#define	SQLCRSDIS	SYBECRSDIS
#define	SQLCRSAGR	SYBECRSAGR
#define	SQLCRSORD	SYBECRSORD
#define	SQLCRSMEM	SYBEMEM
#define	SQLCRSBSKEY	SYBECRSBSKEY
#define	SQLCRSNORES	SYBECRSNORES
#define	SQLCRSVIEW	SYBECRSVIEW
#define	SQLCRSBUFR	SYBECRSBUFR
#define	SQLCRSFROWN	SYBECRSFROWN
#define	SQLCRSBROL	SYBCRSBROL
#define	SQLCRSFRAND	SYBECRSFRAND
#define	SQLCRSFLAST	SYBECRSFLAST
#define	SQLCRSRO	SYBECRSRO
#define	SQLCRSTAB	SYBECRSTAB
#define	SQLCRSUPDTAB	SYBECRSUPDTAB
#define	SQLCRSUPDNB	SYBECRSUPDNB
#define	SQLCRSVIIND	SYBECRSVIIND
#define	SQLCRSNOUPD	SYBECRSNOUPD
#define	SQLCRSOS2	SYBEEFUNC
#define	SQLEBCSA	SYBEBCSA
#define	SQLEBCRO	SYBEBCRO
#define	SQLEUVBF	SYBEUVBF
#define	SQLEBIHC	SYBEBIHC
#define	SQLEBWFF	SYBEBWFF



/*
** dbinit
**
** DB-Lib 4.2 dbinit() returns a version string.
** DB-Lib 10 dbinit() returns SUCCEED or FAIL.
** Return dummy string.
*/
#define	dbinit()		(dbinit(), (char far*)"DB-Library 10.0")


/*
** Bind Type
**
** DB-Lib 4.2 has different define names than DB-Lib 10 for two bind types.
*/
#define	SMALLDATETIBIND		SMALLDATETIMEBIND
#define	FLT4BIND		REALBIND



/*
** Server Data Type
** DB-Lib 4.2 has Server data type define names started with SQL.
** DB-Lib 10 has Server data type define names started with SYB.
** Map the DB-Lib 4.2 define names to 10.
*/
#define	SQLBINARY		SYBBINARY
#define	SQLBIT			SYBBIT
#define	SQLCHAR			SYBCHAR
#define	SQLDATETIM4		SYBDATETIME4
#define	SQLDATETIME		SYBDATETIME
#define	SQLDATETIMN		SYBDATETIMN
#define	SQLFLT8			SYBFLT8
#define	SQLFLTN			SYBFLTN
#define	SQLFLT4			SYBREAL
#define	SQLIMAGE		SYBIMAGE
#define	SQLINT1			SYBINT1
#define	SQLINT2			SYBINT2
#define	SQLINT4			SYBINT4
#define	SQLINTN			SYBINTN
#define	SQLMONEY4		SYBMONEY4
#define	SQLMONEY		SYBMONEY
#define	SQLMONEYN		SYBMONEYN
#define	SQLTEXT			SYBTEXT
#define	SQLVARBINARY		SYBVARBINARY
#define	SQLVARCHAR		SYBVARCHAR
#define	SQLARRAY		THIS_DOES_NOT_EXIST


/*
** DBANSItoOEM is not needed in 10.  We put it here for back-compatibility.
** DB-Lib 10 supports Internationalization already.  Iso_1 is same as ANSI
** in Windows.
*/
#define DBANSItoOEM		14	/* Windows only option */

/*
** dbsetopt
**
** DB-Lib 4.2's dbsetopt has only three parameters.
** DB-Lib 10's dbsetopt has four parameters.
*/
#define	dbsetopt(a,b,c)		dbsetopt(a,b,c,-1)


/*
** dbfreelongin
**
** DB-Lib 4.2 has different function name for dbfreelogin than DB-Lib 10.
*/
#define	dbfreelogin(l)		dbloginfree(l)


/*
** dbwinexit
**
** DB-Lib 10 does not need to use dbwinexit().
*/
#define	dbwinexit()	


/*
** DBLOCKLIB/DBUNLOCKLIB
**
** DB-Lib 10 does not need to use DBLOCKLIB/DBUNLOCKLIB
*/
#define	DBLOCKLIB()	
#define	DBUNLOCKLIB()	


/*
** DBRBUF
**
** DBRBUF in DB-Lib 10 only work on Unix.  DBRBUF does the same thing as
** dbdataready().
*/
#ifdef DBRBUF
#undef DBRBUF
#endif /* DBRBUF */

#define	DBRBUF(dbproc)		dbdataready(dbpproc)


/*
** dbiscount
**
** DB-Lib 10 does not have dbiscount().  
*/
#define	dbiscount(dbproc)	(dbcount(dbproc) != -1)




				


#endif /* DB42TO10_H */


