// Contents copyright (c) 1993 John Deurbrouck
/*
**  Includes
*/
#include<windows.h>
#include<commdlg.h>
#include<stdlib.h>
#include<ctype.h>
#include<string.h>
#include"controls.h"
#include"enumfont.h"

/*
**  Defines
*/
#define IDD_GETGOING 200
#define IDM_ABOUT 1
#define IDM_HELP 2

/*
**  Global Variables
*/
int OldLfHeight;
HCURSOR hHourGlass;                     // global so call LoadCursor() just once

/*
**  Function Prototypes
*/
long FAR PASCAL _export WndProc(HWND,UINT,UINT,LONG);
static void show_default_text_settings(HWND hwndDesc);

/*
**  Function Definitions
*/
#pragma argsused
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow){
    MSG msg;
    HWND hwnd;
    WNDCLASS wndclass;
    static LPSTR appname="FntPrn";
    instance=hInstance;
    hHourGlass=LoadCursor(NULL,IDC_WAIT);
    // verify we're in Win 3.1 or better
    {
        DWORD dwVersion=GetVersion();
        unsigned int winver=((unsigned int)LOBYTE(LOWORD(dwVersion)))<<8;
        winver|=(unsigned int)HIBYTE(LOWORD(dwVersion));
        if(winver<0x30A){
            MessageBox(NULL,"FntPrn requires Windows 3.1 or later",
             "ERROR",MB_OK|MB_ICONSTOP);
            return 1;
        }
    }
    if(!hPrevInstance){
        wndclass.style=CS_HREDRAW|CS_VREDRAW;
        wndclass.lpfnWndProc=WndProc;
        wndclass.cbClsExtra=0;
        wndclass.cbWndExtra=DLGWINDOWEXTRA;
        wndclass.hInstance=hInstance;
        wndclass.hIcon=LoadIcon(hInstance,"FntPrn2");
        wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
        wndclass.hbrBackground=COLOR_WINDOW+1;
        wndclass.lpszMenuName=NULL;
        wndclass.lpszClassName=appname;
        RegisterClass(&wndclass);
    }
    hwnd=CreateDialog(hInstance,appname,0,NULL);
    if(!hwnd){
        MessageBox(NULL,"Could not create window","ERROR",MB_OK|MB_ICONSTOP);
        return 1;
    }
    hwndDialog=hwnd;
    // add new options to System Menu
    {
        HMENU hMenu;
        hMenu=GetSystemMenu(hwnd,FALSE);
        if(hMenu!=NULL){
            EnableMenuItem(hMenu,SC_MAXIMIZE,MF_BYCOMMAND|MF_GRAYED);
            EnableMenuItem(hMenu,SC_SIZE,MF_BYCOMMAND|MF_GRAYED);
            AppendMenu(hMenu,MF_SEPARATOR,0,NULL);
            AppendMenu(hMenu,MF_STRING,IDM_ABOUT,"&About...");
            AppendMenu(hMenu,MF_STRING,IDM_HELP,"&Help...");
        }
    }
    // get dialog box initialized
    PostMessage(hwnd,WM_COMMAND,IDD_GETGOING,0L);
    ShowWindow(hwnd,nCmdShow);
    while(GetMessage(&msg,NULL,0,0)){
        // next line intercepts ESC key so IsDialogMessage() can't exit on it
        if((msg.message==WM_KEYDOWN&&msg.wParam==VK_ESCAPE)||(!IsDialogMessage(hwnd,&msg))){
            TranslateMessage (&msg) ;
            DispatchMessage (&msg) ;
        }
    }
    return msg.wParam ;
}

// this is a dialog box procedure but is also the main window
long FAR PASCAL _export WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam){
    static HWND hwndSampletext,hwndJustification,hwndSize,hwndDesc;
    HCURSOR hSaveCursor;
    switch(message){
    case WM_KEYDOWN:
        if(wParam==VK_ESCAPE)return 1;
        break;
    case WM_SYSCOMMAND:
        switch(wParam){
        case IDM_ABOUT:
            MessageBox(hwndDialog,
            "FntPrn 1.0\n"
            "Font Printing Utility\n"
            "Copyright  1993 John Deurbrouck\n\n"
            "First Published in PC Magazine April 13, 1993",
            "FontPrint",MB_OK);
            SetFocus(hwndSortorder);
            return 1;
        case IDM_HELP:
            MessageBox(hwndDialog,
            "FntPrn helps you browse your fonts.\n\n"
            "You choose which fonts to see and how to sort them (Fonts section), "
            "what you want to see in each font (Sample Text section), "
            "and how you want the font names to look (Description Formatting section).\n\n"
            "FntPrn creates a file (FNTPRN.WRI by default) "
            "and optionally starts Write so you can browse or print the report.\n\n"
            "See PC Magazine, April 13, 1993 (Vol. 12 No. 7) for more details.",
            "FontPrint Help",MB_OK);
            SetFocus(hwndSortorder);
            return 1;
        }
        break;
    case WM_COMMAND:
        switch(wParam){
        case IDD_GETGOING:
            // do this instead of WM_INITDIALOG since child windows
            // won't have been created by that time
            hwndSortorder=GetDlgItem(hwnd,IDD_SORTORDER);
            SendMessage(hwndSortorder,CB_INSERTSTRING,0,(LONG)(LPSTR)"Alphabetical");
            SendMessage(hwndSortorder,CB_INSERTSTRING,1,(LONG)(LPSTR)"Height");
            SendMessage(hwndSortorder,CB_INSERTSTRING,2,(LONG)(LPSTR)"Width");
            SendMessage(hwndSortorder,CB_INSERTSTRING,3,(LONG)(LPSTR)"Proportion (Height/Width)");
            SendMessage(hwndSortorder,CB_INSERTSTRING,4,(LONG)(LPSTR)"Weight");
            SendMessage(hwndSortorder,CB_INSERTSTRING,5,(LONG)(LPSTR)"Font Family");
            hwndSampletext=GetDlgItem(hwnd,IDD_SAMPLETEXT);
            SendMessage(hwndSampletext,CB_INSERTSTRING,0,(LONG)(LPSTR)"\"AENOPS abefglmoqsty 801\"");
            SendMessage(hwndSampletext,CB_INSERTSTRING,1,(LONG)(LPSTR)"Text Paragraph");
            SendMessage(hwndSampletext,CB_INSERTSTRING,2,(LONG)(LPSTR)"Alphabet");
            SendMessage(hwndSampletext,CB_INSERTSTRING,3,(LONG)(LPSTR)"\"Sample Text\"");
            hwndJustification=GetDlgItem(hwnd,IDD_JUSTIFICATION);
            SendMessage(hwndJustification,CB_INSERTSTRING,0,(LONG)(LPSTR)"Justified");
            SendMessage(hwndJustification,CB_INSERTSTRING,1,(LONG)(LPSTR)"Left");
            SendMessage(hwndJustification,CB_INSERTSTRING,2,(LONG)(LPSTR)"Center");
            SendMessage(hwndJustification,CB_INSERTSTRING,3,(LONG)(LPSTR)"Right");
            hwndSize=GetDlgItem(hwnd,IDD_SIZE);
            hwndDesc=GetDlgItem(hwnd,IDD_SHOWDESCRIPTION);
            // fall through to set defaults...
        case IDD_DEFAULTS:
            SendMessage(hwndSortorder,CB_SETCURSEL,0,0L);
            SendMessage(hwndSampletext,CB_SETCURSEL,0,0L);
            SendMessage(hwndJustification,CB_SETCURSEL,1,0L);
            CheckRadioButton(hwnd,IDD_PITCHBOTH,IDD_PITCHVARIABLE,IDD_PITCHBOTH);
            CheckRadioButton(hwnd,IDD_DEVICEPRINTER,IDD_DEVICESCREEN,IDD_DEVICEPRINTER);
            CheckDlgButton(hwnd,IDD_SYNTHESIS,1);
            CheckDlgButton(hwnd,IDD_TRUETYPEONLY,0);
            CheckDlgButton(hwnd,IDD_NOVELTY,1);
            CheckDlgButton(hwnd,IDD_MODERN,1);
            CheckDlgButton(hwnd,IDD_ROMAN,1);
            CheckDlgButton(hwnd,IDD_SANSSERIF,1);
            CheckDlgButton(hwnd,IDD_SCRIPT,1);
            CheckDlgButton(hwnd,IDD_OTHERFONTS,1);
            CheckDlgButton(hwnd,IDD_REGULAR,1);
            CheckDlgButton(hwnd,IDD_ITALIC,1);
            CheckDlgButton(hwnd,IDD_BOLD,1);
            CheckDlgButton(hwnd,IDD_BOLDITALIC,1);
            CheckDlgButton(hwnd,IDD_LAUNCHWRITE,1);
            SendMessage(hwndSize,WM_SETTEXT,0,(LONG)(LPSTR)"18");
            default_font="Arial";
            default_ffid=FF_SWISS;
            default_pointsize=16;
            default_just=JUST_LEFT;
            default_bolditalic=0;
            {                           // adjust points to logical units
                HDC hdc=CreateIC("DISPLAY",NULL,NULL,NULL);
                if(hdc==NULL)OldLfHeight=10;
                else{
                    OldLfHeight=MulDiv(-(default_pointsize/2),
                     GetDeviceCaps(hdc,LOGPIXELSY),72);
                    DeleteDC(hdc);
                }
            }
            show_default_text_settings(hwndDesc);
            SetFocus(hwndSortorder);
            return 1;
        case IDOK:                      // make the file
            for(;;){
                SetCapture(hwnd);
                if(hHourGlass!=NULL)hSaveCursor=SetCursor(hHourGlass);
                switch(SendMessage(hwndSortorder,CB_GETCURSEL,0,0L)){
                default:
                case 0: sortorder=ALPHA; break;
                case 1: sortorder=HEIGHT; break;
                case 2: sortorder=WIDTH; break;
                case 3: sortorder=NARROWNESS; break;
                case 4: sortorder=WEIGHT; break;
                case 5: sortorder=FONTTYPE; break;
                }
                if(IsDlgButtonChecked(hwnd,IDD_PITCHFIXED))monospace=MONO;
                else if(IsDlgButtonChecked(hwnd,IDD_PITCHVARIABLE))monospace=VAR;
                else monospace=VARMONO;
                use_printer_context=IsDlgButtonChecked(hwnd,IDD_DEVICEPRINTER)?1:0;
                allow_synthesis=IsDlgButtonChecked(hwnd,IDD_SYNTHESIS)?1:0;
                truetype_only=IsDlgButtonChecked(hwnd,IDD_TRUETYPEONLY)?1:0;
                incl_regular=IsDlgButtonChecked(hwnd,IDD_REGULAR)?1:0;
                incl_bold=IsDlgButtonChecked(hwnd,IDD_BOLD)?1:0;
                incl_italic=IsDlgButtonChecked(hwnd,IDD_ITALIC)?1:0;
                incl_bolditalic=IsDlgButtonChecked(hwnd,IDD_BOLDITALIC)?1:0;
                if(!(incl_regular+incl_bold+incl_italic+incl_bolditalic)){
                    MessageBox(hwnd,"Must select at least one style","Error",MB_OK);
                    SetFocus(GetDlgItem(hwnd,IDD_REGULAR));
                    break;
                }
                incl_novelty=IsDlgButtonChecked(hwnd,IDD_NOVELTY)?1:0;
                incl_modern=IsDlgButtonChecked(hwnd,IDD_MODERN)?1:0;
                incl_roman=IsDlgButtonChecked(hwnd,IDD_ROMAN)?1:0;
                incl_sanserif=IsDlgButtonChecked(hwnd,IDD_SANSSERIF)?1:0;
                incl_script=IsDlgButtonChecked(hwnd,IDD_SCRIPT)?1:0;
                incl_other=IsDlgButtonChecked(hwnd,IDD_OTHERFONTS)?1:0;
                if(!(incl_novelty+incl_modern+incl_roman+incl_sanserif+
                incl_script+incl_other)){
                    MessageBox(hwnd,"Must select at least one font family","Error",MB_OK);
                    SetFocus(GetDlgItem(hwnd,IDD_ROMAN));
                    break;
                }
                switch(SendMessage(hwndSampletext,CB_GETCURSEL,0,0L)){
                default:
                case 0: sample_text_ptr="AENOPS abefglmoqsty 801\r\n"; break;
                case 1: sample_text_ptr="\tThis sample text paragraph is designed to "
                    "demonstrate the readability and appearance of this font in "
                    "full text paragraphs. For best results, import this into a word "
                    "processor and set up a three-column format.\r\n"; break;
                case 2: sample_text_ptr="ABCDEFGHIJKLMNOPQRSTUVWXYZ "
                    "abcdefghijklmnopqrstuvwxyz 1234567890 "
                    "`~!@#$%^&*()_+-=[]{}\\|;:'\",.<>/?\r\n"; break;
                case 3: sample_text_ptr="Sample Text\r\n"; break;
                }
                sample_text_length=lstrlen(sample_text_ptr);
                for(;;){
                    char buf[10],*ptr;
                    int success;
                    sample_text_pointsize=0;
                    if(SendMessage(hwndSize,WM_GETTEXTLENGTH,0,0L)>3)break;
                    SendMessage(hwndSize,WM_GETTEXT,10,(LPARAM)(LPSTR)buf);
                    ptr=buf;
                    success=1;
                    while(*ptr){
                        if(!isdigit(*ptr))success=0;
                        ptr++;
                    }
                    if(success)sample_text_pointsize=atoi(buf);
                    break;
                }
                if(sample_text_pointsize<6||sample_text_pointsize>72){
                    MessageBox(hwnd,"Legal sizes are from 6 to 72","Error",MB_OK);
                    SetFocus(hwndSize);
                    break;
                }
                sample_text_pointsize*=2;
                switch(SendMessage(hwndJustification,CB_GETCURSEL,0,0L)){
                default:
                case 0: sample_text_just=JUST_JUST; break;
                case 1: sample_text_just=JUST_LEFT; break;
                case 2: sample_text_just=JUST_CENTER; break;
                case 3: sample_text_just=JUST_RIGHT; break;
                }
                launchwrite=IsDlgButtonChecked(hwnd,IDD_LAUNCHWRITE)?1:0;
                generate_file_from_options();
                break;
            }
            if(hHourGlass!=NULL)SetCursor(hSaveCursor);
            ReleaseCapture();
            return 1;
        case IDCANCEL:                  // bail out
            PostMessage(hwnd,WM_SYSCOMMAND,SC_CLOSE,0L);
            return 1;
        case IDD_SETDESCRIPTION:        // will do ChooseFont()
            {
                static char picked_face[LF_FACESIZE],picked_style[LF_FACESIZE];
                char stylestring[LF_FACESIZE];
                CHOOSEFONT cf;
                LOGFONT lf;
                memset(&cf,0,sizeof(cf));
                memset(&lf,0,sizeof(lf));
                cf.lStructSize=sizeof(cf);
                cf.hwndOwner=hwnd;
                cf.lpLogFont=&lf;
                cf.Flags=CF_ANSIONLY|CF_INITTOLOGFONTSTRUCT|
                 CF_LIMITSIZE|CF_USESTYLE|CF_SCREENFONTS;
                cf.lpszStyle=(LPSTR)&stylestring;
                cf.nFontType=REGULAR_FONTTYPE;
                cf.nSizeMin=6;
                cf.nSizeMax=72;
                if(default_font!=(LPSTR)&picked_face){
                    lstrcpy(picked_face,default_font);
                    lstrcpy(picked_style,"Regular");
                }
                lstrcpy(lf.lfFaceName,picked_face);
                lf.lfHeight=OldLfHeight;
                lstrcpy(stylestring,picked_style);
                if(!default_just)cf.nFontType=REGULAR_FONTTYPE;
                if(default_just&ITALIC_BIT){
                    lf.lfItalic=1;
                    cf.nFontType|=ITALIC_FONTTYPE;
                }
                if(default_just&BOLD_BIT){
                    lf.lfWeight=FW_BOLD;
                    cf.nFontType|=BOLD_FONTTYPE;
                }
                else lf.lfWeight=FW_NORMAL;
                lf.lfPitchAndFamily=default_ffid;
                if(ChooseFont(&cf)){
                    lstrcpy(picked_face,lf.lfFaceName);
                    default_font=picked_face;
                    default_ffid=lf.lfPitchAndFamily;
                    default_pointsize=cf.iPointSize/5;
                    default_bolditalic=lf.lfItalic?ITALIC_BIT:0;
                    OldLfHeight=lf.lfHeight;
                    lstrcpy(picked_style,stylestring);
                    if(lf.lfWeight>FW_NORMAL)default_bolditalic|=BOLD_BIT;
                    show_default_text_settings(hwndDesc);
                }
            }
            SetFocus(hwndSortorder);
            return 1;
        }
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        return 0;
    }
    return DefWindowProc(hwnd,message,wParam,lParam);
}
// puts description line's formatting into static text
// control on dialog box
static void show_default_text_settings(HWND hwndDesc){
    char buf[LF_FACESIZE+100],*boldit;
    if(default_bolditalic&BOLD_BIT){
        if(default_bolditalic&ITALIC_BIT)boldit="Bold Italic";
        else boldit="Bold";
    }
    else{
        if(default_bolditalic&ITALIC_BIT)boldit="Italic";
        else boldit="Regular";
    }
    wsprintf(buf,"%s, %d pt, %s",
        (LPSTR)default_font,default_pointsize/2,(LPSTR)boldit);
    SendMessage(hwndDesc,WM_SETTEXT,0,(LONG)(LPSTR)buf);
}
