
{////////////////////////////////////////////////////////////////////////////////}
{/////////////////     sample source for WCL_EXT.WXX   //////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

library wcl_ext;

{$F+,G+,K-,I-}
{$C PRELOAD}
{$D Extension Library for WCL}

uses       { #included headers/units}
wintypes,  { Windows data structures }
winprocs,  { Windows API commands }
windos,    { Windows DOS unit - for GetEnvVar() }
strings,   { Borland Pascal strings unit }
wcl_int;   { Pascal interface to wclcode2.dll }


{ Global variables in this DLL }
Const
  WclDC : HDC  = 0; { device context for WCL window }
Var
  Busy : Word;      { keep count of usage of this DLL }

{////////////////////////////////////////////////////////////////////////////////}
{///////// examples of other functions called from UserProc() ///////////////////}
{////////////////////////////////////////////////////////////////////////////////}
Function one : string;
begin
  one := 'Hello World Number 1';
end;

Function two : string;
begin
  two := 'Hello World Number 2';
end;

Function three : string;
begin
  three := 'Hello World Number 3';
end;

{//////////////  sample (and not very good) stdout function //////////}
Procedure WclPrintF(X, Y : Integer; P : PChar);
begin
   TextOut(WclDC, X, Y, p, StrLen(p));
end;


{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////// sample UserProc() function ///////////////////////}
{////////////////////////////////////////////////////////////////////////////////}
Function userproc(TWnd : HWnd; Var Parm : PChar) : integer; export;
var
p, s,
temp : string[128];
Wnd,
i,id : integer;
sArr : PCharArray;
T    : Text;
p1   : array[0..128] of char;


Begin

     WclDC  := GetDC(TWnd);           { get the device context for the wcl window}
     ReleaseDC(TWnd, WclDC);          { release the device context }
     SetBkColor(WclDC,   $00000000);  { black background }
     SetTextColor(WclDC, $006F9FFF);  { light gray foreground }
                                      { for TextOut() calls }

     UserProc := 0; {default: print the results in WCL window }

   s := 'We cannot process this one, sir/madam';   { a silly default message }
   id := BreakPChar(Parm, sArr);      { how many sub strings? }

{examples of calling other functions inside this DLL}
   case id of
     1 : s := one;
     2 : s := two;
     3 : s := three;
   end;

{- lets do some parsing for possible WinExec() -----}
   temp := '';
   p  := Strpas(sArr[1]);                            {first substring = command }
   for i := 1 to length(p) do p[i] := upcase(p[i]);  {convert to uppercase}

   if id > 1 then for i := 2 to id do temp := temp+strpas(sArr[i])+' '
   else temp := strpas(sArr[1]);

   Strpcopy(Parm, temp);

   If  (p = 'HELLO') then    {Hello World message }
     Messagebox(0, sArr[2], sArr[1], mb_ok)
   else

   If  (p = 'EXCOPY') then   {call DOS "COPY" command }
   begin

      If id < 2 then
      begin
        StrPCopy(Parm,'Syntax = EXCOPY <Sourcefile> <TargetDir> ');
        Exit;
      end;

      s := Strpas(GetEnvVar('COMSPEC'))+' /C COPY '+temp;
      Strpcopy(parm, s);
      WinExec(parm, sw_Normal);
      UserProc := -1;        { return -1 so that Parm will not be echoed in the  WCL window}
      exit;
   end
   else

   if  (p = 'MAX') then
   begin
      If id < 2 then
      begin
        StrPCopy(Parm,'Syntax = MAX <progname.exe>');
        Exit;
      end;

      UserProc := -1;
      WinExec(Parm, sw_Maximize);
      exit;
   end

   else if (p = 'EXEC') then
   begin

      If id < 2 then
      begin
        StrPCopy(Parm,'Syntax = EXEC <progname>');
        Exit;
      end;

      UserProc := -1;
      WinExec(Parm, sw_Normal);
      exit;
   end
   else

{ buggy example of reading from a file and displaying the ouput in the
  WCL window
}
   If  (p = 'EXDIR') then {call DOS DIR command; redirect to file}
   begin

      If id < 2 then
      begin
        StrPCopy(Parm,'Syntax = EXDIR <filespec>');
        Exit;
      end;


      If Busy > 1 then
      begin
         UserProc := 1;
         StrPCopy (Parm, 'WCL_EXT.DLL is busy! Please try later.');
         Exit;
      end;

      s := Strpas(GetEnvVar('COMSPEC'))+' /C DIR '+temp+' > C:\$$$$.$$$';
      Strpcopy(parm, s);

      ShowHourGlass;
      WinExecWait(parm, sw_Hide);    {Exec and wait till program finishes }

      { read the contents of output file and display in WCL window }
      Assign(T, 'C:\$$$$.$$$');
      Reset(T);
      If IoResult <> 0 then {};

      StrPCopy(Parm, '');

      While Not Eof(T) do
      begin
         ShowHourGlass;
         Readln(T, s);
         Strpcopy(p1, ' '+s+#13);
         StrCat(Parm, p1);
      end;

      Close(T);
      Erase(T);
      If IoResult <> 0 then {};
      RestoreCursor;
      UserProc := 1; { return 1 so that Parm will be echoed in the  WCL window}
      exit;
   end;

{----- we get here because the command did not fall within our parsing;
       so lets print some junk -----------}

   StrPCopy(parm, s);

   for i := 1 to id do
   begin
     strcat(parm, ' '+#13);
     strcat(parm, sArr[i]);   {this will be echoed in the WCL window }
   end;

   Wnd := 150;                        { starting Y co-ordinate}
   id  := 20;                         { line height }

   If (p = 'TEXTOUT')  then
   for i := 1 to 5 do                 {loop using wclprintf() }
   begin
     WclPrintF(1, Wnd, parm);
     StrCat(parm, ' and this!');
     Inc(Wnd, id);
   end;
end {UserProc};
{///////////////////////////////////////////////////////////////////////////}


{///////////////////////////////////////////////////////////////////////////}
{////////////// sample  IsvalidCommand function  /////////////////////////////////////}
Function IsValidCommand(Cmd : PChar) : Integer; Export;
Const
Max = 7;
Size= 8;

var
s : string;
i : byte;

Const
ValidCommands : Array[1..Max] of String[Size] =
('HELLO', 'EXCOPY', 'MAX', 'EXEC', 'EXDIR', 'TEXTOUT','TEST');


begin

   IsValidCommand := 1;   { assume error }
   s := TrimString(Strpas(StrUpper(Cmd))); { trim it, turn it to uppercase }

   If s = '' then Exit;  { empty string passed; return }

   i := Pos(' ',s);      { look for a space - end of first substring }
   If i  > 0 then        { a space is found! }
   Delete(s, i, (length(s)-pred(i)) ); { remove everything from the space }

   for i := 1 to max do
   if (s = ValidCommands[i])  { compare result with valid commands }
   then
   begin
      IsValidCommand := 0;     { when you find a match, return }
      Inc(Busy);               { increment usage count of this DLL }
      Exit;
   end;
    { if we get here, no match was found; function returns 1 }
end;


{///////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}
{///////////////////////// exports section ///////////////////}
exports
    UserProc index 1,
    IsValidCommand index 2;


{///////////////////////// initialization section ////////////}
begin
     Busy := 0;
end.

