#include <stdio.h>
#include <functional>
#include <type_traits>
#include <typeinfo>

#define WR         /*read-write*/
#define RC         /*recursive*/
#define API        /*namespace-api*/

#define interface  class
#define mixin      class

#define extends    public
#define implements public
#define imports    private
#define export     using
#define transitive /*export-not-required*/
#define DI         /*dependency-injection*/

#define var        auto /*new-heap-var*/
#define let        /*new-heap-let-type*/

#define with       std::function        // Method with External Method
#define self_ptr   this                 // Calling Chain Link to Self
#define mix        (*this)              // Calling to Mix-in

#define at         class
#define on         class

#define type       typename
#define type_of    enable_if_same_type

#define include    if constexpr
#define PURE_C     1
#define STD_API    1
#define OS2_API    1
#define X11_API    1

#define size_of(x) ( sizeof (x) )
#define array_size(x) ( sizeof (x) )
#define array_length(x) ( sizeof (x) / sizeof (x[0]) )

#define free(ptr) ( delete *ptr, *ptr = NULL )

#define t_id(x) ( typeid (x).hash_code () )
#define t_name(x) ( typeid (x).name () )

#define error(ec) ( exit (ec + (fprintf (stderr, "Error: %d, %s(), %s, line %d." "\n", \
                                                 ec, __FUNCTION__, __FILE__, __LINE__) * 0)) )

typedef void struct_ptr;

typedef unsigned char      byte;
typedef unsigned long      ulong;
typedef unsigned short     ushort;
typedef unsigned long long ulong64;

typedef unsigned long      hfile;
typedef unsigned long      hmq;
typedef unsigned long      hwnd;

template <type T, type U> inline constexpr
     int enable_if_same_type = std::is_same <T, U>::value;

/* * */

namespace geometry
{
  template <type T> struct Point
  {
    T x, y = 0;

    Point (with <void (Point <T> WR *)> init = NULL)
    {
      if (init) init (self_ptr);
    }

    byte is_empty ()
    {
      return (!x && !y) ? 1 : 0;
    }
  };
}

export geometry::Point;

/* * */

int main ()
{
  Point <int> abc = {};
  struct_ptr WR *def = (struct_ptr *) &abc;
  Point <int> WR *xyz = (Point <int> *) def;

  xyz = new Point <int> {0};

  def = xyz;

  var *zvx = new Point <byte> ([=] (var WR *p) {
                                                 p->x = (byte) (xyz->x - 1);
                                                 p->y = (byte) (xyz->y - 1);
                                               });

  printf ("%d" "\n" "%d" "\n", abc.x, xyz->x);
  printf ("%d" "\n" "%d" "\n", zvx->x, zvx->y);

  printf ("%d" "\t" "%s" "\n", t_id (abc),  t_name (abc));
  printf ("%d" "\t" "%s" "\n", t_id (&abc), t_name (&abc));
  printf ("%d" "\t" "%s" "\n", t_id (*xyz), t_name (*xyz));
  printf ("%d" "\t" "%s" "\n", t_id (xyz),  t_name (xyz));

  printf ("%d" "\n", abc.is_empty ());
  printf ("%d" "\n", xyz->is_empty ());

  free (&xyz);
  free (&zvx);

  return 0;
}
