# CK9CRS.MAK, version 1, 10/13/93, Lieven Tomme <ltom@lvd.be>
# based on CK9KER.MAK
#
#   ###################################################
#   # Makefile to build C-Kermit 5A (189) for os9/68k #
#   # using the HP-UX C cross compiler 'cc68'         #
#   ###################################################
#
#
#
# Before proceeding, read the instructions below, and also do read the file
# ck9ker.bwr (the "beware file"), and then rename this file to "makefile"
# or "Makefile", and then:
#
# for os9/68k :        "make"
# to clean up things : "make clean"
#
# or don't rename it and type : "make -f=ck9crs.mak"
# amd to clean up things :      "make clean"
#
###########################################################################
#
# Notes :
#
#   Change KERMIT_OPTIONS according to the version you want to build
#   Change SOURCE_DIR     to the directory where the sources can be found
#   Change RELS_DIR       to the directory where the relocatble files have
#                         to be put
#   Change CC_OPTIONS     according to your target system
#   Change TARGET         to the name of the resulting module (wermit, kermit)
#   Change the fixmod command options according to your whishes.



##
## Kermit options :
##

#   If Kermit is too large for your machine you can add some
#   defines to make it smaller:
#   -dNODEBUG   don't include debugging information
#   -dNOHELP    no on-line help
#   -dNOTLOG    no transaction logging
#   -dNOSCRIPT  no UUCP-style script command
#   -dNOCSETS   no character set translation
#   -dNOMSEND   no msend command
#   -dNOICP     no interactive command parser
#   -dNODIAL    no modem support
#   -dNOXMIT    no tranmit command
#   -dNOSPL     no script programming language
#   Edit the TYPE macro according to your machine.
#
#   If you have problems changing the line speed do read ck9ker.bwr and
#   add -dXMODE option to the CFLAGS if neccessary and wanted (see ck9ker.bwr)
#
#   for futher information see ckuins.doc (installation manual)
###########################################################################
# 
#  minimum size KERMIT_OPTIONS :
#       -dVOID=void -dSIG_V -dDYNAMIC -dNODEBUG \
#       -dNOHELP -dNOTLOG -dNOSCRIPT -dNOCSETS -dNOMSEND -dNODIAL -dNOICP
#  maximum size KERMIT_OPTIONS :
#       -dVOID=void -dSIG_V -dDYNAMIC -dPARSENSE -dKANJI -dMYCURSES
KERMIT_OPTIONS  = -dVOID=void -dSIG_V -dDYNAMIC -dPARSENSE -dKANJI -dMYCURSES



##
## sources directory
##
SOURCE_DIR      = ./


##
## relocatables directory
##
RELS_DIR  = ./rels/


##
## compiler options
##

#    
#   -k=<n>[W|L][CW|CL][F]
#               Target machine - 0=68000, 2=68020
#               Data offsets - W=word, L=long word
#               Code offsets - CW=word, CL=long word
#               Floating Point - F=68881 (68020 only)
#
CC_OPTIONS  = $(KERMIT_OPTIONS) -R=$(RELS_DIR) -k=2CL -t=/tmp -r -x -i -s -q
LNKFLAGS    = -a
CC          = cc68
ASM         = r68
ASM_OPTIONS =

TARGET      = rels/wermit




############################
## relocatable files       #
############################
KERMIT_FILES =    $(RELS_DIR)ckcmai.r \
                  $(RELS_DIR)ckucmd.r \
                  $(RELS_DIR)ckuusr.r \
                  $(RELS_DIR)ckuus2.r \
                  $(RELS_DIR)ckuus3.r \
                  $(RELS_DIR)ckuus4.r \
                  $(RELS_DIR)ckuus5.r \
                  $(RELS_DIR)ckuus6.r \
                  $(RELS_DIR)ckuus7.r \
                  $(RELS_DIR)ckuusx.r \
                  $(RELS_DIR)ckuusy.r \
                  $(RELS_DIR)ckcpro.r \
                  $(RELS_DIR)ckcfns.r \
                  $(RELS_DIR)ckcfn2.r \
                  $(RELS_DIR)ckcfn3.r \
                  $(RELS_DIR)ckuxla.r \
                  $(RELS_DIR)ck9con.r \
                  $(RELS_DIR)ck9tio.r \
                  $(RELS_DIR)ck9fio.r \
                  $(RELS_DIR)ck9asm.r \
                  $(RELS_DIR)ckudia.r \
                  $(RELS_DIR)ckuscr.r




$(TARGET): $(KERMIT_FILES) \
        makefile
        @rm -f *.stb *.dbg
        @l68 $(LNKFLAGS) /usr/local/os9/lib/cstart.r \
        -l=/usr/local/os9/lib/clibn.l \
        -l=/usr/local/os9/lib/math.l \
        -l=/usr/local/os9/lib/sys.l \
        -o=$(TARGET) \
        $(KERMIT_FILES)
        @fixmod -uo0.0 -ua8000 $(TARGET)
        @ll $(TARGET)

clean:
        rm -f $(RELS_DIR)ck*.r $(TARGET)





######################
## relocatable files #
######################

$(RELS_DIR)ckcmai.r: $(SOURCE_DIR)ckcmai.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcsym.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcnet.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckcmai.c

$(RELS_DIR)ckucmd.r: $(SOURCE_DIR)ckucmd.c \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcdeb.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckucmd.c

$(RELS_DIR)ckuusr.r: $(SOURCE_DIR)ckuusr.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcnet.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuusr.c

$(RELS_DIR)ckuus2.r: $(SOURCE_DIR)ckuus2.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuus2.c

$(RELS_DIR)ckuus3.r: $(SOURCE_DIR)ckuus3.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcnet.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuus3.c

$(RELS_DIR)ckuus4.r: $(SOURCE_DIR)ckuus4.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcnet.h \
                     $(SOURCE_DIR)ckuver.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuus4.c

$(RELS_DIR)ckuus5.r: $(SOURCE_DIR)ckuus5.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuus5.c

$(RELS_DIR)ckuus6.r: $(SOURCE_DIR)ckuus6.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuus6.c

$(RELS_DIR)ckuus7.r: $(SOURCE_DIR)ckuus7.c \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcnet.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuus7.c

$(RELS_DIR)ckuusx.r: $(SOURCE_DIR)ckuusx.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckuusr.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuusx.c

$(RELS_DIR)ckuusy.r: $(SOURCE_DIR)ckuusy.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuusy.c

$(RELS_DIR)wart: $(SOURCE_DIR)ckwart.c 
        cc -o $(RELS_DIR)wart $(SOURCE_DIR)ckwart.c

$(SOURCE_DIR)ckcpro.c: $(SOURCE_DIR)ckcpro.w \
                       $(RELS_DIR)wart \
                       $(SOURCE_DIR)ckcdeb.h \
                       $(SOURCE_DIR)ckcasc.h \
                       $(SOURCE_DIR)ckcker.h
        $(RELS_DIR)wart $(SOURCE_DIR)ckcpro.w $(SOURCE_DIR)ckcpro.c

$(RELS_DIR)ckcpro.r: $(SOURCE_DIR)ckcpro.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckcpro.c

$(RELS_DIR)ckcfns.r: $(SOURCE_DIR)ckcfns.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcsym.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h
        $(CC) $(CC_OPTIONS) $(SOURCE_DIR)ckcfns.c

$(RELS_DIR)ckcfn2.r: $(SOURCE_DIR)ckcfn2.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcsym.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckcfn2.c

$(RELS_DIR)ckcfn3.r: $(SOURCE_DIR)ckcfn3.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcsym.h \
                     $(SOURCE_DIR)ckcasc.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckcfn3.c

$(RELS_DIR)ckuxla.r: $(SOURCE_DIR)ckuxla.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcxla.h \
                     $(SOURCE_DIR)ckuxla.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuxla.c

$(RELS_DIR)ck9con.r: $(SOURCE_DIR)ck9con.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ck9con.c

$(RELS_DIR)ck9tio.r: $(SOURCE_DIR)ck9tio.c \
                     $(SOURCE_DIR)ckcdeb.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ck9tio.c

$(RELS_DIR)ck9fio.r: $(SOURCE_DIR)ck9fio.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ck9fio.c

$(RELS_DIR)ck9asm.r: $(SOURCE_DIR)ck9asm.a
        $(ASM)  $(ASM_OPTIONS) -o=$(RELS_DIR)ck9asm.r $(SOURCE_DIR)ck9asm.a 

$(RELS_DIR)ckudia.r: $(SOURCE_DIR)ckudia.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckucmd.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckudia.c

$(RELS_DIR)ckuscr.r: $(SOURCE_DIR)ckuscr.c \
                     $(SOURCE_DIR)ckcker.h \
                     $(SOURCE_DIR)ckcdeb.h \
                     $(SOURCE_DIR)ckcasc.h
        $(CC)  $(CC_OPTIONS) $(SOURCE_DIR)ckuscr.c

