# CK9KER.MAK, version 1, 04/30/87 Robert Larson
#             version 2, 04/12/91 Christian Hemsing for kermit 5a
#             version 3, 03/04/92 kermit 5a,beta; explicit 680x0 distinction
#             version 4, 10/01/92 kermit 5a,beta; added MYCURSES
#             version 5, 01/05/95 kermit 5A(190); add CK_APC, CK_REDIR, RENAME
#             version 6, 06/18/96 C-Kermit 6.0.192, fdc, add ck[cu]sig.[ch]
#             version 7, 07/05/96 James Jones, corrected ckcsig.h, ckwart.c
#                                 dependencies
#             version 8, 12/11/96 Add -ltermlib.l to LFLAGS macro
#             version 9, 11 Feb 1998 - fdc - Add -dNORANDOM for C-Kermit 6.1.
#             version 10, 27 Jul 1998 - Gregorie Martin - first 32-bit build.
#             version 11, 1 Jan 99 - fdc - Add ckclib and ckctel modules.
#             version 12, 21 Apr 99 - Martin Whitaker - allowed makefile to be
#                                     in different directory to source files,
#                                     fixed flags passed to compiler to stop
#                                     processor type being specified twice.
#             version 13, 28 May 99 - Martin Whitaker - included ckcnet module
#                                     in build even when no network support is
#                                     required.
#             version 14, 07 Aug 99 - Martin Whitaker - added ckcuni module.
#
# based on ckuker.mak
#
# -- Makefile to build C-Kermit for OS-9/68k
#
# Before proceeding, read the instructions below, and also do read the file
# ck9ker.bwr (the "beware file"), and then rename this file to "makefile"
# and type:
#
# 	make
#
# or don't rename it and type:
#
#	make -f=ck9ker.mak
#
###############################################################################
#
# Notes:
#
#   Change ODIR to where you want the executable (must be an absolute path).
#   Change RDIR to where you want the rels (can be a relative path).
#   Change SDIR to where you put the source files (can be a relative path).
#
ODIR = /h0/user/system/bin
RDIR = ./obj
SDIR = ./src
#
#   Change CLIB to where you keep your C libraries (can be a relative path).
#
CLIB = /h0/lib/c/lib
#
#   Edit the PROGRAM macro to the name you want kermit to have. Note that this
#   will be the module name, even if you subsequently rename the file.
#
PROGRAM = kermit
#
#   Use the appropriate TYPE macro depending on your processor.
#
TYPE = 0	# use this if you compile for 68000,68008,68010 or 68070
#TYPE = 2	# use this if you compile for 68020,68030
#
#   For network support, enable the following lines:
#
#NET_CFLAGS = -dTCPSOCKET
#NET_LFLAGS = -l=$(CLIB)/netdb.l -l=$(CLIB)/socklib.l
#
#   otherwise enable the following lines:
#
NET_CFLAGS =
NET_LFLAGS =
#
#   If Kermit is too large for your machine you can add some
#   defines to make it smaller:
#
#     -dNODEBUG   don't include debugging information
#     -dNOHELP    no on-line help
#     -dNOTLOG    no transaction logging
#     -dNOSCRIPT  no UUCP-style script command
#     -dNOCSETS   no character set translation
#     -dNOMSEND   no msend command
#     -dNOICP     no interactive command parser
#     -dNODIAL    no modem support
#     -dNOXMIT    no transmit command
#     -dNOSPL     no script programming language
#
#   If you have problems changing the line speed do read ck9ker.bwr, and add
#   the -dXMODE option to CPPFLAGS if necessary and wanted (see ck9ker.bwr).
#
#   minimum size:
#
#CPPFLAGS = -dVOID=void -dSIG_V -dDYNAMIC -dZFCDAT -dNOHELP -dNOSCRIPT \
# -dNOSPL -dNOCSETS -dNOMSEND -dNODIAL -dNOICP -dNORANDOM -dNODEBUG -dNOTLOG
#
# minimum size with debug:
#
#CPPFLAGS = -dVOID=void -dSIG_V -dDYNAMIC -dZFCDAT -dNOHELP -dNOSCRIPT \
# -dNOSPL -dNOCSETS -dNOMSEND -dNODIAL -dNOICP -dNORANDOM
#
# maximum size:
#
CPPFLAGS = -dVOID=void -dSIG_V -dDYNAMIC -dZFCDAT -dPARSENSE -dKANJI -dNOANSI \
 -dMYCURSES -dCK_APC -dCK_REDIR -dRENAME -dCK_TTYFD -dNOOLDMODEMS -dNORANDOM
#
#   If you don't have a ramdisk named /r0, remove the -t=/r0 option. If you
#   don't want to use the math trap handler, remove the -x option. If you
#   don't want to use the cio trap handler, remove the -i option. 
#
CCFLAGS = -qx -t=/r0 -v=$(SDIR)
LCFLAGS = -qx -t=/r0 -i
#
#   For further information see ck9ins.doc (installation manual).
#
###############################################################################
#
# Compile and Link variables:
#
#   Note that CFLAGS forces 32 bit data offsets to be used. If you have
#   chosen to remove some of the features to make kermit smaller, this
#   may not be necessary. Check the data size of the kermit module, if
#   it is < 64K, you can compile with 16 bit data offsets, which will
#   result in smaller, faster code on a 68000/68010.
#
CC = cc
RC = r68
LC = cc
CFLAGS = $(CCFLAGS) $(CPPFLAGS) $(NET_CFLAGS) -k=$(TYPE)l
LFLAGS = $(LCFLAGS) $(NET_LFLAGS) -l=$(CLIB)/termlib.l
#
#   Some modules have grown too large for 16 bit code offsets, so must be
#   compiled with the following flags. Note that there is a bug in o68 when
#   dealing with expressions of the form 'flag ? "string1" : "string2"'
#   compiled using 32 bit pc relative offsets on a 68000, so the optimiser
#   pass is disabled. This may not be necessary if you are compiling for a
#   68020 or above. If you have gone for a reduced size kermit, you may be
#   able to compile some of the affected modules with the normal CFLAGS,
#   which will result in smaller, faster code on a 68000/68010.
#
BIGCFLAGS = $(CCFLAGS) $(CPPFLAGS) $(NET_CFLAGS) -k=$(TYPE)lcl -o
#
#   ckuus2 produces such large intermediary files during compilation that they
#   don't fit on a 1MB RAM disk, so must be compiled with the following flags.
#
HUGECFLAGS = -qx -v=$(SDIR) $(CPPFLAGS) $(NET_CFLAGS) -k=$(TYPE)lcl -o
#
###############################################################################
#
# Dependencies Section:
#
RFILES =\
	$(RDIR)/ckcmai.r\
	$(RDIR)/ckclib.r\
	$(RDIR)/ckucmd.r\
	$(RDIR)/ckuusr.r\
	$(RDIR)/ckuus2.r\
	$(RDIR)/ckuus3.r\
	$(RDIR)/ckuus4.r\
	$(RDIR)/ckuus5.r\
	$(RDIR)/ckuus6.r\
	$(RDIR)/ckuus7.r\
	$(RDIR)/ckuusx.r\
	$(RDIR)/ckuusy.r\
	$(RDIR)/ckcpro.r\
	$(RDIR)/ckcfns.r\
	$(RDIR)/ckcfn2.r\
	$(RDIR)/ckcfn3.r\
	$(RDIR)/ckctel.r\
	$(RDIR)/ckuxla.r\
	$(RDIR)/ck9con.r\
	$(RDIR)/ck9tio.r\
	$(RDIR)/ck9fio.r\
	$(RDIR)/ck9ren.r\
	$(RDIR)/ck9asm.r\
	$(RDIR)/ckudia.r\
	$(RDIR)/ckuscr.r\
	$(RDIR)/ckusig.r\
	$(RDIR)/ckcnet.r\
	$(RDIR)/ckcuni.r

$(ODIR)/$(PROGRAM):\
	$(RFILES)
	$(LC) $(LFLAGS) -m=17 -f=$@ $(RFILES)

$(RDIR)/ckcmai.r:\
	$(SDIR)/ckcmai.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckcsig.h 

$(RDIR)/ckclib.r:\
	$(SDIR)/ckclib.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcdeb.h 

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckcpro.r:\
	$(SDIR)/ckcpro.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

$(SDIR)/ckcpro.c:\
	$(SDIR)/ckcpro.w\
	$(ODIR)/wart
	$(ODIR)/wart $(SDIR)/ckcpro.w $(SDIR)/ckcpro.c

$(ODIR)/wart:\
	$(RDIR)/ckwart.r
	$(LC) $(LFLAGS) -f=$@ $(RDIR)/ckwart.r

$(RDIR)/ckwart.r:\
	$(SDIR)/ckwart.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h 

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckcfns.r:\
	$(SDIR)/ckcfns.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

$(RDIR)/ckcfn2.r:\
	$(SDIR)/ckcfn2.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 

$(RDIR)/ckcfn3.r:\
	$(SDIR)/ckcfn3.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 

$(RDIR)/ckuxla.r:\
	$(SDIR)/ckuxla.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckuusr.r:\
	$(SDIR)/ckuusr.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h\
	$(SDIR)/ckcnet.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckuus2.r:\
	$(SDIR)/ckuus2.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 
	$(CC) $(HUGECFLAGS) $(SDIR)/$*.c -r=$(RDIR)

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckuus3.r:\
	$(SDIR)/ckuus3.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckuus4.r:\
	$(SDIR)/ckuus4.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckuver.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckuus5.r:\
	$(SDIR)/ckuus5.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckuus6.r:\
	$(SDIR)/ckuus6.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h\
	$(SDIR)/ckcnet.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

$(RDIR)/ckuus7.r:\
	$(SDIR)/ckuus7.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h 

$(RDIR)/ckuusx.r:\
	$(SDIR)/ckuusx.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h\
	$(SDIR)/ckcsig.h

$(RDIR)/ckuusy.r:\
	$(SDIR)/ckuusy.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcnet.h 

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckucmd.r:\
	$(SDIR)/ckucmd.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcasc.h 
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

$(RDIR)/ck9fio.r:\
	$(SDIR)/ck9fio.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcasc.h 

$(RDIR)/ck9ren.r:\
	$(SDIR)/ck9ren.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h 

$(RDIR)/ck9tio.r:\
	$(SDIR)/ck9tio.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcnet.h 
	$(CC) $(CFLAGS) -dO_GOODDRIVER $(SDIR)/$*.c -r=$(RDIR)

$(RDIR)/ck9con.r:\
	$(SDIR)/ck9con.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h\
	$(SDIR)/ckcnet.h 

# use 32 bit pc relative addressing because code segment is too big for 16 bit
$(RDIR)/ckudia.r:\
	$(SDIR)/ckudia.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckcsig.h
	$(CC) $(BIGCFLAGS) $(SDIR)/$*.c -r=$(RDIR)

$(RDIR)/ckuscr.r:\
	$(SDIR)/ckuscr.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckcsig.h

$(RDIR)/ckcnet.r:\
	$(SDIR)/ckcnet.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckcsig.h

$(RDIR)/ckctel.r:\
	$(SDIR)/ckctel.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckctel.h\
	$(SDIR)/ckclib.h

$(RDIR)/ckusig.r:\
	$(SDIR)/ckusig.c\
	$(SDIR)/ckcasc.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcnet.h\
	$(SDIR)/ckuusr.h\
	$(SDIR)/ckcsig.h

$(RDIR)/ckcuni.r:\
	$(SDIR)/ckcuni.c\
	$(SDIR)/ckcsym.h\
	$(SDIR)/ckcdeb.h\
	$(SDIR)/ckucmd.h\
	$(SDIR)/ckcker.h\
	$(SDIR)/ckcuni.h\
	$(SDIR)/ckcxla.h\
	$(SDIR)/ckuxla.h
