/* 	
	makebin.c
	Make a .out file into a binary suitable for loading on
	Atari

	makebin infile outfile
*/

#include <stdio.h>

FILE * inf, * outf;

char segment[16384];		/* current segment buffer */
int seg_idx;			/* next byte pos in seg */
int seg_start_pc;

char hexchar[16];		/* = "0123456789ABCDEF"; */

int hexac = 0;			/* hex accumulator */
int hexp = 0;			/* if anything in accumulator */

int pc, expected_pc;		/* pc we're at, pc we expect */
int in_segment = 0;		/* if currently inside segment */

hexdigit(c)
char c;
/*
 *	returns parsed digit
 */
{
  int i;

  for(i = 0; i < 16; i++) 
    {
      if (c == hexchar[i]) return(i);
    }
  printf("Bogus hex char %c\n", c);
}

outbyte(c)
char c;
{
  fputc(c, outf);	
  /*	printf("%x\n", c);	*/
}

/*
 * flush segment buf
 */
endsegment()
{
  int i;
  int end_pc;

  if (in_segment != 0)
    {
      end_pc = seg_start_pc + seg_idx - 1;

      outbyte(255);		/* write atari load header */
      outbyte(255);
      outbyte((seg_start_pc & 255));
      outbyte((seg_start_pc >> 8));
      outbyte((end_pc & 255));
      outbyte((end_pc >> 8));

      for(i = 0; i < seg_idx; i++)
	outbyte((segment[i]) & 255);
    };
  in_segment = 0;
}

startsegment(new_pc)
int new_pc;
{
  endsegment();
  seg_idx = 0;
  seg_start_pc = new_pc;
  in_segment = 1;
}

checkpc(new_pc)
int new_pc;
{
  if ((!in_segment) || (new_pc != seg_start_pc + seg_idx)) 
    startsegment(new_pc);
}

storebyte(ch)
char ch;
{
  int new_pc;

  if((seg_idx >= 16384)) 
    {
      new_pc = seg_start_pc + 16384;
      endsegment();
      startsegment(new_pc);
    };
  segment[seg_idx] = ch;
  seg_idx += 1;
}

FILE * fopen_carefully(char * fn, char * mode)
{
  FILE * f = fopen(fn, mode);

  if (!f)
    {
      printf("Can't open '%s'\n", fn);
      exit(1);
    }
  return(f);
}

main(int argc, char ** argv)
{
  int ch;

  if (argc < 3)
    {
      printf("Try makebin infile outfile ...\n");
      exit(1);
    }
  inf = fopen_carefully(argv[1], "r");
  outf = fopen_carefully(argv[2], "wb");

  hexchar[0] = '0';
  hexchar[1] = '1';
  hexchar[2] = '2';
  hexchar[3] = '3';
  hexchar[4] = '4';
  hexchar[5] = '5';
  hexchar[6] = '6';
  hexchar[7] = '7';
  hexchar[8] = '8';
  hexchar[9] = '9';
  hexchar[10] = 'A';
  hexchar[11] = 'B';
  hexchar[12] = 'C';
  hexchar[13] = 'D';
  hexchar[14] = 'E';
  hexchar[15] = 'F';

  in_segment = 0;
  while((ch = fgetc(inf)) != EOF)

    switch (ch) 
      {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
	hexac = (hexac * 16) + hexdigit(ch);
	hexp = 1;
	break;
      case ':':
	checkpc(hexac);
	hexac = 0;
	hexp = 0;
	break;
      case ' ':
      case '\n':
	if(hexp)
	  storebyte(hexac);
	hexac = 0;
	hexp = 0;
	break;
      default:
	printf("Bogus char %c\n", ch);

      };			/* end of switch */
  endsegment();			/* flush output */
	
  exit(0);
}
