/*
**********************************************************************
*
*       hdsetup
*
**********************************************************************
*/
#include       "stdio.h"
#include       "conio.h"
#include       "ctype.h"
/**
*
*       constant
*
**/
#define NORMAL    0
#define ERROR    -1
#define DB_ERROR -3
#define ESCAPE   -2
#define SPT      17
#define ON        1
#define OFF       0
#define MSDOS     1
#define ACTIVE    1
#define NONACTIVE  0
#define MAX_COLUMN 40
#define recalibrate() disk_int(0xd700 + daua(unit),0,0,0,0)
/**
*
*       external
*
**/
extern long crt_int();
extern int  disk_int();
extern      copy_boot();
extern      disk_ai();
extern int  check_connect();
/**
*
*       global data area
*
**/
struct  vol_entry {
                char    activate;
                char    system;
                char    dummy1[2];
                long    ipl;
                long    start;
                long    end;
                char    vol_name[10];
                char    dummy2[6];
};
struct  vol {
                char    vol_number;
                char    boot_vol;
                char    dummy3[32-2];
                struct  vol_entry ent[12];
                char    dummy4[512-(13*32)-4];
                char    boot_rev;
                char    vol_rev;
                int     id;
};
int     unit;
int     max_track;
struct  vol v;
/**
*
*       static buffer area
*
**/
char    buf1[512];
char    buf2[512];
/**/
/**/
long  track_secter();
/*EJ*/
/*********************************************************************
*
*       main
*
*
**********************************************************************
*/
main(argc,argv)
int  argc;
int  *argv[];
{
     int       ret,i;
     int       row,col;
     int       select_flag;
     char      inchar;
     char      ver_num;
     char      instr[30];
     static char    space_esc[] = "Type space to continue,<Esc> to exit.";
     static char    com_prom[] = "Options: Activate,Create,Delete,Format,\r\n         Select,Exit :";
     cursor(24,0);
     for (i = 0; i < 25; ++i)
          printf("\r\n");
     cursor(0,0);
     if (argc != 1) {
          lp("================ HDSETUP ===============");
          printf("\r\n<PURPOSE>\r\n");
          printf(" Sets up partitions on your hard disks\r\n");
          lp("for use under several operating systems.");
          printf("\r\n<SYNTAX>\r\n HDSETUP [?]\r\n\r\n");
          printf("<COMMENTS>\r\n");
          printf(" HDSETUP ?  ---  display this screen\r\n");
          printf("                 itself.\r\n");
          printf(" HDSETUP    ---  will give you an\r\n");
          printf("                 operating menu.\r\n\r\n");
          printf("    There are following operations.\r\n\r\n");
          printf("    A --- Activate MS-DOS partition\r\n");
          printf("    C --- Create   MS-DOS partition\r\n");
          printf("    D --- Delete   MS-DOS partition\r\n");
          printf("    F --- Format   track\r\n");
          printf("    S --- Select   hard disk unit\r\n");
          printf("    E --- Exit     this program\r\n");
          exit(0);
     }
     printf("NEC Personal Computer\r\n");
     printf("Hard Disk Setup Program Version 1.00\r\n");
     printf("(C)Copyright NEC Corp. 1984\r\n");
     unit = 0;
     peek(0xffff,0xd,&ver_num,1);
     if (ver_num < '\005') {
          cls(24,1);
          cursor(24,0);
          printf("Invalid ROM version");
          exit(1);
     }
     for (;;) {
          select_flag = OFF;
          if ((check_connect(unit) == ERROR) ||
                                   ((max_track = check_size(unit)) == ERROR)) {   
               cls(24,1);
               cursor(24,0);
               printf("Hard disk unit is not connected");
               exit(1);
          }
          cls(4,1);
          cursor(4,0);
          printf("Current Hard Disk Unit #%d (%d tracks)",
                                                  unit,max_track);
          if (read_vol(unit) == ERROR) {
               clear_vol();
               cls(7,12);
               cursor(7,0);
               printf("The drive configuration cannot be read.\r\nA new configuration will be created.");
               cursor(9,0);
               printf("%s",space_esc);
               get_cursor(&row,&col);
               for (;;){
                    cursor(row,col);
                    if ((inchar  = getchar()) == '\x1b')
                         exit(0);
                    if (inchar == ' ')
                         break;
               }
          }
          if ((v.boot_rev != 0) || (v.vol_rev != 0)) {
               cls(7,12);
               cursor(7,0);
               lp("The drive configuration is incompatible");
               printf("%s",space_esc);
               get_cursor(&row,&col);
               for(;;) {
                    cursor(row,col);
                    if ((inchar = getchar()) == '\x1b')
                         exit(0);
                    if (inchar == ' ')
                         break;
               }
          }
          do {
               cls(6,18);
               disp_map();
               do {
                    cls(19,5);
                    ret = get_string(19,0,com_prom,instr);
                    if (ret == ESCAPE) {
                         cls(24,1);
                         break;
                    }
                    if ((ret == ERROR) || (strlen(instr) != 1)) {
                         ret = ERROR;
                         cls(24,1);
                         cursor(24,0);
                         printf("Invalid option");
                         break;
                    }
                    switch (instr[0]) {
                         case 'A': com_activate();
                                   break;
                         case 'C': com_create();
                                   break;
                         case 'D': com_delete();
                                   break;
                         case 'F': com_format();
                                   break;
                         case 'S': com_select();
                                   select_flag = ON;
                                   break;
                         case 'E': com_exit();
                                   break;
                         default : ret = ERROR;
                                   cls(24,1);
                                   cursor(24,0);
                                   printf("Invalid option");
                    }
               } while (ret == ERROR);
          } while (select_flag == OFF);
     }
}
/*EJ*/
/****************************************************************
*
*	com_activate
*
*****************************************************************
*/
com_activate()
{
     int  in_number;
     int  i;
     static char vol_prm2[] = "you want to make active:";
     cls(24,1);
     if (v.vol_number == 0) {
          cursor(24,0);
          printf("There is no partition");
          return;
     }
     do{
          cls(19,5);
          cursor(19,0);
          lp("Enter the number of the MS-DOS partition");
          if ((in_number = get_num(20,0,vol_prm2,1,v.vol_number)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (in_number == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be 1 -- %d)",v.vol_number);
          }
          else {
               if (v.ent[in_number - 1].system != MSDOS) {
                    cls(24,1);
                    cursor(24,0);
                    printf("Cannot activate OTHER system partition");
                    in_number = ERROR;
               }
          }
     } while (in_number == ERROR);
     cls(24,1);
     v.ent[in_number - 1].activate = ACTIVE;
     for (i = 0; i != v.vol_number; ++i) {
          if ((i != in_number - 1) && (v.ent[i].system == MSDOS)) {
               v.ent[i].activate = NONACTIVE;
               if ((i + 1) == v.boot_vol)
                     v.boot_vol = 0;
	  }
     }
}
/*EJ*/
/****************************************************************
*
*	com_create
*
*****************************************************************
*/
com_create()
{
     struct vol_entry new;
     int  in_start;
     int  in_size;
     int  ent_num;
     char in_name[50];
     int  i;
     int  ret;
     int  max_size;
     static char start_prom[] = "Enter starting track number:";
     static char size_prom[]  = "Enter partition size:";
     static char name_prom[]  = "Enter partition name(8 char.):";
/*******  initialize buffer  *******/
     setmem((char *)&new,sizeof(new),'\0');
     new.activate = NONACTIVE;
     new.system = MSDOS;
     for (i = 0; i < 10; ++i)
          new.vol_name[i] = ' ';
/***********************************/
     cls(24,1);
     if (v.vol_number == 12) {
          cursor(24,0);
          printf("Too many partitions (max.12)");
          return;
     }
     do {
          cls(19,5);
          if ((in_start = get_num(19,0,start_prom,2,max_track - 8)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (in_start == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be 2 -- %d)",max_track - 9);
          }
          else {
               if ((ent_num = check_free(in_start,in_start + 9)) == ERROR) {
                    cls(24,1);
                    cursor(24,0);
                    printf("Not enough room for MS-DOS partition");
                    in_start = ERROR;
               }
               else {
                    for (i = 0; i != 2; ++i) {
                         if (check_track(unit,in_start + i) == ERROR) {
                              cls(24,1);
                              cursor(24,0);
                              printf("First 2 tracks are bad tracks");
                              in_start = ERROR;
                              break;
                         }
                    }
               }
          }
     } while (in_start == ERROR);
     new.start = track_sector(in_start);
     new.ipl = new.start;
     cls(24,1);
     if (ent_num > v.vol_number)
          max_size = max_track - in_start;
     else
          max_size = sector_track(v.ent[ent_num - 1].start) - in_start;
     do {  
          cls(20,4);
          if ((in_size = get_num(20,0,size_prom,9,max_size)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (in_size == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be 9 -- %d)",max_size);
          }
          else { 
               if (check_free(in_start,in_start + in_size - 1)== ERROR){
                    cls(24,1);
                    cursor(24,0);
                    printf("Invalid number (must be 9 -- %d)",max_size);
                    in_size = ERROR;
               }
          }
     } while (in_size == ERROR);
     new.end = track_sector(in_start + in_size - 1) + (SPT - 1);
     cls(24,1);
     do {
          cls(21,3);
          if ((ret = get_string(21,0,name_prom,in_name)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (ret == ERROR) { 
               cls(24,1);
               cursor(24,0);
               printf("Invalid name");
          }
     } while (ret == ERROR);
     cls(24,1);
     for (i = 0; (i < 10) && (in_name[i] != '\0'); ++i)
          new.vol_name[i] = in_name[i];
     add_vol(&new,ent_num);
}
/*EJ*/
/****************************************************************
*
*	com_delete
*
*****************************************************************
*/
com_delete()
{
     int  vol_num;
     int  ret;
     char in_string[60];
     static char vol_prm2[] = "you want to delete:";
     static char yn_prom2[] = "DESTROYED. Are you sure(Y/N)? ";
     cls(24,1);
     if (v.vol_number == 0) {
          cursor(24,0);
          printf("There is no partition");
          return;
     }
     do {
          cls(19,5);
          cursor(19,0);
          lp("Enter the number of the MS-DOS partition");
          if ((vol_num = get_num(20,0,vol_prm2,1,v.vol_number)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (vol_num == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be 1 -- %d)",v.vol_number);
          }
          else {
               if (v.ent[vol_num - 1].system != MSDOS) {
                    cls(24,1);
                    cursor(24,0);
                    printf("Cannot delete OTHER system partition");
                    vol_num = ERROR;
               }
          }
     } while (vol_num == ERROR);
     cls(24,1);
     do {
          cls(21,3);
          cursor(21,0);
          lp("All data in the MS-DOS partition will be");
          if ((ret = get_string(22,0,yn_prom2,in_string)) == ESCAPE)
               return;
          if ((ret == ERROR) || (strlen(in_string) != 1))
               ret = ERROR;
          else {
               if (in_string[0] == 'N')
                    return;
               if (in_string[0] != 'Y')
                    ret = ERROR;
          }
     } while (ret == ERROR);
     del_vol(vol_num);
}
/*EJ*/
/****************************************************************
*
*	com_format
*
*****************************************************************
*/
com_format()
{
     int  ret;
     char instring[30];
     int  in_start;
     int  in_end;
     int  i;
     static char yn_prom[] =
                 "Formatting may DESTROY data.\r\nAre you sure(Y/N)? ";
     static char start_prom[] =
                 "Enter starting track number:";
     static char end_prom[] =
                 "Enter ending track number:";
     cls(24,1);
     do {
          cls(19,5);
          if ((ret = get_string(19,0,yn_prom,instring)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if ((ret == ERROR) || (strlen(instring) != 1))
               ret = ERROR;
          else {
               if (instring[0] == 'N')
                    return;
               if (instring[0] != 'Y')
                    ret = ERROR;
          }
     } while (ret == ERROR);
     do {
          cls(21,3);
          if ((in_start = get_num(21,0,start_prom,0,max_track - 1)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (in_start == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be 0 -- %d)",max_track - 1);
          }
     } while (in_start == ERROR);
     cls(24,1);
     do {
          cls(22,2);
          if ((in_end = get_num(22,0,end_prom,in_start,max_track - 1)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (in_end == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be %d -- %d)",
                                             in_start,max_track - 1);
          }
     } while (in_end == ERROR);
     cls(24,1);
     cursor(23,0);
     printf("Number of remaining track : %4d",
                                        i = (in_end - in_start + 1));
     recalibrate();
     while (in_start <= in_end) {
          phy_format(unit,in_start++);
          cursor(23,28);
          printf("%4d",--i);
     }
}
/*EJ*/
/****************************************************************
*
*	com_select  
*
*****************************************************************
*/
com_select()
{
     int  in_unit;
     static char unit_prom[] = "Enter the unit number (0/1):";
     cls(24,1);
     if ((write_vol(unit) == ERROR) || (write_boot(unit) == ERROR)) {
          cls(24,1);
          cursor(24,0);
          printf("Unrecoverable write error");
          exit(1);
     }
     do {
          cls(19,5);
                                                       /* input unit number   */
          if ((in_unit = get_num(19,0,unit_prom,0,1)) == ESCAPE) {
               cls(24,1);
               return;
          }
          if (in_unit == ERROR) {
               cls(24,1);
               cursor(24,0);
               printf("Invalid number (must be 0 -- 1)");
          }
     } while (in_unit == ERROR);
     unit = in_unit;
     cls(24,1);
}
/*EJ*/
/****************************************************************
*
*	com_exit    
*
*****************************************************************
*/
com_exit()
{
     cls(24,1);
     if ((write_vol(unit) == ERROR) || (write_boot(unit) == ERROR))  {
          cursor(24,0);
          printf("Unrecoverable write error");
          exit(1);
     }
     exit(0);
}
/*EJ*/
/****************************************************************
*
*	disp_map    
*
*****************************************************************
*/
disp_map()
{
     int  i,j;
     char sys_name[7];
     char status;
     int  map_start;
     int  map_end;
     int  map_size;
     int  unused;
     static char msdos[] = "MS-DOS";
     static char other[] = "OTHER ";
     static char head[] =
               "Pat. Name  Status System Start  End Size";
     cursor(6,0);
     printf("%s",head);
     for(i = 0; i != v.vol_number; ++i) {
          if (v.ent[i].system == MSDOS)
               strcpy(sys_name,msdos);
          else
               strcpy(sys_name,other);
          if (v.ent[i].activate == ACTIVE)
               status = 'A';
          else
               status = 'N';
          map_start = sector_track(v.ent[i].start);
          map_end = sector_track(v.ent[i].end);
          map_size = map_end - map_start + 1;
          cursor(7 + i,0);
          printf("%2d",i + 1);
          cursor(7 + i,3);
          for (j = 0; j < 8; ++j)
               printf("%c",(v.ent[i].vol_name)[j]);
          cursor(7 + i,14);
          printf("%c   %s  %04d %04d %4d",
                         status,sys_name,map_start,map_end,map_size);
     }
     for(;i < 12; ++i) {
          cursor(7 + i,0);
          printf("%2d",i + 1);
     }
}
/*EJ*/
/****************************************************************
*
*	get_num     
*
*****************************************************************
*/
get_num(row,col,prompt,low,high)
int  row,col;
char *prompt;
int  low,high;
{
     int  ret;
     int  number;
     char in_string[MAX_COLUMN];
     if ((ret = get_string(row,col,prompt,in_string)) == ESCAPE)
          return(ESCAPE);
     if ((ret == ERROR) || (to_num(in_string,&number) == ERROR))
          return(ERROR);
     if ((number < low) || (number > high))
          return(ERROR);
     return(number);
}
/*EJ*/
/****************************************************************
*
*	get_string  
*
*****************************************************************
*/
get_string(row,col,prompt,string)
int  row,col;
char *prompt;
char *string;
{
     int  i;
     char ch;
     char buf[MAX_COLUMN];
     cursor(row,col);
     printf("%s",prompt);
     get_cursor(&row,&col);
     for (i = 0;(ch = getchar()) != '\r';) {
          if (ch == '\x1b')
               return(ESCAPE);
          if ((i != 0) && (ch == '\b')) {
               i--;
               cursor(row,--col);
               putchar(' ');
               cursor(row,col);
          }
          if (col >= MAX_COLUMN)
               return(ERROR);
          ch = toupper(ch);
          if ((ch >= '\x20') && (ch <= '\x5f')){
                    buf[i++] = ch;
                    putchar(ch);
                    col++;
          }
     }
     buf[i] = '\0';
     if ((i = strlen(buf)) == 0) {
          string[0] = '\0';
          return(NORMAL);
     }
     for (i -= 1;buf[i] == ' '; --i)
     ;
     buf[i + 1] = '\0';
     for (i = 0; buf[i] == ' '; ++i)
     ;
     while (buf[i] != '\0')
          *string++ = buf[i++];
     *string = '\0';
     return(NORMAL);
}
/*EJ*/
/*********************************************************************
*
*       to_num
*
**********************************************************************
*/
to_num(string,buf)
char *string;
int  *buf;
{
     int  i;
     *buf = 0;
     if (string[0] == '\0')
          return(ERROR);
     for (i = 0; string[i] != '\0'; ++i) {
          if (isdigit(string[i]) == 0)
               return(ERROR);
          *buf = *buf * 10 + (string[i] - '0');
     }
     return(NORMAL);
}
/*EJ*/
/*********************************************************************
*
*       sector_track
*
**********************************************************************
*/
sector_track(sector_number)
long    sector_number;                  /* sector number                */
{
        return (int)(sector_number/SPT);
}
/*EJ*/
/*********************************************************************
*
*       track_sector
*
**********************************************************************
*/
long    track_sector(track_number)
int     track_number;                   /* track number                 */
{
        return ((long)track_number)*SPT ;
}
/*EJ*/
/*********************************************************************
*
*       daua
*
**********************************************************************
*/
daua(unit_number)
int     unit_number;                    /* unit number                  */
{
        return unit_number | 0x90;
}
/*EJ*/
/*********************************************************************
*
*       clear_vol
*
**********************************************************************
*/
clear_vol()
{
        setmem((char *)&v,sizeof(v),'\0');
        v.id = 0x55aa;
}
/*EJ*/
/*********************************************************************
*
*       add_vol
*
**********************************************************************
*/
add_vol(pent,ent_number)
struct vol_entry *pent;                 /* adding entry pointer         */
int     ent_number;                     /* adding position              */
{
        int     i;
        for (i=v.vol_number   ; i>=ent_number ; i--) {
                movmem((char *)&(v.ent[i-1]),(char *)&(v.ent[i]),
                       sizeof(struct vol_entry));
        }
        movmem((char *)pent,(char *)&(v.ent[ent_number-1]),
               sizeof(struct vol_entry));
        v.vol_number++;
        if (ent_number <= v.boot_vol) v.boot_vol++;
}
/*EJ*/
/*********************************************************************
*
*       del_vol
*
**********************************************************************
*/
del_vol(ent_number)
int     ent_number;                     /* deleting entry number        */
{
        int     i;
        for (i=ent_number ; i< v.vol_number ; i++) {
                movmem((char *)&(v.ent[i]),(char *)&(v.ent[i-1]),
                       sizeof(struct vol_entry));
        }
        setmem((char *)&(v.ent[v.vol_number-1]),sizeof(struct vol_entry),'\0'); 
        v.vol_number--;
        if (ent_number == v.boot_vol) v.boot_vol = 0;
        if (ent_number < v.boot_vol) v.boot_vol--;
}
/*EJ*/
/*********************************************************************
*
*       check_free
*
**********************************************************************
*/
check_free(start_track,end_track)
int     start_track;                    /* start track number           */
int     end_track;                      /* end track number             */
{
        int     i;
        long    ts,te;
        if ( start_track > max_track ) return ERROR;
        if ( end_track   > max_track ) return ERROR;
        ts = track_sector(start_track);
        te = track_sector(end_track) + SPT - 1;
        for (i=1 ; i<=v.vol_number ; i++) {
                if (v.ent[i-1].end > ts) break;                                 
                if (v.ent[i-1].end == ts) return ERROR;
        }
        if (i>v.vol_number) return i;                                           
        if (v.ent[i-1].start > te) return i;                                    
        else                       return ERROR;                                
}
/*EJ*/
/*********************************************************************
*
*       read_hd
*
**********************************************************************
*/
read_hd(unit_number,sector_number,bufferp)
int     unit_number;                    /* unit number                  */
long    sector_number;                  /* sector number                */
char    *bufferp;                       /* buffer pointer               */
{
        int     retry_count;
        int     ret;
        retry_count = 3;
        for (;;)
        {
               ret = disk_int( 0xd600 + daua(unit_number),
                               512,
                               (int)(sector_number & 0xffff),
                               (int)(sector_number >> 16),
                               bufferp );
                if ((ret & 1) == 0)           return NORMAL;
                if ((ret & 0xf000) == 0x2000) return DB_ERROR;
                if (--retry_count == 0)       return ERROR;
                ret = disk_int( 0xd700 + daua(unit_number),0,0,0,0 );
        }
}
/*EJ*/
/*********************************************************************
*
*       write_hd
*
**********************************************************************
*/
write_hd(unit_number,sector_number,bufferp)
int     unit_number;                    /* unit number                  */
long    sector_number;                  /* sector number                */
char    *bufferp;                       /* buffer pointer               */
{
        int     retry_count;
        int     ret;
        retry_count = 3;
        for (;;)
        {
                ret = disk_int( 0xd500 + daua(unit_number),
                                512,
                                (int)(sector_number & 0xffff),
                                (int)(sector_number >> 16),
                                bufferp );
                if ((ret & 1) == 0)           return NORMAL;
                if ((ret & 0xf000) == 0x2000) return DB_ERROR;
                if (--retry_count == 0)       return ERROR;
                ret = disk_int( 0xd700 + daua(unit_number),0,0,0,0 );
        }
}
/*EJ*/
/*********************************************************************
*
*       read_vol
*
**********************************************************************
*/
read_vol(unit_number)
int     unit_number;                    /* unit number                  */
{
        int     ret;
        char    *p;
        ret = read_hd(unit_number,(long)1,p=buf1);
        if (ret == DB_ERROR)
        {
                ret = read_hd(unit_number,(long)1,p=buf2);
        }
        if ((ret == NORMAL) &&
            ((p[510] == 0xaa) && (p[511] == 0x55)))
        ;
        else
        {
                ret = read_hd(unit_number,(long)18,p=buf1);
                if (ret == DB_ERROR)
                {
                        ret = read_hd(unit_number,(long)18,p=buf2);
                }
                if ((ret == NORMAL) &&
                    ((p[510] == 0xaa) && (p[511] == 0x55)))
                ;
                else    return ERROR;
        }
        movmem(p,(char *)&v,512);
        return NORMAL;
}
/*EJ*/
/*********************************************************************
*
*       write_vol
*
**********************************************************************
*/
write_vol(unit_number)
int     unit_number;                    /* unit number                  */
{
        int     ok_flag = 0 ;
        int     ret;
        movmem((char *)&v,buf1,512);
        movmem((char *)&v,buf2,512);
        ret = write_hd(unit_number,(long)1,buf1);
        if (ret == DB_ERROR)
        {
                ret = write_hd(unit_number,(long)1,buf2);
        }
        if (ret == NORMAL) ok_flag = 1;
        ret = write_hd(unit_number,(long)18,buf1);
        if (ret == DB_ERROR)
        {
                ret = write_hd(unit_number,(long)18,buf2);
        }
        if (ret == NORMAL) ok_flag = 1;
        disk_ai(unit_number);
        if (ok_flag == 1) return NORMAL;
        else              return ERROR;
}
/*EJ*/
/*********************************************************************
*
*       check_size
*
**********************************************************************
*/
check_size(unit_number)
int     unit_number;                    /* unit number                  */
{
        int     retry_count;
        int     ret;
        for (retry_count=8 ; retry_count!=0 ; retry_count--)
        {
                ret = disk_int( 0xd400 + daua(unit_number),0,0,0,0 );
                if ((ret & 1) == 0) break;
        }
        if (retry_count == 0) return ERROR;
        switch (ret & 0x0300)
        {
                case 0x0000: return 1240/2  ;
                case 0x0100: return 1240/2*2;
                case 0x0200: return 1240/2*3;
                case 0x0300: return 1240/2*4;
        }
}
/*EJ*/
/*********************************************************************
*
*       check_track
*
**********************************************************************
*/
check_track(unit_number,track_number)
int     unit_number;                    /* unit number                  */
int     track_number;                   /* track number                 */
{
        long    sec;
        int     ret;
        char    *p;
        for ( sec = track_sector(track_number);
              sec < (track_sector(track_number)+SPT);
              sec++ )
        {
                ret = read_hd(unit_number,sec,p=buf1);
                if (ret == DB_ERROR)
                {
                        ret = read_hd(unit_number,sec,p=buf2);
                }
                if (ret != NORMAL) return ERROR;
                ret = write_hd(unit_number,sec,p);
                if (ret != NORMAL) return ERROR;
        }
        return NORMAL;
}
/*EJ*/
/*********************************************************************
*
*       phy_format
*
**********************************************************************
*/
phy_format(unit_number,track_number)
int     unit_number;                    /* unit number                  */
int     track_number;                   /* track number                 */
{
        int     ret;
        int     retry_count;
        for (retry_count=3 ; retry_count!=0 ; retry_count--)
        {
                ret = disk_int( 0xdd00 + daua(unit_number),
                                0,
                                (int)(track_sector(track_number) & 0xffff),
                                (int)(track_sector(track_number) >> 16),
                                0 );
                if ((ret & 1) == 0)     return NORMAL;
                ret = disk_int( 0xd700 + daua(unit_number),0,0,0,0 );
        }
        return ERROR;
}
/*EJ*/
/*********************************************************************
*
*       write_boot
*
**********************************************************************
*/
write_boot(unit_number)
int     unit_number;                    /* unit number                  */
{
        int     ok_flag = 0 ;
        int     ret;
        copy_boot();
        movmem(buf1,buf2,512);
        ret = write_hd(unit_number,(long)0,buf1);
        if (ret == DB_ERROR)
        {
                ret = write_hd(unit_number,(long)0,buf2);
        }
        if (ret == NORMAL) ok_flag = 1;
        ret = write_hd(unit_number,(long)17,buf1);
        if (ret == DB_ERROR)
        {
                ret = write_hd(unit_number,(long)17,buf2);
        }
        if (ret == NORMAL) ok_flag = 1;
        if (ok_flag == 1) return NORMAL;
        else              return ERROR;
}
/*EJ*/
/*********************************************************************
*
*       cls
*
**********************************************************************
*/
cls(row,line_num)
int     row;                            /* row of screen                */
int     line_num;                       /* number of line               */
{
        int  old_row,old_col,i;
        get_cursor(&old_row,&old_col);
        for(; line_num > 0; line_num--, row++) {
             cursor(row,0);
             if (row == 24) {
                  for (i = 0; i < MAX_COLUMN - 1; ++i)
                       putchar(' ');
              }
              else {
                   for (i = 0; i < MAX_COLUMN1; ++i)
                        putchar(' ');
              }
        }
        cursor(old_row,old_col);
}
/*EJ*/
/*********************************************************************
*
*       cursor
*
**********************************************************************
*/
cursor(row,col)
int     row;                            /* row of screen                */
int     col;                            /* column of screen             */
{
        crt_int( 0x0200,
                ((int)crt_int( 0x0f00,0,0,0)),
                0,
                row*256 + col );
}
/*EJ*/
/*********************************************************************
*
*       get_cursor
*
**********************************************************************
*/
get_cursor(row,col)
int     *row;                           /* row of screen                */
int     *col;                           /* column of screen             */
{
        int     tmp;
        tmp = (int)( crt_int( 0x0300,
                              (int)crt_int( 0x0f00,0,0,0 ),
                              0,0 )
                     >> 16 );
        *row = tmp / 256;
        *col = tmp % 256;
}
/*EJ*/
/*********************************************************************
*
*       lp
*
**********************************************************************
*/
lp(str)
char *str;
{
     int row,col;
     get_cursor(&row,&col);
     printf(str);
     if (row < 24)
          cursor(++row,col);
}
