		PAGE	58,132
		TITLE	HDSETUPA
;****************************************************************
;*
;*	HDSETUPA
;*
;*		HDSETUP	(ASSEMBLER PART)
;*
;****************************************************************
;
;	CONSTANT
;
NORMAL		EQU	0
ERROR		EQU	-1

DSK_PTR_OFF	EQU	20H
DSK_PTR_SEG	EQU	60H

DISK_EQP_OFF	EQU	4F1H
DISK_EQP_SEG	EQU	0H
;
;
;
PGROUP		GROUP	PROG
DGROUP		GROUP	DATA
;
		PUBLIC	CRT_INT
		PUBLIC	DISK_INT
		PUBLIC	COPY_BOOT,	COPY_BOO
		PUBLIC	DISK_AI
		PUBLIC	CHECK_CONNECT,	CHECK_CO
;
DATA		SEGMENT	WORD PUBLIC 'DATA'
		EXTRN	BUF1:BYTE
DATA		ENDS

BOOT		SEGMENT	PARA PUBLIC 'CODE'
BOOT		ENDS

;
DYNS		STRUC

OLD_BP		DW	?
RETN		DW	?
ARG1		DW	?
ARG2		DW	?
ARG3		DW	?
ARG4		DW	?
ARG5		DW	?
ARG6		DW	?

DYNS		ENDS

PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	crt_int(ax,bx,cx,dx)
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
PROG		SEGMENT	BYTE PUBLIC 'PROG'
		ASSUME	CS:PGROUP
CRT_INT		PROC	NEAR
		PUSH	BP
		MOV	BP,SP
		MOV	AX,[BP].ARG1
		MOV	BX,[BP].ARG2
		MOV	CX,[BP].ARG3
		MOV	DX,[BP].ARG4
		INT	19H
		MOV	AX,DX
		POP	BP
		RET
CRT_INT		ENDP

PROG		ENDS

PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	disk_int(ax,bx,cx,dx,bp)
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
PROG		SEGMENT	BYTE PUBLIC 'PROG'
		ASSUME	CS:PGROUP
DISK_INT	PROC	NEAR
		PUSH	BP
		MOV	BP,SP
		MOV	AX,[BP].ARG1
		MOV	BX,[BP].ARG2
		MOV	CX,[BP].ARG3
		MOV	DX,[BP].ARG4
		MOV	BP,[BP].ARG5
		INT	1DH
		MOV	AL,0
		ADC	AL,0
		POP	BP
		RET
DISK_INT	ENDP

PROG		ENDS

PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	copy_boot()
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
PROG		SEGMENT	BYTE PUBLIC 'PROG'
		ASSUME	CS:PGROUP
COPY_BOOT	PROC	NEAR
COPY_BOO	LABEL	NEAR
		PUSH	DS
		MOV	AX,BOOT
		MOV	DS,AX
		MOV	SI,0
		MOV	DI,OFFSET DGROUP:BUF1
		MOV	CX,256
		CLD
		REP	MOVSW
		POP	DS
		RET
COPY_BOOT	ENDP

PROG		ENDS

PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	disk_ai(unit_number)
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
PROG		SEGMENT BYTE PUBLIC 'PROG'
		ASSUME	CS:PGROUP
DISK_AI		PROC	NEAR
		PUSH	BP
		MOV	BP,SP
		MOV	AX,[BP].ARG1
		PUSH	DS
		MOV	BX,DSK_PTR_SEG
		MOV	DS,BX
		MOV	BX,DSK_PTR_OFF
		LDS	BX,DWORD PTR DS:[BX]
		MOV	AH,40
		ADD	AL,2
		MUL	AH
		ADD	BX,AX
		OR	BYTE PTR DS:[BX],00001000B
		POP	DS
		POP	BP
		RET
DISK_AI		ENDP

PROG		ENDS

PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	check_connect(unit_number)
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
PROG		SEGMENT	BYTE PUBLIC 'PROG'
		ASSUME	CS:PGROUP
CHECK_CONNECT	PROC	NEAR
CHECK_CO	LABEL	NEAR
		PUSH	BP
		MOV	BP,SP
		MOV	AX,[BP].ARG1
		PUSH	DS
		MOV	BX,DISK_EQP_SEG
		MOV	DS,BX
		MOV	BX,DISK_EQP_OFF
		MOV	AH,BYTE PTR DS:[BX]
		AND	AH,11B
		INC	AL		; UNIT 0 --> 01
		AND	AL,AH		; UNIT 1 --> 10
		MOV	AX,ERROR
		JZ	RET1
		MOV	AX,NORMAL
RET1:
		POP	DS
		POP	BP
		RET
CHECK_CONNECT	ENDP

PROG		ENDS

		END
