#ifndef BASEPAGE_H
#define BASEPAGE_H
/* GemDos base page structure */
/* Alias psp */
/* The documented elements have been augmented by information gleaned from
 * disassembling the ROM based system */
typedef struct {
	long	p_lowtpa;	/* 0 Low transient program area */
	long	p_hitpa;	/* 4 High transient program area */
	long	p_tbase;	/* 8 Text segment base */
	long	p_tlen;		/* C Text segment length */
	long	p_dbase;	/* 10 Data length base */
	long	p_dlen;		/* 14 Data length length */
	long	p_bbase;	/* 18 Bss segment base */
	long	p_blen;		/* 1C Bss segment length */
	long	p_fxx0;		/* 20 Undocumented zero */
	long	p_parent;	/* 24 Parent's basepage (undocumented) */
	long	p_fxx1;		/* 28 Undocumented one */
	long	p_env;		/* 2C Environment string pointer */
	long	p_fxx2;		/* 30 Undoc */
	long	p_fxx3;		/* 34 Undoc */
	long	p_fxx4;		/* 38 Undoc */
	long 	p_fxx5;		/* 3C Undoc */
	long	p_fxx6;		/* 40 Undoc */
	long	p_fxx7;		/* 44 Undoc */
	long	p_fxx8;		/* 48 Undoc */
	long	p_fxx9;		/* 4C Undoc */
	long	p_fxx10;	/* 50 Undoc */
	long	p_fxx11;	/* 54 Undoc */
	long	p_fxx12;	/* 58 Undoc */
	long	p_fxx13;	/* 5C Undoc */
	long	p_fxx14;	/* 60 Undoc */
	long	p_fxx15;	/* 64 Undoc */
	long	p_saved0;	/* 68 Undoc */
	long	p_savea3;	/* 6C Undoc */
	long	p_savea4;	/* 70 Undoc */
	long	p_savea5;	/* 74 Undoc */
	long	p_savea6;	/* 78 Undoc */
	long	p_saveusp;	/* 7C Undoc */
	char	p_cmdlin[128];	/* Command line */
} BASEPAGE;
extern BASEPAGE _start[];
#define BP	(&_start[-1])

/* When handling a gemdos trap, the p_saveusp element points to a considerable
 * amount of saved context on the user's stack.  The layout is as follows */
typedef struct {
	long	p_savessp;	/* The supervisor stack after clean up */
	int	p_savesr;	/* The status register from the trap */
	long	p_savepc;	/* The program counter from the trap */
	long	p_saved1;	/* The saved user d1 */
	long	p_saved2;	/* The saved user d2 */
	long	p_saved3;	/* The saved user d3 */
	long	p_saved4;	/* The saved user d4 */
	long	p_saved5;	/* The saved user d5 */
	long	p_saved6;	/* The saved user d6 */
	long	p_saved7;	/* The saved user d7 */
	long	p_savea0;	/* The saved user a0 */
	long	p_savea1;	/* The saved user a1 */
	long	p_savea2;	/* The saved user a2 */
/* That's 50 bytes of stack overflow you'll never see in user context */
	/* Next are the gemdos opcode and parameters pushed by the user */
	int	p_op;		/* gemdos operation requested */
				/* ... */
} OVERFLOW;
#endif
