/* (-lgl
 * 	Mark Williams C for the Atari ST Version 1.0
 * 	Copyright (c) 1984-1986 by Mark Williams Company, Chicago.
 * 	All rights reserved. May not be copied without permission.
 -lgl) */
/*
 * Stat.
 */
#ifndef	 STAT_H
#define	 STAT_H
#include <types.h>

/*
 * Structure returned by stat and fstat system calls.
 * Nota Bene: fstat cannot work, but it does return the times.
 */
struct stat {
	dev_t	 st_dev;		/* Device */
	ino_t	 st_ino;		/* Inode number */
	unsigned short st_mode;		/* Mode */
	short	 st_nlink;		/* Link count */
	short	 st_uid;		/* User id */
	short	 st_gid;		/* Group id */
	dev_t	 st_rdev;		/* Real device */
	size_t	 st_size;		/* Size */
	time_t	 st_atime;		/* Access time */
	time_t	 st_mtime;		/* Modify time */
	time_t	 st_ctime;		/* Change time */
};

/*
 * Modes ala Jem Dos.
 */
#define S_IJRON	0x01			/* Read-only */
#define S_IJHID	0x02			/* Hidden from search */
#define S_IJSYS	0x04			/* System, hidden from search */
#define S_IJVOL	0x08			/* Volume label in first 11 bytes */
#define S_IJDIR	0x10			/* Directory */
#define S_IJWAC	0x20			/* Written to and closed */

/*
 * "DMA" buffer structure for Fsfirst(), Fsnext().
 */
typedef struct {
	char	d_fill[21];	/* Reserved for jdos joff */
	char	d_fattr;	/* File attributes */
	long	d_tandd;	/* Time and date words */
	long	d_fsize;	/* File size */
	char 	d_fname[14];	/* File name */
} DMABUFFER;

/*
 * Coherent compatibility.
 */
#define S_IFMT	(S_IJDIR|S_IJVOL)	/* Type */
#define S_IFDIR	S_IJDIR			/* Directory */
#define S_IFCHR	0xFFFF			/* Character special */
#define S_IFBLK	0xFFFF			/* Block special */
#define S_IFREG	0			/* Regular */
#define S_IFMPC	0xFFFF			/* Multiplexed character special */
#define S_IFMPB	0xFFFF			/* Multiplexed block special */
#define	S_IFPIP	0xFFFF			/* Pipe */
#define	S_ISUID	0			/* Set user id on execution */
#define S_ISGID	0			/* Set group id on execution */
#define	S_ISVTX	0			/* Save swapped text even after use */
#define S_IREAD	0			/* Read permission, owner */
#define S_IWRITE 0			/* Write permission, owner */
#define S_IEXEC	0			/* Execute/search permission, owner */

/*
 * Non existant device.
 */
#define NODEV	(-1)

/*
 * Functions.
 */
#define	major(dev)	((dev>>8)&0377)
#define minor(dev)	(dev&0377)
#define makedev(m1, m2)	((m1<<8)|m2)

#endif
