;	CP/M 1.4 boot-loader for Z80-Simulator
;
;	Copyright (C) 2007 by Udo Munk
;
	ORG	0		;mem base of boot
;
MSIZE	EQU	63		;mem size in kbytes
;
BIAS	EQU	(MSIZE-16)*1024	;offset from 16k system
CPMB	EQU	BIAS+2900H	;start of CP/M
BOOTE	EQU	BIAS+3E00H	;cold boot entry point
SECTS	EQU	51		;# of sectors to load (26 * 2 - 1)
;
;	I/O ports
;
CONDAT	EQU	1		;console data port
DRIVE	EQU	10		;fdc-port: # of drive
TRACK	EQU	11		;fdc-port: # of track
SECTOR	EQU	12		;fdc-port: # of sector
FDCOP	EQU	13		;fdc-port: command
FDCST	EQU	14		;fdc-port: status
DMAL	EQU	15		;dma-port: dma address low
DMAH	EQU	16		;dma-port: dma address high
;
	JMP	COLD
;
ERRMSG:	DB	'BOOT: error booting'
	DB	13,10,0
;
;
;	begin the load operation
;
COLD:	LXI	B,2		;b=track 0, c=sector 2
	MVI	D,SECTS		;d=# sectors to load
	LXI	H,CPMB		;base transfer address
	XRA	A		;select drive A
	OUT	DRIVE
;
;	load the next sector
;
LSECT:	MOV	A,B		;set track
	OUT	TRACK
	MOV	A,C		;set sector
	OUT	SECTOR
	MOV	A,L		;set dma address low
	OUT	DMAL
	MOV	A,H		;set dma address high
	OUT	DMAH
	XRA	A		;read sector
	OUT	FDCOP
	IN	FDCST		;get status of fdc
	ORA	A		;read successful ?
	JZ	CONT		;yes, continue
	LXI	D,ERRMSG	;no, print error
PRTMSG:	LDAX	D
	ORA	A
	JZ	STOP
	OUT	CONDAT
	INX	D
	JMP	PRTMSG
STOP:	DI
	HLT			;and halt cpu
CONT:
				;go to next sector if load is incomplete
	DCR	D		;sects=sects-1
	JZ	BOOTE		;go to CP/M
;
;	more sectors to load
;
;	we aren't using a stack, so use <sp> as scratch register
;	to hold the load address increment
;
	LXI	SP,128		;128 bytes per sector
	DAD	SP		;<hl> = <hl> + 128
;
	INR	C		;sector = sector + 1
	MOV	A,C
	CPI	27		;last sector of track ?
	JC	LSECT		;no, go read another
;
;	end of track, increment to next track
;
	MVI	C,1		;sector = 1
	INR	B		;track = track + 1
	JMP	LSECT		;for another group
;
	END			;of boot loader
