
; ================================================
;
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
;  OUTPUTS 00H, THEN FFH, THEN 55H, THEN AAH, TO PARALLEL (LPT) PORTS 378h, 278h, and 3BCh.
;
;  REASONABLE DELAYS IN BETWEEN - REQUIRED FOR THE PARALLEL (LPT) PORT CODE READER DEVICE.
;
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER) TO PRODUCE FILE TEST5000_8K_SIZED.BIN
;
; ================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

TIMES 0x1F00 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)


; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli

	; Send 00 to the parallel (LPT1) port code reader device
	mov	al,00h
	mov	dx,378h		; For those sitting at I/O port 378h
	out	dx,al
	mov	dx,278h		; For those sitting at I/O port 278h
	out	dx,al
	mov	dx,3BCh		; For those sitting at I/O port 3BCh
	out	dx,al

	; Now a small inter-byte delay, required by the parallel (LPT1) port code reader device
	sub	cx,cx
loop1:	loop	loop1

	; Send FF to the parallel (LPT1) port code reader device
	mov	al,0FFh
	mov	dx,378h		; For those sitting at I/O port 378h
	out	dx,al
	mov	dx,278h		; For those sitting at I/O port 278h
	out	dx,al
	mov	dx,3BCh		; For those sitting at I/O port 3BCh
	out	dx,al

	; Now a small inter-byte delay, required by the parallel (LPT1) port code reader device
	sub	cx,cx
loop2:	loop	loop2

	; Send 55 to the parallel (LPT1) port code reader device
	mov	al,055h
	mov	dx,378h		; For those sitting at I/O port 378h
	out	dx,al
	mov	dx,278h		; For those sitting at I/O port 278h
	out	dx,al
	mov	dx,3BCh		; For those sitting at I/O port 3BCh
	out	dx,al

	; Now a small inter-byte delay, required by the parallel (LPT1) port code reader device
	sub	cx,cx
loop3:	loop	loop3

	; Send AA to the parallel (LPT1) port code reader device
	mov	al,0AAh
	mov	dx,378h		; For those sitting at I/O port 378h
	out	dx,al
	mov	dx,278		; For those sitting at I/O port 278h
	out	dx,al
	mov	dx,3BCh		; For those sitting at I/O port 3BCh
	out	dx,al

	; We are finished - halt
	hlt


TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector

	jmp	0xFFF0:0x0000

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM 





