
; ================================================
;
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
;  OUTPUTS 55H TO LPT PORTS 378h, 278h, and 3BCh.
;
;  NO DELAYS IN BETWEEN (NOT REQUIRED).
;
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER) TO PRODUCE FILE TEST5055_8K_SIZED.BIN
;
; ================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)


TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector

	cli

	; Send 55 to the parallel (LPT1) port code reader device
	mov	al,55h
	mov	dx,378h		; For those sitting at I/O port 378h
	out	dx,al
	mov	dx,278h		; For those sitting at I/O port 278h
	out	dx,al
	mov	dx,3BCh		; For those sitting at I/O port 3BCh
	out	dx,al

	; We are finished - halt
	hlt


TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM 





