
; ==============================================================================================
;
;  -------------------------------------------------------
;  TARGET COMPUTER
;  -------------------------------------------------------
;  
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
;  -------------------------------------------------------
;  WHAT THE CODES DOES
;  -------------------------------------------------------
;  
;  In a loop, the code does:
;  
;  Step 1: Write 55h to motherboard address 0 (i.e. address 0 in bank 0).
;  Step 2: Read motherboard address 0.
;  Step 3: Write AAh to motherboard address 0 (i.e. address 0 in bank 0).
;  Step 4: Read motherboard address 0.
;  Step 5: Go to step 1.
;  
;  RAM refresh was NOT set up up prior. It is not needed. The act of a read/write to address 0 in bank 0, refreshes row 0 in the bank 0 chips.
;  
;  The code does not examine the byte read back.
;  
;  -------------------------------------------------------
;  EXPECTED OBSERVATIONS
;  -------------------------------------------------------
;  
;  1. Expect to observe /RAS pulses on all RAM chips in bank 0.
;  2. Expect NOT to observe /RAS pulses on the RAM chips of other banks.
;  
;  3. Expect to observe /CAS pulses on all RAM chips in bank 0.
;  4. Expect NOT to observe /CAS pulses on the RAM chips of other banks.
;  
;  5. Expect to observe pulses on the WRITE pin of all RAM chips in bank 0.
;  
;  6. Expect to observe activity on the address pins of all RAM chips in bank 0.
;  
;  7. Expect to observe activity on the 'Data in' and 'data out' pins of all RAM chips in bank 0.
;  
;  ( FYI. Had RAM refresh been set up by this test code, then there would have been /RAS pulses expected on all banks. )
;  
;  -------------------------------------------------------
;  LIMITATIONS
;  -------------------------------------------------------
;  
;  The 'expected observations' above does not reveal timing.
;
;  -------------------------------------------------------
;  COMPILATION
;  -------------------------------------------------------
;  
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER).
;
; ==============================================================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

TIMES 0x1F00 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)


; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli
	mov	dx,0			; Segment of RAM address to be read.
	mov	es,dx			; Put into ES for following instructions.
LOOP:
	mov	byte es:[0],055h	; Write 55h into motherboard address 00000 (0000:0000)
	mov	al,es:[0]		; Read motherboard address 00000           (0000:0000)
	mov	byte es:[0],0AAh	; Write AAh into motherboard address 00000 (0000:0000)
	mov	al,es:[0]		; Read motherboard address 00000           (0000:0000)
	jmp	LOOP



TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector.

	jmp	0xFFF0:0000

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM.





