
; ==============================================================================================
;
;  -------------------------------------------------------
;  TARGET COMPUTER
;  -------------------------------------------------------
;  
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
; --------------------------------------------------
; WHAT DOES THE CODE DO ?
; --------------------------------------------------
; 
; In a loop, the code:
; Step 1: Reads address 55555 hex  (5555:0005) (01010101010101010101 binary)
; Step 2: Reads address AAAAA hex  (AAAA:000A) (10101010101010101010 binary)
; 
; 55555 and AAAAA chosen because they will reveal if any adjacent bits are 'shorted'.
; 
; An example of adjacent bits is A0 and A1.
; An example of adjacent bits is A1 and A2.
; An example of adjacent bits is A2 and A3.
; 
; --------------------------------------------------
; WHAT YOU SHOULD OBSERVE IF USING A LOGIC ANALYSER
; --------------------------------------------------
; 
; Reference diagram at https://minuszerodegrees.net/5150/misc/5150_address_bus.jpg
; 
; Using a logic analyser:
; 1. On the address bus, verify that two of the addresses seen are 55555 and AAAAA, i.e. all adjacent bits are at different logic states.
; 2. On the external address bus, verify that two of the addresses seen are 1555 and AAA, i.e. all adjacent bits are at different logic states.
; 
; ( In the IBM 5150, the external address bus is the lowest 13 bits of the address bus. )
; 
; --------------------------------------------------
; WHAT YOU SHOULD OBSERVE IF USING AN OSCILLOSCOPE
; --------------------------------------------------
; 
; Reference diagram at https://minuszerodegrees.net/5150/misc/5150_address_bus.jpg
; 
; Using an oscilloscope:
; Verify that adjacent bits are at different logic states.
; 
; E.g. When you see A4 at HIGH, A3 and A5 should be LOW.
;  
; -------------------------------------------------------
; LIMITATIONS
; -------------------------------------------------------
; 
; Certain cases of motherboard failure will stop this code from running.

; -------------------------------------------------------
; COMPILATION
; -------------------------------------------------------
; 
; COMPILE THIS CODE USING NASM 2.10 (OR LATER).
;
; ==============================================================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

TIMES 0x1F00 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)


; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli

LOOP:	mov	dx,5555h
	mov	es,dx
	mov	al,byte es:[5]		; Read address 55555h (5555:0005 in the CPU)

	mov	dx,0AAAAh
	mov	es,dx
	mov	al,byte es:[0Ah]	; Read address AAAAAh (AAAA:000A in the CPU)

	jmp	LOOP



TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector.

	jmp	0xFFF0:0000

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM.





