
; ================================================
;
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
;  U33 ROM ADDRESSING TEST.
;
;  OUTPUTS TO LPT PORTS 378h, 278h, and 3BCh.  REFER TO FILE TEST5077.TXT FOR DETAILS.
;
;  THIS CODE PURPOSELY USES NO RAM.
;
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER) TO PRODUCE FILE TEST5077_8K_SIZED.BIN
;
; ================================================

BITS 16

CPU 8086

; ----------------------------------------------------------------------------------------------
; TEST BYTES
; ----------------------------------------------------------------------------------------------

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

	db	0E0h
TIMES 0x100-1 DB 0	; Pad with zero to address 0100h in ROM (i.e. address FE100 in IBM 5150 address space)
	db	0E1h
TIMES 0x100-1 DB 0	; Pad with zero to address 0200h in ROM (i.e. address FE200 in IBM 5150 address space)
	db	0E2h
TIMES 0x100-1 DB 0	; Pad with zero to address 0300h in ROM (i.e. address FE300 in IBM 5150 address space)
	db	0E3h
TIMES 0x100-1 DB 0	; Pad with zero to address 0400h in ROM (i.e. address FE400 in IBM 5150 address space)
	db	0E4h
TIMES 0x100-1 DB 0	; Pad with zero to address 0500h in ROM (i.e. address FE500 in IBM 5150 address space)
	db	0E5h
TIMES 0x100-1 DB 0	; Pad with zero to address 0600h in ROM (i.e. address FE600 in IBM 5150 address space)
	db	0E6h
TIMES 0x100-1 DB 0	; Pad with zero to address 0700h in ROM (i.e. address FE700 in IBM 5150 address space)
	db	0E7h
TIMES 0x100-1 DB 0	; Pad with zero to address 0800h in ROM (i.e. address FE800 in IBM 5150 address space)
	db	0E8h
TIMES 0x100-1 DB 0	; Pad with zero to address 0900h in ROM (i.e. address FE900 in IBM 5150 address space)
	db	0E9h
TIMES 0x100-1 DB 0	; Pad with zero to address 0A00h in ROM (i.e. address FEA00 in IBM 5150 address space)
	db	0EAh
TIMES 0x100-1 DB 0	; Pad with zero to address 0B00h in ROM (i.e. address FEB00 in IBM 5150 address space)
	db	0EBh
TIMES 0x100-1 DB 0	; Pad with zero to address 0C00h in ROM (i.e. address FEC00 in IBM 5150 address space)
	db	0ECh
TIMES 0x100-1 DB 0	; Pad with zero to address 0D00h in ROM (i.e. address FED00 in IBM 5150 address space)
	db	0EDh
TIMES 0x100-1 DB 0	; Pad with zero to address 0E00h in ROM (i.e. address FEE00 in IBM 5150 address space)
	db	0EEh
TIMES 0x100-1 DB 0	; Pad with zero to address 0F00h in ROM (i.e. address FEF00 in IBM 5150 address space)
	db	0EFh
TIMES 0x100-1 DB 0	; Pad with zero to address 1000h in ROM (i.e. address FF000 in IBM 5150 address space)
	db	0F0h
TIMES 0x100-1 DB 0	; Pad with zero to address 1100h in ROM (i.e. address FF100 in IBM 5150 address space)
	db	0F1h
TIMES 0x100-1 DB 0	; Pad with zero to address 1200h in ROM (i.e. address FF200 in IBM 5150 address space)
	db	0F2h
TIMES 0x100-1 DB 0	; Pad with zero to address 1300h in ROM (i.e. address FF300 in IBM 5150 address space)
	db	0F3h
TIMES 0x100-1 DB 0	; Pad with zero to address 1400h in ROM (i.e. address FF400 in IBM 5150 address space)
	db	0F4h
TIMES 0x100-1 DB 0	; Pad with zero to address 1500h in ROM (i.e. address FF500 in IBM 5150 address space)
	db	0F5h
TIMES 0x100-1 DB 0	; Pad with zero to address 1600h in ROM (i.e. address FF600 in IBM 5150 address space)
	db	0F6h
TIMES 0x100-1 DB 0	; Pad with zero to address 1700h in ROM (i.e. address FF700 in IBM 5150 address space)
	db	0F7h
TIMES 0x100-1 DB 0	; Pad with zero to address 1800h in ROM (i.e. address FF800 in IBM 5150 address space)
	db	0F8h
TIMES 0x100-1 DB 0	; Pad with zero to address 1900h in ROM (i.e. address FF900 in IBM 5150 address space)
	db	0F9h
TIMES 0x100-1 DB 0	; Pad with zero to address 1A00h in ROM (i.e. address FFA00 in IBM 5150 address space)
	db	0FAh
TIMES 0x100-1 DB 0	; Pad with zero to address 1B00h in ROM (i.e. address FFB00 in IBM 5150 address space)
	db	0FBh
TIMES 0x100-1 DB 0	; Pad with zero to address 1C00h in ROM (i.e. address FFC00 in IBM 5150 address space)
	db	0FCh
TIMES 0x100-1 DB 0	; Pad with zero to address 1D00h in ROM (i.e. address FFD00 in IBM 5150 address space)
	db	0FDh
TIMES 0x100-1 DB 0	; Pad with zero to address 0E00h in ROM (i.e. address FFE00 in IBM 5150 address space)
	db	0FEh
TIMES 0x100-1 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
	db	0FFh

; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F01h in ROM (i.e. address FFF01 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli

	mov	ax,0F000h	; Segment of ROM address to be read
	mov	ds,ax		; Put that into the data segment register
	mov	bx,0DF00h	; Offset of ROM address to be read
	mov	cx,32		; 32 times. So addresses F000:E000, F000:E100, F000:E200, F000:E300, ......... F000:FF00

NEXTOFF:
	add	bh,1		; Next offset of ROM address to be read: e.g. BX=DF00 becomes BX=E000, BX=E000 becomes BX=E100, etc.

	mov	al,bh		; Get high byte of address offset (e.g. E0)
	mov	dx,378h
	out	dx,al		; Send high byte to LPT port 378h
	mov	dx,278h
	out	dx,al		; Send high byte to LPT port 278h
	mov	dx,3BCh
	out	dx,al		; Send high byte to LPT port 3BCh

	; 2 second delay
	mov	dl,8
	mov	ax,cx		; Preserve CX
	sub	cx,cx
.loop:	loop	.loop
	dec	dl
	jnz	.loop
	mov	cx,ax		; Restore CX

	mov	al,[ds:bx]	; Read the ROM address
	cmp	al,bh		; Is the byte read as expected?  Example: For address F000:E300, expect to read the data of E3
	je	GOOD
	mov	al,099h
	mov	dx,378h
	out	dx,al		; BAD: Send 99h to LPT port 378h
	mov	dx,278h
	out	dx,al		; BAD: Send 99h to LPT port 278h
	mov	dx,3BCh
	out	dx,al		; BAD: Send 99h to LPT port 3BCh
	jmp	END
GOOD:
	mov	al,11h
	mov	dx,378h
	out	dx,al		; GOOD: Send 11h to LPT port 378h
	mov	dx,278h
	out	dx,al		; GOOD: Send 11h to LPT port 278h
	mov	dx,3BCh
	out	dx,al		; GOOD: Send 11h to LPT port 3BCh
END:
	; 2 second delay
	mov	dl,8
	mov	ax,cx		; Preserve CX
	sub	cx,cx
.loop:	loop	.loop
	dec	dl
	jnz	.loop
	mov	cx,ax		; Restore CX

	loop	NEXTOFF		; Go do the next of the 32 addresses


; ------------------------------
; ALL 32 ADDRESSES DONE - HALT
; ------------------------------
	hlt




TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector

	jmp	0xFF00:0x0001

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM 





