
; ================================================
;
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
;  ABOUT EVERY TWO SECONDS, THE PB2 PIN (PIN 20) OF THE 8255 CHIP IS TOGGLED BETWEEN HIGH AND LOW.
;  THE TOGGLING NEVER STOPS.
;  THE TOGGLING CAN BE SEEN BY USING A LOGIC PROBE, OR A MULTIMETER IN 'DC VOLTAGE' MODE.
;
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER) TO PRODUCE FILE TEST5082_8K_SIZED.BIN
;
; ================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

TIMES 0x1F00 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)


; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli

	; Set 8255 port B to outputs (and ports A and C to inputs)
	mov al,99h
	out 63h,al

loop1: 

	; Set 8255 pin PB2 to HIGH
	mov al,04h
	out 61h,al

	; 2 second delay
	mov	dl,8
	sub	cx,cx
loop2:	loop	loop2
	dec	dl
	jnz	loop2
                          
	; Set 8255 port B pins to LOW 
	mov al,00h
	out 61h,al
                              
	; 2 second delay
	mov	dl,8
	sub	cx,cx
loop3:	loop	loop3
	dec	dl
	jnz	loop3
                          
	; Do it all again         
	jmp loop1



TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector

	jmp	0xFFF0:0000

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM 





