
; ================================================
;
;  FOR IC SOCKET U18 ON THE IBM 5160 MOTHERBOARD.
;
;  Configures the 5150 motherboard to generate a continuous tone from the speaker.
;
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER) TO PRODUCE FILE TEST6046_32K_SIZED.BIN
;
; ================================================

BITS 16

CPU 8086

PPI8255_B	equ	61h		; 8255 port B
PPI8255_ctrl	equ	63h		; 8255 control

PIT8253_2	equ	42h		; 8253 channel 2
PIT8253_ctrl	equ	43h		; 8253 control

ORG 0			; Offset 0 in ROM (i.e. address F8000 in IBM 5160 address space)

TIMES 0x7F00-($-$$) DB 0	; Pad with zero to address 7F00h in ROM (i.e. address FFF00 in IBM 5160 address space)

; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 7F00h in ROM (i.e. address FFF00 in IBM 5160 address space)
; ----------------------------------------------------------------------------------------------

; Set 8255 port B to outputs (and ports A and C to inputs).
	mov	al,99h
	out	PPI8255_ctrl,al

; Initialise channel 2 of the 8253 PIT chip.
	mov	al,10110110b		; Timer IC 8253 square waves
	out	PIT8253_ctrl,al		;   channel 2, speaker
	mov	ax,528h			; Get countdown constant word
	out	PIT8253_2,al		;   send low order
	mov	al,ah			;   load high order
	out	PIT8253_2,al		;   send high order

; Start beep by setting 8255 pins PB1 and PB0 to HIGH.
; The other six port B pins are set LOW, but that is of no consequence to this code.
	mov	al,00000011b
	out	PPI8255_B,al

; Halt the CPU.
	cli
	hlt


TIMES 0x7FF0-($-$$) DB 0	; Pad out to reset vector

	jmp	0xFF00:0000

TIMES 0x8000-($-$$) DB 0	; Pad out to end of ROM 

